#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "EOS Fluid Characterization \"SCN for MWs and SGs\""
show title

$Expt << END
#                                                        Tb            Tc          Pc                       
#  Component       LMW          MW          SG           (C)          (K)        (bar)         AF         VTran
#------------   ---------   ---------   ---------   ------------   ---------   ---------   ---------   ----------
     N2              NaN      28.014     0.28339     -195.90291     126.200     33.9800     0.03700     -0.16758
     CO2             NaN      44.010     0.76193      -88.26608     304.120     73.7400     0.22500      0.00191
     C1              NaN      16.043     0.14609     -161.59338     190.560     45.9900     0.01100     -0.14996
     C2              NaN      30.070     0.32976      -88.71667     305.320     48.7200     0.09900     -0.06280
     C3              NaN      44.097     0.50977      -42.21618     369.830     42.4800     0.15200     -0.06381
     I-C4            NaN      58.123     0.57043      -11.65811     407.850     36.4000     0.18600     -0.06197
     N-C4            NaN      58.123     0.59055       -0.51619     425.120     37.9600     0.20000     -0.05393
     I-C5            NaN      72.150     0.62952       28.01296     460.390     33.8100     0.22900     -0.05646
     N-C5            NaN      72.150     0.63585       36.18684     469.700     33.7000     0.25200     -0.02928
     C6           77.714      84.751     0.69921       64.83930     513.482     33.2738     0.24565     -0.02474
     C7           91.551      98.595     0.72940       94.25535     548.497     30.6745     0.28230     -0.00820
     C8          105.403     112.460     0.75398      121.35092     579.790     28.5096     0.31809      0.00569
     C9          119.362     126.496     0.77457      146.51023     608.034     26.6688     0.35344      0.01630
     C10         133.445     140.601     0.79195      169.99044     633.638     25.0631     0.38878      0.02554
     C11         147.592     154.767     0.80682      191.98102     656.967     23.6445     0.42415      0.03372
     C12         161.797     168.989     0.81967      212.63178     678.316     22.3800     0.45954      0.04105
     C13         176.052     183.259     0.83088      232.06704     697.934     21.2452     0.49151      0.04765
     C14         190.351     197.571     0.84075      250.39330     716.029     20.2213     0.52508      0.05359
     C15         204.687     211.919     0.84950      267.70376     732.779     19.2934     0.55826      0.05893
     C16         219.058     226.301     0.85730      284.08099     748.334     18.4493     0.59100      0.06371
     C17         233.458     240.711     0.86430      299.59884     762.825     17.6789     0.62328      0.06797
     C18         247.886     255.149     0.87063      314.32372     776.364     16.9733     0.65506      0.07174
     C19         262.339     269.611     0.87636      328.31560     789.048     16.3254     0.68633      0.07505
     C20         276.815     284.096     0.88158      341.62882     800.961     15.7287     0.71706      0.07793
     C21         291.313     298.601     0.88635      354.31270     812.177     15.1776     0.74726      0.08042
     C22         305.830     313.126     0.89074      366.41217     822.761     14.6675     0.77691      0.08254
     C23         320.366     327.669     0.89477      377.96816     832.769     14.1940     0.80601      0.08432
     C24         334.920     342.230     0.89850      389.01807     842.251     13.7535     0.83456      0.08579
     C25         349.491     356.807     0.90196      399.59611     851.252     13.3427     0.86257      0.08698
     C26         364.077     371.400     0.90517      409.73362     859.812     12.9588     0.89004      0.08790
     C27         378.678     386.007     0.90817      419.45935     867.964     12.5994     0.91698      0.08859
     C28         393.293     400.628     0.91096      428.79974     875.742     12.2620     0.94339      0.08906
     C29         407.922     415.262     0.91358      437.77907     883.172     11.9449     0.96930      0.08933
     C30+        422.563     602.891     0.93649      528.47876     956.060      9.0961     1.25946      0.08196
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_005_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:4 with points notitle

set title "Gamma Model of Lab3_MDT1_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.63      112.46      113.23     1.1039e-01    1.1755e-01    4.7659e-02    5.1095e-02
    119.36      126.50      126.09     8.7711e-02    9.8594e-02    4.2593e-02    4.7724e-02
    133.44      140.60      140.30     7.7769e-02    7.9549e-02    4.1976e-02    4.2846e-02
    147.59      154.77      154.52     6.2187e-02    6.7800e-02    3.6948e-02    4.0218e-02
    161.80      168.99      168.77     5.4506e-02    5.9146e-02    3.5360e-02    3.8320e-02
    176.05      183.26      183.06     5.4919e-02    5.2268e-02    3.8637e-02    3.6731e-02
    190.35      197.57      197.38     5.2220e-02    4.6570e-02    3.9607e-02    3.5288e-02
    204.69      211.92      211.74     4.8220e-02    4.1729e-02    3.9229e-02    3.3920e-02
    219.06      226.30      226.13     4.2675e-02    3.7547e-02    3.7074e-02    3.2594e-02
    233.46      240.71      240.55     3.9902e-02    3.3890e-02    3.6872e-02    3.1296e-02
    247.89      255.15      254.99     3.6563e-02    3.0666e-02    3.5814e-02    3.0019e-02
    262.34      269.61      269.46     3.1485e-02    2.7804e-02    3.2588e-02    2.8761e-02
    276.82      284.10      283.95     2.4680e-02    2.5251e-02    2.6917e-02    2.7525e-02
    291.31      298.60      298.46     2.0568e-02    2.2964e-02    2.3578e-02    2.6311e-02
    305.83      313.13      312.98     1.8912e-02    2.0908e-02    2.2733e-02    2.5122e-02
    320.37      327.67      327.53     1.7562e-02    1.9056e-02    2.2091e-02    2.3960e-02
    334.92      342.23      342.09     1.5213e-02    1.7382e-02    1.9986e-02    2.2828e-02
    349.49      356.81      356.67     1.4002e-02    1.5868e-02    1.9180e-02    2.1727e-02
    364.08      371.40      371.27     1.3072e-02    1.4495e-02    1.8638e-02    2.0659e-02
    378.68      386.01      385.88     1.3096e-02    1.3249e-02    1.9406e-02    1.9626e-02
    393.29      400.63      400.50     1.2208e-02    1.2116e-02    1.8776e-02    1.8628e-02
    407.92      415.26      415.13     1.0790e-02    1.1085e-02    1.7201e-02    1.7666e-02
    422.56      602.89      596.59     1.4135e-01    1.2312e-01    3.2714e-01    2.8198e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_002_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT1_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.63      112.46      113.23     1.1605e-01    1.1561e-01    4.9834e-02    4.9981e-02
    119.36      126.50      126.09     9.2210e-02    9.6967e-02    4.4537e-02    4.6683e-02
    133.44      140.60      140.30     8.1719e-02    7.8236e-02    4.3871e-02    4.1913e-02
    147.59      154.77      154.52     6.5034e-02    6.6681e-02    3.8431e-02    3.9341e-02
    161.80      168.99      168.77     5.6043e-02    5.8170e-02    3.6161e-02    3.7485e-02
    176.05      183.26      183.06     5.4545e-02    5.1406e-02    3.8167e-02    3.5930e-02
    190.35      197.57      197.38     5.0346e-02    4.5802e-02    3.7980e-02    3.4519e-02
    204.69      211.92      211.74     4.3633e-02    4.1041e-02    3.5306e-02    3.3181e-02
    219.06      226.30      226.13     3.6542e-02    3.6927e-02    3.1575e-02    3.1884e-02
    233.46      240.71      240.55     3.1898e-02    3.3331e-02    2.9317e-02    3.0614e-02
    247.89      255.15      254.99     2.9177e-02    3.0160e-02    2.8425e-02    2.9364e-02
    262.34      269.61      269.46     2.8135e-02    2.7345e-02    2.8964e-02    2.8134e-02
    276.82      284.10      283.95     2.4409e-02    2.4834e-02    2.6478e-02    2.6925e-02
    291.31      298.60      298.46     2.1326e-02    2.2585e-02    2.4314e-02    2.5737e-02
    305.83      313.13      312.98     1.9794e-02    2.0563e-02    2.3665e-02    2.4574e-02
    320.37      327.67      327.53     1.8365e-02    1.8741e-02    2.2977e-02    2.3438e-02
    334.92      342.23      342.09     1.5966e-02    1.7096e-02    2.0864e-02    2.2330e-02
    349.49      356.81      356.67     1.4682e-02    1.5606e-02    2.0002e-02    2.1253e-02
    364.08      371.40      371.27     1.3736e-02    1.4256e-02    1.9478e-02    2.0209e-02
    378.68      386.01      385.88     1.3754e-02    1.3030e-02    2.0272e-02    1.9198e-02
    393.29      400.63      400.50     1.2825e-02    1.1916e-02    1.9618e-02    1.8222e-02
    407.92      415.26      415.13     1.1328e-02    1.0902e-02    1.7962e-02    1.7281e-02
    422.56      602.89      596.59     1.4848e-01    1.2109e-01    3.4180e-01    2.7583e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_003_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT2_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.11      112.46      112.94     1.1780e-01    1.1984e-01    5.1674e-02    5.2790e-02
    119.36      126.50      126.10     9.0283e-02    9.6703e-02    4.4546e-02    4.7564e-02
    133.44      140.60      140.31     8.1226e-02    7.8597e-02    4.4546e-02    4.3015e-02
    147.59      154.77      154.52     6.4936e-02    6.7285e-02    3.9201e-02    4.0555e-02
    161.80      168.99      168.77     5.6961e-02    5.8906e-02    3.7546e-02    3.8778e-02
    176.05      183.26      183.06     5.5019e-02    5.2218e-02    3.9328e-02    3.7286e-02
    190.35      197.57      197.39     4.8886e-02    4.6661e-02    3.7673e-02    3.5925e-02
    204.69      211.92      211.74     4.6038e-02    4.1925e-02    3.8055e-02    3.4627e-02
    219.06      226.30      226.13     3.8787e-02    3.7823e-02    3.4237e-02    3.3362e-02
    233.46      240.71      240.55     3.4025e-02    3.4227e-02    3.1946e-02    3.2115e-02
    247.89      255.15      254.99     3.2739e-02    3.1049e-02    3.2582e-02    3.0882e-02
    262.34      269.61      269.46     3.0378e-02    2.8222e-02    3.1946e-02    2.9662e-02
    276.82      284.10      283.95     2.4924e-02    2.5693e-02    2.7619e-02    2.8456e-02
    291.31      298.60      298.46     2.2511e-02    2.3422e-02    2.6219e-02    2.7267e-02
    305.83      313.13      312.99     1.9799e-02    2.1377e-02    2.4182e-02    2.6097e-02
    320.37      327.67      327.53     1.8522e-02    1.9529e-02    2.3673e-02    2.4950e-02
    334.92      342.23      342.10     1.6685e-02    1.7857e-02    2.2273e-02    2.3827e-02
    349.49      356.81      356.67     1.5364e-02    1.6339e-02    2.1382e-02    2.2732e-02
    364.08      371.40      371.27     1.4321e-02    1.4961e-02    2.0746e-02    2.1665e-02
    378.68      386.01      385.88     1.4624e-02    1.3706e-02    2.2019e-02    2.0630e-02
    393.29      400.63      400.50     1.2054e-02    1.2563e-02    1.8837e-02    1.9626e-02
    407.92      415.26      415.14     1.2494e-02    1.1521e-02    2.0237e-02    1.8656e-02
    422.56      602.89      601.47     1.3163e-01    1.3164e-01    3.0953e-01    3.0885e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_005_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT2_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.11      112.46      112.94     1.1936e-01    1.1935e-01    5.2293e-02    5.2512e-02
    119.36      126.50      126.10     9.1476e-02    9.6309e-02    4.5080e-02    4.7314e-02
    133.44      140.60      140.31     8.2289e-02    7.8276e-02    4.5075e-02    4.2788e-02
    147.59      154.77      154.52     6.5706e-02    6.7011e-02    3.9618e-02    4.0341e-02
    161.80      168.99      168.77     5.7389e-02    5.8665e-02    3.7783e-02    3.8573e-02
    176.05      183.26      183.06     5.4924e-02    5.2005e-02    3.9213e-02    3.7089e-02
    190.35      197.57      197.39     4.8359e-02    4.6470e-02    3.7223e-02    3.5735e-02
    204.69      211.92      211.74     4.4828e-02    4.1754e-02    3.7010e-02    3.4444e-02
    219.06      226.30      226.13     3.7156e-02    3.7669e-02    3.2758e-02    3.3186e-02
    233.46      240.71      240.55     3.1886e-02    3.4088e-02    2.9902e-02    3.1946e-02
    247.89      255.15      254.99     3.0786e-02    3.0923e-02    3.0602e-02    3.0719e-02
    262.34      269.61      269.46     2.9500e-02    2.8106e-02    3.0986e-02    2.9506e-02
    276.82      284.10      283.95     2.4857e-02    2.5588e-02    2.7512e-02    2.8306e-02
    291.31      298.60      298.46     2.2732e-02    2.3327e-02    2.6444e-02    2.7123e-02
    305.83      313.13      312.99     2.0038e-02    2.1290e-02    2.4445e-02    2.5960e-02
    320.37      327.67      327.53     1.8742e-02    1.9450e-02    2.3925e-02    2.4818e-02
    334.92      342.23      342.10     1.6899e-02    1.7784e-02    2.2531e-02    2.3702e-02
    349.49      356.81      356.67     1.5557e-02    1.6273e-02    2.1625e-02    2.2612e-02
    364.08      371.40      371.27     1.4508e-02    1.4900e-02    2.0992e-02    2.1551e-02
    378.68      386.01      385.88     1.4814e-02    1.3650e-02    2.2277e-02    2.0521e-02
    393.29      400.63      400.50     1.2211e-02    1.2512e-02    1.9059e-02    1.9522e-02
    407.92      415.26      415.14     1.2655e-02    1.1474e-02    2.0473e-02    1.8557e-02
    422.56      602.89      601.47     1.3333e-01    1.3111e-01    3.1318e-01    3.0722e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_006_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT3_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.41      112.46      113.05     1.1891e-01    1.2086e-01    5.1487e-02    5.2604e-02
    119.36      126.50      126.08     9.0316e-02    9.7063e-02    4.3987e-02    4.7118e-02
    133.44      140.60      140.30     8.0786e-02    7.8013e-02    4.3733e-02    4.2141e-02
    147.59      154.77      154.52     6.4217e-02    6.6411e-02    3.8266e-02    3.9509e-02
    161.80      168.99      168.77     5.6078e-02    5.7941e-02    3.6486e-02    3.7649e-02
    176.05      183.26      183.06     5.4053e-02    5.1249e-02    3.8139e-02    3.6120e-02
    190.35      197.57      197.38     4.8132e-02    4.5727e-02    3.6613e-02    3.4751e-02
    204.69      211.92      211.74     4.5029e-02    4.1047e-02    3.6740e-02    3.3464e-02
    219.06      226.30      226.13     3.8082e-02    3.7010e-02    3.3181e-02    3.2223e-02
    233.46      240.71      240.55     3.3333e-02    3.3483e-02    3.0892e-02    3.1010e-02
    247.89      255.15      254.99     3.1965e-02    3.0372e-02    3.1401e-02    2.9819e-02
    262.34      269.61      269.46     2.9760e-02    2.7610e-02    3.0892e-02    2.8645e-02
    276.82      284.10      283.95     2.4407e-02    2.5144e-02    2.6697e-02    2.7489e-02
    291.31      298.60      298.46     2.2005e-02    2.2932e-02    2.5299e-02    2.6351e-02
    305.83      313.13      312.99     1.9403e-02    2.0941e-02    2.3392e-02    2.5235e-02
    320.37      327.67      327.53     1.8139e-02    1.9143e-02    2.2883e-02    2.4141e-02
    334.92      342.23      342.10     1.6402e-02    1.7516e-02    2.1612e-02    2.3071e-02
    349.49      356.81      356.68     1.5362e-02    1.6041e-02    2.1103e-02    2.2028e-02
    364.08      371.40      371.27     1.3691e-02    1.4700e-02    1.9578e-02    2.1013e-02
    378.68      386.01      385.88     1.3772e-02    1.3480e-02    2.0468e-02    2.0027e-02
    393.29      400.63      400.50     1.2445e-02    1.2368e-02    1.9197e-02    1.9071e-02
    407.92      415.26      415.14     1.2245e-02    1.1353e-02    1.9578e-02    1.8147e-02
    422.56      602.89      604.88     1.4147e-01    1.3195e-01    3.2838e-01    3.0730e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_008_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT3_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.41      112.46      113.05     1.2048e-01    1.2033e-01    5.2096e-02    5.2305e-02
    119.36      126.50      126.08     9.1507e-02    9.6643e-02    4.4507e-02    4.6850e-02
    133.44      140.60      140.30     8.1842e-02    7.7675e-02    4.4244e-02    4.1902e-02
    147.59      154.77      154.52     6.4976e-02    6.6123e-02    3.8666e-02    3.9285e-02
    161.80      168.99      168.77     5.6493e-02    5.7690e-02    3.6707e-02    3.7436e-02
    176.05      183.26      183.06     5.3946e-02    5.1027e-02    3.8011e-02    3.5915e-02
    190.35      197.57      197.38     4.7596e-02    4.5529e-02    3.6157e-02    3.4554e-02
    204.69      211.92      211.74     4.3807e-02    4.0870e-02    3.5695e-02    3.3274e-02
    219.06      226.30      226.13     3.6444e-02    3.6850e-02    3.1711e-02    3.2040e-02
    233.46      240.71      240.55     3.1188e-02    3.3338e-02    2.8865e-02    3.0834e-02
    247.89      255.15      254.99     3.0004e-02    3.0241e-02    2.9435e-02    2.9649e-02
    262.34      269.61      269.46     2.8876e-02    2.7491e-02    2.9934e-02    2.8482e-02
    276.82      284.10      283.95     2.4334e-02    2.5035e-02    2.6581e-02    2.7333e-02
    291.31      298.60      298.46     2.2219e-02    2.2833e-02    2.5510e-02    2.6202e-02
    305.83      313.13      312.99     1.9636e-02    2.0850e-02    2.3641e-02    2.5091e-02
    320.37      327.67      327.53     1.8353e-02    1.9060e-02    2.3122e-02    2.4004e-02
    334.92      342.23      342.10     1.6612e-02    1.7440e-02    2.1858e-02    2.2940e-02
    349.49      356.81      356.68     1.5554e-02    1.5971e-02    2.1339e-02    2.1903e-02
    364.08      371.40      371.27     1.3870e-02    1.4636e-02    1.9807e-02    2.0893e-02
    378.68      386.01      385.88     1.3950e-02    1.3421e-02    2.0704e-02    1.9913e-02
    393.29      400.63      400.50     1.2607e-02    1.2314e-02    1.9419e-02    1.8963e-02
    407.92      415.26      415.14     1.2403e-02    1.1304e-02    1.9803e-02    1.8044e-02
    422.56      602.89      604.88     1.4330e-01    1.3138e-01    3.3219e-01    3.0556e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_009_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "EOS Fluid Characterization \"SCN EOS\""
show title

$Expt << END
#                                                        Tb            Tc          Pc                                                          Visc                        Vc            VcVis
#  Component       LMW          MW          SG           (C)          (K)        (bar)         AF         VTran         Zc        ZcVis        (cp)        Pchor      (ft3/lbmol)     (ft3/lbmol)
#------------   ---------   ---------   ---------   ------------   ---------   ---------   ---------   ----------   ---------   ---------   ----------   ---------   -------------   -------------
     N2              NaN      28.014     0.28339     -195.90291     126.200     33.9800     0.03700     -0.16758     0.29178     0.29178          NaN       59.10        1.4433          1.4433
     CO2             NaN      44.010     0.76193      -88.26608     304.120     73.7400     0.22500      0.00191     0.27433     0.27433          NaN       80.00        1.5069          1.5069
     C1              NaN      16.043     0.14609     -161.59338     190.560     45.9900     0.01100     -0.14996     0.28620     0.28620          NaN       71.00        1.5794          1.5794
     C2              NaN      30.070     0.32976      -88.71667     305.320     48.7200     0.09900     -0.06280     0.27924     0.27924          NaN      111.00        2.3307          2.3307
     C3              NaN      44.097     0.50977      -42.21618     369.830     42.4800     0.15200     -0.06381     0.27630     0.27630          NaN      151.00        3.2037          3.2037
     I-C4            NaN      58.123     0.57043      -11.65811     407.850     36.4000     0.18600     -0.06197     0.28199     0.28199          NaN      188.80        4.2081          4.2081
     N-C4            NaN      58.123     0.59055       -0.51619     425.120     37.9600     0.20000     -0.05393     0.27385     0.27385          NaN      191.00        4.0847          4.0847
     I-C5            NaN      72.150     0.62952       28.01296     460.390     33.8100     0.22900     -0.05646     0.27231     0.27231          NaN      227.40        4.9385          4.9385
     N-C5            NaN      72.150     0.63585       36.18684     469.700     33.7000     0.25200     -0.02928     0.26837     0.26837          NaN      231.00        4.9817          4.9817
     C6           77.714      84.751     0.69921       64.83930     513.482     33.2738     0.24565     -0.02474     0.26937     0.26937          NaN      238.40        5.5365          5.5365
     C7           91.551      98.595     0.72940       94.25535     548.497     30.6745     0.28230     -0.00820     0.26470     0.26601      0.24166      271.63        6.3039          6.3351
     C8          105.403     112.460     0.75398      121.35092     579.790     28.5096     0.31809      0.00569     0.26056     0.26355      0.30650      304.90        7.0573          7.1382
     C9          119.362     126.496     0.77457      146.51023     608.034     26.6688     0.35344      0.01630     0.25684     0.26245      0.38367      338.59        7.7990          7.9693
     C10         133.445     140.601     0.79195      169.99044     633.638     25.0637     0.38879      0.02551     0.25345     0.26198      0.47437      372.44        8.5337          8.8212
     C11         147.592     154.767     0.80682      191.98102     656.967     23.6316     0.42389      0.03433     0.25031     0.26176      0.57993      406.44        9.2681          9.6920
     C12         161.797     168.989     0.81967      212.63178     678.316     22.3551     0.45899      0.04227     0.24738     0.26179      0.70168      440.57        9.9972         10.5794
     C13         176.052     183.259     0.83088      232.06704     697.934     21.2094     0.49067      0.04946     0.24461     0.26198      0.84092      474.82       10.7204         11.4819
     C14         190.351     197.571     0.84075      250.39330     716.029     20.1758     0.52390      0.05598     0.24195     0.26230      0.99891      509.17       11.4364         12.3979
     C15         204.687     211.919     0.84950      267.70376     732.779     19.2390     0.55671      0.06189     0.23940     0.26271      1.17687      543.61       12.1441         13.3266
     C16         219.058     226.301     0.85730      284.08099     748.334     18.3869     0.58907      0.06723     0.23692     0.26320      1.37598      578.12       12.8421         14.2667
     C17         233.458     240.711     0.86430      299.59884     762.825     17.6091     0.62093      0.07203     0.23450     0.26376      1.59738      612.71       13.5295         15.2176
     C18         247.886     255.149     0.87063      314.32372     776.364     16.8968     0.65228      0.07634     0.23213     0.26438      1.84214      647.36       14.2053         16.1785
     C19         262.339     269.611     0.87636      328.31560     789.048     16.2427     0.68308      0.08018     0.22981     0.26505      2.11132      682.07       14.8688         17.1488
     C20         276.815     284.096     0.88158      341.62882     800.961     15.6403     0.71332      0.08359     0.22754     0.26578      2.40590      716.83       15.5195         18.1278
     C21         291.313     298.601     0.88635      354.31270     812.177     15.0840     0.74300      0.08660     0.22531     0.26655      2.72683      751.64       16.1571         19.1150
     C22         305.830     313.126     0.89074      366.41217     822.761     14.5690     0.77211      0.08923     0.22311     0.26737      3.07503      786.50       16.7813         20.1102
     C23         320.366     327.669     0.89477      377.96816     832.769     14.0910     0.80064      0.09152     0.22096     0.26823      3.45136      821.41       17.3920         21.1127
     C24         334.920     342.230     0.89850      389.01807     842.251     13.6463     0.82860      0.09349     0.21884     0.26912      3.85665      856.35       17.9892         22.1223
     C25         349.491     356.807     0.90196      399.59611     851.252     13.2316     0.85600      0.09518     0.21676     0.27005      4.29169      891.34       18.5731         23.1387
     C26         364.077     371.400     0.90517      409.73362     859.812     12.8441     0.88284      0.09660     0.21472     0.27100      4.75723      926.36       19.1439         24.1616
     C27         378.678     386.007     0.90817      419.45935     867.964     12.4812     0.90912      0.09777     0.21272     0.27198      5.25399      961.42       19.7017         25.1906
     C28         393.293     400.628     0.91096      428.79974     875.742     12.1406     0.93486      0.09873     0.21075     0.27298      5.78268      996.51       20.2469         26.2256
     C29         407.922     415.262     0.91358      437.77907     883.172     11.8205     0.96007      0.09948     0.20882     0.27401      6.34396     1031.63       20.7798         27.2663
     C30+        422.563     602.891     0.93649      528.47876     956.060      8.9445     1.23959      0.09809     0.18723     0.28782     16.61871     1481.94       26.6541         40.9739
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_006_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:4 with points notitle
set ylabel "Boiling Temperature (C)"
set output "Figures/Table_006_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:5 with points notitle
set ylabel "Critical Temperature (K)"
set output "Figures/Table_006_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:6 with points notitle
set ylabel "Critical Pressure (bar)"
set output "Figures/Table_006_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:7 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_006_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:8 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_006_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:9 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_006_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:10 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_006_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:11 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_006_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:12 with points notitle
set ylabel "Parachor"
set output "Figures/Table_006_PCHOR_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:13 with points notitle

set title "EOS Fluid Characterization \"Pseudo EOS\""
show title

$Expt << END
#                                                       Tb           Tc          Pc                                                          Visc                        Vc            VcVis
# Component       LMW          MW          SG          (C)          (K)        (bar)         AF         VTran         Zc        ZcVis        (cp)        Pchor      (ft3/lbmol)     (ft3/lbmol)
#-----------   ---------   ---------   ---------   -----------   ---------   ---------   ---------   ----------   ---------   ---------   ----------   ---------   -------------   -------------
   CO2              NaN      44.010     0.76193      -88.2661     304.120     73.7400     0.22500      0.00191     0.27433     0.27433          NaN       80.00        1.5069          1.5069
   C1+N2            NaN      16.093     0.14661     -161.7620     190.241     45.9329     0.01106     -0.15003     0.28622     0.28622          NaN       70.95        1.5789          1.5789
   C2               NaN      30.070     0.32976      -88.7167     305.320     48.7200     0.09900     -0.06280     0.27924     0.27924          NaN      111.00        2.3307          2.3307
   C3               NaN      44.097     0.50977      -42.2162     369.830     42.4800     0.15200     -0.06381     0.27630     0.27630          NaN      151.00        3.2037          3.2037
   C4            49.864      58.123     0.58558       -3.3840     420.683     37.5591     0.19639     -0.05600     0.27595     0.27595          NaN      190.43        4.1164          4.1164
   C5            63.854      72.150     0.63331       32.8644     465.930     33.7480     0.24260     -0.04027     0.26996     0.26996          NaN      229.52        4.9640          4.9640
   C6            77.714      84.751     0.69921       64.8393     513.482     33.2738     0.24565     -0.02474     0.26937     0.26937          NaN      238.40        5.5365          5.5365
   C7            91.551      98.595     0.72940       94.2554     548.497     30.6745     0.28230     -0.00820     0.26470     0.26601      0.24166      271.63        6.3039          6.3351
   C8-C9        105.403     118.581     0.76343      132.4894     592.340     27.6658     0.33368      0.01061     0.25883     0.26304      0.33933      319.59        7.3807          7.5006
   C10-C13      133.445     159.400     0.81119      198.6209     663.670     23.1765     0.43593      0.03737     0.24913     0.26188      0.62179      417.56        9.5013          9.9878
   C14-C19      190.351     228.734     0.85848      286.3976     750.258     18.2338     0.59494      0.06821     0.23615     0.26349      1.42396      583.96       12.9411         14.4393
   C20-C29      276.815     340.077     0.89790      386.7496     840.053     13.7048     0.82400      0.09266     0.21859     0.26943      3.84358      851.18       17.8449         21.9957
   C30+         422.563     602.891     0.93649      528.4788     956.060      8.9445     1.23959      0.09809     0.18723     0.28782     16.61871     1481.94       26.6541         40.9739
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_007_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:4 with points notitle
set ylabel "Boiling Temperature (C)"
set output "Figures/Table_007_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:5 with points notitle
set ylabel "Critical Temperature (K)"
set output "Figures/Table_007_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:6 with points notitle
set ylabel "Critical Pressure (bar)"
set output "Figures/Table_007_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:7 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_007_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:8 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_007_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:9 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_007_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:10 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_007_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:11 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_007_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:12 with points notitle
set ylabel "Parachor"
set output "Figures/Table_007_PCHOR_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:13 with points notitle

set title "Lab1 Swelling Test"
show title

$Expt << END
#                             Mole Frac Inj                Sat Pres (barg)      Density (g/cm3)      Liq Vol Frac           C30+ K-Value
#  Stg     Mass Frac Inj           (%)           Feed       Expt    Calc         Expt     Calc       Expt    Calc         Expt        Calc
#------   ---------------   ----------------   -------   ------------------   ------------------   ----------------   ------------------------
     1        0.00000             0.000          NaN       232.42  231.60          NaN  0.69389     1.0000  1.0000            NaN  4.7658e-05
     2        0.06563            21.999          M23       272.47  284.92      0.65300  0.65792     1.0000  1.0000            NaN  8.3549e-04
     3        0.21770            52.773          M54       397.42  390.00      0.58000  0.58952     1.0000  1.0000            NaN  1.0813e-01
     4        0.26890            59.627          M61       425.37  428.93      0.56100  0.57185     1.0000  1.0000            NaN  8.4515e-01
     5        0.27500            60.366          NaN          NaN  434.74          NaN  0.57011        NaN  0.0000     1.0000e+00  8.8625e-01
     6        0.30676            63.988          M65       452.11  468.03      0.54700  0.56201     0.0000  0.0000            NaN  4.2898e-01
     7        0.45610            77.102          M78       586.05  615.87      0.49600  0.52862     0.0000  0.0000            NaN  1.3859e-01
     8        0.50000            80.061          NaN          NaN  647.73          NaN  0.51854        NaN  0.0000            NaN  1.0968e-01
     9        0.55000            83.073          NaN          NaN  673.92          NaN  0.50632        NaN  0.0000            NaN  8.4719e-02
    10        0.60000            85.761          NaN          NaN  687.50          NaN  0.49301        NaN  0.0000            NaN  6.5356e-02
    11        0.65000            88.176          NaN          NaN  687.24          NaN  0.47833        NaN  0.0000            NaN  4.9928e-02
    12        0.70000            90.356          NaN          NaN  672.83          NaN  0.46200        NaN  0.0000            NaN  3.7445e-02
    13        0.75000            92.335          NaN          NaN  644.77          NaN  0.44374        NaN  0.0000            NaN  2.7277e-02
    14        0.80000            94.139          NaN          NaN  603.91          NaN  0.42312        NaN  0.0000            NaN  1.8997e-02
    15        0.85000            95.790          NaN          NaN  550.70          NaN  0.39932        NaN  0.0000            NaN  1.2303e-02
    16        0.90000            97.307          NaN          NaN  483.83          NaN  0.37054        NaN  0.0000            NaN  6.9759e-03
    17        0.95000            98.706          NaN          NaN  395.71          NaN  0.33106        NaN  0.0000            NaN  2.8706e-03
END
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (barg)"
set output "Figures/Expt_005_SATP_vs_WFI_1.pdf"
plot [0:1][*<0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_005_DEN_vs_WFI_1.pdf"
plot [0:1][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"
set ylabel "Liquid Volume Fraction"
set output "Figures/Expt_005_LVF_vs_WFI_1.pdf"
plot [0:1][0:1] $Expt using 2:9 with points title "Expt", $Expt using 2:10 with lines title "Calc"

set title "Lab1 Viscosity Test"
show title

$Expt << END
#                            Pres                          Liq Vis (cp)
# Stg     Mass Frac Inj     (psig)     Mole Frac Inj       Expt     Calc
#-----   ---------------   --------   ---------------   ------------------
    1        0.06563        6000.0        0.21999        0.57800  0.48015
    2        0.21770        6200.0        0.52773        0.31700  0.21235
    3        0.26890        6450.0        0.59627        0.24500  0.17604
END
set xlabel "Mole Fraction Injectant"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_006_LVIS_vs_MFI_1.pdf"
plot [0:1][0:*] $Expt using 4:5 with points title "Expt", $Expt using 4:6 with lines title "Calc"

set title "P/V Test on Lab1 0% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liquid Volume (m3)       GOR (sm3/m3)         Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc           Expt       Calc        Expt    Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------------   ----------------   ----------------
     1     240.00     96.000          NaN  100.00             NaN  0.0001483        NaN   0.000        NaN  0.9981
     2     235.00     96.000          NaN  100.00             NaN  0.0001485        NaN   0.000        NaN  0.9993
     3     232.42     96.000       100.00  100.00             NaN  0.0001486        NaN   0.000        NaN  1.0000
     4     212.01     96.000        91.90   95.11             NaN  0.0001450        NaN   9.657        NaN  1.0261
     5     206.64     96.000        91.30   93.72             NaN  0.0001440        NaN  12.281        NaN  1.0344
     6     200.84     96.000        90.40   92.20             NaN  0.0001430        NaN  15.107        NaN  1.0442
     7     194.43     96.000        89.40   90.48             NaN  0.0001419        NaN  18.222        NaN  1.0559
     8     186.16     96.000        84.80   88.20             NaN  0.0001406        NaN  22.231        NaN  1.0726
     9     151.68     96.000        76.20   77.72             NaN  0.0001351        NaN  38.934        NaN  1.1699
    10     128.24     96.000        69.00   69.41             NaN  0.0001315        NaN  50.420        NaN  1.2757
    11     111.83     96.000        63.50   62.86             NaN  0.0001291        NaN  58.621        NaN  1.3824
    12      99.84     96.000        57.90   57.63             NaN  0.0001273        NaN  64.747        NaN  1.4868
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_007_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 23% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)        GOR (sm3/m3)          Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc        Expt     Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------   ------------------   ----------------
     1     285.00     96.000          NaN  100.00          NaN  1.5766         NaN    0.000        NaN  0.9885
     2     280.00     96.000          NaN   98.76          NaN  1.5639         NaN    3.017        NaN  0.9929
     3     275.00     96.000          NaN   97.51          NaN  1.5514         NaN    6.050        NaN  0.9975
     4     272.47     96.000       100.00   96.88          NaN  1.5452         NaN    7.571        NaN  1.0000
     5     241.66     96.000        83.50   89.32          NaN  1.4765         NaN   25.552        NaN  1.0364
     6     235.39     96.000        83.00   87.78          NaN  1.4638         NaN   29.114        NaN  1.0455
     7     214.43     96.000        79.20   82.51          NaN  1.4236         NaN   40.868        NaN  1.0817
     8     155.82     96.000        65.40   65.91          NaN  1.3236         NaN   73.382        NaN  1.2591
     9     101.63     96.000        49.60   46.40          NaN  1.2371         NaN  105.004        NaN  1.6717
    10      75.84     96.000        39.10   35.38          NaN  1.1939         NaN  121.747        NaN  2.1159
    11      60.67     96.000        31.10   28.42          NaN  1.1663         NaN  132.669        NaN  2.5730
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_008_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 54% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)       GOR (sm3/m3)         Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc       Expt    Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------   ----------------   ----------------
     1     400.00     96.000          NaN  100.00          NaN  2.2890        NaN    0.00        NaN  0.9991
     2     397.42     96.000       100.00  100.00          NaN  2.2910        NaN    0.00        NaN  1.0000
     3     395.21     96.000        88.10  100.00          NaN  2.2927        NaN    0.00        NaN  1.0008
     4     390.93     96.000        85.70  100.00          NaN  2.2961        NaN    0.00        NaN  1.0022
     5     381.35     96.000        79.40   95.49          NaN  2.2039        NaN   13.11        NaN  1.0074
     6     367.90     96.000        76.90   90.41          NaN  2.1038        NaN   29.39        NaN  1.0157
     7     343.36     96.000        73.60   83.76          NaN  1.9832        NaN   52.79        NaN  1.0335
     8     255.66     96.000        62.20   66.49          NaN  1.7422        NaN  115.65        NaN  1.1436
     9     197.88     96.000        51.50   54.68          NaN  1.6290        NaN  153.14        NaN  1.3004
    10     147.34     96.000        40.20   42.30          NaN  1.5332        NaN  188.18        NaN  1.5821
    11     118.73     96.000        35.20   34.29          NaN  1.4756        NaN  210.48        NaN  1.8783
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_009_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 61% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)       GOR (sm3/m3)         Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc       Expt    Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------   ----------------   ----------------
     1     440.00     96.000          NaN  100.00          NaN  2.4825        NaN    0.00        NaN  0.9946
     2     435.00     96.000          NaN  100.00          NaN  2.4868        NaN    0.00        NaN  0.9963
     3     430.00     96.000          NaN  100.00          NaN  2.4912        NaN    0.00        NaN  0.9981
     4     425.37     96.000       100.00   79.78          NaN  1.9912        NaN   63.96        NaN  1.0000
     5     421.96     96.000        88.60   79.51          NaN  1.9876        NaN   66.38        NaN  1.0015
     6     415.75     96.000        83.10   79.72          NaN  1.9988        NaN   67.27        NaN  1.0045
     7     410.10     96.000        79.30   79.51          NaN  1.9992        NaN   69.23        NaN  1.0073
     8     398.86     96.000        75.20   78.47          NaN  1.9850        NaN   75.13        NaN  1.0135
     9     388.45     96.000        69.70   77.22          NaN  1.9654        NaN   81.44        NaN  1.0197
    10     378.18     96.000        69.60   75.90          NaN  1.9444        NaN   87.88        NaN  1.0263
    11     368.52     96.000        66.00   74.63          NaN  1.9245        NaN   93.97        NaN  1.0331
    12     350.18     96.000        65.90   72.19          NaN  1.8877        NaN  105.46        NaN  1.0476
    13     333.36     96.000        62.80   69.93          NaN  1.8554        NaN  115.84        NaN  1.0630
    14     270.76     96.000        56.50   61.01          NaN  1.7459        NaN  153.71        NaN  1.1466
    15     218.22     96.000        51.20   52.23          NaN  1.6605        NaN  186.00        NaN  1.2736
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_010_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 65% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)       Liq Vol (m3)        GOR (sm3/m3)         Rel Vol 1               N2 x                    CO2 x                 C1 x                  C2 x                   C3 x                   i-C4 x                  n-C4 x                  i-C5 x                  n-C5 x                 C6-C7 x                C8-C9 x               C10-C13 x              C14-C19 x              C20-C29 x               C30+ x                 C6+ x          Gas N2 Mole Fraction            CO2 y                 C1 y                  C2 y                   C3 y                   i-C4 y                  n-C4 y                  i-C5 y                  n-C5 y                 C6-C7 y                C8-C9 y               C10-C13 y              C14-C19 y               C20-C29 y          Gas C30+ Mole Fraction           C6+ y            N2 K-Value         CO2 K-Value        C1 K-Value         C2 K-Value         C3 K-Value         i-C4 K-Value         n-C4 K-Value         i-C5 K-Value         n-C5 K-Value         C6-C7 K-Value        C8-C9 K-Value       C10-C13 K-Value      C14-C19 K-Value       C20-C29 K-Value          C30+ K-Value            C6+ K-Value
#  Stg     (barg)       (C)         Expt    Calc          Expt     Calc       Expt    Calc       Expt    Calc         Expt       Calc         Expt      Calc         Expt     Calc        Expt      Calc         Expt      Calc          Expt       Calc         Expt      Calc          Expt       Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt     Calc         Expt       Calc         Expt      Calc         Expt     Calc        Expt      Calc         Expt      Calc          Expt       Calc         Expt      Calc          Expt       Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc          Expt       Calc          Expt        Calc          Expt     Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt      Calc          Expt       Calc         Expt     Calc
#------   --------   --------   --------------------   ------------------   ----------------   ----------------   ----------------------   --------------------   ------------------   --------------------   --------------------   ----------------------   --------------------   ----------------------   --------------------   --------------------   --------------------   --------------------   --------------------   --------------------   --------------------   ------------------   ----------------------   --------------------   ------------------   --------------------   --------------------   ----------------------   --------------------   ----------------------   --------------------   --------------------   --------------------   --------------------   --------------------   ----------------------   ------------------------   ------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   --------------------   ----------------------   ------------------
     1     480.00     96.000          NaN   0.000           NaN  0.00000        NaN                NaN  0.9897           NaN  0.0022524          NaN  0.013829         NaN  0.56084          NaN  0.086805          NaN  0.078358           NaN  0.0046009          NaN  0.037225           NaN  0.0053482          NaN  0.017905          NaN  0.043727          NaN  0.025156          NaN  0.030886          NaN  0.027424          NaN  0.024037          NaN  0.041600         NaN  0.19283           NaN  0.0024098          NaN  0.014156         NaN  0.60004          NaN  0.088581          NaN  0.078789           NaN  0.0045639          NaN  0.036926           NaN  0.0052325          NaN  0.017517          NaN  0.041830          NaN  0.023367          NaN  0.027592          NaN  0.022965           NaN  0.0182313            NaN  1.7801e-02         NaN  0.15179        NaN  1.0630        NaN  1.0213        NaN  1.0630        NaN  1.0185        NaN  1.0050         NaN  0.99275         NaN  0.99275         NaN  0.98047         NaN  0.98047         NaN  0.96086         NaN  0.93585         NaN  0.90378         NaN  0.85328          NaN  0.782084           NaN  0.4838430         NaN  0.80796
     2     475.00     96.000          NaN   0.000           NaN  0.00000        NaN                NaN  0.9913           NaN  0.0022485          NaN  0.013822         NaN  0.55987          NaN  0.086787          NaN  0.078397           NaN  0.0046060          NaN  0.037267           NaN  0.0053575          NaN  0.017936          NaN  0.043843          NaN  0.025251          NaN  0.031049          NaN  0.027627          NaN  0.024280          NaN  0.041660         NaN  0.19371           NaN  0.0024098          NaN  0.014156         NaN  0.60004          NaN  0.088581          NaN  0.078789           NaN  0.0045639          NaN  0.036926           NaN  0.0052325          NaN  0.017517          NaN  0.041830          NaN  0.023367          NaN  0.027592          NaN  0.022965           NaN  0.0182313            NaN  1.7801e-02         NaN  0.15179        NaN  1.0677        NaN  1.0228        NaN  1.0677        NaN  1.0195        NaN  1.0047         NaN  0.99136         NaN  0.99136         NaN  0.97797         NaN  0.97797         NaN  0.95667         NaN  0.92955         NaN  0.89491         NaN  0.84069          NaN  0.764820           NaN  0.4593539         NaN  0.79569
     3     470.00     96.000          NaN   0.000           NaN  0.00000        NaN                NaN  0.9930           NaN  0.0022451          NaN  0.013816         NaN  0.55904          NaN  0.086780          NaN  0.078445           NaN  0.0046116          NaN  0.037312           NaN  0.0053672          NaN  0.017968          NaN  0.043959          NaN  0.025347          NaN  0.031208          NaN  0.027823          NaN  0.024510          NaN  0.041572         NaN  0.19442           NaN  0.0024098          NaN  0.014156         NaN  0.60004          NaN  0.088581          NaN  0.078789           NaN  0.0045639          NaN  0.036926           NaN  0.0052325          NaN  0.017517          NaN  0.041830          NaN  0.023367          NaN  0.027592          NaN  0.022965           NaN  0.0182313            NaN  1.7801e-02         NaN  0.15179        NaN  1.0722        NaN  1.0242        NaN  1.0722        NaN  1.0204        NaN  1.0043         NaN  0.98982         NaN  0.98982         NaN  0.97530         NaN  0.97530         NaN  0.95234         NaN  0.92312         NaN  0.88597         NaN  0.82813          NaN  0.747848           NaN  0.4371773         NaN  0.78417
     4     465.00     96.000          NaN   2.782           NaN  0.07360        NaN  8711.2        NaN  0.9949           NaN  0.0022424          NaN  0.013811         NaN  0.55836          NaN  0.086784          NaN  0.078501           NaN  0.0046176          NaN  0.037360           NaN  0.0053772          NaN  0.018002          NaN  0.044076          NaN  0.025441          NaN  0.031363          NaN  0.028011          NaN  0.024726          NaN  0.041332         NaN  0.19495           NaN  0.0024139          NaN  0.014164         NaN  0.60105          NaN  0.088625          NaN  0.078796           NaN  0.0045626          NaN  0.036915           NaN  0.0052290          NaN  0.017506          NaN  0.041776          NaN  0.023317          NaN  0.027501          NaN  0.022842           NaN  0.0180736            NaN  1.7230e-02         NaN  0.15074        NaN  1.0765        NaN  1.0256        NaN  1.0765        NaN  1.0212        NaN  1.0038         NaN  0.98809         NaN  0.98809         NaN  0.97243         NaN  0.97243         NaN  0.94781         NaN  0.91650         NaN  0.87685         NaN  0.81548          NaN  0.730961           NaN  0.4168615         NaN  0.77322
     5     460.00     96.000          NaN   7.182           NaN  0.19036        NaN  3238.6        NaN  0.9968           NaN  0.0022403          NaN  0.013808         NaN  0.55784          NaN  0.086800          NaN  0.078566           NaN  0.0046240          NaN  0.037413           NaN  0.0053877          NaN  0.018037          NaN  0.044195          NaN  0.025535          NaN  0.031514          NaN  0.028189          NaN  0.024924          NaN  0.040929         NaN  0.19529           NaN  0.0024209          NaN  0.014179         NaN  0.60279          NaN  0.088698          NaN  0.078804           NaN  0.0045600          NaN  0.036894           NaN  0.0052223          NaN  0.017483          NaN  0.041676          NaN  0.023225          NaN  0.027336          NaN  0.022624           NaN  0.0177943            NaN  1.6291e-02         NaN  0.14895        NaN  1.0806        NaN  1.0268        NaN  1.0806        NaN  1.0219        NaN  1.0030         NaN  0.98614         NaN  0.98614         NaN  0.96931         NaN  0.96931         NaN  0.94301         NaN  0.90957         NaN  0.86743         NaN  0.80256          NaN  0.713948           NaN  0.3980289         NaN  0.76271
     6     455.00     96.000          NaN  11.471           NaN  0.30464        NaN  1944.2        NaN  0.9988           NaN  0.0022390          NaN  0.013807         NaN  0.55750          NaN  0.086829          NaN  0.078641           NaN  0.0046310          NaN  0.037469           NaN  0.0053986          NaN  0.018073          NaN  0.044314          NaN  0.025626          NaN  0.031660          NaN  0.028356          NaN  0.025100          NaN  0.040352         NaN  0.19541           NaN  0.0024284          NaN  0.014194         NaN  0.60467          NaN  0.088772          NaN  0.078805           NaN  0.0045566          NaN  0.036867           NaN  0.0052144          NaN  0.017457          NaN  0.041560          NaN  0.023121          NaN  0.027150          NaN  0.022378           NaN  0.0174838            NaN  1.5347e-02         NaN  0.14704        NaN  1.0846        NaN  1.0280        NaN  1.0846        NaN  1.0224        NaN  1.0021         NaN  0.98394         NaN  0.98394         NaN  0.96588         NaN  0.96588         NaN  0.93786         NaN  0.90224         NaN  0.85755         NaN  0.78918          NaN  0.696564           NaN  0.3803255         NaN  0.75248
     7     452.11     96.000        0.000  13.952           NaN  0.37098        NaN  1558.6        NaN  1.0000           NaN  0.0022386          NaN  0.013808         NaN  0.55740          NaN  0.086853          NaN  0.078690           NaN  0.0046352          NaN  0.037503           NaN  0.0054051          NaN  0.018095          NaN  0.044383          NaN  0.025678          NaN  0.031740          NaN  0.028446          NaN  0.025190          NaN  0.039934         NaN  0.19537           NaN  0.0024330          NaN  0.014203         NaN  0.60583          NaN  0.088816          NaN  0.078803           NaN  0.0045542          NaN  0.036848           NaN  0.0052090          NaN  0.017439          NaN  0.041484          NaN  0.023053          NaN  0.027029          NaN  0.022220           NaN  0.0172860            NaN  1.4794e-02         NaN  0.14587        NaN  1.0869        NaN  1.0287        NaN  1.0869        NaN  1.0226        NaN  1.0014         NaN  0.98252         NaN  0.98252         NaN  0.96373         NaN  0.96373         NaN  0.93468         NaN  0.89776         NaN  0.85157         NaN  0.78115          NaN  0.686227           NaN  0.3704614         NaN  0.74661
     8     438.02     96.000       40.300  26.978           NaN  0.72169        NaN   696.4        NaN  1.0061           NaN  0.0022410          NaN  0.013821         NaN  0.55800          NaN  0.087051          NaN  0.078988           NaN  0.0046586          NaN  0.037692           NaN  0.0054387          NaN  0.018208          NaN  0.044715          NaN  0.025914          NaN  0.032081          NaN  0.028782          NaN  0.025451          NaN  0.036960         NaN  0.19390           NaN  0.0024616          NaN  0.014259         NaN  0.61293          NaN  0.089051          NaN  0.078728           NaN  0.0045348          NaN  0.036691           NaN  0.0051692          NaN  0.017306          NaN  0.040945          NaN  0.022586          NaN  0.026215          NaN  0.021180           NaN  0.0160162            NaN  1.1923e-02         NaN  0.13887        NaN  1.0985        NaN  1.0317        NaN  1.0985        NaN  1.0230        NaN  0.9967         NaN  0.97343         NaN  0.97343         NaN  0.95046         NaN  0.95046         NaN  0.91571         NaN  0.87156         NaN  0.81716         NaN  0.73587          NaN  0.629291           NaN  0.3225875         NaN  0.71616
     9     431.89     96.000       40.000  33.475           NaN  0.89802        NaN   516.3        NaN  1.0089           NaN  0.0022441          NaN  0.013832         NaN  0.55879          NaN  0.087178          NaN  0.079149           NaN  0.0046702          NaN  0.037786           NaN  0.0054544          NaN  0.018260          NaN  0.044857          NaN  0.026006          NaN  0.032198          NaN  0.028868          NaN  0.025455          NaN  0.035253         NaN  0.19264           NaN  0.0024788          NaN  0.014291         NaN  0.61721          NaN  0.089166          NaN  0.078639           NaN  0.0045196          NaN  0.036568           NaN  0.0051401          NaN  0.017208          NaN  0.040570          NaN  0.022268          NaN  0.025674          NaN  0.020507           NaN  0.0152230            NaN  1.0533e-02         NaN  0.13478        NaN  1.1046        NaN  1.0331        NaN  1.1046        NaN  1.0228        NaN  0.9936         NaN  0.96776         NaN  0.96776         NaN  0.94238         NaN  0.94238         NaN  0.90444         NaN  0.85625         NaN  0.79738         NaN  0.71035          NaN  0.598030           NaN  0.2988006         NaN  0.69963
    10     426.23     96.000       41.000  39.764           NaN  1.06964        NaN   397.6        NaN  1.0117           NaN  0.0022473          NaN  0.013844         NaN  0.55957          NaN  0.087307          NaN  0.079311           NaN  0.0046818          NaN  0.037880           NaN  0.0054699          NaN  0.018312          NaN  0.044995          NaN  0.026093          NaN  0.032303          NaN  0.028930          NaN  0.025419          NaN  0.033639         NaN  0.19138           NaN  0.0024982          NaN  0.014326         NaN  0.62205          NaN  0.089275          NaN  0.078506           NaN  0.0044997          NaN  0.036407           NaN  0.0051033          NaN  0.017085          NaN  0.040109          NaN  0.021884          NaN  0.025029          NaN  0.019719           NaN  0.0143209            NaN  9.1842e-03         NaN  0.13025        NaN  1.1117        NaN  1.0348        NaN  1.1117        NaN  1.0225        NaN  0.9898         NaN  0.96112         NaN  0.96112         NaN  0.93298         NaN  0.93298         NaN  0.89141         NaN  0.83867         NaN  0.77483         NaN  0.68161          NaN  0.563399           NaN  0.2730200         NaN  0.68056
    11     420.10     96.000       42.600  46.215           NaN  1.24705        NaN   309.1        NaN  1.0148           NaN  0.0022493          NaN  0.013854         NaN  0.56007          NaN  0.087438          NaN  0.079493           NaN  0.0046955          NaN  0.037991           NaN  0.0054888          NaN  0.018376          NaN  0.045169          NaN  0.026206          NaN  0.032444          NaN  0.029022          NaN  0.025394          NaN  0.032109         NaN  0.19034           NaN  0.0025227          NaN  0.014368         NaN  0.62816          NaN  0.089386          NaN  0.078294           NaN  0.0044713          NaN  0.036177           NaN  0.0050521          NaN  0.016914          NaN  0.039481          NaN  0.021369          NaN  0.024179          NaN  0.018703           NaN  0.0131916            NaN  7.7335e-03         NaN  0.12466        NaN  1.1216        NaN  1.0371        NaN  1.1216        NaN  1.0223        NaN  0.9849         NaN  0.95226         NaN  0.95226         NaN  0.92044         NaN  0.92044         NaN  0.87408         NaN  0.81541         NaN  0.74524         NaN  0.64442          NaN  0.519486           NaN  0.2408538         NaN  0.65490
    12     414.24     96.000       43.500  51.334           NaN  1.38948        NaN   254.5        NaN  1.0180           NaN  0.0022486          NaN  0.013858         NaN  0.55990          NaN  0.087540          NaN  0.079671           NaN  0.0047100          NaN  0.038108           NaN  0.0055099          NaN  0.018446          NaN  0.045376          NaN  0.026349          NaN  0.032635          NaN  0.029176          NaN  0.025441          NaN  0.031029         NaN  0.19001           NaN  0.0025479          NaN  0.014411         NaN  0.63443          NaN  0.089474          NaN  0.078034           NaN  0.0044387          NaN  0.035913           NaN  0.0049948          NaN  0.016722          NaN  0.038792          NaN  0.020812          NaN  0.023271          NaN  0.017642           NaN  0.0120531            NaN  6.4660e-03         NaN  0.11904        NaN  1.1331        NaN  1.0399        NaN  1.1331        NaN  1.0221        NaN  0.9795         NaN  0.94241         NaN  0.94241         NaN  0.90651         NaN  0.90651         NaN  0.85491         NaN  0.78987         NaN  0.71308         NaN  0.60467          NaN  0.473763           NaN  0.2083865         NaN  0.62649
    13     402.86     96.000       46.100  57.777           NaN  1.57402        NaN   199.4        NaN  1.0246           NaN  0.0022396          NaN  0.013850         NaN  0.55766          NaN  0.087665          NaN  0.080026           NaN  0.0047426          NaN  0.038372           NaN  0.0055603          NaN  0.018615          NaN  0.045906          NaN  0.026735          NaN  0.033191          NaN  0.029699          NaN  0.025790          NaN  0.029952         NaN  0.19127           NaN  0.0025957          NaN  0.014490         NaN  0.64633          NaN  0.089582          NaN  0.077439           NaN  0.0043687          NaN  0.035347           NaN  0.0048743          NaN  0.016318          NaN  0.037378          NaN  0.019688          NaN  0.021477          NaN  0.015609           NaN  0.0099748            NaN  4.5285e-03         NaN  0.10866        NaN  1.1590        NaN  1.0462        NaN  1.1590        NaN  1.0219        NaN  0.9677         NaN  0.92116         NaN  0.92116         NaN  0.87662         NaN  0.87662         NaN  0.81424         NaN  0.73644         NaN  0.64707         NaN  0.52558          NaN  0.386772           NaN  0.1511913         NaN  0.56807
    14     381.69     96.000       48.500  62.220           NaN  1.71816        NaN   167.8        NaN  1.0385           NaN  0.0022055          NaN  0.013796         NaN  0.54918          NaN  0.087758          NaN  0.080759           NaN  0.0048177          NaN  0.038980           NaN  0.0056823          NaN  0.019023          NaN  0.047249          NaN  0.027747          NaN  0.034705          NaN  0.031222          NaN  0.027032          NaN  0.029849         NaN  0.19780           NaN  0.0026708          NaN  0.014616         NaN  0.66503          NaN  0.089633          NaN  0.076272           NaN  0.0042395          NaN  0.034302           NaN  0.0046576          NaN  0.015593          NaN  0.034906          NaN  0.017769          NaN  0.018503          NaN  0.012413           NaN  0.0069854            NaN  2.4050e-03         NaN  0.09298        NaN  1.2110        NaN  1.0595        NaN  1.2110        NaN  1.0214        NaN  0.9444         NaN  0.87999         NaN  0.87999         NaN  0.81967         NaN  0.81967         NaN  0.73876         NaN  0.64039         NaN  0.53317         NaN  0.39759          NaN  0.258418           NaN  0.0805742         NaN  0.47007
    15     362.39     96.000       49.400  62.784           NaN  1.75860        NaN   163.3        NaN  1.0534           NaN  0.0021639          NaN  0.013721         NaN  0.53882          NaN  0.087781          NaN  0.081533           NaN  0.0049006          NaN  0.039650           NaN  0.0058192          NaN  0.019482          NaN  0.048775          NaN  0.028906          NaN  0.036440          NaN  0.032966          NaN  0.028476          NaN  0.030562         NaN  0.20613           NaN  0.0027260          NaN  0.014716         NaN  0.67878          NaN  0.089611          NaN  0.075260           NaN  0.0041308          NaN  0.033422           NaN  0.0044777          NaN  0.014991          NaN  0.032897          NaN  0.016242          NaN  0.016211          NaN  0.010100           NaN  0.0050533            NaN  1.3862e-03         NaN  0.08189        NaN  1.2597        NaN  1.0725        NaN  1.2597        NaN  1.0208        NaN  0.9231         NaN  0.84291         NaN  0.84291         NaN  0.76947         NaN  0.76947         NaN  0.67447         NaN  0.56189         NaN  0.44488         NaN  0.30639          NaN  0.177458           NaN  0.0453559         NaN  0.39729
    16     314.68     96.000       48.500  59.885           NaN  1.75515        NaN   176.2        NaN  1.1022           NaN  0.0020346          NaN  0.013452         NaN  0.50661          NaN  0.087724          NaN  0.083930           NaN  0.0051642          NaN  0.041783           NaN  0.0062587          NaN  0.020953          NaN  0.053660          NaN  0.032589          NaN  0.041837          NaN  0.038144          NaN  0.032532          NaN  0.033330         NaN  0.23209           NaN  0.0028316          NaN  0.014948         NaN  0.70506          NaN  0.089545          NaN  0.073010           NaN  0.0038890          NaN  0.031466           NaN  0.0040789          NaN  0.013655          NaN  0.028532          NaN  0.013000          NaN  0.011579          NaN  0.005902           NaN  0.0021556            NaN  3.4444e-04         NaN  0.06151        NaN  1.3917        NaN  1.1112        NaN  1.3917        NaN  1.0208        NaN  0.8699         NaN  0.75307         NaN  0.75307         NaN  0.65172         NaN  0.65172         NaN  0.53172         NaN  0.39891         NaN  0.27677         NaN  0.15472          NaN  0.066263           NaN  0.0103342         NaN  0.26504
    17     259.10     96.000       45.900  53.588           NaN  1.70120        NaN   202.8        NaN  1.1939           NaN  0.0018400          NaN  0.012952         NaN  0.45815          NaN  0.087360          NaN  0.087703           NaN  0.0055971          NaN  0.045286           NaN  0.0069899          NaN  0.023401          NaN  0.061704          NaN  0.038517          NaN  0.050068          NaN  0.045314          NaN  0.037682          NaN  0.037436         NaN  0.27072           NaN  0.0029249          NaN  0.015245         NaN  0.72830          NaN  0.089685          NaN  0.070731           NaN  0.0036298          NaN  0.029369           NaN  0.0036437          NaN  0.012199          NaN  0.023864          NaN  0.009672          NaN  0.007274          NaN  0.002761           NaN  0.0006479            NaN  5.1158e-05         NaN  0.04427        NaN  1.5897        NaN  1.1771        NaN  1.5897        NaN  1.0266        NaN  0.8065         NaN  0.64852         NaN  0.64852         NaN  0.52129         NaN  0.52129         NaN  0.38675         NaN  0.25110         NaN  0.14528         NaN  0.06092          NaN  0.017195           NaN  0.0013666         NaN  0.16352
    18     222.29     96.000       42.500  48.188           NaN  1.65566        NaN   223.4        NaN  1.2922     0.0012831  0.0016812     0.014805  0.012454     0.41119  0.41861     0.084685  0.086713     0.089818  0.090838     0.0042441  0.0059801     0.051522  0.048384     0.0061194  0.0076490     0.028919  0.025607     0.073236  0.068877     0.043626  0.043644     0.062872  0.056757     0.051324  0.050663     0.038888  0.041415     0.037472  0.040729     0.29830  0.30208     0.0039012  0.0029752     0.020706  0.015477     0.72523  0.74081     0.090929  0.090031     0.070522  0.069440     0.0035011  0.0034650     0.029409  0.028035     0.0030010  0.0033574     0.011003  0.011240     0.020507  0.020844     0.009303  0.007633     0.008403  0.004963     0.002901  0.001473     0.0006002  0.0002423     8.3800e-05  1.0799e-05     0.04220  0.03517     3.0404  1.7697     1.3986  1.2427     1.7637  1.7697     1.0737  1.0383     0.7852  0.7644     0.82493  0.57942     0.57081  0.57942     0.49040  0.43894     0.38049  0.43894     0.28001  0.30262     0.21324  0.17490     0.13365  0.08744     0.05652  0.02908     0.015434  0.005850     0.0022355  0.0002652     0.14150  0.11641
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_011_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 78% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)     Liquid Volume (m3)        GOR (sm3/m3)           Rel Vol 1
#  Stg     (barg)       (C)        Expt      Calc         Expt      Calc         Expt      Calc        Expt    Calc
#------   --------   --------   --------------------   --------------------   --------------------   ----------------
     1     630.00     96.000          NaN   0.00000          NaN  0.000000          NaN                  NaN  0.9858
     2     625.00     96.000          NaN   0.00000          NaN  0.000000          NaN                  NaN  0.9873
     3     620.00     96.000          NaN   0.00000          NaN  0.000000          NaN                  NaN  0.9888
     4     615.00     96.000          NaN   0.07036          NaN  0.002313          NaN  409706.2        NaN  0.9903
     5     610.00     96.000          NaN   0.47313          NaN  0.015577          NaN   60670.4        NaN  0.9920
     6     605.00     96.000          NaN   0.87244          NaN  0.028771          NaN   32763.2        NaN  0.9936
     7     600.00     96.000          NaN   1.26847          NaN  0.041900          NaN   22439.0        NaN  0.9952
     8     595.00     96.000          NaN   1.66140          NaN  0.054972          NaN   17059.5        NaN  0.9969
     9     590.00     96.000          NaN   2.05143          NaN  0.067994          NaN   13757.4        NaN  0.9986
    10     586.05     96.000      0.00000   2.35765          NaN  0.078250          NaN   11930.4        NaN  1.0000
    11     442.09     96.000     18.50000  14.19855          NaN  0.502329          NaN    1707.9        NaN  1.0660
    12     430.92     96.000     19.80000  15.55639          NaN  0.554040          NaN    1530.6        NaN  1.0731
    13     419.41     96.000     20.80000  17.16917          NaN  0.615946          NaN    1357.0        NaN  1.0809
    14     398.03     96.000     25.40000  20.86960          NaN  0.759947          NaN    1061.3        NaN  1.0971
    15     377.83     96.000     26.40000  24.96090          NaN  0.923716          NaN     836.1        NaN  1.1150
    16     350.39     96.000     28.90000  29.85897          NaN  1.133793          NaN     643.3        NaN  1.1441
    17     284.41     96.000     31.80000  34.20925          NaN  1.416357          NaN     482.1        NaN  1.2474
    18     239.94     96.000     30.20000  32.83751          NaN  1.486839          NaN     458.5        NaN  1.3642
    19     210.36     96.000     28.90000  30.58764          NaN  1.503877          NaN     457.6        NaN  1.4814
    20     188.43     96.000     31.60000  28.29846          NaN  1.504024          NaN     462.7        NaN  1.6013
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_012_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "Lab2 Constant Composition Expansion"
show title

$Expt << END
#           Pres          Rel Vol         Liq Den (kg/m3)      Liq Vis (cp)
#  Stg     (barg)      Expt    Calc        Expt    Calc        Expt    Calc
#------   --------   ----------------   ------------------   ----------------
     1     379.21     0.9761  0.9695      706.80  710.18      0.4760  0.6802
     2     344.74     0.9819  0.9760      702.60  705.47      0.4560  0.6385
     3     310.26     0.9879  0.9831      698.40  700.38      0.4340  0.5966
     4     275.79     0.9943  0.9909      693.90  694.84      0.4130  0.5549
     5     268.90     0.9956  0.9926      692.90  693.67      0.4090  0.5465
     6     262.00     0.9970  0.9943      692.00  692.48      0.4040  0.5382
     7     255.11     0.9983  0.9960      691.10  691.27      0.4000  0.5298
     8     246.83     1.0000  1.0000      689.90  691.17      0.3950  0.5277
     9     236.35     1.0115  1.0119         NaN  695.54         NaN  0.5517
    10     215.94     1.0389  1.0400         NaN  704.06         NaN  0.6021
    11     194.09     1.0777  1.0795         NaN  713.26         NaN  0.6622
    12     170.37     1.1359  1.1384         NaN  723.40         NaN  0.7361
    13     148.10     1.2139  1.2164         NaN  733.13         NaN  0.8155
    14     126.93     1.3210  1.3228         NaN  742.64         NaN  0.9021
    15     108.32     1.4583  1.4580         NaN  751.28         NaN  0.9892
    16      90.32     1.6556  1.6506         NaN  759.98         NaN  1.0859
    17      81.91     1.7821  1.7733         NaN  764.20         NaN  1.1362
END
set xlabel "Pressure (barg)"
set ylabel "Relative Volume"
set output "Figures/Expt_016_RV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "Lab2 Differential Liberation"
show title

$Expt << END
#           Temp       Pres                    Liq Vol (m3)        Removed (sm3)       Liq Den (kg/m3)      Liq Vis (cp)       Gas Z-Factor      Gas Sp Gravity        Gas Vis (cp)
#  Stg       (C)      (barg)      Stg Wgt      Expt    Calc        Expt     Calc        Expt    Calc        Expt    Calc       Expt    Calc       Expt    Calc        Expt      Calc
#------   --------   --------   ----------   ----------------   ------------------   ------------------   ----------------   ----------------   ----------------   --------------------
     1     100.00     379.21       1.00       1.4660  1.4562         NaN    0.000      706.80  710.18      0.4760  0.6802        NaN  1.0397        NaN  0.9451          NaN  0.040348
     2     100.00     344.74       1.00       1.4750  1.4659         NaN    0.000      702.60  705.47      0.4560  0.6385        NaN  0.9911        NaN  0.8829          NaN  0.035113
     3     100.00     310.26       1.00       1.4840  1.4766         NaN    0.000      698.40  700.38      0.4340  0.5966        NaN  0.9521        NaN  0.8356          NaN  0.030873
     4     100.00     275.79       1.00       1.4930  1.4884         NaN    0.000      693.90  694.84      0.4130  0.5549        NaN  0.9211        NaN  0.7986          NaN  0.027221
     5     100.00     268.90       1.00       1.4950  1.4909         NaN    0.000      692.90  693.67      0.4090  0.5465        NaN  0.9159        NaN  0.7922          NaN  0.026545
     6     100.00     262.00       1.00       1.4970  1.4934         NaN    0.000      692.00  692.48      0.4040  0.5382        NaN  0.9109        NaN  0.7861          NaN  0.025884
     7     100.00     255.11       1.00       1.4990  1.4960         NaN    0.000      691.10  691.27      0.4000  0.5298        NaN  0.9062        NaN  0.7802          NaN  0.025239
     8     100.00     246.83       1.00       1.5020  1.4939       0.000    1.692      689.90  691.17      0.3950  0.5277        NaN  0.9010        NaN  0.7736          NaN  0.024485
     9     100.00     220.63       1.00       1.4550  1.4466      18.340   19.984      700.10  702.11      0.4250  0.5902     0.8780  0.8876     0.7920  0.7550     0.022900  0.022244
    10     100.00     193.05       1.00       1.4110  1.4002      35.950   37.910      710.20  713.80      0.4730  0.6662     0.8670  0.8784     0.7650  0.7393     0.020700  0.020132
    11     100.00     165.47       1.00       1.3700  1.3567      52.490   54.670      720.20  725.70      0.5380  0.7548     0.8640  0.8746     0.7490  0.7276     0.019000  0.018293
    12     100.00     137.90       1.00       1.3320  1.3156      68.140   70.415      730.20  737.85      0.6170  0.8585     0.8690  0.8763     0.7430  0.7206     0.017500  0.016741
    13     100.00     110.32       1.00       1.2950  1.2764      83.430   85.294      740.00  750.27      0.7080  0.9800     0.8790  0.8837     0.7510  0.7194     0.016200  0.015474
    14     100.00      82.74       1.00       1.2590  1.2386      98.370   99.445      750.00  763.01      0.8310  1.1227     0.8940  0.8968     0.7720  0.7273     0.015100  0.014466
    15     100.00      55.16       1.00       1.2230  1.2012     112.950  113.093      760.70  776.24      1.0360  1.2919     0.9130  0.9154     0.7930  0.7533     0.014100  0.013655
    16     100.00      27.58       1.00       1.1830  1.1614     128.420  126.944      772.30  790.69      1.4090  1.5031     0.9380  0.9396     0.8870  0.8365     0.012900  0.012874
    17     100.00      11.86       1.00       1.1520  1.1329     138.740  135.944      781.70  800.66      1.7390  1.6674     0.9630  0.9557     1.0470  1.0213     0.012400  0.012106
    18     100.00       0.00       0.00       1.0710  1.0242     157.590  159.055      802.30  827.73      2.0560  2.3072     1.0000  0.9846     1.7690  2.0998     0.009500  0.009716
    19      15.60       0.00       0.00       1.0000  0.9817         NaN  159.055      858.60  863.52         NaN  4.0238        NaN  0.9961        NaN  0.7251          NaN  0.010321
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_017_LV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_017_MR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Density (kg/m3)"
set output "Figures/Expt_017_LDEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_017_LVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_017_GZ_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_017_GSG_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_017_GVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Lab2 CCE of Surface Sample"
show title

$Expt << END
#           Pres          Rel Vol         Density (g/cm3)
#  Stg     (psig)      Expt    Calc        Expt     Calc
#------   --------   ----------------   ------------------
     1     3650.0     1.0000  1.0000     0.69540  0.69607
     2     3700.0     0.9992  0.9991     0.69600  0.69667
     3     3800.0     0.9978  0.9974     0.69700  0.69786
     4     3900.0     0.9963  0.9958     0.69800  0.69903
     5     4000.0     0.9949  0.9941     0.69900  0.70017
     6     4100.0     0.9935  0.9925     0.70000  0.70130
     7     4200.0     0.9922  0.9910     0.70090  0.70241
     8     4300.0     0.9909  0.9895     0.70190  0.70349
     9     4500.0     0.9883  0.9865     0.70370  0.70561
    10     5000.0     0.9823  0.9795     0.70800  0.71061
    11     5500.0     0.9768  0.9732     0.71200  0.71524
    12     6000.0     0.9717  0.9674     0.71570  0.71954
    13     6500.0     0.9671  0.9620     0.71910  0.72355
END
set xlabel "Pressure (psig)"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_019_DEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"

set title "CCE of Lab3_MDT1_Oil"
show title

$Expt << END
#           Pres          Rel Vol          Liq Sat (%)       Liq Den (g/cm3)
#  Stg      (bar)      Expt    Calc       Expt    Calc        Expt     Calc
#------   --------   ----------------   ----------------   ------------------
     1     981.73     0.9130  0.9042     100.00  100.00     0.76800  0.76059
     2     930.09     0.9160  0.9075     100.00  100.00     0.76600  0.75780
     3     861.28     0.9210  0.9123     100.00  100.00     0.76100  0.75381
     4     758.96     0.9300  0.9204     100.00  100.00     0.75400  0.74720
     5     647.82     0.9410  0.9307     100.00  100.00     0.74500  0.73889
     6     585.70     0.9480  0.9374     100.00  100.00     0.74000  0.73361
     7     516.41     0.9560  0.9459     100.00  100.00     0.73400  0.72706
     8     481.11     0.9600  0.9506     100.00  100.00     0.73000  0.72340
     9     445.60     0.9650  0.9558     100.00  100.00     0.72700  0.71948
    10     411.13     0.9700  0.9613     100.00  100.00     0.72300  0.71540
    11     372.66     0.9750  0.9679     100.00  100.00     0.71900  0.71050
    12     354.11     0.9790  0.9713     100.00  100.00     0.71600  0.70799
    13     310.54     0.9850  0.9801     100.00  100.00     0.71100  0.70166
    14     275.92     0.9920  0.9879     100.00  100.00     0.70700  0.69613
    15     242.90     0.9990  0.9961     100.00  100.00     0.70200  0.69036
    16     230.63     1.0000  1.0000     100.00   99.85     0.70100  0.68846
    17     227.66     1.0030  1.0038      99.94   99.08         NaN  0.68979
    18     206.77     1.0300  1.0349      95.27   93.53         NaN  0.69912
    19     190.29     1.0580  1.0663      91.25   88.93         NaN  0.70651
    20     155.13     1.1460  1.1646      81.88   78.06         NaN  0.72248
    21     120.45     1.3050  1.3366      69.78   65.30         NaN  0.73878
    22      54.33     2.3520  2.4416      36.41   32.84         NaN  0.77353
END
set xlabel "Pressure (bar)"
set ylabel "Relative Volume"
set output "Figures/Expt_021_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_021_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_021_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"

set title "DLE of Lab3_MDT1_Oil"
show title

$Expt << END
#           Temp        Pres                   Tot Vol 2 (m3)        Removed (sm3)        Liq Den (g/cm3)      Liq Vis (cp)         Gas Den (g/cm3)       Gas Sp Gravity      Gas Z-Factor
#  Stg       (C)       (bar)       Stg Wgt      Expt    Calc        Expt      Calc         Expt     Calc       Expt    Calc         Expt       Calc        Expt    Calc       Expt    Calc
#------   --------   ---------   ----------   ----------------   --------------------   ------------------   ----------------   ----------------------   ----------------   ----------------
     1     102.00     354.110       1.00          NaN  1.4269          NaN    0.0000         NaN  0.70799     0.5870  0.6262           NaN  0.2951955        NaN  0.8997        NaN  1.0021
     2     102.00     330.940       1.00          NaN  1.4335          NaN    0.0000         NaN  0.70470     0.5740  0.5996           NaN  0.2731245        NaN  0.8655        NaN  0.9738
     3     102.00     303.360       1.00          NaN  1.4420          NaN    0.0000         NaN  0.70055     0.5570  0.5678           NaN  0.2479556        NaN  0.8317        NaN  0.9449
     4     102.00     275.850       1.00          NaN  1.4512          NaN    0.0000         NaN  0.69611     0.5420  0.5362           NaN  0.2236051        NaN  0.8040        NaN  0.9210
     5     102.00     248.280       1.00          NaN  1.4612          NaN    0.0000         NaN  0.69134     0.5270  0.5045           NaN  0.1996673        NaN  0.7810        NaN  0.9018
     6     102.00     234.420       1.00          NaN  1.4666          NaN    0.0000         NaN  0.68880     0.5190  0.4885           NaN  0.1877534        NaN  0.7711        NaN  0.8940
     7     102.00     230.630       1.00       1.4690  1.4667       0.0000    0.4427         NaN  0.68846     0.5170  0.4862           NaN  0.1845069        NaN  0.7686        NaN  0.8921
     8     102.00     175.810       1.00       1.4130  1.3687      35.1000   37.8554         NaN  0.71305     0.7370  0.6232     0.1373000  0.1380503     0.7340  0.7401     0.8730  0.8752
     9     102.00     113.760       1.00       1.3180  1.2714      70.8000   74.5106         NaN  0.74188     0.8840  0.8408     0.0849000  0.0873199     0.7120  0.7295     0.8860  0.8825
    10     102.00      44.820       1.00       1.2140  1.1689     107.9000  111.3146         NaN  0.77680     1.2500  1.2126     0.0344000  0.0352162     0.7670  0.7830     0.9280  0.9254
    11     102.00      13.790       1.00       1.1610  1.1136     124.5000  128.9988         NaN  0.79610     1.5150  1.4797     0.0126000  0.0133212     0.9410  0.9952     0.9600  0.9566
    12     102.00       3.030       0.25       1.1160  1.0651     138.3000  140.9606         NaN  0.81021     1.7510  1.7236     0.0043000  0.0046516     1.5060  1.6088     0.9760  0.9731
    13     102.00       1.010       0.00       1.0760  1.0276     146.0000  148.4390         NaN  0.81927     2.0380  1.9191     0.0020000  0.0022093     2.0930  2.3122     0.9840  0.9816
    14      15.00       1.010       0.00       1.0000  0.9815          NaN  148.4390     0.86900  0.85771        NaN  3.4576           NaN  0.0008930        NaN  0.7284        NaN  0.9960
END
set xlabel "Pressure (bar)"
set ylabel "Volume, After Removal (m3)"
set output "Figures/Expt_022_V2_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_022_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_022_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_022_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_022_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_022_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Swelling of Lab3_Surface_Oil with 23% C2+ Gas"
show title

$Expt << END
#                                        Sat Pres (psia)      Liq Vol Frac       Density (g/cm3)         Rel Vol             C30+ K-Value
#  Stg      Rel Moles Inj      Feed       Expt    Calc        Expt    Calc        Expt     Calc       Expt    Calc         Expt        Calc
#------   ----------------   -------   ------------------   ----------------   ------------------   ----------------   ------------------------
     1         0.0000          NaN        3720.   3656.      1.0000  1.0000     0.69900  0.68660     1.0000  1.0012            NaN  1.0944e-04
     2         0.2500          F20        4500.   4532.      1.0000  1.0000     0.67700  0.65467     1.1100  1.1113            NaN  1.5076e-03
     3         0.6667          F40        5800.   5694.      1.0000  1.0000     0.62100  0.61532     1.3000  1.2910            NaN  2.6133e-02
     4         1.0000          F50        6710.   6491.      1.0000  1.0000     0.58300  0.59273     1.4800  1.4305            NaN  1.4938e-01
     5         1.0500          NaN          NaN   6609.         NaN  1.0000         NaN  0.58991        NaN  1.4509            NaN  1.9540e-01
     6         1.1000          NaN          NaN   6729.         NaN  1.0000         NaN  0.58724        NaN  1.4712            NaN  2.5966e-01
     7         1.1500          NaN          NaN   6851.         NaN  1.0000         NaN  0.58474        NaN  1.4912            NaN  3.5447e-01
     8         1.2000          NaN          NaN   6977.         NaN  1.0000         NaN  0.58240        NaN  1.5110            NaN  5.0528e-01
     9         1.2500          NaN          NaN   7111.         NaN  1.0000         NaN  0.58027        NaN  1.5304            NaN  7.5463e-01
    10         1.3000          NaN          NaN   7254.         NaN  0.0000         NaN  0.57834        NaN  1.5493     1.0000e+00  9.1676e-01
    11         1.3500          NaN          NaN   7403.         NaN  0.0000         NaN  0.57660        NaN  1.5680            NaN  7.0533e-01
    12         1.4000          NaN          NaN   7557.         NaN  0.0000         NaN  0.57498        NaN  1.5863            NaN  5.8650e-01
    13         1.4500          NaN          NaN   7711.      0.0000  0.0000         NaN  0.57347        NaN  1.6045            NaN  5.0997e-01
    14         1.5000          F60        7750.   7867.      0.0000  0.0000     0.54800  0.57204     1.7300  1.6225            NaN  4.5562e-01
    15         2.3333          NaN          NaN  10254.      0.0000  0.0000         NaN  0.55451        NaN  1.9150            NaN  1.9482e-01
    16         4.0000          NaN          NaN  13483.      0.0000  0.0000         NaN  0.53250        NaN  2.4966            NaN  9.7437e-02
    17         5.6667          NaN          NaN  14920.      0.0000  0.0000         NaN  0.51486        NaN  3.1017            NaN  6.4095e-02
    18         7.0000          NaN          NaN  15196.      0.0000  0.0000         NaN  0.50169        NaN  3.6097            NaN  4.9611e-02
    19         9.0000          F90       15000.  14889.      0.0000  0.0000         NaN  0.48362        NaN  4.4083            NaN  3.6387e-02
END
set xlabel "Relative Moles Injected"
set ylabel "Saturation Pressure (psia)"
set output "Figures/Expt_024_SATP_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Volume Fraction"
set output "Figures/Expt_024_LVF_vs_RMI_1.pdf"
plot [0:*][0:1] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_024_DEN_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:8 with points title "Expt", $Expt using 2:9 with lines title "Calc"
set ylabel "Relative Volume"
set output "Figures/Expt_024_RV_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 100% Lab3_Surface_Oil, 0% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     6000.0       1.00       0.9730  0.9674     100.00  100.00         NaN   96.74      0.71900  0.71059
     2     5500.0       1.00       0.9790  0.9734     100.00  100.00         NaN   97.34      0.71500  0.70619
     3     5000.0       1.00       0.9840  0.9800     100.00  100.00         NaN   98.00      0.71100  0.70145
     4     4750.0       1.00       0.9870  0.9835     100.00  100.00         NaN   98.35      0.70900  0.69894
     5     4500.0       1.00       0.9900  0.9872     100.00  100.00         NaN   98.72      0.70700  0.69632
     6     4250.0       1.00       0.9930  0.9911     100.00  100.00         NaN   99.11      0.70400  0.69359
     7     4000.0       1.00       0.9960  0.9952     100.00  100.00         NaN   99.52      0.70200  0.69074
     8     3720.0       1.00       1.0000  1.0000     100.00  100.00         NaN  100.00      0.69900  0.68739
     9     3400.0       1.00       1.0230  1.0215      96.10   95.78       98.29   97.84          NaN  0.67295
    10     3000.0       1.00       1.0620  1.0637      90.16   88.90       95.71   94.56          NaN  0.64625
    11     2500.0       1.00       1.1380  1.1442      81.56   79.38       92.79   90.83          NaN  0.60077
    12     2000.0       1.00       1.2670  1.2803      71.14   68.21       90.16   87.33          NaN  0.53689
    13     1500.0       1.00       1.5090  1.5334      58.01   54.73       87.56   83.93          NaN  0.44828
    14     1000.0       1.00       2.0450  2.0917      41.63   38.43       85.12   80.38          NaN  0.32863
    15      450.0       1.00       4.4700  4.3575      18.17   17.34       81.21   75.58          NaN  0.15775
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_025_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_025_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_025_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 80% Lab3_Surface_Oil, 20% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     6000.0       1.00       0.9790  0.9735     100.00  100.00         NaN  97.345      0.68100  0.67138
     2     5500.0       1.00       0.9860  0.9811     100.00  100.00         NaN  98.112      0.67700  0.66613
     3     5250.0       1.00       0.9890  0.9852     100.00  100.00         NaN  98.523      0.67500  0.66335
     4     5000.0       1.00       0.9930  0.9896     100.00  100.00         NaN  98.956      0.67200  0.66045
     5     4750.0       1.00       0.9960  0.9941     100.00  100.00         NaN  99.412      0.67000  0.65742
     6     4500.0       1.00       1.0000  1.0000     100.00   99.46         NaN  99.458      0.66700  0.65355
     7     4250.0       1.00       1.0130  1.0145      95.80   95.38      97.000  96.767          NaN  0.64419
     8     3750.0       1.00       1.0460  1.0526      88.41   87.54      92.520  92.139          NaN  0.62090
     9     3250.0       1.00       1.0970  1.1083      81.59   79.56      89.510  88.180          NaN  0.58968
    10     2750.0       1.00       1.1760  1.1933      73.83   70.92      86.790  84.631          NaN  0.54766
    11     2250.0       1.00       1.3050  1.3303      64.65   61.12      84.340  81.312          NaN  0.49128
    12     1750.0       1.00       1.5300  1.5688      53.48   49.77      81.820  78.071          NaN  0.41660
    13     1250.0       1.00       1.9740  2.0399      40.13   36.63      79.220  74.729          NaN  0.32038
    14      600.0       1.00       3.9240  4.0186      19.11   17.31      75.000  69.576          NaN  0.16263
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_026_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_026_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_026_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 60% Lab3_Surface_Oil, 40% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     8000.0       1.00       0.9650  0.9628     100.00  100.00         NaN   96.28      0.64300  0.64049
     2     7500.0       1.00       0.9710  0.9700     100.00  100.00         NaN   97.00      0.63900  0.63573
     3     7000.0       1.00       0.9790  0.9779     100.00  100.00         NaN   97.79      0.63400  0.63063
     4     6500.0       1.00       0.9870  0.9865     100.00  100.00         NaN   98.65      0.62900  0.62514
     5     6250.0       1.00       0.9910  0.9911     100.00  100.00         NaN   99.11      0.62600  0.62223
     6     6000.0       1.00       0.9960  0.9959     100.00  100.00         NaN   99.59      0.62300  0.61920
     7     5800.0       0.50       1.0000  1.0000     100.00  100.00         NaN  100.00      0.62100  0.61669
     8     5500.0       0.50       1.0100  1.0099      91.77   95.90       92.67   96.85          NaN  0.61065
     9     5000.0       1.00       1.0310  1.0339      84.01   87.48       86.59   90.44          NaN  0.59646
    10     4000.0       1.00       1.1000  1.1104      73.29   73.85       80.65   82.00          NaN  0.55539
    11     3000.0       1.00       1.2460  1.2654      61.24   59.86       76.29   75.75          NaN  0.48735
    12     2000.0       1.00       1.6120  1.6445      44.78   42.60       72.17   70.06          NaN  0.37499
    13     1500.0       1.00       2.0200  2.0752      34.60   32.32       69.89   67.07          NaN  0.29716
    14      965.0       1.00       3.0260  3.1135      20.60   20.38       62.32   63.45          NaN  0.19807
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_027_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_027_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_027_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 50% Lab3_Surface_Oil, 50% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     9990.0       1.00       0.9440  0.9485     100.00  100.00         NaN   94.85      0.61800  0.62779
     2     9490.0       1.00       0.9500  0.9547     100.00  100.00         NaN   95.47      0.61400  0.62370
     3     9000.0       1.00       0.9560  0.9613     100.00  100.00         NaN   96.13      0.61000  0.61944
     4     8500.0       1.00       0.9640  0.9685     100.00  100.00         NaN   96.85      0.60500  0.61483
     5     8000.0       1.00       0.9720  0.9763     100.00  100.00         NaN   97.63      0.60000  0.60990
     6     7500.0       1.00       0.9820  0.9848     100.00  100.00         NaN   98.48      0.59400  0.60463
     7     7004.0       1.00       0.9930  0.9941     100.00  100.00         NaN   99.41      0.58800  0.59901
     8     6800.0       1.00       0.9980  0.9982     100.00  100.00         NaN   99.82      0.58500  0.59657
     9     6710.0       0.50       1.0000  1.0000     100.00  100.00         NaN  100.00      0.58300  0.59547
    10     6500.0       0.50       1.0050  1.0044      91.90  100.00       92.38  100.44          NaN  0.59284
    11     6000.0       0.50       1.0200  1.0216      78.34   87.19       79.94   89.07          NaN  0.58289
    12     5000.0       1.00       1.0680  1.0726      69.49   74.22       74.25   79.61          NaN  0.55517
    13     4000.0       1.00       1.1550  1.1630      61.75   63.42       71.31   73.75          NaN  0.51202
    14     2000.0       1.00       1.7700  1.7832      37.51   35.85       66.38   63.93          NaN  0.33393
    15     1300.0       1.00       2.6150  2.6017      24.18   23.05       63.23   59.97          NaN  0.22888
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_028_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_028_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_028_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 40% Lab3_Surface_Oil, 60% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)      Gas Z-Factor
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc       Expt    Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------   ----------------
     1     9900.0       1.00       0.9630  0.9628      0.000   0.000       0.000   0.000      0.56900  0.59260     2.0650  1.9986
     2     9500.0       1.00       0.9680  0.9687      0.000   0.000       0.000   0.000      0.56600  0.58896     1.9920  1.9296
     3     9000.0       1.00       0.9760  0.9767      0.000   0.000       0.000   0.000      0.56100  0.58417     1.9030  1.8431
     4     8750.0       1.00       0.9810  0.9809      0.000   0.000       0.000   0.000      0.55900  0.58165     1.8590  1.7996
     5     8500.0       1.00       0.9850  0.9853      0.000   0.000       0.000   0.000      0.55600  0.57905     1.8140  1.7561
     6     8250.0       1.00       0.9890  0.9899      0.000   0.000       0.000   0.000      0.55400  0.57636     1.7680  1.7124
     7     8000.0       0.50       0.9940  0.9947      0.000   0.000       0.000   0.000      0.55100  0.57357     1.7240  1.6686
     8     7750.0       0.25       1.0000  1.0000      0.000   6.945       0.000   6.945      0.54800  0.57056     1.6790  1.6079
     9     7500.0       0.25       1.0060  1.0059     19.710  21.022      19.830  21.146      0.54500  0.56723        NaN  1.5271
    10     7000.0       0.50       1.0190  1.0195     44.130  51.425      44.970  52.427      0.53800  0.55965        NaN  1.3472
    11     6000.0       1.00       1.0570  1.0579     52.790  63.340      55.810  67.007      0.51800  0.53933        NaN  1.1080
    12     5010.0       1.00       1.1180  1.1186     51.570  58.997      57.660  65.994      0.49000  0.51007        NaN  0.9783
    13     4000.0       1.00       1.2210  1.2263     47.750  51.690      58.280  63.386      0.44900  0.46528        NaN  0.8918
    14     3000.0       1.00       1.4310  1.4381     40.820  41.907      58.430  60.267      0.38300  0.39674        NaN  0.8445
    15     1750.0       1.00       2.2000  2.1907     25.310  25.225      55.690  55.262      0.24900  0.26044        NaN  0.8487
    16      950.0       1.00       4.0050  3.9667     13.360  12.776      53.510  50.678      0.13700  0.14384        NaN  0.8933
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_029_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_029_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_029_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 10% Lab3_Surface_Oil, 90% Injectant"
show title

$Expt << END
#           Pres         Liq Sat (%)        Density (g/cm3)
#  Stg     (psia)       Expt     Calc        Expt     Calc
#------   --------   ------------------   ------------------
     1     14900.      0.8600   0.0000     0.45500  0.48370
     2     14000.      1.0900   0.5056     0.44500  0.47705
     3     13000.      1.2200   1.1170     0.44200  0.46894
     4     12000.      1.4100   1.7669     0.43400  0.45993
     5     11000.      1.7600   2.4462     0.42600  0.44984
     6     10000.      2.4400   3.1453     0.41600  0.43840
     7      9000.      3.2300   3.8575     0.40200  0.42527
     8      8000.      4.5900   4.5916     0.38800  0.40993
     9      7000.      7.1500   5.4144     0.37100  0.39159
    10      6000.      9.2100   6.5986     0.35000  0.36890
    11      5000.     10.3300   8.5088     0.32600  0.33925
    12      4000.     11.2200   9.8823     0.28900  0.29900
    13      3500.     11.2400   9.9205     0.26500  0.27344
    14      3000.     10.8100   9.4511     0.23600  0.24330
    15      1685.      7.2700   5.8076     0.13400  0.14101
END
set xlabel "Pressure (psia)"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_030_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_030_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"

set title "CCE of Lab3_MDT2_Oil"
show title

$Expt << END
#           Pres      Liq Vol Frac (%)         Rel Vol         Liq Den (g/cm3)
#  Stg      (kPa)       Expt    Calc        Expt    Calc        Expt     Calc
#------   --------   ------------------   ----------------   ------------------
     1     55158.      100.00  100.00      0.9530  0.9450     0.72500  0.72872
     2     48264.      100.00  100.00      0.9610  0.9538     0.71900  0.72202
     3     41383.      100.00  100.00      0.9700  0.9639     0.71300  0.71443
     4     34853.      100.00  100.00      0.9800  0.9752     0.70500  0.70619
     5     31027.      100.00  100.00      0.9860  0.9827     0.70100  0.70079
     6     27579.      100.00  100.00      0.9920  0.9902     0.69600  0.69548
     7     24146.      100.00  100.00      0.9990  0.9985     0.69200  0.68971
     8     23546.      100.00  100.00      1.0000  1.0000     0.69100  0.68865
     9     22422.       97.80   98.43      1.0130  1.0090         NaN  0.69044
    10     20684.       93.50   93.82      1.0370  1.0347         NaN  0.69825
    11     18961.       89.20   89.02      1.0680  1.0670         NaN  0.70604
    12     17237.       84.60   83.90      1.1070  1.1085         NaN  0.71390
    13     13686.       73.30   71.91      1.2370  1.2393         NaN  0.73048
    14     10370.       60.30   58.36      1.4620  1.4674         NaN  0.74670
    15      6909.       43.10   41.15      1.9770  1.9905         NaN  0.76505
END
set xlabel "Pressure (kPa)"
set ylabel "Liquid Volume Fraction (%)"
set output "Figures/Expt_033_LVF_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Relative Volume"
set output "Figures/Expt_033_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_033_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"

set title "DLE of Lab3_MDT2_Oil at 92.2 C"
show title

$Expt << END
#           Temp        Pres                    Removed (sm3)      Liq Den (g/cm3)      Liq Vol (m3)       Liq Vis (cp)         Gas Den (g/cm3)           Gas MW         Gas Sp Gravity       Gas Z-Factor          Gas Vis (cp)            N2 y (%)            CO2 y (%)          C1 y (%)           C2 y (%)           C3 y (%)           C4+ y (%)           C6+ y (%)
#  Stg       (C)       (kPa)       Stg Wgt      Expt    Calc        Expt     Calc       Expt    Calc       Expt    Calc         Expt       Calc        Expt    Calc       Expt    Calc        Expt     Calc        Expt      Calc         Expt     Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc
#------   --------   ---------   ----------   ----------------   ------------------   ----------------   ----------------   ----------------------   ----------------   ----------------   ------------------   --------------------   ------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------
     1     92.200     34853.0       1.00         0.00    0.00     0.70500  0.70619     1.4870  1.4793     0.7840  0.6153           NaN  0.2977963        NaN  25.655        NaN  0.8857         NaN  0.98843          NaN  0.036426         NaN  0.32400        NaN  1.2559        NaN  80.675        NaN   5.499        NaN   4.032        NaN   8.214         NaN   4.8634
     2     92.200     32406.0       1.00         0.00    0.00         NaN  0.70279        NaN  1.4865     0.7510  0.5883           NaN  0.2741488        NaN  24.616        NaN  0.8499         NaN  0.95789          NaN  0.033163         NaN  0.32741        NaN  1.2721        NaN  81.526        NaN   5.503        NaN   3.963        NaN   7.409         NaN   4.1995
     3     92.200     29648.0       1.00         0.00    0.00         NaN  0.69872        NaN  1.4951     0.7220  0.5578           NaN  0.2485349        NaN  23.650        NaN  0.8165         NaN  0.92873          NaN  0.029923         NaN  0.33071        NaN  1.2931        NaN  82.348        NaN   5.521        NaN   3.895        NaN   6.613         NaN   3.5536
     4     92.200     27234.0       1.00         0.00    0.00         NaN  0.69493        NaN  1.5033     0.7000  0.5310           NaN  0.2266645        NaN  22.943        NaN  0.7921         NaN  0.90747          NaN  0.027357         NaN  0.33318        NaN  1.3143        NaN  82.963        NaN   5.549        NaN   3.845        NaN   5.996         NaN   3.0606
     5     92.200     24821.0       1.00         0.00    0.00         NaN  0.69089        NaN  1.5121     0.6770  0.5043           NaN  0.2051089        NaN  22.344        NaN  0.7714         NaN  0.89013          NaN  0.024994         NaN  0.33528        NaN  1.3387        NaN  83.485        NaN   5.592        NaN   3.805        NaN   5.444         NaN   2.6260
     6     92.200     23546.0       1.00         0.00    0.00     0.69100  0.68865     1.5170  1.5170     0.6670  0.4901           NaN  0.1938017        NaN  22.067        NaN  0.7619         NaN  0.88259          NaN  0.023821         NaN  0.33624        NaN  1.3530        NaN  83.723        NaN   5.622        NaN   3.788        NaN   5.177         NaN   2.4180
     7     92.200     17926.0       1.00        39.00   37.45     0.71600  0.71075     1.4170  1.4227     0.7430  0.6101     0.1460000  0.1444762     20.900  21.139     0.7220  0.7299     0.84600  0.86345     0.019700  0.019292     0.50000  0.33899     1.4430  1.4312     84.108  84.407      5.895   5.840      3.836   3.778      4.215   4.204      1.5560   1.6661
     8     92.200     12411.0       1.00        73.00   72.96     0.73800  0.73659     1.3340  1.3305     0.9290  0.7961     0.0970000  0.0974939     20.400  20.734     0.7040  0.7159     0.85800  0.86890     0.016700  0.016009     0.39000  0.33781     1.5550  1.5682     84.360  84.116      6.334   6.372      3.941   3.984      3.419   3.622      0.9830   1.1785
     9     92.200      6895.0       1.00       103.00  104.94     0.76000  0.76394     1.2610  1.2454     1.1440  1.0591     0.0530000  0.0535147     20.900  21.207     0.7220  0.7322     0.89000  0.89948     0.014500  0.013887     0.32000  0.32648     1.7960  1.8487     81.772  81.294      7.732   7.851      4.822   4.928      3.554   3.752      0.8290   0.9766
    10     92.200      2758.0       1.00       126.00  128.36     0.78200  0.78680     1.1970  1.1790     1.4430  1.3421     0.0220000  0.0231786     23.200  23.961     0.8010  0.8273     0.93800  0.93857     0.013000  0.012711     0.37000  0.28682     2.0880  2.3319     73.077  71.417     11.163  11.653      7.903   8.309      5.399   6.002      1.0170   1.3372
    11     92.200       101.3       0.00       161.00  164.29     0.81200  0.82594     1.0610  1.0263     2.6010  2.0904     0.0020000  0.0017770     50.800  52.624     1.7530  1.8169     0.99600  0.98781     0.009300  0.009978     0.48400  0.08684     1.3280  1.4210     21.877  21.623     12.236  12.182     18.925  19.244     45.150  45.444     19.2640  19.4795
    12     15.000       101.3       0.00       161.00  164.29     0.86100  0.85908     1.0000  0.9867        NaN  3.4774           NaN  0.0008905        NaN  20.972        NaN  0.7241         NaN  0.99605          NaN  0.010333         NaN  0.33787        NaN  0.8204        NaN  84.130        NaN   5.085        NaN   4.818        NaN   4.809         NaN   1.0952
END
set xlabel "Pressure (kPa)"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_034_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_034_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_034_LV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_034_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_034_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_034_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_034_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:19 with points title "Expt", $Expt using 3:20 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_034_GVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:21 with points title "Expt", $Expt using 3:22 with lines title "Calc"
set ylabel "Gas C1 Mole Fraction (%)"
set output "Figures/Expt_034_Y-C1_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:27 with points title "Expt", $Expt using 3:28 with lines title "Calc"
set ylabel "Gas C2 Mole Fraction (%)"
set output "Figures/Expt_034_Y-C2_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:29 with points title "Expt", $Expt using 3:30 with lines title "Calc"
set ylabel "Gas C3 Mole Fraction (%)"
set output "Figures/Expt_034_Y-C3_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:31 with points title "Expt", $Expt using 3:32 with lines title "Calc"
set ylabel "Gas C4+ Mole Fraction (%)"
set output "Figures/Expt_034_Y-C4+_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:33 with points title "Expt", $Expt using 3:34 with lines title "Calc"

set title "DLE of Lab3_MDT2_Oil at 70 C"
show title

$Expt << END
#          Temp        Pres                    Removed (sm3)      Liq Den (g/cm3)      Liq Vol (m3)       Liq Vis (cp)         Gas Den (g/cm3)           Gas MW         Gas Sp Gravity       Gas Z-Factor          Gas Vis (cp)           N2 y (%)           CO2 y (%)          C1 y (%)           C2 y (%)           C3 y (%)           C4+ y (%)           C6+ y (%)
# Stg       (C)       (kPa)       Stg Wgt      Expt    Calc        Expt     Calc       Expt    Calc       Expt    Calc         Expt       Calc        Expt    Calc       Expt    Calc        Expt     Calc        Expt      Calc        Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc
#-----   --------   ---------   ----------   ----------------   ------------------   ----------------   ----------------   ----------------------   ----------------   ----------------   ------------------   --------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------
    1     70.000     22408.0       1.00         0.00    0.00     0.70700  0.70362     1.4510  1.4510        NaN  0.5943           NaN  0.1950112        NaN  21.095        NaN  0.7283         NaN  0.84959          NaN  0.023570        NaN  0.3429        NaN  1.2894        NaN  85.394        NaN   5.306        NaN   3.437        NaN   4.231         NaN   1.8425
    2     70.000     17926.0       1.00        29.00   26.95     0.72500  0.71888     1.3820  1.3879     1.2600  0.6915     0.1460000  0.1530907     19.200  20.351     0.6620  0.7026     0.82300  0.83523     0.019400  0.019585     0.4600  0.3459     1.0550  1.3488     88.686  86.128      4.490   5.419      2.779   3.348      2.527   3.411      0.7260   1.2686
    3     70.000     12411.0       1.00        65.00   63.05     0.74900  0.74434     1.2990  1.2997     1.3670  0.9007     0.0980000  0.1023079     18.900  19.866     0.6540  0.6859     0.83800  0.84467     0.016300  0.015822     0.2500  0.3463     1.1230  1.4792     89.378  86.234      4.502   5.822      2.616   3.395      2.132   2.724      0.6110   0.7967
    4     70.000      6895.0       1.00        94.00   96.17     0.77500  0.77181     1.2260  1.2169     1.5580  1.2028     0.0520000  0.0549779     19.100  20.140     0.6590  0.6953     0.88000  0.88528     0.014000  0.013463     0.1600  0.3377     1.3210  1.7735     87.938  84.083      5.528   7.145      3.108   4.052      1.948   2.610      0.3880   0.5772
    5     70.000      2758.0       1.00       116.00  120.44     0.79700  0.79472     1.1660  1.1530     1.8480  1.5270     0.0220000  0.0230526     21.300  22.286     0.7340  0.7695     0.93000  0.93453     0.012600  0.012297     0.1000  0.3033     1.9570  2.3584     79.085  75.520      9.551  10.976      5.975   6.844      3.335   3.999      0.4900   0.7192
    6     70.000       103.0       0.00       152.00  154.82     0.82300  0.83070     1.0410  1.0234     3.1250  2.2640     0.0020000  0.0016635     48.900  45.561     1.6890  1.5730     0.99100  0.98875     0.008800  0.009852     2.0300  0.1038     1.8090  1.7912     14.932  25.850     15.914  14.740     23.980  21.681     41.335  35.834     12.0260  11.2439
    7     15.000       101.3       0.00       152.00  154.82     0.85700  0.85418     1.0000  0.9952        NaN  3.2478           NaN  0.0009882        NaN  23.253        NaN  0.8028         NaN  0.99515          NaN  0.010105        NaN  0.3062        NaN  1.2211        NaN  76.253        NaN   7.707        NaN   7.579        NaN   6.935         NaN   1.3024
END
set xlabel "Pressure (kPa)"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_035_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_035_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_035_LV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_035_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_035_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_035_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_035_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:19 with points title "Expt", $Expt using 3:20 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_035_GVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:21 with points title "Expt", $Expt using 3:22 with lines title "Calc"
set ylabel "Gas C1 Mole Fraction (%)"
set output "Figures/Expt_035_Y-C1_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:27 with points title "Expt", $Expt using 3:28 with lines title "Calc"
set ylabel "Gas C2 Mole Fraction (%)"
set output "Figures/Expt_035_Y-C2_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:29 with points title "Expt", $Expt using 3:30 with lines title "Calc"
set ylabel "Gas C3 Mole Fraction (%)"
set output "Figures/Expt_035_Y-C3_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:31 with points title "Expt", $Expt using 3:32 with lines title "Calc"
set ylabel "Gas C4+ Mole Fraction (%)"
set output "Figures/Expt_035_Y-C4+_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:33 with points title "Expt", $Expt using 3:34 with lines title "Calc"

set title "Damped Isothermal Segregation from Averaged Sample"
show title

$Expt << END
#           Depth                               Pressure (bar)     Sat Pres (bar)      Density (g/cm3)      Viscosity (cp)            MW           Overall C6+ MW           C1 zwt                C2-C5 zwt              C6+ zwt
#  Stg       (m)         Feed         Zone       Expt    Calc       Expt    Calc        Expt     Calc        Expt     Calc       Expt    Calc       Expt    Calc        Expt      Calc         Expt      Calc         Expt     Calc
#------   ---------   ----------   ---------   ----------------   ----------------   ------------------   ------------------   ----------------   ----------------   --------------------   --------------------   ------------------
     1     3200.00     F_3200         Oil          NaN  328.47        NaN  237.45         NaN  0.69745         NaN  0.55565        NaN   97.05        NaN  229.84          NaN  0.075870          NaN  0.085496         NaN  0.83297
     2     3220.00          NaN       Oil          NaN  329.84        NaN  237.08         NaN  0.69834         NaN  0.56209        NaN   97.35        NaN  230.24          NaN  0.075533          NaN  0.085180         NaN  0.83364
     3     3240.00          NaN       Oil          NaN  331.21        NaN  236.70         NaN  0.69923         NaN  0.56859        NaN   97.65        NaN  230.64          NaN  0.075198          NaN  0.084865         NaN  0.83431
     4     3260.00          NaN       Oil          NaN  332.58        NaN  236.33         NaN  0.70012         NaN  0.57514        NaN   97.94        NaN  231.03          NaN  0.074866          NaN  0.084551         NaN  0.83497
     5     3280.00          NaN       Oil          NaN  333.95        NaN  235.95         NaN  0.70100         NaN  0.58176        NaN   98.24        NaN  231.43          NaN  0.074536          NaN  0.084239         NaN  0.83563
     6     3300.00          NaN       Oil          NaN  335.33        NaN  235.58         NaN  0.70188         NaN  0.58844        NaN   98.54        NaN  231.83          NaN  0.074208          NaN  0.083929         NaN  0.83628
     7     3317.90     F_3317.9       Oil       336.63  336.56        NaN  235.25         NaN  0.70266         NaN  0.59446        NaN   98.81        NaN  232.18     0.073180  0.073916     0.083951  0.083653     0.83733  0.83687
     8     3320.00          NaN       Oil          NaN  336.71        NaN  235.21         NaN  0.70275         NaN  0.59517        NaN   98.84        NaN  232.22          NaN  0.073882          NaN  0.083620         NaN  0.83694
     9     3340.00          NaN       Oil          NaN  338.09        NaN  234.84         NaN  0.70362         NaN  0.60197        NaN   99.14        NaN  232.62          NaN  0.073559          NaN  0.083313         NaN  0.83758
    10     3346.40     F_3346.4       Oil       338.55  338.53        NaN  234.73         NaN  0.70389         NaN  0.60416        NaN   99.24        NaN  232.75     0.073692  0.073456     0.082350  0.083215     0.83842  0.83779
    11     3350.00     F_3350         Oil          NaN  338.78        NaN  234.66         NaN  0.70405         NaN  0.60539        NaN   99.29        NaN  232.82          NaN  0.073398          NaN  0.083160         NaN  0.83791
    12     3360.00          NaN       Oil          NaN  339.47        NaN  234.48         NaN  0.70448         NaN  0.60883        NaN   99.44        NaN  233.02          NaN  0.073238          NaN  0.083008         NaN  0.83823
    13     3380.00          NaN       Oil          NaN  340.85        NaN  234.11         NaN  0.70534         NaN  0.61575        NaN   99.74        NaN  233.41          NaN  0.072918          NaN  0.082704         NaN  0.83887
    14     3400.00          NaN       Oil          NaN  342.23        NaN  233.75         NaN  0.70619         NaN  0.62273        NaN  100.04        NaN  233.81          NaN  0.072601          NaN  0.082401         NaN  0.83950
    15     3403.80     F_3403.8       Oil       342.40  342.50        NaN  233.68         NaN  0.70636         NaN  0.62406        NaN  100.10        NaN  233.89     0.071692  0.072541     0.082205  0.082344     0.83991  0.83962
    16     3420.00          NaN       Oil          NaN  343.62        NaN  233.38         NaN  0.70704         NaN  0.62977        NaN  100.34        NaN  234.21          NaN  0.072287          NaN  0.082100         NaN  0.84014
    17     3440.00          NaN       Oil          NaN  345.01        NaN  233.02         NaN  0.70789         NaN  0.63688        NaN  100.64        NaN  234.60          NaN  0.071974          NaN  0.081801         NaN  0.84076
    18     3460.00          NaN       Oil          NaN  346.40        NaN  232.66         NaN  0.70873         NaN  0.64404        NaN  100.94        NaN  235.00          NaN  0.071663          NaN  0.081503         NaN  0.84139
    19     3480.00          NaN       Oil          NaN  347.79        NaN  232.30         NaN  0.70957         NaN  0.65127        NaN  101.24        NaN  235.40          NaN  0.071354          NaN  0.081207         NaN  0.84201
    20     3500.00     F_3500         Oil          NaN  349.18        NaN  231.94         NaN  0.71041         NaN  0.65857        NaN  101.54        NaN  235.80          NaN  0.071048          NaN  0.080912         NaN  0.84263
END
set xlabel "Pressure (bar)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_PRES_1.pdf"
plot [*:*][*:*] $Expt using 5:2 with points title "Expt", $Expt using 6:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Saturation Pressure (bar)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_SATP_1.pdf"
plot [*:*][*:*] $Expt using 7:2 with points title "Expt", $Expt using 8:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall Density (g/cm3)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_DEN_1.pdf"
plot [*:*][*:*] $Expt using 9:2 with points title "Expt", $Expt using 10:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Viscosity (cp)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_VIS_1.pdf"
plot [*:*][*:*] $Expt using 11:2 with points title "Expt", $Expt using 12:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C1 Mass Fraction"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_ZWT-C1_1.pdf"
plot [*:*][*:*] $Expt using 17:2 with points title "Expt", $Expt using 18:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C2-C5 Mass Fraction"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_ZWT-C2-C5_1.pdf"
plot [*:*][*:*] $Expt using 19:2 with points title "Expt", $Expt using 20:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C6+ Mass Fraction"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_ZWT-C6+_1.pdf"
plot [*:*][*:*] $Expt using 21:2 with points title "Expt", $Expt using 22:2 with lines title "Calc"
set yrange [] noreverse

set title "P-T Diagram for Lab1_Recombined_Oil"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   32.690     1.00000e-13        0.00000         2.54264e-15          1.00000       602.891     103.116     0.932450     4.05505e-16     1.84593e-17
   35.000     1.60898e-13        0.00000         4.06226e-15          1.00000       602.891     103.116     0.932019     6.47558e-16     2.93728e-17
   37.500     2.66726e-13        0.00000         6.68334e-15          1.00000       602.891     103.116     0.931549     1.06484e-15     4.81261e-17
   40.000     4.38030e-13        0.00000         1.08936e-14          1.00000       602.891     103.116     0.931075     1.73477e-15     7.81406e-17
   42.500     7.12798e-13        0.00000         1.75956e-14          1.00000       602.891     103.116     0.930597     2.80060e-15     1.25757e-16
   45.000     1.14962e-12        0.00000         2.81702e-14          1.00000       602.891     103.116     0.930115     4.48139e-15     2.00652e-16
   47.500     1.83808e-12        0.00000         4.47123e-14          1.00000       602.891     103.116     0.929629     7.10924e-15     3.17472e-16
   50.000     2.91399e-12        0.00000         7.03732e-14          1.00000       602.891     103.116     0.929139     1.11834e-14     4.98205e-16
   52.500     4.58161e-12        0.00000         1.09855e-13          1.00000       602.891     103.116     0.928646     1.74485e-14     7.75600e-16
   55.000     7.14565e-12        0.00000         1.70120e-13          1.00000       602.891     103.116     0.928148     2.70060e-14     1.19806e-15
   57.500     1.10571e-11        0.00000         2.61395e-13          1.00000       602.891     103.116     0.927646     4.14730e-14     1.83661e-15
   60.000     1.69787e-11        0.00000         3.98588e-13          1.00000       602.891     103.116     0.927139     6.32057e-14     2.79466e-15
   62.500     2.58766e-11        0.00000         6.03280e-13          1.00000       602.891     103.116     0.926629     9.56118e-14     4.22175e-15
   65.000     3.91496e-11        0.00000         9.06478e-13          1.00000       602.891     103.116     0.926115     1.43585e-13     6.33259e-15
   67.500     5.88084e-11        0.00000         1.35243e-12          1.00000       602.890     103.116     0.925596     2.14102e-13     9.43342e-15
   70.000     8.77235e-11        0.00000         2.00383e-12          1.00000       602.890     103.116     0.925073     3.17046e-13     1.39581e-14
   72.500     1.29966e-10        0.00000         2.94895e-12          1.00000       602.890     103.116     0.924546     4.66318e-13     2.05173e-14
   75.000     1.91269e-10        0.00000         4.31125e-12          1.00000       602.890     103.116     0.924014     6.81348e-13     2.99652e-14
   77.500     2.79660e-10        0.00000         6.26230e-12          1.00000       602.890     103.116     0.923478     9.89117e-13     4.34892e-14
   80.000     4.06304e-10        0.00000         9.03906e-12          1.00000       602.890     103.116     0.922938     1.42686e-12     6.27300e-14
   82.500     5.86636e-10        0.00000         1.29668e-11          1.00000       602.890     103.116     0.922393     2.04567e-12     8.99413e-14
   85.000     8.41866e-10        0.00000         1.84895e-11          1.00000       602.889     103.116     0.921844     2.91520e-12     1.28201e-13
   87.500     1.20098e-09        0.00000         2.62093e-11          1.00000       602.889     103.116     0.921290     4.12989e-12     1.81690e-13
   90.000     1.70333e-09        0.00000         3.69388e-11          1.00000       602.889     103.116     0.920732     5.81706e-12     2.56053e-13
   92.500     2.40211e-09        0.00000         5.17681e-11          1.00000       602.889     103.116     0.920169     8.14737e-12     3.58875e-13
   95.000     3.36875e-09        0.00000         7.21518e-11          1.00000       602.888     103.116     0.919601     1.13484e-11     5.00293e-13
   97.500     4.69873e-09        0.00000         1.00021e-10          1.00000       602.888     103.116     0.919029     1.57220e-11     6.93782e-13
  100.000     6.51898e-09        0.00000         1.37924e-10          1.00000       602.887     103.116     0.918452     2.16664e-11     9.57169e-13
  102.500     8.99734e-09        0.00000         1.89213e-10          1.00000       602.887     103.116     0.917871     2.97044e-11     1.31392e-12
  105.000     1.23547e-08        0.00000         2.58265e-10          1.00000       602.886     103.116     0.917284     4.05191e-11     1.79479e-12
  107.500     1.68804e-08        0.00000         3.50779e-10          1.00000       602.886     103.116     0.916693     5.49981e-11     2.43985e-12
  110.000     2.29514e-08        0.00000         4.74133e-10          1.00000       602.885     103.116     0.916097     7.42902e-11     3.30114e-12
  112.500     3.10569e-08        0.00000         6.37834e-10          1.00000       602.884     103.116     0.915496     9.98746e-11     4.44590e-12
  115.000     4.18283e-08        0.00000         8.54084e-10          1.00000       602.883     103.116     0.914890     1.33648e-10     5.96062e-12
  117.500     5.60775e-08        0.00000         1.13847e-09          1.00000       602.882     103.116     0.914279     1.78029e-10     7.95610e-12
  120.000     7.48435e-08        0.00000         1.51080e-09          1.00000       602.881     103.116     0.913663     2.36095e-10     1.05736e-11
  122.500     9.94504e-08        0.00000         1.99619e-09          1.00000       602.880     103.116     0.913042     3.11735e-10     1.39928e-11
  125.000     1.31579e-07        0.00000         2.62628e-09          1.00000       602.878     103.116     0.912416     4.09854e-10     1.84407e-11
  127.500     1.73351e-07        0.00000         3.44084e-09          1.00000       602.877     103.116     0.911784     5.36602e-10     2.42035e-11
  130.000     2.27441e-07        0.00000         4.48959e-09          1.00000       602.875     103.116     0.911148     6.99670e-10     3.16406e-11
  132.500     2.97199e-07        0.00000         5.83451e-09          1.00000       602.873     103.116     0.910506     9.08629e-10     4.12013e-11
  135.000     3.86809e-07        0.00000         7.55254e-09          1.00000       602.871     103.116     0.909858     1.17535e-09     5.34453e-11
  137.500     5.01476e-07        0.00000         9.73879e-09          1.00000       602.868     103.116     0.909206     1.51450e-09     6.90676e-11
  140.000     6.47653e-07        0.00000         1.25105e-08          1.00000       602.866     103.116     0.908548     1.94413e-09     8.89278e-11
  142.500     8.33308e-07        0.00000         1.60115e-08          1.00000       602.863     103.116     0.907884     2.48638e-09     1.14086e-10
  145.000     1.06824e-06        0.00000         2.04178e-08          1.00000       602.860     103.116     0.907215     3.16832e-09     1.45842e-10
  147.500     1.36448e-06        0.00000         2.59441e-08          1.00000       602.857     103.116     0.906540     4.02288e-09     1.85792e-10
  150.000     1.73671e-06        0.00000         3.28510e-08          1.00000       602.853     103.116     0.905860     5.09006e-09     2.35879e-10
  152.500     2.20281e-06        0.00000         4.14541e-08          1.00000       602.849     103.116     0.905174     6.41824e-09     2.98468e-10
  155.000     2.78451e-06        0.00000         5.21344e-08          1.00000       602.845     103.116     0.904482     8.06574e-09     3.76429e-10
  157.500     3.50808e-06        0.00000         6.53503e-08          1.00000       602.840     103.116     0.903785     1.01027e-08     4.73226e-10
  160.000     4.40518e-06        0.00000         8.16512e-08          1.00000       602.835     103.116     0.903081     1.26129e-08     5.93039e-10
  162.500     5.51391e-06        0.00000         1.01694e-07          1.00000       602.829     103.116     0.902372     1.56969e-08     7.40887e-10
  165.000     6.87992e-06        0.00000         1.26263e-07          1.00000       602.823     103.116     0.901657     1.94738e-08     9.22783e-10
  167.500     8.55775e-06        0.00000         1.56287e-07          1.00000       602.816     103.116     0.900936     2.40856e-08     1.14591e-09
  170.000     1.06124e-05        0.00000         1.92870e-07          1.00000       602.809     103.116     0.900208     2.96998e-08     1.41883e-09
  172.500     1.31210e-05        0.00000         2.37315e-07          1.00000       602.802     103.116     0.899474     3.65144e-08     1.75169e-09
  175.000     1.61751e-05        0.00000         2.91156e-07          1.00000       602.793     103.116     0.898735     4.47624e-08     2.15656e-09
  177.500     1.98826e-05        0.00000         3.56197e-07          1.00000       602.784     103.116     0.897988     5.47173e-08     2.64764e-09
  180.000     2.43708e-05        0.00000         4.34552e-07          1.00000       602.774     103.116     0.897236     6.66988e-08     3.24172e-09
  182.500     2.97891e-05        0.00000         5.28689e-07          1.00000       602.764     103.116     0.896477     8.10806e-08     3.95850e-09
  185.000     3.63127e-05        0.00000         6.41487e-07          1.00000       602.753     103.116     0.895711     9.82974e-08     4.82109e-09
  187.500     4.41462e-05        0.00000         7.76293e-07          1.00000       602.741     103.116     0.894939     1.18854e-07     5.85652e-09
  190.000     5.35282e-05        0.00000         9.36985e-07          1.00000       602.728     103.116     0.894161     1.43335e-07     7.09633e-09
  192.500     6.47361e-05        0.00000         1.12805e-06          1.00000       602.714     103.116     0.893375     1.72416e-07     8.57723e-09
  195.000     7.80915e-05        0.00000         1.35468e-06          1.00000       602.699     103.116     0.892583     2.06876e-07     1.03419e-08
  197.500     9.39666e-05        0.00000         1.62282e-06          1.00000       602.683     103.116     0.891784     2.47609e-07     1.24396e-08
  200.000     1.12791e-04        0.00000         1.93933e-06          1.00000       602.666     103.116     0.890978     2.95643e-07     1.49276e-08
  202.500     1.35059e-04        0.00000         2.31205e-06          1.00000       602.648     103.116     0.890165     3.52151e-07     1.78717e-08
  205.000     1.61340e-04        0.00000         2.74994e-06          1.00000       602.628     103.116     0.889344     4.18476e-07     2.13477e-08
  207.500     1.92285e-04        0.00000         3.26325e-06          1.00000       602.607     103.116     0.888517     4.96144e-07     2.54428e-08
  210.000     2.28638e-04        0.00000         3.86361e-06          1.00000       602.585     103.116     0.887682     5.86893e-07     3.02567e-08
  212.500     2.71251e-04        0.00000         4.56425e-06          1.00000       602.561     103.116     0.886840     6.92692e-07     3.59035e-08
  215.000     3.21091e-04        0.00000         5.38015e-06          0.99999       602.536     103.116     0.885991     8.15769e-07     4.25138e-08
  217.500     3.79258e-04        0.00000         6.32825e-06          0.99999       602.509     103.116     0.885133     9.58641e-07     5.02358e-08
  220.000     4.47000e-04        0.00000         7.42769e-06          0.99999       602.481     103.116     0.884269     1.12414e-06     5.92385e-08
  222.500     5.25729e-04        0.00000         8.69999e-06          0.99999       602.451     103.116     0.883396     1.31547e-06     6.97135e-08
  225.000     6.17039e-04        0.00000         1.01694e-05          0.99999       602.418     103.116     0.882516     1.53620e-06     8.18777e-08
  227.500     7.22727e-04        0.00000         1.18630e-05          0.99999       602.384     103.116     0.881627     1.79034e-06     9.59766e-08
  230.000     8.44814e-04        0.00000         1.38113e-05          0.99999       602.348     103.116     0.880731     2.08238e-06     1.12287e-07
  232.500     9.85569e-04        0.00000         1.60482e-05          0.99999       602.309     103.116     0.879826     2.41732e-06     1.31121e-07
  235.000     1.14753e-03        0.00000         1.86116e-05          0.99998       602.268     103.116     0.878913     2.80073e-06     1.52830e-07
  237.500     1.33355e-03        0.00000         2.15438e-05          0.99998       602.225     103.116     0.877992     3.23881e-06     1.77808e-07
  240.000     1.54681e-03        0.00000         2.48916e-05          0.99998       602.179     103.116     0.877062     3.73844e-06     2.06495e-07
  242.500     1.79082e-03        0.00000         2.87071e-05          0.99998       602.131     103.116     0.876124     4.30724e-06     2.39388e-07
  245.000     2.06955e-03        0.00000         3.30479e-05          0.99997       602.080     103.116     0.875176     4.95362e-06     2.77037e-07
  247.500     2.38735e-03        0.00000         3.79778e-05          0.99997       602.026     103.116     0.874220     5.68687e-06     3.20058e-07
  250.000     2.74907e-03        0.00000         4.35670e-05          0.99997       601.969     103.116     0.873255     6.51726e-06     3.69138e-07
  252.500     3.16007e-03        0.00000         4.98931e-05          0.99996       601.909     103.116     0.872281     7.45604e-06     4.25039e-07
  255.000     3.62629e-03        0.00000         5.70413e-05          0.99996       601.845     103.116     0.871298     8.51559e-06     4.88609e-07
  257.500     4.15425e-03        0.00000         6.51051e-05          0.99995       601.778     103.116     0.870305     9.70949e-06     5.60786e-07
  260.000     4.75115e-03        0.00000         7.41873e-05          0.99994       601.707     103.116     0.869303     1.10526e-05     6.42610e-07
  262.500     5.42491e-03        0.00000         8.44003e-05          0.99994       601.633     103.116     0.868290     1.25612e-05     7.35230e-07
  265.000     6.18422e-03        0.00000         9.58669e-05          0.99993       601.555     103.116     0.867269     1.42529e-05     8.39916e-07
  267.500     7.03859e-03        0.00000         1.08721e-04          0.99992       601.472     103.116     0.866237     1.61471e-05     9.58067e-07
  270.000     7.99845e-03        0.00000         1.23109e-04          0.99991       601.386     103.116     0.865195     1.82648e-05     1.09122e-06
  272.500     9.07520e-03        0.00000         1.39191e-04          0.99990       601.294     103.116     0.864143     2.06289e-05     1.24108e-06
  275.000     1.02813e-02        0.00000         1.57137e-04          0.99989       601.199     103.116     0.863080     2.32641e-05     1.40950e-06
  277.500     1.16302e-02        0.00000         1.77138e-04          0.99988       601.098     103.116     0.862006     2.61972e-05     1.59852e-06
  280.000     1.31367e-02        0.00000         1.99395e-04          0.99986       600.992     103.116     0.860922     2.94573e-05     1.81039e-06
  282.500     1.48168e-02        0.00000         2.24128e-04          0.99985       600.881     103.116     0.859827     3.30758e-05     2.04754e-06
  285.000     1.66879e-02        0.00000         2.51577e-04          0.99983       600.765     103.116     0.858721     3.70865e-05     2.31266e-06
  287.500     1.87689e-02        0.00000         2.81996e-04          0.99981       600.642     103.116     0.857603     4.15259e-05     2.60866e-06
  290.000     2.10801e-02        0.00000         3.15663e-04          0.99979       600.514     103.116     0.856474     4.64333e-05     2.93874e-06
  292.500     2.36436e-02        0.00000         3.52876e-04          0.99977       600.380     103.116     0.855333     5.18508e-05     3.30637e-06
  295.000     2.64831e-02        0.00000         3.93955e-04          0.99975       600.239     103.116     0.854180     5.78237e-05     3.71532e-06
  297.500     2.96244e-02        0.00000         4.39244e-04          0.99972       600.091     103.116     0.853015     6.44007e-05     4.16972e-06
  300.000     3.30950e-02        0.00000         4.89112e-04          0.99969       599.937     103.116     0.851837     7.16337e-05     4.67402e-06
  302.500     3.69247e-02        0.00000         5.43955e-04          0.99966       599.775     103.116     0.850647     7.95783e-05     5.23308e-06
  305.000     4.11455e-02        0.00000         6.04196e-04          0.99963       599.606     103.116     0.849444     8.82941e-05     5.85214e-06
  307.500     4.57915e-02        0.00000         6.70288e-04          0.99960       599.428     103.116     0.848228     9.78446e-05     6.53691e-06
  310.000     5.08997e-02        0.00000         7.42714e-04          0.99956       599.243     103.116     0.846998     1.08297e-04     7.29356e-06
  312.500     5.65094e-02        0.00000         8.21989e-04          0.99952       599.049     103.116     0.845755     1.19724e-04     8.12874e-06
  315.000     6.26626e-02        0.00000         9.08663e-04          0.99947       598.847     103.116     0.844498     1.32203e-04     9.04968e-06
  317.500     6.94045e-02        0.00000         1.00332e-03          0.99942       598.635     103.116     0.843227     1.45814e-04     1.00641e-05
  320.000     7.67831e-02        0.00000         1.10659e-03          0.99937       598.414     103.116     0.841942     1.60644e-04     1.11806e-05
  322.500     8.48496e-02        0.00000         1.21912e-03          0.99932       598.183     103.116     0.840642     1.76785e-04     1.24080e-05
  325.000     9.36589e-02        0.00000         1.34163e-03          0.99926       597.941     103.116     0.839326     1.94336e-04     1.37562e-05
  327.500     1.03269e-01        0.00000         1.47485e-03          0.99919       597.689     103.116     0.837996     2.13398e-04     1.52357e-05
  330.000     1.13742e-01        0.00000         1.61958e-03          0.99912       597.426     103.116     0.836650     2.34081e-04     1.68578e-05
  332.500     1.25144e-01        0.00000         1.77665e-03          0.99905       597.152     103.116     0.835288     2.56501e-04     1.86348e-05
  335.000     1.37544e-01        0.00000         1.94694e-03          0.99897       596.865     103.116     0.833909     2.80781e-04     2.05797e-05
  337.500     1.51017e-01        0.00000         2.13140e-03          0.99889       596.566     103.116     0.832514     3.07048e-04     2.27067e-05
  340.000     1.65642e-01        0.00000         2.33102e-03          0.99880       596.254     103.116     0.831102     3.35440e-04     2.50309e-05
  342.500     1.81501e-01        0.00000         2.54683e-03          0.99870       595.929     103.116     0.829673     3.66100e-04     2.75686e-05
  345.000     1.98685e-01        0.00000         2.77994e-03          0.99860       595.590     103.116     0.828226     3.99180e-04     3.03373e-05
  347.500     2.17285e-01        0.00000         3.03151e-03          0.99849       595.237     103.116     0.826761     4.34839e-04     3.33557e-05
  350.000     2.37401e-01        0.00000         3.30277e-03          0.99838       594.869     103.116     0.825277     4.73245e-04     3.66441e-05
  352.500     2.59138e-01        0.00000         3.59500e-03          0.99826       594.485     103.116     0.823774     5.14576e-04     4.02241e-05
  355.000     2.82607e-01        0.00000         3.90957e-03          0.99813       594.085     103.116     0.822251     5.59017e-04     4.41188e-05
  357.500     3.07924e-01        0.00000         4.24791e-03          0.99799       593.668     103.116     0.820709     6.06764e-04     4.83531e-05
  360.000     3.35213e-01        0.00000         4.61152e-03          0.99784       593.234     103.116     0.819146     6.58025e-04     5.29538e-05
  362.500     3.64603e-01        0.00000         5.00198e-03          0.99769       592.782     103.116     0.817563     7.13014e-04     5.79495e-05
  365.000     3.96233e-01        0.00000         5.42096e-03          0.99753       592.311     103.116     0.815958     7.71960e-04     6.33708e-05
  367.500     4.30247e-01        0.00000         5.87020e-03          0.99735       591.821     103.116     0.814331     8.35102e-04     6.92509e-05
  370.000     4.66799e-01        0.00000         6.35153e-03          0.99717       591.310     103.116     0.812681     9.02690e-04     7.56249e-05
  372.500     5.06048e-01        0.00000         6.86689e-03          0.99698       590.779     103.116     0.811009     9.74990e-04     8.25309e-05
  375.000     5.48166e-01        0.00000         7.41829e-03          0.99677       590.225     103.116     0.809312     1.05228e-03     9.00095e-05
  377.500     5.93331e-01        0.00000         8.00787e-03          0.99656       589.649     103.116     0.807592     1.13484e-03     9.81044e-05
  380.000     6.41731e-01        0.00000         8.63784e-03          0.99634       589.049     103.116     0.805846     1.22300e-03     1.06863e-04
  382.500     6.93566e-01        0.00000         9.31056e-03          0.99610       588.425     103.116     0.804075     1.31705e-03     1.16334e-04
  385.000     7.49044e-01        0.00000         1.00285e-02          0.99585       587.775     103.116     0.802278     1.41736e-03     1.26573e-04
  387.500     8.08386e-01        0.00000         1.07941e-02          0.99559       587.099     103.116     0.800453     1.52426e-03     1.37638e-04
  390.000     8.71825e-01        0.00000         1.16103e-02          0.99531       586.394     103.116     0.798601     1.63813e-03     1.49591e-04
  392.500     9.39606e-01        0.00000         1.24798e-02          0.99502       585.662     103.116     0.796720     1.75937e-03     1.62500e-04
  395.000     1.01199e+00        0.00000         1.34056e-02          0.99472       584.899     103.116     0.794809     1.88839e-03     1.76436e-04
  397.500     1.08924e+00        0.00000         1.43907e-02          0.99440       584.105     103.116     0.792868     2.02561e-03     1.91478e-04
  400.000     1.17165e+00        0.00000         1.54387e-02          0.99407       583.278     103.116     0.790896     2.17151e-03     2.07710e-04
  402.500     1.25953e+00        0.00000         1.65527e-02          0.99372       582.418     103.116     0.788891     2.32655e-03     2.25221e-04
  405.000     1.35319e+00        0.00000         1.77366e-02          0.99335       581.522     103.116     0.786854     2.49126e-03     2.44110e-04
  407.500     1.45297e+00        0.00000         1.89941e-02          0.99297       580.589     103.116     0.784782     2.66616e-03     2.64483e-04
  410.000     1.55923e+00        0.00000         2.03292e-02          0.99257       579.618     103.116     0.782674     2.85181e-03     2.86453e-04
  412.500     1.67234e+00        0.00000         2.17462e-02          0.99216       578.607     103.116     0.780530     3.04883e-03     3.10143e-04
  415.000     1.79271e+00        0.00000         2.32494e-02          0.99172       577.554     103.116     0.778348     3.25783e-03     3.35688e-04
  417.500     1.92076e+00        0.00000         2.48437e-02          0.99126       576.458     103.116     0.776127     3.47950e-03     3.63231e-04
  420.000     2.05694e+00        0.00000         2.65338e-02          0.99079       575.315     103.116     0.773865     3.71453e-03     3.92932e-04
  422.500     2.20172e+00        0.00000         2.83252e-02          0.99029       574.125     103.116     0.771561     3.96367e-03     4.24960e-04
  425.000     2.35560e+00        0.00000         3.02231e-02          0.98977       572.885     103.116     0.769214     4.22774e-03     4.59501e-04
  427.500     2.51914e+00        0.00000         3.22336e-02          0.98923       571.592     103.116     0.766822     4.50757e-03     4.96758e-04
  430.000     2.69289e+00        0.00000         3.43627e-02          0.98867       570.244     103.116     0.764382     4.80407e-03     5.36952e-04
  432.500     2.87747e+00        0.00000         3.66169e-02          0.98808       568.839     103.116     0.761894     5.11821e-03     5.80326e-04
  435.000     3.07353e+00        0.00000         3.90033e-02          0.98747       567.373     103.116     0.759356     5.45101e-03     6.27144e-04
  437.500     3.28175e+00        0.00000         4.15291e-02          0.98684       565.844     103.116     0.756764     5.80358e-03     6.77695e-04
  440.000     3.50290e+00        0.00000         4.42021e-02          0.98617       564.248     103.116     0.754118     6.17709e-03     7.32300e-04
  442.500     3.73776e+00        0.00000         4.70308e-02          0.98548       562.582     103.116     0.751414     6.57282e-03     7.91309e-04
  445.000     3.98718e+00        0.00000         5.00240e-02          0.98476       560.842     103.116     0.748650     6.99213e-03     8.55110e-04
  447.500     4.25210e+00        0.00000         5.31911e-02          0.98402       559.024     103.116     0.745824     7.43649e-03     9.24131e-04
  450.000     4.53351e+00        0.00000         5.65424e-02          0.98324       557.123     103.116     0.742932     7.90749e-03     9.98846e-04
  452.500     4.83248e+00        0.00000         6.00888e-02          0.98243       555.136     103.116     0.739971     8.40685e-03     1.07978e-03
  455.000     5.15018e+00        0.00000         6.38420e-02          0.98158       553.057     103.116     0.736938     8.93644e-03     1.16753e-03
  457.500     5.48787e+00        0.00000         6.78146e-02          0.98071       550.881     103.116     0.733829     9.49831e-03     1.26275e-03
  460.000     5.84694e+00        0.00000         7.20203e-02          0.97979       548.601     103.116     0.730640     1.00947e-02     1.36616e-03
  462.500     6.22889e+00        0.00000         7.64739e-02          0.97884       546.211     103.116     0.727366     1.07280e-02     1.47861e-03
  465.000     6.63538e+00        0.00000         8.11914e-02          0.97785       543.705     103.116     0.724003     1.14009e-02     1.60102e-03
  467.500     7.06823e+00        0.00000         8.61905e-02          0.97682       541.074     103.116     0.720546     1.21164e-02     1.73445e-03
  470.000     7.52946e+00        0.00000         9.14901e-02          0.97575       538.310     103.116     0.716987     1.28777e-02     1.88011e-03
  472.500     8.02129e+00        0.00000         9.71116e-02          0.97463       535.404     103.116     0.713322     1.36886e-02     2.03938e-03
  475.000     8.54621e+00        0.00000         1.03078e-01          0.97347       532.345     103.116     0.709541     1.45530e-02     2.21382e-03
  477.500     9.10703e+00        0.00000         1.09415e-01          0.97225       529.121     103.116     0.705639     1.54757e-02     2.40528e-03
  480.000     9.70688e+00        0.00000         1.16152e-01          0.97099       525.719     103.116     0.701604     1.64617e-02     2.61586e-03
  482.500     1.03493e+01        0.00000         1.23320e-01          0.96966       522.125     103.116     0.697427     1.75171e-02     2.84805e-03
  485.000     1.10385e+01        0.00000         1.30956e-01          0.96828       518.321     103.116     0.693096     1.86485e-02     3.10477e-03
  487.500     1.17790e+01        0.00000         1.39101e-01          0.96683       514.290     103.116     0.688597     1.98638e-02     3.38948e-03
  490.000     1.25763e+01        0.00000         1.47803e-01          0.96532       510.008     103.116     0.683915     2.11720e-02     3.70633e-03
  492.500     1.34368e+01        0.00000         1.57116e-01          0.96373       505.450     103.116     0.679030     2.25839e-02     4.06034e-03
  495.000     1.43680e+01        0.00000         1.67104e-01          0.96206       500.586     103.116     0.673922     2.41123e-02     4.45766e-03
  497.500     1.53791e+01        0.00000         1.77842e-01          0.96031       495.380     103.116     0.668563     2.57723e-02     4.90590e-03
  500.000     1.64810e+01        0.00000         1.89423e-01          0.95846       489.788     103.116     0.662923     2.75828e-02     5.41468e-03
  502.500     1.76875e+01        0.00000         2.01955e-01          0.95650       483.758     103.116     0.656961     2.95671e-02     5.99627e-03
  505.000     1.90158e+01        0.00000         2.15579e-01          0.95441       477.223     103.116     0.650628     3.17545e-02     6.66678e-03
  507.500     2.04885e+01        0.00000         2.30471e-01          0.95219       470.097     103.116     0.643860     3.41837e-02     7.44785e-03
  510.000     2.21355e+01        0.00000         2.46864e-01          0.94981       462.267     103.116     0.636570     3.69061e-02     8.36944e-03
  512.500     2.39988e+01        0.00000         2.65078e-01          0.94723       453.575     103.116     0.628639     3.99938e-02     9.47487e-03
  515.000     2.61395e+01        0.00000         2.85576e-01          0.94442       443.797     103.116     0.619892     4.35527e-02     1.08300e-02
  517.500     2.86542e+01        0.00000         3.09076e-01          0.94129       432.578     103.116     0.610056     4.77500e-02     1.25427e-02
  520.000     3.17122e+01        0.00000         3.36819e-01          0.93772       419.307     103.116     0.598649     5.28796e-02     1.48099e-02
  522.500     3.56674e+01        0.00000         3.71366e-01          0.93346       402.715     103.116     0.584671     5.95584e-02     1.80614e-02
  525.000     4.16027e+01        0.00000         4.20445e-01          0.92774       378.969     103.116     0.565063     6.96787e-02     2.36774e-02
  526.221     4.69396e+01        0.00000         4.61828e-01          0.92321       358.739     103.116     0.548600     7.88823e-02     2.95652e-02
  526.660     5.29610e+01        0.00000         5.05514e-01          0.91873       337.133     103.116     0.531133     8.93870e-02     3.72845e-02
  526.660     5.29922e+01        0.00000         5.05732e-01          0.91870       337.024     103.116     0.531045     8.94417e-02     3.73277e-02
  526.266     5.90668e+01        0.00000         5.46699e-01          0.91479       316.486     103.116     0.514450     1.00170e-01     4.64341e-02
  525.000     6.58377e+01        0.00000         5.88896e-01          0.91110       295.010     103.116     0.496997     1.12283e-01     5.83710e-02
  522.500     7.39927e+01        0.00000         6.35170e-01          0.90752       271.021     103.116     0.477250     1.27087e-01     7.56809e-02
  520.000     8.01554e+01        0.00000         6.67068e-01          0.90541       254.180     103.116     0.463143     1.38428e-01     9.12651e-02
  517.500     8.54087e+01        0.00000         6.92311e-01          0.90398       240.652     103.116     0.451620     1.48200e-01     1.06534e-01
  515.000     9.01064e+01        0.00000         7.13455e-01          0.90300       229.170     103.116     0.441677     1.57018e-01     1.21951e-01
  512.500     9.44176e+01        0.00000         7.31735e-01          0.90233       219.122     103.116     0.432835     1.65177e-01     1.37746e-01
  510.000     9.84387e+01        0.00000         7.47864e-01          0.90190       210.155     103.116     0.424819     1.72843e-01     1.54062e-01
  507.500     1.02231e+02        0.00000         7.62300e-01          0.90167       202.042     103.116     0.417454     1.80123e-01     1.71003e-01
  505.000     1.05836e+02        0.00000         7.75356e-01          0.90160       194.629     103.116     0.410621     1.87089e-01     1.88652e-01
  502.500     1.09284e+02        0.00000         7.87263e-01          0.90167       187.800     103.116     0.404233     1.93791e-01     2.07081e-01
  500.000     1.12597e+02        0.00000         7.98192e-01          0.90186       181.472     103.116     0.398226     2.00268e-01     2.26354e-01
  497.500     1.15792e+02        0.00000         8.08276e-01          0.90216       175.577     103.116     0.392550     2.06550e-01     2.46534e-01
  495.000     1.18883e+02        0.00000         8.17624e-01          0.90256       170.063     103.116     0.387165     2.12660e-01     2.67681e-01
  492.500     1.21881e+02        0.00000         8.26321e-01          0.90305       164.887     103.116     0.382040     2.18617e-01     2.89855e-01
  490.000     1.24795e+02        0.00000         8.34439e-01          0.90362       160.012     103.116     0.377147     2.24435e-01     3.13119e-01
  487.500     1.27632e+02        0.00000         8.42038e-01          0.90426       155.409     103.116     0.372465     2.30128e-01     3.37535e-01
  485.000     1.30398e+02        0.00000         8.49169e-01          0.90498       151.053     103.116     0.367976     2.35706e-01     3.63166e-01
  482.500     1.33100e+02        0.00000         8.55875e-01          0.90575       146.922     103.116     0.363663     2.41178e-01     3.90081e-01
  480.000     1.35740e+02        0.00000         8.62195e-01          0.90659       142.996     103.116     0.359512     2.46552e-01     4.18348e-01
  477.500     1.38325e+02        0.00000         8.68160e-01          0.90748       139.260     103.116     0.355512     2.51835e-01     4.48040e-01
  475.000     1.40856e+02        0.00000         8.73801e-01          0.90843       135.698     103.116     0.351651     2.57032e-01     4.79234e-01
  472.500     1.43336e+02        0.00000         8.79142e-01          0.90942       132.298     103.116     0.347922     2.62148e-01     5.12008e-01
  470.000     1.45770e+02        0.00000         8.84205e-01          0.91047       129.048     103.116     0.344314     2.67189e-01     5.46447e-01
  467.500     1.48158e+02        0.00000         8.89012e-01          0.91155       125.938     103.116     0.340822     2.72158e-01     5.82637e-01
  465.000     1.50504e+02        0.00000         8.93580e-01          0.91269       122.958     103.116     0.337437     2.77059e-01     6.20673e-01
  462.500     1.52809e+02        0.00000         8.97926e-01          0.91386       120.101     103.116     0.334155     2.81896e-01     6.60650e-01
  460.000     1.55074e+02        0.00000         9.02064e-01          0.91507       117.358     103.116     0.330969     2.86670e-01     7.02673e-01
  457.500     1.57302e+02        0.00000         9.06008e-01          0.91632       114.723     103.116     0.327875     2.91385e-01     7.46848e-01
  455.000     1.59493e+02        0.00000         9.09770e-01          0.91761       112.189     103.116     0.324868     2.96043e-01     7.93291e-01
  452.500     1.61649e+02        0.00000         9.13360e-01          0.91893       109.751     103.116     0.321943     3.00646e-01     8.42121e-01
  450.000     1.63772e+02        0.00000         9.16790e-01          0.92028       107.403     103.116     0.319098     3.05197e-01     8.93467e-01
  447.500     1.65861e+02        0.00000         9.20068e-01          0.92167       105.141     103.116     0.316328     3.09698e-01     9.47463e-01
  445.613     1.67417e+02        0.00000         9.22447e-01          0.92273       103.487     103.116     0.314286     3.13061e-01     9.90047e-01
  445.183     1.67770e+02        0.50000         9.22978e-01          0.92298       103.116     103.116     0.313825     3.13825e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   15.848     1.70538e+02        0.00000         1.27880e+00          0.98501       144.457     103.116     0.801730     7.42979e-01     3.25998e-01
   16.392     2.53999e+02        0.00000         1.87778e+00          1.44879       143.600     103.116     0.806854     7.50941e-01     3.24818e-01
   17.715     3.78306e+02        0.00000         2.73996e+00          2.12129       142.391     103.116     0.812934     7.60398e-01     3.26582e-01
   20.042     5.63448e+02        0.00000         3.97247e+00          3.09039       140.942     103.116     0.820063     7.71222e-01     3.31451e-01
   23.502     8.39200e+02        0.00000         5.72730e+00          4.48011       139.411     103.116     0.828195     7.83106e-01     3.39118e-01
   28.068     1.24990e+03        0.00000         8.22424e+00          6.46867       137.939     103.116     0.837053     7.95557e-01     3.48977e-01
   33.527     1.86161e+03        0.00000         1.17868e+01          9.31786       136.604     103.116     0.846141     8.07944e-01     3.60330e-01
   39.497     2.77267e+03        0.00000         1.68975e+01         13.41935       135.428     103.116     0.854860     8.19602e-01     3.71932e-01
   45.507     4.12962e+03        0.00000         2.42831e+01         19.36486       134.401     103.116     0.862683     8.29972e-01     3.82215e-01
   51.102     6.15066e+03        0.00000         3.50412e+01         28.04922       133.516     103.116     0.869278     8.38705e-01     3.91982e-01
   55.955     9.16078e+03        0.00000         5.08257e+01         40.81998       132.770     103.116     0.874543     8.45700e-01     4.00742e-01
   59.913     1.36441e+04        0.00000         7.41180e+01         59.69597       132.164     103.116     0.878562     8.51066e-01     4.08155e-01
   62.981     2.03215e+04        0.00000         1.08626e+02         87.69031       131.690     103.116     0.881522     8.55039e-01     4.14095e-01
   65.265     3.02668e+04        0.00000         1.59876e+02        129.29170       131.334     103.116     0.883645     8.57900e-01     4.18475e-01
   66.915     4.50793e+04        0.00000         2.36096e+02        191.18297       131.074     103.116     0.885138     8.59919e-01     4.21526e-01
   68.080     6.71411e+04        0.00000         3.49536e+02        283.31323       130.889     103.116     0.886173     8.61322e-01     4.23718e-01
   68.890     1.00000e+05        0.00000         5.18436e+02        420.49619       130.759     103.116     0.886883     8.62286e-01     4.25262e-01
END

$Env_BP << END
#   Temp       Sat Pres                                                                                    Liq Den      Gas Den           
#   (C)         (bar)        Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   -----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
  445.183      167.770          0.5000            0.92298          0.922978       103.116     103.116     0.313825     0.313825     1.00000e+00
  444.752      168.122          1.0000            0.92323          0.923507       103.116     102.746     0.314588     0.313365     9.90048e-01
  442.500      169.946          1.0000            0.92453          0.926203       103.116     100.854     0.318553     0.311001     9.39865e-01
  440.000      171.943          1.0000            0.92600          0.929075       103.116      98.821     0.322910     0.308438     8.87456e-01
  437.500      173.911          1.0000            0.92751          0.931827       103.116      96.857     0.327224     0.305939     8.38278e-01
  435.000      175.850          1.0000            0.92904          0.934463       103.116      94.960     0.331494     0.303500     7.92094e-01
  432.500      177.761          1.0000            0.93059          0.936990       103.116      93.124     0.335721     0.301121     7.48688e-01
  430.000      179.645          1.0000            0.93217          0.939414       103.116      91.349     0.339908     0.298798     7.07863e-01
  427.500      181.501          1.0000            0.93377          0.941739       103.116      89.630     0.344055     0.296529     6.69439e-01
  425.000      183.332          1.0000            0.93540          0.943970       103.116      87.965     0.348163     0.294312     6.33252e-01
  422.500      185.137          1.0000            0.93705          0.946112       103.116      86.352     0.352233     0.292146     5.99151e-01
  420.000      186.916          1.0000            0.93872          0.948168       103.116      84.789     0.356266     0.290030     5.66997e-01
  417.500      188.671          1.0000            0.94041          0.950142       103.116      83.274     0.360262     0.287960     5.36664e-01
  415.000      190.401          1.0000            0.94213          0.952039       103.116      81.803     0.364223     0.285936     5.08033e-01
  412.500      192.107          1.0000            0.94386          0.953860       103.116      80.377     0.368149     0.283956     4.80996e-01
  410.000      193.789          1.0000            0.94561          0.955610       103.116      78.991     0.372041     0.282019     4.55455e-01
  407.500      195.448          1.0000            0.94738          0.957291       103.116      77.646     0.375899     0.280124     4.31314e-01
  405.000      197.083          1.0000            0.94917          0.958906       103.116      76.340     0.379725     0.278269     4.08490e-01
  402.500      198.695          1.0000            0.95098          0.960458       103.116      75.070     0.383518     0.276452     3.86903e-01
  400.000      200.285          1.0000            0.95280          0.961948       103.116      73.836     0.387280     0.274674     3.66478e-01
  397.500      201.853          1.0000            0.95464          0.963380       103.116      72.636     0.391011     0.272933     3.47147e-01
  395.000      203.398          1.0000            0.95650          0.964756       103.116      71.468     0.394711     0.271227     3.28846e-01
  392.500      204.921          1.0000            0.95837          0.966077       103.116      70.332     0.398382     0.269556     3.11515e-01
  390.000      206.422          1.0000            0.96025          0.967346       103.116      69.227     0.402022     0.267918     2.95100e-01
  387.500      207.902          1.0000            0.96215          0.968563       103.116      68.151     0.405634     0.266314     2.79547e-01
  385.000      209.360          1.0000            0.96406          0.969732       103.116      67.103     0.409217     0.264741     2.64808e-01
  382.500      210.797          1.0000            0.96599          0.970853       103.116      66.082     0.412772     0.263200     2.50839e-01
  380.000      212.212          1.0000            0.96793          0.971929       103.116      65.087     0.416299     0.261689     2.37595e-01
  377.500      213.607          1.0000            0.96988          0.972960       103.116      64.118     0.419799     0.260207     2.25039e-01
  375.000      214.981          1.0000            0.97184          0.973947       103.116      63.173     0.423272     0.258754     2.13132e-01
  372.500      216.334          1.0000            0.97382          0.974893       103.116      62.252     0.426718     0.257329     2.01840e-01
  370.000      217.667          1.0000            0.97580          0.975798       103.116      61.353     0.430138     0.255931     1.91129e-01
  367.500      218.979          1.0000            0.97780          0.976664       103.116      60.477     0.433532     0.254560     1.80968e-01
  365.000      220.270          1.0000            0.97981          0.977491       103.116      59.622     0.436901     0.253215     1.71329e-01
  362.500      221.541          1.0000            0.98182          0.978281       103.116      58.787     0.440244     0.251896     1.62184e-01
  360.000      222.792          1.0000            0.98385          0.979034       103.116      57.972     0.443563     0.250601     1.53507e-01
  357.500      224.022          1.0000            0.98588          0.979751       103.116      57.177     0.446857     0.249330     1.45274e-01
  355.000      225.233          1.0000            0.98792          0.980434       103.116      56.400     0.450127     0.248082     1.37461e-01
  352.500      226.423          1.0000            0.98997          0.981082       103.116      55.641     0.453373     0.246858     1.30049e-01
  350.000      227.593          1.0000            0.99203          0.981698       103.116      54.900     0.456596     0.245657     1.23015e-01
  347.500      228.743          1.0000            0.99410          0.982281       103.116      54.176     0.459795     0.244477     1.16341e-01
  345.000      229.874          1.0000            0.99617          0.982832       103.116      53.468     0.462971     0.243319     1.10008e-01
  342.500      230.984          1.0000            0.99825          0.983351       103.116      52.776     0.466124     0.242182     1.03999e-01
  340.000      232.074          1.0000            1.00033          0.983841       103.116      52.099     0.469254     0.241065     9.82983e-02
  337.500      233.145          1.0000            1.00242          0.984300       103.116      51.438     0.472362     0.239968     9.28898e-02
  335.000      234.195          1.0000            1.00451          0.984729       103.116      50.791     0.475449     0.238892     8.77591e-02
  332.500      235.226          1.0000            1.00661          0.985129       103.116      50.158     0.478513     0.237834     8.28922e-02
  330.000      236.237          1.0000            1.00871          0.985500       103.116      49.538     0.481556     0.236795     7.82761e-02
  327.500      237.228          1.0000            1.01082          0.985844       103.116      48.932     0.484577     0.235775     7.38983e-02
  325.000      238.200          1.0000            1.01293          0.986159       103.116      48.339     0.487578     0.234773     6.97470e-02
  322.500      239.151          1.0000            1.01504          0.986447       103.116      47.758     0.490557     0.233788     6.58109e-02
  320.000      240.083          1.0000            1.01715          0.986707       103.116      47.190     0.493516     0.232821     6.20795e-02
  317.500      240.994          1.0000            1.01927          0.986941       103.116      46.633     0.496454     0.231870     5.85427e-02
  315.000      241.886          1.0000            1.02138          0.987148       103.116      46.088     0.499372     0.230936     5.51908e-02
  312.500      242.758          1.0000            1.02350          0.987329       103.116      45.554     0.502270     0.230019     5.20147e-02
  310.000      243.610          1.0000            1.02562          0.987483       103.116      45.030     0.505148     0.229117     4.90058e-02
  307.500      244.442          1.0000            1.02774          0.987612       103.116      44.518     0.508007     0.228231     4.61558e-02
  305.000      245.255          1.0000            1.02986          0.987714       103.116      44.015     0.510846     0.227361     4.34569e-02
  302.500      246.047          1.0000            1.03197          0.987792       103.116      43.523     0.513666     0.226505     4.09016e-02
  300.000      246.819          1.0000            1.03409          0.987843       103.116      43.040     0.516467     0.225664     3.84829e-02
  297.500      247.571          1.0000            1.03620          0.987870       103.116      42.567     0.519249     0.224838     3.61939e-02
  295.000      248.303          1.0000            1.03831          0.987871       103.116      42.103     0.522012     0.224026     3.40284e-02
  292.500      249.015          1.0000            1.04042          0.987847       103.116      41.648     0.524757     0.223227     3.19801e-02
  290.000      249.706          1.0000            1.04253          0.987798       103.116      41.202     0.527483     0.222443     3.00433e-02
  287.500      250.378          1.0000            1.04463          0.987724       103.116      40.764     0.530191     0.221671     2.82124e-02
  285.000      251.029          1.0000            1.04673          0.987625       103.116      40.334     0.532881     0.220913     2.64821e-02
  282.500      251.659          1.0000            1.04882          0.987500       103.116      39.913     0.535553     0.220168     2.48474e-02
  280.000      252.269          1.0000            1.05090          0.987351       103.116      39.499     0.538208     0.219435     2.33035e-02
  277.500      252.859          1.0000            1.05298          0.987177       103.116      39.094     0.540845     0.218715     2.18458e-02
  275.000      253.428          1.0000            1.05505          0.986978       103.116      38.695     0.543465     0.218008     2.04700e-02
  272.500      253.977          1.0000            1.05712          0.986753       103.116      38.304     0.546067     0.217312     1.91720e-02
  270.000      254.504          1.0000            1.05918          0.986503       103.116      37.920     0.548653     0.216628     1.79478e-02
  267.500      255.011          1.0000            1.06123          0.986228       103.116      37.543     0.551221     0.215956     1.67936e-02
  265.000      255.497          1.0000            1.06327          0.985928       103.116      37.173     0.553773     0.215295     1.57059e-02
  262.500      255.962          1.0000            1.06530          0.985602       103.116      36.810     0.556308     0.214645     1.46812e-02
  260.000      256.406          1.0000            1.06731          0.985250       103.116      36.453     0.558827     0.214007     1.37163e-02
  257.500      256.829          1.0000            1.06932          0.984873       103.116      36.102     0.561329     0.213379     1.28081e-02
  255.000      257.231          1.0000            1.07132          0.984469       103.116      35.757     0.563815     0.212762     1.19535e-02
  252.500      257.611          1.0000            1.07330          0.984040       103.116      35.419     0.566286     0.212156     1.11499e-02
  250.000      257.970          1.0000            1.07528          0.983583       103.116      35.086     0.568740     0.211560     1.03944e-02
  247.500      258.307          1.0000            1.07723          0.983101       103.116      34.759     0.571178     0.210974     9.68466e-03
  245.000      258.623          1.0000            1.07918          0.982591       103.116      34.438     0.573601     0.210398     9.01809e-03
  242.500      258.917          1.0000            1.08110          0.982055       103.116      34.122     0.576008     0.209832     8.39241e-03
  240.000      259.189          1.0000            1.08302          0.981491       103.116      33.812     0.578400     0.209276     7.80541e-03
  237.500      259.439          1.0000            1.08491          0.980899       103.116      33.507     0.580777     0.208730     7.25498e-03
  235.000      259.668          1.0000            1.08679          0.980279       103.116      33.207     0.583139     0.208193     6.73912e-03
  232.500      259.874          1.0000            1.08865          0.979632       103.116      32.912     0.585485     0.207666     6.25593e-03
  230.000      260.057          1.0000            1.09049          0.978955       103.116      32.622     0.587817     0.207147     5.80358e-03
  227.500      260.218          1.0000            1.09230          0.978250       103.116      32.336     0.590134     0.206638     5.38035e-03
  225.000      260.357          1.0000            1.09410          0.977516       103.116      32.056     0.592437     0.206138     4.98459e-03
  222.500      260.473          1.0000            1.09588          0.976752       103.116      31.780     0.594724     0.205647     4.61475e-03
  220.000      260.566          1.0000            1.09763          0.975958       103.116      31.508     0.596998     0.205164     4.26933e-03
  217.500      260.636          1.0000            1.09936          0.975133       103.116      31.242     0.599257     0.204690     3.94693e-03
  215.000      260.683          1.0000            1.10107          0.974278       103.116      30.979     0.601502     0.204225     3.64620e-03
  212.500      260.707          1.0000            1.10274          0.973392       103.116      30.720     0.603733     0.203768     3.36587e-03
  210.000      260.707          1.0000            1.10440          0.972473       103.116      30.466     0.605950     0.203319     3.10473e-03
  207.500      260.684          1.0000            1.10602          0.971523       103.116      30.216     0.608153     0.202879     2.86164e-03
  205.000      260.637          1.0000            1.10762          0.970540       103.116      29.970     0.610343     0.202447     2.63549e-03
  202.500      260.567          1.0000            1.10918          0.969523       103.116      29.728     0.612519     0.202022     2.42527e-03
  200.000      260.472          1.0000            1.11071          0.968473       103.116      29.489     0.614681     0.201606     2.22999e-03
  197.500      260.353          1.0000            1.11222          0.967389       103.116      29.255     0.616830     0.201198     2.04872e-03
  195.000      260.210          1.0000            1.11368          0.966270       103.116      29.024     0.618966     0.200797     1.88058e-03
  192.500      260.042          1.0000            1.11512          0.965116       103.116      28.796     0.621088     0.200404     1.72475e-03
  190.000      259.849          1.0000            1.11651          0.963925       103.116      28.573     0.623198     0.200019     1.58044e-03
  187.500      259.632          1.0000            1.11787          0.962698       103.116      28.352     0.625294     0.199641     1.44690e-03
  185.000      259.389          1.0000            1.11919          0.961434       103.116      28.135     0.627378     0.199271     1.32343e-03
  182.500      259.121          1.0000            1.12048          0.960131       103.116      27.922     0.629449     0.198908     1.20937e-03
  180.000      258.828          1.0000            1.12171          0.958790       103.116      27.712     0.631507     0.198552     1.10409e-03
  177.500      258.509          1.0000            1.12291          0.957410       103.116      27.505     0.633552     0.198204     1.00699e-03
  175.000      258.165          1.0000            1.12406          0.955990       103.116      27.301     0.635585     0.197863     9.17532e-04
  172.500      257.794          1.0000            1.12517          0.954528       103.116      27.100     0.637606     0.197528     8.35177e-04
  170.000      257.397          1.0000            1.12623          0.953026       103.116      26.903     0.639614     0.197201     7.59436e-04
  167.500      256.974          1.0000            1.12724          0.951481       103.116      26.708     0.641610     0.196881     6.89841e-04
  165.000      256.524          1.0000            1.12819          0.949892       103.116      26.516     0.643594     0.196567     6.25957e-04
  162.500      256.047          1.0000            1.12910          0.948260       103.116      26.328     0.645566     0.196261     5.67372e-04
  160.000      255.543          1.0000            1.12995          0.946582       103.116      26.142     0.647526     0.195961     5.13700e-04
  157.500      255.012          1.0000            1.13074          0.944859       103.116      25.959     0.649474     0.195667     4.64581e-04
  155.000      254.453          1.0000            1.13148          0.943089       103.116      25.778     0.651410     0.195380     4.19675e-04
  152.500      253.866          1.0000            1.13216          0.941272       103.116      25.601     0.653335     0.195100     3.78664e-04
  150.000      253.251          1.0000            1.13277          0.939405       103.116      25.426     0.655248     0.194826     3.41251e-04
  147.500      252.608          1.0000            1.13332          0.937489       103.116      25.254     0.657149     0.194559     3.07159e-04
  145.000      251.937          1.0000            1.13381          0.935522       103.116      25.084     0.659039     0.194298     2.76128e-04
  142.500      251.236          1.0000            1.13422          0.933503       103.116      24.917     0.660918     0.194042     2.47916e-04
  140.000      250.507          1.0000            1.13457          0.931432       103.116      24.752     0.662785     0.193793     2.22297e-04
  137.500      249.748          1.0000            1.13484          0.929306       103.116      24.590     0.664642     0.193551     1.99061e-04
  135.000      248.960          1.0000            1.13504          0.927125       103.116      24.430     0.666487     0.193314     1.78013e-04
  132.500      248.142          1.0000            1.13515          0.924887       103.116      24.273     0.668321     0.193082     1.58970e-04
  130.000      247.294          1.0000            1.13519          0.922592       103.116      24.118     0.670144     0.192857     1.41763e-04
  127.500      246.415          1.0000            1.13515          0.920237       103.116      23.965     0.671957     0.192637     1.26237e-04
  125.000      245.506          1.0000            1.13502          0.917822       103.116      23.814     0.673758     0.192423     1.12245e-04
  122.500      244.566          1.0000            1.13480          0.915346       103.116      23.666     0.675549     0.192215     9.96537e-05
  120.000      243.594          1.0000            1.13449          0.912806       103.116      23.520     0.677329     0.192012     8.83383e-05
  117.500      242.591          1.0000            1.13408          0.910202       103.116      23.376     0.679099     0.191814     7.81844e-05
  115.000      241.556          1.0000            1.13358          0.907532       103.116      23.234     0.680858     0.191621     6.90860e-05
  112.500      240.489          1.0000            1.13298          0.904795       103.116      23.094     0.682607     0.191434     6.09457e-05
  110.000      239.389          1.0000            1.13227          0.901988       103.116      22.956     0.684346     0.191251     5.36738e-05
  107.500      238.256          1.0000            1.13146          0.899110       103.116      22.821     0.686074     0.191073     4.71879e-05
  105.000      237.090          1.0000            1.13053          0.896160       103.116      22.687     0.687792     0.190900     4.14123e-05
  102.500      235.891          1.0000            1.12949          0.893137       103.116      22.555     0.689500     0.190732     3.62777e-05
  100.000      234.658          1.0000            1.12834          0.890037       103.116      22.425     0.691198     0.190568     3.17208e-05
   97.500      233.390          1.0000            1.12706          0.886859       103.116      22.297     0.692886     0.190408     2.76834e-05
   95.000      232.088          1.0000            1.12566          0.883602       103.116      22.171     0.694565     0.190252     2.41128e-05
   92.500      230.751          1.0000            1.12412          0.880264       103.116      22.047     0.696233     0.190101     2.09607e-05
   90.000      229.378          1.0000            1.12245          0.876842       103.116      21.925     0.697892     0.189953     1.81832e-05
   87.500      227.970          1.0000            1.12065          0.873334       103.116      21.804     0.699541     0.189809     1.57405e-05
   85.000      226.526          1.0000            1.11870          0.869739       103.116      21.685     0.701180     0.189668     1.35965e-05
   82.500      225.045          1.0000            1.11660          0.866055       103.116      21.568     0.702810     0.189530     1.17184e-05
   80.000      223.527          1.0000            1.11436          0.862278       103.116      21.453     0.704430     0.189396     1.00766e-05
   77.500      221.972          1.0000            1.11195          0.858408       103.116      21.339     0.706041     0.189264     8.64451e-06
   75.000      220.379          1.0000            1.10938          0.854440       103.116      21.227     0.707643     0.189135     7.39802e-06
   72.500      218.749          1.0000            1.10665          0.850374       103.116      21.116     0.709235     0.189008     6.31553e-06
   70.000      217.079          1.0000            1.10374          0.846207       103.116      21.007     0.710818     0.188883     5.37763e-06
   67.500      215.371          1.0000            1.10065          0.841935       103.116      20.900     0.712392     0.188759     4.56694e-06
   65.000      213.623          1.0000            1.09738          0.837557       103.116      20.794     0.713957     0.188638     3.86792e-06
   62.500      211.835          1.0000            1.09392          0.833070       103.116      20.690     0.715513     0.188517     3.26671e-06
   60.000      210.007          1.0000            1.09026          0.828470       103.116      20.587     0.717060     0.188396     2.75096e-06
   57.500      208.138          1.0000            1.08640          0.823756       103.116      20.485     0.718598     0.188276     2.30973e-06
   55.000      206.228          1.0000            1.08232          0.818925       103.116      20.386     0.720128     0.188156     1.93327e-06
   52.500      204.276          1.0000            1.07803          0.813972       103.116      20.287     0.721648     0.188036     1.61301e-06
   50.000      202.282          1.0000            1.07352          0.808896       103.116      20.190     0.723160     0.187914     1.34136e-06
   47.500      200.245          1.0000            1.06877          0.803693       103.116      20.094     0.724664     0.187790     1.11165e-06
   45.000      198.165          1.0000            1.06379          0.798360       103.116      20.000     0.726159     0.187665     9.18007e-07
   42.500      196.041          1.0000            1.05855          0.792893       103.116      19.906     0.727645     0.187537     7.55309e-07
   40.000      193.873          1.0000            1.05306          0.787290       103.116      19.815     0.729123     0.187405     6.19074e-07
   37.500      191.660          1.0000            1.04731          0.781547       103.116      19.724     0.730592     0.187269     5.05398e-07
   35.000      189.401          1.0000            1.04128          0.775660       103.116      19.635     0.732054     0.187128     4.10892e-07
   32.500      187.097          1.0000            1.03497          0.769627       103.116      19.547     0.733507     0.186982     3.32622e-07
   30.000      184.746          1.0000            1.02837          0.763442       103.116      19.460     0.734951     0.186829     2.68054e-07
   27.500      182.349          1.0000            1.02147          0.757103       103.116      19.374     0.736388     0.186668     2.15009e-07
   25.000      179.904          1.0000            1.01426          0.750607       103.116      19.289     0.737817     0.186498     1.71617e-07
   22.500      177.410          1.0000            1.00672          0.743949       103.116      19.206     0.739237     0.186318     1.36280e-07
   20.000      174.868          1.0000            0.99885          0.737125       103.116      19.123     0.740650     0.186127     1.07637e-07
   17.500      172.277          1.0000            0.99063          0.730133       103.116      19.042     0.742055     0.185923     8.45349e-08
   15.848      170.538          1.0000            0.98501          0.725418       103.116      18.989     0.742979     0.185780     7.18280e-08
END

set output "Figures/Env_001_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:4.5e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_001_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "P-X Diagram for Lab1_Recombined_Oil\n with Lab1_Swelling_Gas at 96 C "
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   1.00000e-12        1.00000e+00        2.49041e-13        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   2.00000e-12        1.00000e+00        4.98082e-13        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   5.00000e-12        1.00000e+00        1.24521e-12        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   1.00000e-11        1.00000e+00        2.49041e-12        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   2.00000e-11        1.00000e+00        4.98082e-12        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   5.00000e-11        1.00000e+00        1.24521e-11        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   1.00000e-10        1.00000e+00        2.49041e-11        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   2.00000e-10        1.00000e+00        4.98082e-11        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   5.00000e-10        1.00000e+00        1.24521e-10        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   1.00000e-09        1.00000e+00        2.49041e-10        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   2.00000e-09        1.00000e+00        4.98082e-10        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   5.00000e-09        1.00000e+00        1.24521e-09        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   1.00000e-08        1.00000e+00        2.49041e-09        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   2.00000e-08        1.00000e+00        4.98082e-09        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   5.00000e-08        1.00000e+00        1.24521e-08        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   1.00000e-07        1.00000e+00        2.49041e-08        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   2.00000e-07        1.00000e+00        4.98082e-08        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   5.00000e-07        1.00000e+00        1.24521e-07        1.00000e+00       3.85083e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   1.00000e-06        9.99999e-01        2.49041e-07        1.00000e+00       3.85084e-09        0.00000         8.22740e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   2.00000e-06        9.99998e-01        4.98083e-07        1.00000e+00       3.85084e-09        0.00000         8.22741e-11         1.00000        602.888     103.116     0.919373     1.29373e-11     5.70551e-13
   5.00000e-06        9.99995e-01        1.24521e-06        9.99999e-01       3.85085e-09        0.00000         8.22744e-11         1.00000        602.888     103.115     0.919373     1.29373e-11     5.70551e-13
   1.00000e-05        9.99990e-01        2.49043e-06        9.99998e-01       3.85087e-09        0.00000         8.22748e-11         1.00000        602.888     103.115     0.919373     1.29373e-11     5.70551e-13
   2.00000e-05        9.99980e-01        4.98090e-06        9.99995e-01       3.85091e-09        0.00000         8.22756e-11         1.00000        602.888     103.114     0.919373     1.29373e-11     5.70551e-13
   5.00000e-05        9.99950e-01        1.24525e-05        9.99988e-01       3.85102e-09        0.00000         8.22781e-11         1.00000        602.888     103.112     0.919373     1.29374e-11     5.70551e-13
   1.00000e-04        9.99900e-01        2.49060e-05        9.99975e-01       3.85122e-09        0.00000         8.22822e-11         1.00000        602.888     103.108     0.919373     1.29376e-11     5.70551e-13
   2.00000e-04        9.99800e-01        4.98157e-05        9.99950e-01       3.85160e-09        0.00000         8.22904e-11         1.00000        602.888     103.100     0.919373     1.29379e-11     5.70551e-13
   5.00000e-04        9.99500e-01        1.24567e-04        9.99875e-01       3.85276e-09        0.00000         8.23151e-11         1.00000        602.888     103.077     0.919373     1.29389e-11     5.70551e-13
   1.00000e-03        9.99000e-01        2.49228e-04        9.99751e-01       3.85469e-09        0.00000         8.23563e-11         1.00000        602.888     103.038     0.919373     1.29405e-11     5.70551e-13
   2.00000e-03        9.98000e-01        4.98831e-04        9.99501e-01       3.85855e-09        0.00000         8.24388e-11         1.00000        602.888     102.961     0.919373     1.29437e-11     5.70551e-13
   5.00000e-03        9.95000e-01        1.24990e-03        9.98750e-01       3.87018e-09        0.00000         8.26874e-11         1.00000        602.888     102.729     0.919373     1.29535e-11     5.70551e-13
   1.00000e-02        9.90000e-01        2.50925e-03        9.97491e-01       3.88973e-09        0.00000         8.31050e-11         1.00000        602.888     102.341     0.919373     1.29698e-11     5.70551e-13
   2.00000e-02        9.80000e-01        5.05677e-03        9.94943e-01       3.92942e-09        0.00000         8.39530e-11         1.00000        602.888     101.567     0.919373     1.30030e-11     5.70551e-13
   3.00000e-02        9.70000e-01        7.64343e-03        9.92357e-01       3.96993e-09        0.00000         8.48185e-11         1.00000        602.888     100.793     0.919373     1.30369e-11     5.70551e-13
   4.00000e-02        9.60000e-01        1.02701e-02        9.89730e-01       4.01128e-09        0.00000         8.57020e-11         1.00000        602.888     100.018     0.919373     1.30715e-11     5.70551e-13
   5.00000e-02        9.50000e-01        1.29378e-02        9.87062e-01       4.05351e-09        0.00000         8.66042e-11         1.00000        602.888      99.244     0.919373     1.31068e-11     5.70551e-13
   6.00000e-02        9.40000e-01        1.56475e-02        9.84353e-01       4.09663e-09        0.00000         8.75255e-11         1.00000        602.888      98.470     0.919373     1.31429e-11     5.70551e-13
   7.00000e-02        9.30000e-01        1.84001e-02        9.81600e-01       4.14068e-09        0.00000         8.84666e-11         1.00000        602.888      97.695     0.919373     1.31798e-11     5.70551e-13
   8.00000e-02        9.20000e-01        2.11967e-02        9.78803e-01       4.18569e-09        0.00000         8.94282e-11         1.00000        602.888      96.921     0.919373     1.32174e-11     5.70551e-13
   9.00000e-02        9.10000e-01        2.40384e-02        9.75962e-01       4.23168e-09        0.00000         9.04109e-11         1.00000        602.888      96.147     0.919373     1.32559e-11     5.70551e-13
   1.00000e-01        9.00000e-01        2.69261e-02        9.73074e-01       4.27870e-09        0.00000         9.14155e-11         1.00000        602.888      95.372     0.919373     1.32952e-11     5.70551e-13
   1.10000e-01        8.90000e-01        2.98612e-02        9.70139e-01       4.32678e-09        0.00000         9.24426e-11         1.00000        602.888      94.598     0.919373     1.33355e-11     5.70551e-13
   1.20000e-01        8.80000e-01        3.28447e-02        9.67155e-01       4.37594e-09        0.00000         9.34931e-11         1.00000        602.888      93.823     0.919373     1.33766e-11     5.70551e-13
   1.30000e-01        8.70000e-01        3.58779e-02        9.64122e-01       4.42624e-09        0.00000         9.45678e-11         1.00000        602.888      93.049     0.919373     1.34187e-11     5.70551e-13
   1.40000e-01        8.60000e-01        3.89620e-02        9.61038e-01       4.47771e-09        0.00000         9.56674e-11         1.00000        602.888      92.275     0.919373     1.34618e-11     5.70551e-13
   1.50000e-01        8.50000e-01        4.20983e-02        9.57902e-01       4.53039e-09        0.00000         9.67929e-11         1.00000        602.888      91.500     0.919373     1.35058e-11     5.70551e-13
   1.60000e-01        8.40000e-01        4.52881e-02        9.54712e-01       4.58432e-09        0.00000         9.79452e-11         1.00000        602.888      90.726     0.919373     1.35510e-11     5.70551e-13
   1.70000e-01        8.30000e-01        4.85328e-02        9.51467e-01       4.63956e-09        0.00000         9.91252e-11         1.00000        602.888      89.952     0.919373     1.35972e-11     5.70551e-13
   1.80000e-01        8.20000e-01        5.18339e-02        9.48166e-01       4.69614e-09        0.00000         1.00334e-10         1.00000        602.888      89.177     0.919373     1.36445e-11     5.70551e-13
   1.90000e-01        8.10000e-01        5.51928e-02        9.44807e-01       4.75411e-09        0.00000         1.01573e-10         1.00000        602.888      88.403     0.919373     1.36930e-11     5.70551e-13
   2.00000e-01        8.00000e-01        5.86111e-02        9.41389e-01       4.81354e-09        0.00000         1.02842e-10         1.00000        602.888      87.629     0.919373     1.37427e-11     5.70551e-13
   2.10000e-01        7.90000e-01        6.20904e-02        9.37910e-01       4.87447e-09        0.00000         1.04144e-10         1.00000        602.888      86.854     0.919373     1.37937e-11     5.70551e-13
   2.20000e-01        7.80000e-01        6.56322e-02        9.34368e-01       4.93696e-09        0.00000         1.05479e-10         1.00000        602.888      86.080     0.919373     1.38460e-11     5.70551e-13
   2.30000e-01        7.70000e-01        6.92383e-02        9.30762e-01       5.00108e-09        0.00000         1.06849e-10         1.00000        602.888      85.306     0.919373     1.38996e-11     5.70551e-13
   2.40000e-01        7.60000e-01        7.29105e-02        9.27089e-01       5.06688e-09        0.00000         1.08255e-10         1.00000        602.888      84.531     0.919373     1.39547e-11     5.70551e-13
   2.50000e-01        7.50000e-01        7.66506e-02        9.23349e-01       5.13444e-09        0.00000         1.09699e-10         1.00000        602.888      83.757     0.919373     1.40112e-11     5.70551e-13
   2.60000e-01        7.40000e-01        8.04605e-02        9.19539e-01       5.20383e-09        0.00000         1.11181e-10         1.00000        602.888      82.982     0.919373     1.40693e-11     5.70551e-13
   2.70000e-01        7.30000e-01        8.43422e-02        9.15658e-01       5.27511e-09        0.00000         1.12704e-10         1.00000        602.888      82.208     0.919373     1.41289e-11     5.70551e-13
   2.80000e-01        7.20000e-01        8.82977e-02        9.11702e-01       5.34838e-09        0.00000         1.14269e-10         1.00000        602.888      81.434     0.919373     1.41902e-11     5.70551e-13
   2.90000e-01        7.10000e-01        9.23292e-02        9.07671e-01       5.42371e-09        0.00000         1.15879e-10         1.00000        602.888      80.659     0.919373     1.42533e-11     5.70551e-13
   3.00000e-01        7.00000e-01        9.64388e-02        9.03561e-01       5.50119e-09        0.00000         1.17534e-10         1.00000        602.888      79.885     0.919373     1.43181e-11     5.70551e-13
   3.10000e-01        6.90000e-01        1.00629e-01        8.99371e-01       5.58092e-09        0.00000         1.19238e-10         1.00000        602.888      79.111     0.919373     1.43848e-11     5.70551e-13
   3.20000e-01        6.80000e-01        1.04902e-01        8.95098e-01       5.66299e-09        0.00000         1.20991e-10         1.00000        602.888      78.336     0.919373     1.44535e-11     5.70551e-13
   3.30000e-01        6.70000e-01        1.09260e-01        8.90740e-01       5.74751e-09        0.00000         1.22797e-10         1.00000        602.888      77.562     0.919373     1.45242e-11     5.70551e-13
   3.40000e-01        6.60000e-01        1.13706e-01        8.86294e-01       5.83459e-09        0.00000         1.24658e-10         1.00000        602.888      76.788     0.919373     1.45970e-11     5.70551e-13
   3.50000e-01        6.50000e-01        1.18243e-01        8.81757e-01       5.92436e-09        0.00000         1.26575e-10         1.00000        602.888      76.013     0.919373     1.46721e-11     5.70551e-13
   3.60000e-01        6.40000e-01        1.22873e-01        8.77127e-01       6.01692e-09        0.00000         1.28553e-10         1.00000        602.888      75.239     0.919373     1.47496e-11     5.70551e-13
   3.70000e-01        6.30000e-01        1.27599e-01        8.72401e-01       6.11243e-09        0.00000         1.30594e-10         1.00000        602.888      74.465     0.919373     1.48295e-11     5.70551e-13
   3.80000e-01        6.20000e-01        1.32425e-01        8.67575e-01       6.21102e-09        0.00000         1.32700e-10         1.00000        602.888      73.690     0.919373     1.49120e-11     5.70551e-13
   3.90000e-01        6.10000e-01        1.37353e-01        8.62647e-01       6.31284e-09        0.00000         1.34875e-10         1.00000        602.888      72.916     0.919373     1.49972e-11     5.70551e-13
   4.00000e-01        6.00000e-01        1.42387e-01        8.57613e-01       6.41805e-09        0.00000         1.37123e-10         1.00000        602.888      72.141     0.919373     1.50852e-11     5.70551e-13
   4.10000e-01        5.90000e-01        1.47530e-01        8.52470e-01       6.52683e-09        0.00000         1.39447e-10         1.00000        602.888      71.367     0.919373     1.51762e-11     5.70551e-13
   4.20000e-01        5.80000e-01        1.52787e-01        8.47213e-01       6.63936e-09        0.00000         1.41852e-10         1.00000        602.888      70.593     0.919373     1.52704e-11     5.70551e-13
   4.30000e-01        5.70000e-01        1.58159e-01        8.41841e-01       6.75584e-09        0.00000         1.44340e-10         1.00000        602.888      69.818     0.919373     1.53678e-11     5.70551e-13
   4.40000e-01        5.60000e-01        1.63652e-01        8.36348e-01       6.87648e-09        0.00000         1.46918e-10         1.00000        602.888      69.044     0.919373     1.54688e-11     5.70551e-13
   4.50000e-01        5.50000e-01        1.69270e-01        8.30730e-01       7.00151e-09        0.00000         1.49589e-10         1.00000        602.888      68.270     0.919373     1.55734e-11     5.70551e-13
   4.60000e-01        5.40000e-01        1.75017e-01        8.24983e-01       7.13117e-09        0.00000         1.52359e-10         1.00000        602.888      67.495     0.919373     1.56818e-11     5.70551e-13
   4.70000e-01        5.30000e-01        1.80897e-01        8.19103e-01       7.26572e-09        0.00000         1.55234e-10         1.00000        602.888      66.721     0.919373     1.57944e-11     5.70551e-13
   4.80000e-01        5.20000e-01        1.86915e-01        8.13085e-01       7.40545e-09        0.00000         1.58219e-10         1.00000        602.888      65.947     0.919373     1.59113e-11     5.70551e-13
   4.90000e-01        5.10000e-01        1.93076e-01        8.06924e-01       7.55065e-09        0.00000         1.61321e-10         1.00000        602.888      65.172     0.919373     1.60328e-11     5.70551e-13
   5.00000e-01        5.00000e-01        1.99386e-01        8.00614e-01       7.70166e-09        0.00000         1.64548e-10         1.00000        602.888      64.398     0.919373     1.61592e-11     5.70551e-13
   5.10000e-01        4.90000e-01        2.05849e-01        7.94151e-01       7.85884e-09        0.00000         1.67906e-10         1.00000        602.888      63.624     0.919373     1.62907e-11     5.70551e-13
   5.20000e-01        4.80000e-01        2.12471e-01        7.87529e-01       8.02257e-09        0.00000         1.71404e-10         1.00000        602.888      62.849     0.919373     1.64277e-11     5.70551e-13
   5.30000e-01        4.70000e-01        2.19258e-01        7.80742e-01       8.19326e-09        0.00000         1.75051e-10         1.00000        602.888      62.075     0.919373     1.65705e-11     5.70551e-13
   5.40000e-01        4.60000e-01        2.26217e-01        7.73783e-01       8.37137e-09        0.00000         1.78856e-10         1.00000        602.888      61.300     0.919373     1.67195e-11     5.70551e-13
   5.50000e-01        4.50000e-01        2.33354e-01        7.66646e-01       8.55740e-09        0.00000         1.82831e-10         1.00000        602.888      60.526     0.919373     1.68751e-11     5.70551e-13
   5.60000e-01        4.40000e-01        2.40676e-01        7.59324e-01       8.75189e-09        0.00000         1.86986e-10         1.00000        602.888      59.752     0.919373     1.70379e-11     5.70551e-13
   5.70000e-01        4.30000e-01        2.48190e-01        7.51810e-01       8.95542e-09        0.00000         1.91335e-10         1.00000        602.888      58.977     0.919373     1.72082e-11     5.70551e-13
   5.80000e-01        4.20000e-01        2.55905e-01        7.44095e-01       9.16865e-09        0.00000         1.95890e-10         1.00000        602.888      58.203     0.919373     1.73866e-11     5.70551e-13
   5.90000e-01        4.10000e-01        2.63827e-01        7.36173e-01       9.39227e-09        0.00000         2.00668e-10         1.00000        602.888      57.429     0.919373     1.75737e-11     5.70551e-13
   6.00000e-01        4.00000e-01        2.71966e-01        7.28034e-01       9.62708e-09        0.00000         2.05685e-10         1.00000        602.888      56.654     0.919373     1.77701e-11     5.70551e-13
   6.10000e-01        3.90000e-01        2.80330e-01        7.19670e-01       9.87393e-09        0.00000         2.10959e-10         1.00000        602.888      55.880     0.919373     1.79767e-11     5.70551e-13
   6.20000e-01        3.80000e-01        2.88929e-01        7.11071e-01       1.01338e-08        0.00000         2.16510e-10         1.00000        602.888      55.106     0.919373     1.81941e-11     5.70551e-13
   6.30000e-01        3.70000e-01        2.97774e-01        7.02226e-01       1.04077e-08        0.00000         2.22362e-10         1.00000        602.888      54.331     0.919373     1.84232e-11     5.70551e-13
   6.40000e-01        3.60000e-01        3.06874e-01        6.93126e-01       1.06968e-08        0.00000         2.28539e-10         1.00000        602.888      53.557     0.919373     1.86651e-11     5.70551e-13
   6.50000e-01        3.50000e-01        3.16242e-01        6.83758e-01       1.10024e-08        0.00000         2.35068e-10         1.00000        602.888      52.783     0.919373     1.89208e-11     5.70551e-13
   6.60000e-01        3.40000e-01        3.25888e-01        6.74112e-01       1.13260e-08        0.00000         2.41982e-10         1.00000        602.888      52.008     0.919373     1.91916e-11     5.70551e-13
   6.70000e-01        3.30000e-01        3.35826e-01        6.64174e-01       1.16692e-08        0.00000         2.49315e-10         1.00000        602.888      51.234     0.919373     1.94787e-11     5.70551e-13
   6.80000e-01        3.20000e-01        3.46069e-01        6.53931e-01       1.20338e-08        0.00000         2.57106e-10         1.00000        602.888      50.459     0.919373     1.97838e-11     5.70551e-13
   6.90000e-01        3.10000e-01        3.56631e-01        6.43369e-01       1.24220e-08        0.00000         2.65400e-10         1.00000        602.888      49.685     0.919373     2.01086e-11     5.70551e-13
   7.00000e-01        3.00000e-01        3.67527e-01        6.32473e-01       1.28361e-08        0.00000         2.74247e-10         1.00000        602.888      48.911     0.919373     2.04550e-11     5.70551e-13
   7.10000e-01        2.90000e-01        3.78774e-01        6.21226e-01       1.32787e-08        0.00000         2.83703e-10         1.00000        602.888      48.136     0.919373     2.08254e-11     5.70551e-13
   7.20000e-01        2.80000e-01        3.90389e-01        6.09611e-01       1.37530e-08        0.00000         2.93836e-10         1.00000        602.888      47.362     0.919373     2.12222e-11     5.70551e-13
   7.30000e-01        2.70000e-01        4.02390e-01        5.97610e-01       1.42623e-08        0.00000         3.04718e-10         1.00000        602.888      46.588     0.919373     2.16483e-11     5.70551e-13
   7.40000e-01        2.60000e-01        4.14797e-01        5.85203e-01       1.48109e-08        0.00000         3.16438e-10         1.00000        602.888      45.813     0.919373     2.21073e-11     5.70551e-13
   7.50000e-01        2.50000e-01        4.27630e-01        5.72370e-01       1.54033e-08        0.00000         3.29096e-10         1.00000        602.888      45.039     0.919373     2.26030e-11     5.70551e-13
   7.60000e-01        2.40000e-01        4.40913e-01        5.59087e-01       1.60451e-08        0.00000         3.42808e-10         1.00000        602.888      44.265     0.919373     2.31400e-11     5.70551e-13
   7.70000e-01        2.30000e-01        4.54668e-01        5.45332e-01       1.67427e-08        0.00000         3.57713e-10         1.00000        602.888      43.490     0.919373     2.37236e-11     5.70551e-13
   7.80000e-01        2.20000e-01        4.68922e-01        5.31078e-01       1.75038e-08        0.00000         3.73973e-10         1.00000        602.888      42.716     0.919373     2.43604e-11     5.70551e-13
   7.90000e-01        2.10000e-01        4.83703e-01        5.16297e-01       1.83373e-08        0.00000         3.91781e-10         1.00000        602.888      41.942     0.919373     2.50578e-11     5.70551e-13
   8.00000e-01        2.00000e-01        4.99039e-01        5.00961e-01       1.92542e-08        0.00000         4.11370e-10         1.00000        602.888      41.167     0.919373     2.58249e-11     5.70551e-13
   8.10000e-01        1.90000e-01        5.14964e-01        4.85036e-01       2.02675e-08        0.00000         4.33021e-10         1.00000        602.888      40.393     0.919373     2.66728e-11     5.70551e-13
   8.20000e-01        1.80000e-01        5.31511e-01        4.68489e-01       2.13935e-08        0.00000         4.57078e-10         1.00000        602.888      39.618     0.919373     2.76148e-11     5.70551e-13
   8.30000e-01        1.70000e-01        5.48717e-01        4.51283e-01       2.26520e-08        0.00000         4.83964e-10         1.00000        602.888      38.844     0.919373     2.86678e-11     5.70551e-13
   8.40000e-01        1.60000e-01        5.66624e-01        4.33376e-01       2.40677e-08        0.00000         5.14212e-10         1.00000        602.888      38.070     0.919373     2.98523e-11     5.70551e-13
   8.50000e-01        1.50000e-01        5.85274e-01        4.14726e-01       2.56722e-08        0.00000         5.48493e-10         1.00000        602.888      37.295     0.919373     3.11947e-11     5.70551e-13
   8.60000e-01        1.40000e-01        6.04716e-01        3.95284e-01       2.75059e-08        0.00000         5.87671e-10         1.00000        602.888      36.521     0.919373     3.27290e-11     5.70551e-13
   8.70000e-01        1.30000e-01        6.24999e-01        3.75001e-01       2.96218e-08        0.00000         6.32877e-10         1.00000        602.888      35.747     0.919373     3.44993e-11     5.70551e-13
   8.80000e-01        1.20000e-01        6.46181e-01        3.53819e-01       3.20903e-08        0.00000         6.85616e-10         1.00000        602.888      34.972     0.919373     3.65646e-11     5.70551e-13
   8.90000e-01        1.10000e-01        6.68322e-01        3.31678e-01       3.50076e-08        0.00000         7.47945e-10         1.00000        602.888      34.198     0.919373     3.90054e-11     5.70551e-13
   9.00000e-01        1.00000e-01        6.91488e-01        3.08512e-01       3.85083e-08        0.00000         8.22740e-10         1.00000        602.888      33.424     0.919373     4.19344e-11     5.70551e-13
   9.10000e-01        9.00000e-02        7.15754e-01        2.84246e-01       4.27870e-08        0.00000         9.14155e-10         1.00000        602.888      32.649     0.919373     4.55143e-11     5.70551e-13
   9.20000e-01        8.00000e-02        7.41199e-01        2.58801e-01       4.81354e-08        0.00000         1.02842e-09         1.00000        602.888      31.875     0.919373     4.99892e-11     5.70551e-13
   9.30000e-01        7.00000e-02        7.67911e-01        2.32089e-01       5.50119e-08        0.00000         1.17534e-09         1.00000        602.888      31.101     0.919373     5.57426e-11     5.70551e-13
   9.40000e-01        6.00000e-02        7.95987e-01        2.04013e-01       6.41805e-08        0.00000         1.37123e-09         1.00000        602.888      30.326     0.919373     6.34138e-11     5.70551e-13
   9.50000e-01        5.00000e-02        8.25534e-01        1.74466e-01       7.70166e-08        0.00000         1.64548e-09         1.00000        602.888      29.552     0.919373     7.41535e-11     5.70551e-13
   9.60000e-01        4.00000e-02        8.56672e-01        1.43328e-01       9.62708e-08        0.00000         2.05685e-09         1.00000        602.888      28.777     0.919373     9.02631e-11     5.70551e-13
   9.70000e-01        3.00000e-02        8.89531e-01        1.10469e-01       1.28361e-07        0.00000         2.74247e-09         1.00000        602.888      28.003     0.919373     1.17112e-10     5.70551e-13
   9.80000e-01        2.00000e-02        9.24260e-01        7.57403e-02       1.92542e-07        0.00000         4.11370e-09         1.00000        602.888      27.229     0.919373     1.70811e-10     5.70551e-13
   9.90000e-01        1.00000e-02        9.61021e-01        3.89787e-02       3.85083e-07        0.00000         8.22740e-09         1.00000        602.888      26.454     0.919373     3.31906e-10     5.70551e-13
   9.95000e-01        5.00000e-03        9.80221e-01        1.97788e-02       7.70166e-07        0.00000         1.64548e-08         1.00000        602.888      26.067     0.919373     6.54097e-10     5.70551e-13
   9.98000e-01        2.00000e-03        9.92017e-01        7.98266e-03       1.92542e-06        0.00000         4.11370e-08         1.00000        602.888      25.835     0.919373     1.62067e-09     5.70551e-13
   9.99000e-01        1.00000e-03        9.95997e-01        4.00333e-03       3.85083e-06        0.00000         8.22740e-08         1.00000        602.888      25.757     0.919373     3.23163e-09     5.70552e-13
   9.99500e-01        5.00000e-04        9.97995e-01        2.00468e-03       7.70167e-06        0.00000         1.64548e-07         1.00000        602.888      25.719     0.919373     6.45354e-09     5.70552e-13
   9.99800e-01        2.00000e-04        9.99197e-01        8.02596e-04       1.92542e-05        0.00000         4.11370e-07         1.00000        602.888      25.696     0.919373     1.61193e-08     5.70553e-13
   9.99900e-01        1.00000e-04        9.99599e-01        4.01419e-04       3.85085e-05        0.00000         8.22742e-07         1.00000        602.888      25.688     0.919373     3.22289e-08     5.70554e-13
   9.99950e-01        5.00000e-05        9.99799e-01        2.00740e-04       7.70172e-05        0.00000         1.64549e-06         1.00000        602.887      25.684     0.919373     6.44484e-08     5.70556e-13
   9.99980e-01        2.00000e-05        9.99920e-01        8.03032e-05       1.92545e-04        0.00000         4.11376e-06         1.00000        602.886      25.682     0.919373     1.61108e-07     5.70564e-13
   9.99990e-01        1.00000e-05        9.99960e-01        4.01528e-05       3.85097e-04        0.00000         8.22764e-06         1.00000        602.884      25.681     0.919373     3.22213e-07     5.70577e-13
   9.99995e-01        5.00000e-06        9.99980e-01        2.00767e-05       7.70223e-04        0.00000         1.64558e-05         1.00000        602.879      25.680     0.919372     6.44441e-07     5.70602e-13
   9.99998e-01        2.00000e-06        9.99992e-01        8.03076e-06       1.92577e-03        0.00000         4.11432e-05         0.99999        602.866      25.680     0.919371     1.61127e-06     5.70679e-13
   9.99999e-01        1.00000e-06        9.99996e-01        4.01539e-06       3.85226e-03        0.00000         8.22989e-05         0.99999        602.844      25.680     0.919368     3.22315e-06     5.70807e-13
   1.00000e+00        5.00000e-07        9.99998e-01        2.00770e-06       7.70738e-03        0.00000         1.64648e-04         0.99998        602.801      25.680     0.919363     6.44874e-06     5.71063e-13
   1.00000e+00        2.00000e-07        9.99999e-01        8.03080e-07       1.92899e-02        0.00000         4.11996e-04         0.99995        602.670      25.680     0.919348     1.61403e-05     5.71834e-13
   1.00000e+00        1.00000e-07        1.00000e+00        4.01540e-07       3.86518e-02        0.00000         8.25251e-04         0.99990        602.451      25.680     0.919324     3.23425e-05     5.73124e-13
   1.00000e+00        5.00000e-08        1.00000e+00        2.00770e-07       7.75939e-02        0.00000         1.65558e-03         0.99979        602.011      25.680     0.919274     6.49346e-05     5.75728e-13
   1.00000e+00        2.00000e-08        1.00000e+00        8.03080e-08       1.96212e-01        0.00000         4.17785e-03         0.99948        600.673      25.680     0.919123     1.64252e-04     5.83733e-13
   1.00000e+00        1.00000e-08        1.00000e+00        4.01540e-08       4.00208e-01        0.00000         8.49134e-03         0.99894        598.381      25.680     0.918862     3.35202e-04     5.97762e-13
   1.00000e+00        5.00000e-09        1.00000e+00        2.00770e-08       8.34620e-01        0.00000         1.75758e-02         0.99778        593.540      25.680     0.918304     6.99859e-04     6.28778e-13
   1.00000e+00        3.09894e-09        1.00000e+00        1.24435e-08       1.42557e+00        0.00000         2.97160e-02         0.99622        587.038      25.680     0.917543     1.19727e-03     6.73585e-13
   1.00000e+00        2.00000e-09        1.00000e+00        8.03081e-09       2.43493e+00        0.00000         4.98866e-02         0.99355        576.156      25.680     0.916233     2.05048e-03     7.57672e-13
   1.00000e+00        1.54678e-09        1.00000e+00        6.21096e-09       3.48477e+00        0.00000         7.01342e-02         0.99078        565.129      25.680     0.914858     2.94276e-03     8.56355e-13
   1.00000e+00        1.25017e-09        1.00000e+00        5.01995e-09       4.98724e+00        0.00000         9.78718e-02         0.98683        549.848      25.680     0.912870     4.22842e-03     1.02050e-12
   1.00000e+00        1.07659e-09        1.00000e+00        4.32293e-09       7.13752e+00        0.00000         1.35179e-01         0.98120        528.972      25.680     0.909984     6.08623e-03     1.31197e-12
   1.00000e+00        1.01587e-09        1.00000e+00        4.07914e-09       1.02149e+01        0.00000         1.84091e-01         0.97321        501.023      25.680     0.905780     8.78189e-03     1.88062e-12
   1.00000e+00        1.01587e-09        1.00000e+00        4.07914e-09       1.02174e+01        0.00000         1.84128e-01         0.97320        501.002      25.680     0.905776     8.78407e-03     1.88116e-12
   1.00000e+00        1.04893e-09        1.00000e+00        4.21187e-09       1.29929e+01        0.00000         2.24177e-01         0.96605        477.628      25.680     0.901919     1.12529e-02     2.60413e-12
   1.00000e+00        1.16845e-09        1.00000e+00        4.69179e-09       1.65223e+01        0.00000         2.70218e-01         0.95705        450.240      25.680     0.896942     1.44442e-02     3.93993e-12
   1.00000e+00        1.43520e-09        1.00000e+00        5.76291e-09       2.10106e+01        0.00000         3.22000e-01         0.94576        418.896      25.680     0.890536     1.85872e-02     6.67444e-12
   1.00000e+00        2.00000e-09        1.00000e+00        8.03081e-09       2.67180e+01        0.00000         3.78963e-01         0.93169        384.125      25.680     0.882353     2.39934e-02     1.30513e-11
   1.00000e+00        2.95624e-09        1.00000e+00        1.18705e-08       3.25193e+01        0.00000         4.29042e-01         0.91773        353.974      25.680     0.874130     2.96473e-02     2.57854e-11
   1.00000e+00        5.00000e-09        1.00000e+00        2.00770e-08       3.95802e+01        0.00000         4.82505e-01         0.90128        323.458      25.680     0.864485     3.67434e-02     5.88835e-11
   1.00000e+00        1.00000e-08        1.00000e+00        4.01540e-08       4.81968e+01        0.00000         5.41009e-01         0.88209        294.111      25.680     0.853665     4.57153e-02     1.59898e-10
   1.00000e+00        2.00000e-08        1.00000e+00        8.03080e-08       5.63642e+01        0.00000         5.93517e-01         0.86495        273.035      25.680     0.844793     5.45221e-02     4.06366e-10
   1.00000e+00        5.00000e-08        1.00000e+00        2.00770e-07       6.67947e+01        0.00000         6.60912e-01         0.84472        253.854      25.680     0.835881     6.61590e-02     1.29903e-09
   1.00000e+00        1.00000e-07        1.00000e+00        4.01540e-07       7.45672e+01        0.00000         7.13387e-01         0.83101        244.043      25.680     0.831096     7.50761e-02     3.00583e-09
   1.00000e+00        2.00000e-07        9.99999e-01        8.03080e-07       8.23482e+01        0.00000         7.68669e-01         0.81856        237.158      25.680     0.827781     8.41708e-02     6.77386e-09
   1.00000e+00        5.00000e-07        9.99998e-01        2.00770e-06       9.28025e+01        0.00000         8.47395e-01         0.80401        231.280      25.680     0.825232     9.65736e-02     1.92302e-08
   9.99999e-01        1.00000e-06        9.99996e-01        4.01539e-06       1.00958e+02        0.00000         9.11841e-01         0.79447        228.522      25.680     0.824355     1.06322e-01     4.16294e-08
   9.99998e-01        2.00000e-06        9.99992e-01        8.03076e-06       1.09441e+02        0.00000         9.80870e-01         0.78629        226.701      25.680     0.824106     1.16454e-01     8.92097e-08
   9.99995e-01        5.00000e-06        9.99980e-01        2.00767e-05       1.21360e+02        0.00000         1.07966e+00         0.77780        225.096      25.680     0.824365     1.30548e-01     2.41925e-07
   9.99990e-01        1.00000e-05        9.99960e-01        4.01528e-05       1.31103e+02        0.00000         1.16056e+00         0.77341        224.090      25.681     0.824763     1.41832e-01     5.12543e-07
   9.99980e-01        2.00000e-05        9.99920e-01        8.03032e-05       1.41679e+02        0.00000         1.24733e+00         0.77107        222.971      25.682     0.825159     1.53744e-01     1.08505e-06
   9.99950e-01        5.00000e-05        9.99799e-01        2.00740e-04       1.57374e+02        0.00000         1.37227e+00         0.77183        220.918      25.684     0.825446     1.70621e-01     2.93134e-06
   9.99900e-01        1.00000e-04        9.99599e-01        4.01419e-04       1.70991e+02        0.00000         1.47586e+00         0.77606        218.641      25.688     0.825321     1.84402e-01     6.24422e-06
   9.99800e-01        2.00000e-04        9.99197e-01        8.02596e-04       1.86650e+02        0.00000         1.58887e+00         0.78432        215.489      25.696     0.824758     1.99231e-01     1.33826e-05
   9.99680e-01        3.20144e-04        9.98716e-01        1.28427e-03       1.98787e+02        0.00000         1.67192e+00         0.79278        212.725      25.705     0.824054     2.09998e-01     2.25563e-05
   9.99500e-01        5.00000e-04        9.97995e-01        2.00468e-03       2.11713e+02        0.00000         1.75613e+00         0.80341        209.553      25.719     0.823091     2.20811e-01     3.71562e-05
   9.99287e-01        7.13278e-04        9.97142e-01        2.85795e-03       2.23218e+02        0.00000         1.82760e+00         0.81406        206.587      25.735     0.822081     2.29913e-01     5.55043e-05
   9.99000e-01        1.00000e-03        9.95997e-01        4.00333e-03       2.35349e+02        0.00000         1.89961e+00         0.82630        203.364      25.757     0.820889     2.39022e-01     8.15822e-05
   9.98572e-01        1.42849e-03        9.94289e-01        5.71134e-03       2.49644e+02        0.00000         1.98035e+00         0.84185        199.493      25.791     0.819352     2.49180e-01     1.23015e-04
   9.98000e-01        2.00000e-03        9.92017e-01        7.98266e-03       2.64808e+02        0.00000         2.06149e+00         0.85944        195.356      25.835     0.817599     2.59349e-01     1.82068e-04
   9.97237e-01        2.76324e-03        9.88996e-01        1.10038e-02       2.81198e+02        0.00000         2.14441e+00         0.87952        190.901      25.894     0.815598     2.69731e-01     2.66586e-04
   9.96251e-01        3.74851e-03        9.85116e-01        1.48836e-02       2.98603e+02        0.00000         2.22752e+00         0.90185        186.235      25.970     0.813386     2.80157e-01     3.83835e-04
   9.95000e-01        5.00000e-03        9.80221e-01        1.97788e-02       3.17084e+02        0.00000         2.31069e+00         0.92652        181.388      26.067     0.810967     2.90655e-01     5.44226e-04
   9.93633e-01        6.36727e-03        9.74914e-01        2.50855e-02       3.34369e+02        0.00000         2.38417e+00         0.95038        176.976      26.173     0.808661     3.00018e-01     7.32417e-04
   9.91980e-01        8.01954e-03        9.68559e-01        3.14414e-02       3.52596e+02        0.00000         2.45754e+00         0.97627        172.466      26.301     0.806198     3.09487e-01     9.76076e-04
   9.90000e-01        1.00000e-02        9.61021e-01        3.89787e-02       3.71816e+02        0.00000         2.53070e+00         1.00432        167.872      26.454     0.803580     3.19092e-01     1.28949e-03
   9.88010e-01        1.19900e-02        9.53535e-01        4.64649e-02       3.89074e+02        0.00000         2.59300e+00         1.03013        163.892      26.608     0.801218     3.27434e-01     1.62607e-03
   9.85709e-01        1.42913e-02        9.44986e-01        5.50143e-02       4.07132e+02        0.00000         2.65498e+00         1.05774        159.871      26.787     0.798740     3.35923e-01     2.04054e-03
   9.83055e-01        1.69449e-02        9.35267e-01        6.47330e-02       4.26028e+02        0.00000         2.71656e+00         1.08728        155.815      26.992     0.796142     3.44586e-01     2.55011e-03
   9.80000e-01        2.00000e-02        9.24260e-01        7.57403e-02       4.45802e+02        0.00000         2.77761e+00         1.11893        151.729      27.229     0.793418     3.53453e-01     3.17640e-03
   9.77060e-01        2.29404e-02        9.13845e-01        8.61552e-02       4.63236e+02        0.00000         2.82870e+00         1.14746        148.253      27.456     0.791010     3.61138e-01     3.81725e-03
   9.73745e-01        2.62551e-02        9.02309e-01        9.76907e-02       4.81352e+02        0.00000         2.87916e+00         1.17776        144.757      27.713     0.788499     3.69025e-01     4.58243e-03
   9.70000e-01        3.00000e-02        8.89531e-01        1.10469e-01       5.00176e+02        0.00000         2.92881e+00         1.20999        141.240      28.003     0.785872     3.77146e-01     5.49921e-03
   9.65360e-01        3.46403e-02        8.74060e-01        1.25940e-01       5.21460e+02        0.00000         2.98157e+00         1.24743        137.388      28.362     0.782869     3.86287e-01     6.70896e-03
   9.60000e-01        4.00000e-02        8.56672e-01        1.43328e-01       5.43649e+02        0.00000         3.03264e+00         1.28772        133.492      28.777     0.779680     3.95834e-01     8.20359e-03
   9.55321e-01        4.46793e-02        8.41895e-01        1.58105e-01       5.61196e+02        0.00000         3.07004e+00         1.32061        130.479      29.140     0.777094     4.03451e-01     9.59042e-03
   9.50000e-01        5.00000e-02        8.25534e-01        1.74466e-01       5.79309e+02        0.00000         3.10562e+00         1.35567        127.411      29.552     0.774339     4.11439e-01     1.12568e-02
   9.40000e-01        6.00000e-02        7.95987e-01        2.04013e-01       6.08656e+02        0.00000         3.15558e+00         1.41545        122.462      30.326     0.769584     4.24873e-01     1.46355e-02
   9.30000e-01        7.00000e-02        7.67911e-01        2.32089e-01       6.32574e+02        0.00000         3.18701e+00         1.46793        118.335      31.101     0.765248     4.36654e-01     1.83222e-02
   9.20000e-01        8.00000e-02        7.41199e-01        2.58801e-01       6.51674e+02        0.00000         3.20283e+00         1.51365        114.829      31.875     0.761222     4.47111e-01     2.23034e-02
   9.10000e-01        9.00000e-02        7.15754e-01        2.84246e-01       6.66436e+02        0.00000         3.20522e+00         1.55303        111.808      32.649     0.757424     4.56473e-01     2.65697e-02
   9.00000e-01        1.00000e-01        6.91488e-01        3.08512e-01       6.77283e+02        0.00000         3.19592e+00         1.58642        109.173      33.424     0.753794     4.64908e-01     3.11148e-02
   8.90000e-01        1.10000e-01        6.68322e-01        3.31678e-01       6.84604e+02        0.00000         3.17644e+00         1.61419        106.848      34.198     0.750286     4.72549e-01     3.59363e-02
   8.80000e-01        1.20000e-01        6.46181e-01        3.53819e-01       6.88774e+02        0.00000         3.14816e+00         1.63672        104.775      34.972     0.746866     4.79503e-01     4.10352e-02
   8.70000e-01        1.30000e-01        6.24999e-01        3.75001e-01       6.90154e+02        0.00000         3.11232e+00         1.65438        102.910      35.747     0.743504     4.85857e-01     4.64162e-02
   8.60000e-01        1.40000e-01        6.04716e-01        3.95284e-01       6.89091e+02        0.00000         3.07006e+00         1.66760        101.215      36.521     0.740177     4.91688e-01     5.20878e-02
   8.50000e-01        1.50000e-01        5.85274e-01        4.14726e-01       6.85913e+02        0.00000         3.02245e+00         1.67679         99.659      37.295     0.736867     4.97060e-01     5.80624e-02
   8.40000e-01        1.60000e-01        5.66624e-01        4.33376e-01       6.80926e+02        0.00000         2.97043e+00         1.68234         98.218      38.070     0.733557     5.02029e-01     6.43567e-02
   8.30000e-01        1.70000e-01        5.48717e-01        4.51283e-01       6.74413e+02        0.00000         2.91485e+00         1.68465         96.870      38.844     0.730235     5.06644e-01     7.09920e-02
   8.20000e-01        1.80000e-01        5.31511e-01        4.68489e-01       6.66628e+02        0.00000         2.85645e+00         1.68410         95.598      39.618     0.726888     5.10948e-01     7.79945e-02
   8.10000e-01        1.90000e-01        5.14964e-01        4.85036e-01       6.57800e+02        0.00000         2.79589e+00         1.68102         94.385      40.393     0.723503     5.14978e-01     8.53962e-02
   8.00000e-01        2.00000e-01        4.99039e-01        5.00961e-01       6.48131e+02        0.00000         2.73372e+00         1.67573         93.218      41.167     0.720069     5.18766e-01     9.32354e-02
   7.90000e-01        2.10000e-01        4.83703e-01        5.16297e-01       6.37797e+02        0.00000         2.67041e+00         1.66853         92.086      41.942     0.716575     5.22341e-01     1.01558e-01
   7.80000e-01        2.20000e-01        4.68922e-01        5.31078e-01       6.26950e+02        0.00000         2.60634e+00         1.65968         90.977      42.716     0.713007     5.25727e-01     1.10420e-01
   7.70000e-01        2.30000e-01        4.54668e-01        5.45332e-01       6.15722e+02        0.00000         2.54185e+00         1.64941         89.880      43.490     0.709351     5.28946e-01     1.19887e-01
   7.60000e-01        2.40000e-01        4.40913e-01        5.59087e-01       6.04225e+02        0.00000         2.47717e+00         1.63792         88.787      44.265     0.705592     5.32018e-01     1.30040e-01
   7.50000e-01        2.50000e-01        4.27630e-01        5.72370e-01       5.92556e+02        0.00000         2.41252e+00         1.62540         87.687      45.039     0.701712     5.34958e-01     1.40977e-01
   7.40000e-01        2.60000e-01        4.14797e-01        5.85203e-01       5.80793e+02        0.00000         2.34803e+00         1.61202         86.573      45.813     0.697689     5.37782e-01     1.52818e-01
   7.30000e-01        2.70000e-01        4.02390e-01        5.97610e-01       5.69007e+02        0.00000         2.28380e+00         1.59792         85.433      46.588     0.693500     5.40502e-01     1.65714e-01
   7.20000e-01        2.80000e-01        3.90389e-01        6.09611e-01       5.57255e+02        0.00000         2.21990e+00         1.58322         84.257      47.362     0.689113     5.43131e-01     1.79854e-01
   7.10000e-01        2.90000e-01        3.78774e-01        6.21226e-01       5.45585e+02        0.00000         2.15633e+00         1.56806         83.035      48.136     0.684493     5.45679e-01     1.95483e-01
   7.00000e-01        3.00000e-01        3.67527e-01        6.32473e-01       5.34039e+02        0.00000         2.09308e+00         1.55252         81.752      48.911     0.679592     5.48155e-01     2.12920e-01
   6.90000e-01        3.10000e-01        3.56631e-01        6.43369e-01       5.22654e+02        0.00000         2.03007e+00         1.53671         80.393      49.685     0.674350     5.50568e-01     2.32595e-01
   6.80000e-01        3.20000e-01        3.46069e-01        6.53931e-01       5.11460e+02        0.00000         1.96717e+00         1.52072         78.939      50.459     0.668691     5.52927e-01     2.55101e-01
   6.70000e-01        3.30000e-01        3.35826e-01        6.64174e-01       5.00486e+02        0.00000         1.90419e+00         1.50463         77.365      51.234     0.662509     5.55240e-01     2.81285e-01
   6.60000e-01        3.40000e-01        3.25888e-01        6.74112e-01       4.89760e+02        0.00000         1.84082e+00         1.48854         75.638      52.008     0.655654     5.57515e-01     3.12410e-01
   6.50000e-01        3.50000e-01        3.16242e-01        6.83758e-01       4.79310e+02        0.00000         1.77661e+00         1.47255         73.710      52.783     0.647910     5.59759e-01     3.50461e-01
   6.40000e-01        3.60000e-01        3.06874e-01        6.93126e-01       4.69168e+02        0.00000         1.71088e+00         1.45675         71.514      53.557     0.638940     5.61983e-01     3.98778e-01
   6.30000e-01        3.70000e-01        2.97774e-01        7.02226e-01       4.59373e+02        0.00000         1.64250e+00         1.44128         68.939      54.331     0.628186     5.64197e-01     4.63524e-01
   6.20000e-01        3.80000e-01        2.88929e-01        7.11071e-01       4.49981e+02        0.00000         1.56954e+00         1.42632         65.802      55.106     0.614638     5.66416e-01     5.57550e-01
   6.10000e-01        3.90000e-01        2.80330e-01        7.19670e-01       4.41080e+02        0.00000         1.48867e+00         1.41216         61.772      55.880     0.596315     5.68661e-01     7.12352e-01
   6.00577e-01        3.99423e-01        2.72442e-01        7.27558e-01       4.33277e+02        0.00000         1.40198e+00         1.39995         56.771      56.610     0.571634     5.70832e-01     9.90030e-01
   6.00351e-01        3.99649e-01        2.72255e-01        7.27745e-01       4.33099e+02        0.50000         1.39967e+00         1.39967         56.627      56.627     0.570885     5.70885e-01     1.00000e+00
END

$Env_BP << END
#                                                                              Sat Pres                                                                                     Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
   6.00351e-01          0.39965          2.72255e-01          0.72774          433.099          0.5000            1.39967           1.39967         56.627     56.6271     0.570885     0.570885     1.00000e+00
   6.00125e-01          0.39987          2.72069e-01          0.72793          432.921          1.0000            1.39940           1.39738         56.645     56.4836     0.570938     0.570137     9.90037e-01
   6.00000e-01          0.40000          2.71966e-01          0.72803          432.822          1.0000            1.39925           1.39623         56.654     56.4135     0.570967     0.569769     9.85114e-01
   5.90000e-01          0.41000          2.63827e-01          0.73617          425.396          1.0000            1.38818           1.30418         57.429     50.4418     0.573377     0.536056     6.18355e-01
   5.80000e-01          0.42000          2.55905e-01          0.74410          418.780          1.0000            1.37897           1.23743         58.203     45.9517     0.575891     0.506676     3.99918e-01
   5.70000e-01          0.43000          2.48190e-01          0.75181          412.759          1.0000            1.37109           1.19210         58.977     42.9284     0.578468     0.484273     2.79197e-01
   5.60000e-01          0.44000          2.40676e-01          0.75932          407.165          1.0000            1.36411           1.15878         59.752     40.7438     0.581076     0.466440     2.05462e-01
   5.50000e-01          0.45000          2.33354e-01          0.76665          401.893          1.0000            1.35778           1.13255         60.526     39.0531     0.583696     0.451513     1.56420e-01
   5.40000e-01          0.46000          2.26217e-01          0.77378          396.878          1.0000            1.35193           1.11097         61.300     37.6803     0.586315     0.438564     1.21866e-01
   5.30000e-01          0.47000          2.19258e-01          0.78074          392.076          1.0000            1.34644           1.09265         62.075     36.5277     0.588926     0.427046     9.65371e-02
   5.20000e-01          0.48000          2.12471e-01          0.78753          387.453          1.0000            1.34125           1.07675         62.849     35.5360     0.591523     0.416616     7.74361e-02
   5.10000e-01          0.49000          2.05849e-01          0.79415          382.987          1.0000            1.33630           1.06273         63.624     34.6671     0.594102     0.407042     6.27239e-02
   5.00000e-01          0.50000          1.99386e-01          0.80061          378.657          1.0000            1.33154           1.05022         64.398     33.8947     0.596661     0.398163     5.12061e-02
   4.90000e-01          0.51000          1.93076e-01          0.80692          374.450          1.0000            1.32693           1.03894         65.172     33.2005     0.599198     0.389861     4.20725e-02
   4.80000e-01          0.52000          1.86915e-01          0.81308          370.352          1.0000            1.32246           1.02869         65.947     32.5705     0.601710     0.382048     3.47539e-02
   4.70000e-01          0.53000          1.80897e-01          0.81910          366.355          1.0000            1.31810           1.01932         66.721     31.9946     0.604198     0.374654     2.88392e-02
   4.60000e-01          0.54000          1.75017e-01          0.82498          362.449          1.0000            1.31383           1.01070         67.495     31.4645     0.606659     0.367626     2.40250e-02
   4.50000e-01          0.55000          1.69270e-01          0.83073          358.628          1.0000            1.30963           1.00275         68.270     30.9740     0.609095     0.360921     2.00828e-02
   4.40000e-01          0.56000          1.63652e-01          0.83635          354.885          1.0000            1.30550           0.99538         69.044     30.5180     0.611503     0.354503     1.68379e-02
   4.30000e-01          0.57000          1.58159e-01          0.84184          351.216          1.0000            1.30143           0.98852         69.818     30.0922     0.613885     0.348342     1.41549e-02
   4.20000e-01          0.58000          1.52787e-01          0.84721          347.615          1.0000            1.29740           0.98213         70.593     29.6931     0.616239     0.342414     1.19279e-02
   4.10000e-01          0.59000          1.47530e-01          0.85247          344.079          1.0000            1.29340           0.97615         71.367     29.3180     0.618566     0.336698     1.00729e-02
   4.00000e-01          0.60000          1.42387e-01          0.85761          340.604          1.0000            1.28943           0.97055         72.141     28.9644     0.620867     0.331176     8.52320e-03
   3.90000e-01          0.61000          1.37353e-01          0.86265          337.187          1.0000            1.28549           0.96529         72.916     28.6301     0.623140     0.325833     7.22489e-03
   3.80000e-01          0.62000          1.32425e-01          0.86758          333.824          1.0000            1.28157           0.96036         73.690     28.3133     0.625387     0.320656     6.13455e-03
   3.70000e-01          0.63000          1.27599e-01          0.87240          330.514          1.0000            1.27766           0.95571         74.465     28.0126     0.627607     0.315633     5.21680e-03
   3.60000e-01          0.64000          1.22873e-01          0.87713          327.254          1.0000            1.27376           0.95132         75.239     27.7266     0.629800     0.310754     4.44275e-03
   3.50000e-01          0.65000          1.18243e-01          0.88176          324.042          1.0000            1.26987           0.94719         76.013     27.4541     0.631968     0.306009     3.78868e-03
   3.40000e-01          0.66000          1.13706e-01          0.88629          320.876          1.0000            1.26598           0.94329         76.788     27.1939     0.634110     0.301390     3.23503e-03
   3.30000e-01          0.67000          1.09260e-01          0.89074          317.754          1.0000            1.26209           0.93959         77.562     26.9453     0.636226     0.296891     2.76564e-03
   3.20000e-01          0.68000          1.04902e-01          0.89510          314.675          1.0000            1.25821           0.93610         78.336     26.7073     0.638317     0.292504     2.36708e-03
   3.10000e-01          0.69000          1.00629e-01          0.89937          311.637          1.0000            1.25431           0.93280         79.111     26.4793     0.640384     0.288224     2.02819e-03
   3.00000e-01          0.70000          9.64388e-02          0.90356          308.638          1.0000            1.25042           0.92967         79.885     26.2605     0.642426     0.284045     1.73966e-03
   2.90000e-01          0.71000          9.23292e-02          0.90767          305.678          1.0000            1.24651           0.92671         80.659     26.0504     0.644443     0.279962     1.49370e-03
   2.80000e-01          0.72000          8.82977e-02          0.91170          302.754          1.0000            1.24260           0.92390         81.434     25.8484     0.646437     0.275971     1.28377e-03
   2.70000e-01          0.73000          8.43422e-02          0.91566          299.867          1.0000            1.23868           0.92123         82.208     25.6541     0.648407     0.272068     1.10439e-03
   2.60000e-01          0.74000          8.04605e-02          0.91954          297.014          1.0000            1.23474           0.91871         82.982     25.4669     0.650354     0.268249     9.50951e-04
   2.50000e-01          0.75000          7.66506e-02          0.92335          294.195          1.0000            1.23080           0.91631         83.757     25.2864     0.652278     0.264510     8.19566e-04
   2.40000e-01          0.76000          7.29105e-02          0.92709          291.409          1.0000            1.22683           0.91404         84.531     25.1123     0.654180     0.260848     7.06950e-04
   2.30000e-01          0.77000          6.92383e-02          0.93076          288.655          1.0000            1.22286           0.91189         85.306     24.9443     0.656060     0.257260     6.10329e-04
   2.20000e-01          0.78000          6.56322e-02          0.93437          285.933          1.0000            1.21887           0.90985         86.080     24.7820     0.657917     0.253743     5.27352e-04
   2.10000e-01          0.79000          6.20904e-02          0.93791          283.240          1.0000            1.21486           0.90791         86.854     24.6250     0.659754     0.250295     4.56028e-04
   2.00000e-01          0.80000          5.86111e-02          0.94139          280.577          1.0000            1.21084           0.90607         87.629     24.4732     0.661569     0.246913     3.94666e-04
   1.90000e-01          0.81000          5.51928e-02          0.94481          277.943          1.0000            1.20680           0.90433         88.403     24.3263     0.663363     0.243595     3.41829e-04
   1.80000e-01          0.82000          5.18339e-02          0.94817          275.337          1.0000            1.20274           0.90268         89.177     24.1841     0.665136     0.240338     2.96294e-04
   1.70000e-01          0.83000          4.85328e-02          0.95147          272.759          1.0000            1.19866           0.90112         89.952     24.0462     0.666890     0.237140     2.57019e-04
   1.60000e-01          0.84000          4.52881e-02          0.95471          270.207          1.0000            1.19457           0.89964         90.726     23.9126     0.668623     0.234000     2.23117e-04
   1.50000e-01          0.85000          4.20983e-02          0.95790          267.682          1.0000            1.19045           0.89824         91.500     23.7830     0.670337     0.230916     1.93829e-04
   1.40000e-01          0.86000          3.89620e-02          0.96104          265.182          1.0000            1.18632           0.89692         92.275     23.6572     0.672032     0.227885     1.68507e-04
   1.30000e-01          0.87000          3.58779e-02          0.96412          262.708          1.0000            1.18216           0.89567         93.049     23.5352     0.673708     0.224907     1.46599e-04
   1.20000e-01          0.88000          3.28447e-02          0.96716          260.258          1.0000            1.17798           0.89449         93.823     23.4166     0.675365     0.221979     1.27628e-04
   1.10000e-01          0.89000          2.98612e-02          0.97014          257.832          1.0000            1.17379           0.89338         94.598     23.3014     0.677004     0.219101     1.11190e-04
   1.00000e-01          0.90000          2.69261e-02          0.97307          255.430          1.0000            1.16957           0.89234         95.372     23.1894     0.678624     0.216270     9.69352e-05
   9.00000e-02          0.91000          2.40384e-02          0.97596          253.051          1.0000            1.16534           0.89135         96.147     23.0806     0.680227     0.213486     8.45655e-05
   8.00000e-02          0.92000          2.11967e-02          0.97880          250.695          1.0000            1.16108           0.89043         96.921     22.9747     0.681812     0.210746     7.38238e-05
   7.00000e-02          0.93000          1.84001e-02          0.98160          248.361          1.0000            1.15680           0.88956         97.695     22.8716     0.683380     0.208051     6.44893e-05
   6.00000e-02          0.94000          1.56475e-02          0.98435          246.049          1.0000            1.15250           0.88874         98.470     22.7713     0.684931     0.205398     5.63720e-05
   5.00000e-02          0.95000          1.29378e-02          0.98706          243.758          1.0000            1.14817           0.88798         99.244     22.6737     0.686465     0.202786     4.93085e-05
   4.00000e-02          0.96000          1.02701e-02          0.98973          241.488          1.0000            1.14383           0.88727        100.018     22.5786     0.687983     0.200215     4.31577e-05
   3.00000e-02          0.97000          7.64343e-03          0.99236          239.239          1.0000            1.13946           0.88662        100.793     22.4859     0.689485     0.197683     3.77982e-05
   2.00000e-02          0.98000          5.05677e-03          0.99494          237.011          1.0000            1.13507           0.88600        101.567     22.3956     0.690970     0.195190     3.31251e-05
   1.00000e-02          0.99000          2.50925e-03          0.99749          234.802          1.0000            1.13066           0.88544        102.341     22.3075     0.692440     0.192734     2.90479e-05
   5.00000e-03          0.99500          1.24990e-03          0.99875          233.705          1.0000            1.12845           0.88517        102.729     22.2643     0.693169     0.191520     2.72078e-05
   2.00000e-03          0.99800          4.98831e-04          0.99950          233.049          1.0000            1.12712           0.88502        102.961     22.2386     0.693605     0.190795     2.61622e-05
   1.00000e-03          0.99900          2.49228e-04          0.99975          232.831          1.0000            1.12668           0.88496        103.038     22.2301     0.693750     0.190555     2.58229e-05
   5.00000e-04          0.99950          1.24567e-04          0.99988          232.722          1.0000            1.12645           0.88494        103.077     22.2259     0.693822     0.190434     2.56550e-05
   2.00000e-04          0.99980          4.98157e-05          0.99995          232.656          1.0000            1.12632           0.88492        103.100     22.2233     0.693866     0.190362     2.55548e-05
   1.00000e-04          0.99990          2.49060e-05          0.99998          232.635          1.0000            1.12628           0.88492        103.108     22.2225     0.693880     0.190338     2.55215e-05
   5.00000e-05          0.99995          1.24525e-05          0.99999          232.624          1.0000            1.12625           0.88492        103.112     22.2221     0.693887     0.190326     2.55049e-05
   2.00000e-05          0.99998          4.98090e-06          1.00000          232.617          1.0000            1.12624           0.88492        103.114     22.2218     0.693892     0.190319     2.54949e-05
   1.00000e-05          0.99999          2.49043e-06          1.00000          232.615          1.0000            1.12624           0.88492        103.115     22.2217     0.693893     0.190317     2.54916e-05
   5.00000e-06          0.99999          1.24521e-06          1.00000          232.614          1.0000            1.12623           0.88491        103.115     22.2217     0.693894     0.190315     2.54899e-05
   2.00000e-06          1.00000          4.98083e-07          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190315     2.54889e-05
   1.00000e-06          1.00000          2.49041e-07          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54886e-05
   5.00000e-07          1.00000          1.24521e-07          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54884e-05
   2.00000e-07          1.00000          4.98082e-08          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54883e-05
   1.00000e-07          1.00000          2.49041e-08          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54883e-05
   5.00000e-08          1.00000          1.24521e-08          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54883e-05
   2.00000e-08          1.00000          4.98082e-09          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   1.00000e-08          1.00000          2.49041e-09          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   5.00000e-09          1.00000          1.24521e-09          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   2.00000e-09          1.00000          4.98082e-10          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   1.00000e-09          1.00000          2.49041e-10          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   5.00000e-10          1.00000          1.24521e-10          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   2.00000e-10          1.00000          4.98082e-11          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   1.00000e-10          1.00000          2.49041e-11          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   5.00000e-11          1.00000          1.24521e-11          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   2.00000e-11          1.00000          4.98082e-12          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   1.00000e-11          1.00000          2.49041e-12          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   5.00000e-12          1.00000          1.24521e-12          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   2.00000e-12          1.00000          4.98082e-13          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   1.00000e-12          1.00000          2.49041e-13          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          232.613          1.0000            1.12623           0.88491        103.116     22.2216     0.693894     0.190314     2.54882e-05
END

set output "Figures/Env_002_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_002_P_vs_Wi_1.pdf"
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 3:5 with lines title "Dew Points", \
     $Env_BP using 3:5 with lines title "Bubble Points"

set output "Figures/Env_002_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_002_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (bar)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "P-T Diagram for Lab2_Slimtube_Oil"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   33.761     1.00000e-13        0.00000         2.53431e-15          1.00000       602.891     102.781     0.932251     4.02780e-16     2.29166e-17
   35.000     1.28934e-13        0.00000         3.25524e-15          1.00000       602.891     102.781     0.932019     5.17229e-16     2.93728e-17
   37.500     2.13738e-13        0.00000         5.35561e-15          1.00000       602.891     102.781     0.931549     8.50530e-16     4.81261e-17
   40.000     3.51010e-13        0.00000         8.72945e-15          1.00000       602.891     102.781     0.931075     1.38563e-15     7.81406e-17
   42.500     5.71192e-13        0.00000         1.41000e-14          1.00000       602.891     102.781     0.930597     2.23695e-15     1.25757e-16
   45.000     9.21234e-13        0.00000         2.25739e-14          1.00000       602.891     102.781     0.930115     3.57946e-15     2.00652e-16
   47.500     1.47292e-12        0.00000         3.58297e-14          1.00000       602.891     102.781     0.929629     5.67842e-15     3.17472e-16
   50.000     2.33509e-12        0.00000         5.63927e-14          1.00000       602.891     102.781     0.929139     8.93262e-15     4.98205e-16
   52.500     3.67142e-12        0.00000         8.80313e-14          1.00000       602.891     102.781     0.928646     1.39368e-14     7.75600e-16
   55.000     5.72608e-12        0.00000         1.36324e-13          1.00000       602.891     102.781     0.928148     2.15707e-14     1.19806e-15
   57.500     8.86051e-12        0.00000         2.09466e-13          1.00000       602.891     102.781     0.927646     3.31261e-14     1.83661e-15
   60.000     1.36057e-11        0.00000         3.19404e-13          1.00000       602.891     102.781     0.927139     5.04848e-14     2.79466e-15
   62.500     2.07359e-11        0.00000         4.83431e-13          1.00000       602.891     102.781     0.926629     7.63688e-14     4.22175e-15
   65.000     3.13720e-11        0.00000         7.26395e-13          1.00000       602.891     102.781     0.926115     1.14687e-13     6.33259e-15
   67.500     4.71254e-11        0.00000         1.08375e-12          1.00000       602.891     102.781     0.925596     1.71012e-13     9.43342e-15
   70.000     7.02962e-11        0.00000         1.60574e-12          1.00000       602.891     102.781     0.925073     2.53237e-13     1.39581e-14
   72.500     1.04146e-10        0.00000         2.36311e-12          1.00000       602.891     102.781     0.924546     3.72467e-13     2.05173e-14
   75.000     1.53271e-10        0.00000         3.45478e-12          1.00000       602.890     102.781     0.924014     5.44219e-13     2.99652e-14
   77.500     2.24103e-10        0.00000         5.01823e-12          1.00000       602.890     102.781     0.923478     7.90046e-13     4.34892e-14
   80.000     3.25587e-10        0.00000         7.24335e-12          1.00000       602.890     102.781     0.922938     1.13969e-12     6.27300e-14
   82.500     4.70094e-10        0.00000         1.03908e-11          1.00000       602.890     102.781     0.922393     1.63396e-12     8.99413e-14
   85.000     6.74621e-10        0.00000         1.48163e-11          1.00000       602.890     102.781     0.921844     2.32849e-12     1.28201e-13
   87.500     9.62389e-10        0.00000         2.10026e-11          1.00000       602.890     102.781     0.921290     3.29871e-12     1.81690e-13
   90.000     1.36495e-09        0.00000         2.96005e-11          1.00000       602.890     102.781     0.920732     4.64632e-12     2.56053e-13
   92.500     1.92490e-09        0.00000         4.14839e-11          1.00000       602.889     102.781     0.920169     6.50763e-12     3.58875e-13
   95.000     2.69952e-09        0.00000         5.78182e-11          1.00000       602.889     102.781     0.919601     9.06443e-12     5.00292e-13
   97.500     3.76529e-09        0.00000         8.01508e-11          1.00000       602.889     102.781     0.919029     1.25578e-11     6.93781e-13
  100.000     5.22393e-09        0.00000         1.10525e-10          1.00000       602.889     102.781     0.918452     1.73059e-11     9.57169e-13
  102.500     7.20995e-09        0.00000         1.51625e-10          1.00000       602.888     102.781     0.917871     2.37262e-11     1.31392e-12
  105.000     9.90037e-09        0.00000         2.06960e-10          1.00000       602.888     102.781     0.917284     3.23643e-11     1.79478e-12
  107.500     1.35270e-08        0.00000         2.81095e-10          1.00000       602.887     102.781     0.916693     4.39294e-11     2.43985e-12
  110.000     1.83920e-08        0.00000         3.79944e-10          1.00000       602.887     102.781     0.916097     5.93389e-11     3.30114e-12
  112.500     2.48873e-08        0.00000         5.11127e-10          1.00000       602.886     102.781     0.915496     7.97744e-11     4.44590e-12
  115.000     3.35189e-08        0.00000         6.84419e-10          1.00000       602.886     102.781     0.914890     1.06750e-10     5.96061e-12
  117.500     4.49375e-08        0.00000         9.12310e-10          1.00000       602.885     102.781     0.914279     1.42200e-10     7.95609e-12
  120.000     5.99757e-08        0.00000         1.21068e-09          1.00000       602.884     102.781     0.913663     1.88580e-10     1.05736e-11
  122.500     7.96945e-08        0.00000         1.59965e-09          1.00000       602.883     102.781     0.913042     2.48999e-10     1.39928e-11
  125.000     1.05441e-07        0.00000         2.10458e-09          1.00000       602.882     102.781     0.912416     3.27371e-10     1.84407e-11
  127.500     1.38915e-07        0.00000         2.75734e-09          1.00000       602.881     102.781     0.911785     4.28612e-10     2.42035e-11
  130.000     1.82261e-07        0.00000         3.59778e-09          1.00000       602.880     102.781     0.911148     5.58864e-10     3.16405e-11
  132.500     2.38162e-07        0.00000         4.67556e-09          1.00000       602.879     102.781     0.910506     7.25773e-10     4.12012e-11
  135.000     3.09972e-07        0.00000         6.05235e-09          1.00000       602.877     102.781     0.909859     9.38821e-10     5.34451e-11
  137.500     4.01863e-07        0.00000         7.80437e-09          1.00000       602.876     102.781     0.909207     1.20972e-09     6.90674e-11
  140.000     5.19005e-07        0.00000         1.00256e-08          1.00000       602.874     102.781     0.908549     1.55290e-09     8.89276e-11
  142.500     6.67784e-07        0.00000         1.28312e-08          1.00000       602.872     102.781     0.907885     1.98604e-09     1.14085e-10
  145.000     8.56056e-07        0.00000         1.63625e-08          1.00000       602.870     102.781     0.907216     2.53075e-09     1.45842e-10
  147.500     1.09346e-06        0.00000         2.07912e-08          1.00000       602.868     102.781     0.906542     3.21336e-09     1.85791e-10
  150.000     1.39175e-06        0.00000         2.63265e-08          1.00000       602.866     102.781     0.905862     4.06582e-09     2.35878e-10
  152.500     1.76529e-06        0.00000         3.32212e-08          1.00000       602.863     102.781     0.905176     5.12676e-09     2.98467e-10
  155.000     2.23147e-06        0.00000         4.17807e-08          1.00000       602.860     102.781     0.904485     6.44279e-09     3.76427e-10
  157.500     2.81133e-06        0.00000         5.23723e-08          1.00000       602.857     102.781     0.903787     8.06989e-09     4.73224e-10
  160.000     3.53028e-06        0.00000         6.54366e-08          1.00000       602.853     102.781     0.903084     1.00751e-08     5.93036e-10
  162.500     4.41885e-06        0.00000         8.15002e-08          1.00000       602.850     102.781     0.902375     1.25386e-08     7.40882e-10
  165.000     5.51361e-06        0.00000         1.01191e-07          1.00000       602.846     102.781     0.901660     1.55558e-08     9.22776e-10
  167.500     6.85828e-06        0.00000         1.25255e-07          1.00000       602.841     102.781     0.900939     1.92398e-08     1.14590e-09
  170.000     8.50496e-06        0.00000         1.54576e-07          1.00000       602.836     102.781     0.900212     2.37247e-08     1.41881e-09
  172.500     1.05155e-05        0.00000         1.90199e-07          1.00000       602.831     102.781     0.899479     2.91687e-08     1.75168e-09
  175.000     1.29633e-05        0.00000         2.33354e-07          1.00000       602.826     102.781     0.898739     3.57578e-08     2.15653e-09
  177.500     1.59348e-05        0.00000         2.85487e-07          1.00000       602.820     102.781     0.897994     4.37105e-08     2.64761e-09
  180.000     1.95320e-05        0.00000         3.48293e-07          1.00000       602.813     102.781     0.897242     5.32825e-08     3.24168e-09
  182.500     2.38748e-05        0.00000         4.23751e-07          1.00000       602.806     102.781     0.896483     6.47722e-08     3.95844e-09
  185.000     2.91037e-05        0.00000         5.14170e-07          1.00000       602.799     102.781     0.895718     7.85271e-08     4.82101e-09
  187.500     3.53825e-05        0.00000         6.22233e-07          1.00000       602.791     102.781     0.894947     9.49506e-08     5.85641e-09
  190.000     4.29027e-05        0.00000         7.51051e-07          1.00000       602.782     102.781     0.894169     1.14510e-07     7.09619e-09
  192.500     5.18866e-05        0.00000         9.04226e-07          1.00000       602.773     102.781     0.893384     1.37745e-07     8.57705e-09
  195.000     6.25922e-05        0.00000         1.08591e-06          1.00000       602.763     102.781     0.892593     1.65278e-07     1.03416e-08
  197.500     7.53179e-05        0.00000         1.30089e-06          1.00000       602.752     102.781     0.891795     1.97825e-07     1.24393e-08
  200.000     9.04082e-05        0.00000         1.55465e-06          1.00000       602.740     102.781     0.890990     2.36205e-07     1.49272e-08
  202.500     1.08260e-04        0.00000         1.85349e-06          1.00000       602.728     102.781     0.890178     2.81359e-07     1.78712e-08
  205.000     1.29329e-04        0.00000         2.20461e-06          1.00000       602.715     102.781     0.889359     3.34358e-07     2.13470e-08
  207.500     1.54137e-04        0.00000         2.61622e-06          1.00000       602.701     102.781     0.888532     3.96424e-07     2.54419e-08
  210.000     1.83283e-04        0.00000         3.09765e-06          1.00000       602.686     102.781     0.887699     4.68945e-07     3.02555e-08
  212.500     2.17449e-04        0.00000         3.65952e-06          1.00000       602.670     102.781     0.886858     5.53496e-07     3.59020e-08
  215.000     2.57410e-04        0.00000         4.31387e-06          1.00000       602.653     102.781     0.886010     6.51859e-07     4.25118e-08
  217.500     3.04051e-04        0.00000         5.07429e-06          1.00000       602.635     102.781     0.885155     7.66047e-07     5.02332e-08
  220.000     3.58371e-04        0.00000         5.95614e-06          0.99999       602.616     102.781     0.884292     8.98329e-07     5.92351e-08
  222.500     4.21504e-04        0.00000         6.97671e-06          0.99999       602.596     102.781     0.883421     1.05126e-06     6.97091e-08
  225.000     4.94729e-04        0.00000         8.15546e-06          0.99999       602.574     102.781     0.882543     1.22769e-06     8.18721e-08
  227.500     5.79489e-04        0.00000         9.51419e-06          0.99999       602.551     102.781     0.881656     1.43085e-06     9.59694e-08
  230.000     6.77406e-04        0.00000         1.10773e-05          0.99999       602.527     102.781     0.880762     1.66431e-06     1.12278e-07
  232.500     7.90302e-04        0.00000         1.28722e-05          0.99999       602.501     102.781     0.879860     1.93209e-06     1.31109e-07
  235.000     9.20218e-04        0.00000         1.49293e-05          0.99999       602.473     102.781     0.878950     2.23864e-06     1.52815e-07
  237.500     1.06944e-03        0.00000         1.72824e-05          0.99999       602.444     102.781     0.878031     2.58892e-06     1.77788e-07
  240.000     1.24051e-03        0.00000         1.99694e-05          0.99998       602.414     102.781     0.877105     2.98843e-06     2.06471e-07
  242.500     1.43628e-03        0.00000         2.30321e-05          0.99998       602.381     102.781     0.876169     3.44328e-06     2.39356e-07
  245.000     1.65991e-03        0.00000         2.65168e-05          0.99998       602.347     102.781     0.875226     3.96021e-06     2.76997e-07
  247.500     1.91491e-03        0.00000         3.04748e-05          0.99998       602.310     102.781     0.874273     4.54666e-06     3.20007e-07
  250.000     2.20517e-03        0.00000         3.49628e-05          0.99997       602.272     102.781     0.873312     5.21084e-06     3.69074e-07
  252.500     2.53501e-03        0.00000         4.00429e-05          0.99997       602.231     102.781     0.872342     5.96179e-06     4.24958e-07
  255.000     2.90919e-03        0.00000         4.57840e-05          0.99997       602.188     102.781     0.871363     6.80941e-06     4.88506e-07
  257.500     3.33296e-03        0.00000         5.22614e-05          0.99996       602.143     102.781     0.870375     7.76458e-06     5.60657e-07
  260.000     3.81210e-03        0.00000         5.95577e-05          0.99996       602.095     102.781     0.869378     8.83922e-06     6.42447e-07
  262.500     4.35300e-03        0.00000         6.77636e-05          0.99995       602.045     102.781     0.868371     1.00463e-05     7.35026e-07
  265.000     4.96262e-03        0.00000         7.69782e-05          0.99994       601.992     102.781     0.867355     1.14002e-05     8.39661e-07
  267.500     5.64864e-03        0.00000         8.73094e-05          0.99994       601.936     102.781     0.866329     1.29162e-05     9.57748e-07
  270.000     6.41944e-03        0.00000         9.88753e-05          0.99993       601.878     102.781     0.865293     1.46112e-05     1.09083e-06
  272.500     7.28419e-03        0.00000         1.11804e-04          0.99992       601.816     102.781     0.864248     1.65036e-05     1.24058e-06
  275.000     8.25289e-03        0.00000         1.26236e-04          0.99991       601.751     102.781     0.863192     1.86133e-05     1.40888e-06
  277.500     9.33645e-03        0.00000         1.42321e-04          0.99990       601.683     102.781     0.862126     2.09617e-05     1.59776e-06
  280.000     1.05467e-02        0.00000         1.60224e-04          0.99989       601.611     102.781     0.861050     2.35723e-05     1.80943e-06
  282.500     1.18967e-02        0.00000         1.80124e-04          0.99988       601.536     102.781     0.859964     2.64701e-05     2.04636e-06
  285.000     1.34002e-02        0.00000         2.02212e-04          0.99987       601.457     102.781     0.858866     2.96823e-05     2.31120e-06
  287.500     1.50726e-02        0.00000         2.26695e-04          0.99985       601.374     102.781     0.857758     3.32383e-05     2.60687e-06
  290.000     1.69302e-02        0.00000         2.53798e-04          0.99984       601.286     102.781     0.856639     3.71696e-05     2.93653e-06
  292.500     1.89908e-02        0.00000         2.83761e-04          0.99982       601.195     102.781     0.855509     4.15100e-05     3.30365e-06
  295.000     2.12736e-02        0.00000         3.16845e-04          0.99980       601.099     102.781     0.854367     4.62960e-05     3.71200e-06
  297.500     2.37993e-02        0.00000         3.53327e-04          0.99978       600.999     102.781     0.853214     5.15666e-05     4.16565e-06
  300.000     2.65902e-02        0.00000         3.93506e-04          0.99976       600.893     102.781     0.852049     5.73635e-05     4.66905e-06
  302.500     2.96702e-02        0.00000         4.37704e-04          0.99974       600.783     102.781     0.850872     6.37316e-05     5.22702e-06
  305.000     3.30651e-02        0.00000         4.86264e-04          0.99971       600.667     102.781     0.849683     7.07185e-05     5.84477e-06
  307.500     3.68025e-02        0.00000         5.39552e-04          0.99969       600.546     102.781     0.848481     7.83754e-05     6.52796e-06
  310.000     4.09122e-02        0.00000         5.97961e-04          0.99966       600.419     102.781     0.847267     8.67565e-05     7.28270e-06
  312.500     4.54259e-02        0.00000         6.61910e-04          0.99962       600.287     102.781     0.846041     9.59199e-05     8.11560e-06
  315.000     5.03776e-02        0.00000         7.31845e-04          0.99959       600.148     102.781     0.844801     1.05927e-04     9.03380e-06
  317.500     5.58035e-02        0.00000         8.08241e-04          0.99955       600.003     102.781     0.843548     1.16844e-04     1.00450e-05
  320.000     6.17426e-02        0.00000         8.91604e-04          0.99951       599.851     102.781     0.842282     1.28740e-04     1.11575e-05
  322.500     6.82362e-02        0.00000         9.82473e-04          0.99947       599.692     102.781     0.841002     1.41688e-04     1.23803e-05
  325.000     7.53283e-02        0.00000         1.08142e-03          0.99942       599.526     102.781     0.839708     1.55768e-04     1.37229e-05
  327.500     8.30660e-02        0.00000         1.18905e-03          0.99937       599.353     102.781     0.838400     1.71062e-04     1.51959e-05
  330.000     9.14993e-02        0.00000         1.30600e-03          0.99932       599.172     102.781     0.837077     1.87659e-04     1.68102e-05
  332.500     1.00681e-01        0.00000         1.43296e-03          0.99926       598.983     102.781     0.835740     2.05649e-04     1.85780e-05
  335.000     1.10668e-01        0.00000         1.57065e-03          0.99920       598.785     102.781     0.834387     2.25133e-04     2.05120e-05
  337.500     1.21520e-01        0.00000         1.71983e-03          0.99913       598.578     102.781     0.833020     2.46213e-04     2.26262e-05
  340.000     1.33300e-01        0.00000         1.88131e-03          0.99906       598.363     102.781     0.831637     2.68998e-04     2.49353e-05
  342.500     1.46076e-01        0.00000         2.05593e-03          0.99899       598.138     102.781     0.830238     2.93604e-04     2.74552e-05
  345.000     1.59918e-01        0.00000         2.24460e-03          0.99891       597.903     102.781     0.828822     3.20152e-04     3.02030e-05
  347.500     1.74903e-01        0.00000         2.44826e-03          0.99883       597.658     102.781     0.827390     3.48770e-04     3.31970e-05
  350.000     1.91109e-01        0.00000         2.66791e-03          0.99874       597.402     102.781     0.825942     3.79592e-04     3.64568e-05
  352.500     2.08621e-01        0.00000         2.90461e-03          0.99864       597.135     102.781     0.824475     4.12760e-04     4.00032e-05
  355.000     2.27528e-01        0.00000         3.15946e-03          0.99854       596.857     102.781     0.822992     4.48421e-04     4.38589e-05
  357.500     2.47924e-01        0.00000         3.43363e-03          0.99843       596.567     102.781     0.821490     4.86733e-04     4.80477e-05
  360.000     2.69908e-01        0.00000         3.72834e-03          0.99832       596.264     102.781     0.819970     5.27860e-04     5.25953e-05
  362.500     2.93583e-01        0.00000         4.04488e-03          0.99820       595.948     102.781     0.818432     5.71973e-04     5.75294e-05
  365.000     3.19061e-01        0.00000         4.38461e-03          0.99807       595.619     102.781     0.816874     6.19253e-04     6.28792e-05
  367.500     3.46457e-01        0.00000         4.74894e-03          0.99794       595.276     102.781     0.815296     6.69890e-04     6.86762e-05
  370.000     3.75892e-01        0.00000         5.13938e-03          0.99780       594.919     102.781     0.813699     7.24083e-04     7.49542e-05
  372.500     4.07497e-01        0.00000         5.55749e-03          0.99765       594.546     102.781     0.812081     7.82041e-04     8.17489e-05
  375.000     4.41405e-01        0.00000         6.00492e-03          0.99749       594.157     102.781     0.810442     8.43981e-04     8.90990e-05
  377.500     4.77759e-01        0.00000         6.48338e-03          0.99732       593.752     102.781     0.808781     9.10133e-04     9.70455e-05
  380.000     5.16710e-01        0.00000         6.99470e-03          0.99715       593.330     102.781     0.807099     9.80737e-04     1.05632e-04
  382.500     5.58413e-01        0.00000         7.54076e-03          0.99697       592.890     102.781     0.805394     1.05605e-03     1.14907e-04
  385.000     6.03035e-01        0.00000         8.12356e-03          0.99677       592.432     102.781     0.803666     1.13632e-03     1.24919e-04
  387.500     6.50751e-01        0.00000         8.74519e-03          0.99657       591.954     102.781     0.801914     1.22184e-03     1.35723e-04
  390.000     7.01742e-01        0.00000         9.40783e-03          0.99636       591.457     102.781     0.800138     1.31290e-03     1.47377e-04
  392.500     7.56202e-01        0.00000         1.01138e-02          0.99613       590.938     102.781     0.798338     1.40979e-03     1.59941e-04
  395.000     8.14333e-01        0.00000         1.08654e-02          0.99590       590.398     102.781     0.796512     1.51284e-03     1.73483e-04
  397.500     8.76347e-01        0.00000         1.16653e-02          0.99565       589.834     102.781     0.794659     1.62238e-03     1.88073e-04
  400.000     9.42468e-01        0.00000         1.25160e-02          0.99540       589.248     102.781     0.792780     1.73875e-03     2.03786e-04
  402.500     1.01293e+00        0.00000         1.34204e-02          0.99513       588.636     102.781     0.790873     1.86234e-03     2.20705e-04
  405.000     1.08799e+00        0.00000         1.43813e-02          0.99485       587.999     102.781     0.788938     1.99352e-03     2.38917e-04
  407.500     1.16789e+00        0.00000         1.54017e-02          0.99455       587.335     102.781     0.786974     2.13270e-03     2.58514e-04
  410.000     1.25292e+00        0.00000         1.64850e-02          0.99424       586.643     102.781     0.784980     2.28031e-03     2.79599e-04
  412.500     1.34336e+00        0.00000         1.76343e-02          0.99392       585.922     102.781     0.782955     2.43678e-03     3.02278e-04
  415.000     1.43952e+00        0.00000         1.88533e-02          0.99359       585.170     102.781     0.780899     2.60260e-03     3.26668e-04
  417.500     1.54172e+00        0.00000         2.01457e-02          0.99324       584.386     102.781     0.778809     2.77826e-03     3.52895e-04
  420.000     1.65029e+00        0.00000         2.15152e-02          0.99288       583.569     102.781     0.776686     2.96427e-03     3.81093e-04
  422.500     1.76559e+00        0.00000         2.29661e-02          0.99250       582.717     102.781     0.774529     3.16119e-03     4.11406e-04
  425.000     1.88801e+00        0.00000         2.45025e-02          0.99210       581.829     102.781     0.772335     3.36960e-03     4.43993e-04
  427.500     2.01793e+00        0.00000         2.61290e-02          0.99169       580.903     102.781     0.770105     3.59011e-03     4.79022e-04
  430.000     2.15577e+00        0.00000         2.78504e-02          0.99126       579.936     102.781     0.767837     3.82337e-03     5.16677e-04
  432.500     2.30198e+00        0.00000         2.96717e-02          0.99081       578.928     102.781     0.765529     4.07005e-03     5.57154e-04
  435.000     2.45704e+00        0.00000         3.15981e-02          0.99035       577.876     102.781     0.763180     4.33089e-03     6.00669e-04
  437.500     2.62144e+00        0.00000         3.36352e-02          0.98987       576.778     102.781     0.760789     4.60665e-03     6.47454e-04
  440.000     2.79571e+00        0.00000         3.57890e-02          0.98937       575.632     102.781     0.758355     4.89815e-03     6.97762e-04
  442.500     2.98041e+00        0.00000         3.80656e-02          0.98885       574.436     102.781     0.755875     5.20626e-03     7.51868e-04
  445.000     3.17615e+00        0.00000         4.04717e-02          0.98831       573.186     102.781     0.753348     5.53189e-03     8.10071e-04
  447.500     3.38356e+00        0.00000         4.30142e-02          0.98775       571.880     102.781     0.750773     5.87603e-03     8.72699e-04
  450.000     3.60333e+00        0.00000         4.57006e-02          0.98716       570.516     102.781     0.748147     6.23972e-03     9.40108e-04
  452.500     3.83617e+00        0.00000         4.85387e-02          0.98656       569.089     102.781     0.745468     6.62410e-03     1.01269e-03
  455.000     4.08288e+00        0.00000         5.15369e-02          0.98593       567.598     102.781     0.742735     7.03037e-03     1.09087e-03
  457.500     4.34428e+00        0.00000         5.47042e-02          0.98528       566.038     102.781     0.739944     7.45981e-03     1.17512e-03
  460.000     4.62127e+00        0.00000         5.80501e-02          0.98461       564.405     102.781     0.737093     7.91381e-03     1.26596e-03
  462.500     4.91483e+00        0.00000         6.15848e-02          0.98391       562.695     102.781     0.734181     8.39388e-03     1.36397e-03
  465.000     5.22598e+00        0.00000         6.53191e-02          0.98318       560.905     102.781     0.731203     8.90162e-03     1.46977e-03
  467.500     5.55586e+00        0.00000         6.92649e-02          0.98243       559.028     102.781     0.728157     9.43880e-03     1.58406e-03
  470.000     5.90569e+00        0.00000         7.34346e-02          0.98165       557.061     102.781     0.725039     1.00073e-02     1.70764e-03
  472.500     6.27679e+00        0.00000         7.78420e-02          0.98084       554.996     102.781     0.721846     1.06092e-02     1.84136e-03
  475.000     6.67061e+00        0.00000         8.25016e-02          0.98000       552.829     102.781     0.718574     1.12468e-02     1.98620e-03
  477.500     7.08874e+00        0.00000         8.74293e-02          0.97913       550.552     102.781     0.715218     1.19226e-02     2.14326e-03
  480.000     7.53290e+00        0.00000         9.26425e-02          0.97823       548.159     102.781     0.711774     1.26392e-02     2.31376e-03
  482.500     8.00501e+00        0.00000         9.81600e-02          0.97730       545.640     102.781     0.708237     1.33997e-02     2.49909e-03
  485.000     8.50718e+00        0.00000         1.04002e-01          0.97633       542.988     102.781     0.704601     1.42074e-02     2.70083e-03
  487.500     9.04175e+00        0.00000         1.10192e-01          0.97532       540.193     102.781     0.700859     1.50660e-02     2.92079e-03
  490.000     9.61134e+00        0.00000         1.16755e-01          0.97428       537.243     102.781     0.697005     1.59797e-02     3.16102e-03
  492.500     1.02189e+01        0.00000         1.23717e-01          0.97320       534.126     102.781     0.693031     1.69532e-02     3.42390e-03
  495.000     1.08677e+01        0.00000         1.31111e-01          0.97207       530.830     102.781     0.688927     1.79917e-02     3.71219e-03
  497.500     1.15615e+01        0.00000         1.38970e-01          0.97090       527.339     102.781     0.684684     1.91012e-02     4.02909e-03
  500.000     1.23046e+01        0.00000         1.47334e-01          0.96969       523.635     102.781     0.680291     2.02885e-02     4.37837e-03
  502.500     1.31019e+01        0.00000         1.56246e-01          0.96842       519.698     102.781     0.675733     2.15617e-02     4.76450e-03
  505.000     1.39592e+01        0.00000         1.65758e-01          0.96711       515.506     102.781     0.670997     2.29298e-02     5.19280e-03
  507.500     1.48831e+01        0.00000         1.75928e-01          0.96573       511.033     102.781     0.666064     2.44039e-02     5.66972e-03
  510.000     1.58816e+01        0.00000         1.86824e-01          0.96430       506.246     102.781     0.660913     2.59967e-02     6.20310e-03
  512.500     1.69643e+01        0.00000         1.98527e-01          0.96280       501.109     102.781     0.655520     2.77238e-02     6.80263e-03
  515.000     1.81429e+01        0.00000         2.11134e-01          0.96123       495.577     102.781     0.649853     2.96040e-02     7.48049e-03
  517.500     1.94316e+01        0.00000         2.24764e-01          0.95958       489.594     102.781     0.643875     3.16611e-02     8.25223e-03
  520.000     2.08489e+01        0.00000         2.39563e-01          0.95784       483.093     102.781     0.637537     3.39247e-02     9.13814e-03
  522.500     2.24184e+01        0.00000         2.55719e-01          0.95600       475.985     102.781     0.630779     3.64338e-02     1.01654e-02
  525.000     2.41717e+01        0.00000         2.73481e-01          0.95404       468.153     102.781     0.623519     3.92405e-02     1.13714e-02
  527.500     2.61531e+01        0.00000         2.93187e-01          0.95195       459.436     102.781     0.615641     4.24173e-02     1.28100e-02
  530.000     2.84271e+01        0.00000         3.15324e-01          0.94970       449.603     102.781     0.606979     4.60711e-02     1.45629e-02
  532.500     3.10956e+01        0.00000         3.40651e-01          0.94723       438.292     102.781     0.597271     5.03703e-02     1.67629e-02
  535.000     3.43368e+01        0.00000         3.70472e-01          0.94448       424.878     102.781     0.586060     5.56102e-02     1.96511e-02
  537.500     3.85231e+01        0.00000         4.07471e-01          0.94128       408.072     102.781     0.572392     6.24094e-02     2.37499e-02
  540.000     4.47874e+01        0.00000         4.59687e-01          0.93715       384.003     102.781     0.553379     7.26532e-02     3.07157e-02
  541.239     5.04927e+01        0.00000         5.04042e-01          0.93402       363.192     102.781     0.537319     8.20578e-02     3.80059e-02
  541.684     5.69248e+01        0.00000         5.50518e-01          0.93113       340.979     102.781     0.520420     9.27473e-02     4.74211e-02
  541.684     5.69629e+01        0.00000         5.50783e-01          0.93111       340.851     102.781     0.520323     9.28109e-02     4.74809e-02
  541.282     6.34666e+01        0.00000         5.94123e-01          0.92883       319.712     102.781     0.504358     1.03714e-01     5.84418e-02
  540.000     7.07128e+01        0.00000         6.38348e-01          0.92696       297.667     102.781     0.487714     1.15970e-01     7.25607e-02
  537.500     7.93652e+01        0.00000         6.85934e-01          0.92561       273.334     102.781     0.469216     1.30752e-01     9.24257e-02
  535.000     8.59280e+01        0.00000         7.18525e-01          0.92517       256.249     102.781     0.456068     1.42069e-01     1.09992e-01
  532.500     9.15340e+01        0.00000         7.44150e-01          0.92519       242.544     102.781     0.445381     1.51804e-01     1.26938e-01
  530.000     9.65553e+01        0.00000         7.65486e-01          0.92550       230.929     102.781     0.436201     1.60577e-01     1.43809e-01
  527.500     1.01170e+02        0.00000         7.83828e-01          0.92601       220.781     102.781     0.428071     1.68683e-01     1.60868e-01
  525.000     1.05480e+02        0.00000         7.99925e-01          0.92669       211.739     102.781     0.420730     1.76291e-01     1.78274e-01
  522.500     1.09550e+02        0.00000         8.14257e-01          0.92751       203.571     102.781     0.414009     1.83506e-01     1.96133e-01
  520.000     1.13423e+02        0.00000         8.27156e-01          0.92844       196.119     102.781     0.407795     1.90402e-01     2.14526e-01
  517.500     1.17131e+02        0.00000         8.38862e-01          0.92947       189.264     102.781     0.402006     1.97031e-01     2.33518e-01
  515.000     1.20699e+02        0.00000         8.49556e-01          0.93058       182.921     102.781     0.396580     2.03432e-01     2.53165e-01
  512.500     1.24143e+02        0.00000         8.59380e-01          0.93178       177.020     102.781     0.391468     2.09633e-01     2.73517e-01
  510.000     1.27478e+02        0.00000         8.68444e-01          0.93304       171.508     102.781     0.386633     2.15660e-01     2.94622e-01
  507.500     1.30716e+02        0.00000         8.76840e-01          0.93437       166.340     102.781     0.382044     2.21530e-01     3.16523e-01
  505.000     1.33866e+02        0.00000         8.84642e-01          0.93576       161.479     102.781     0.377677     2.27260e-01     3.39266e-01
  502.500     1.36936e+02        0.00000         8.91915e-01          0.93720       156.894     102.781     0.373509     2.32862e-01     3.62894e-01
  500.000     1.39933e+02        0.00000         8.98710e-01          0.93870       152.560     102.781     0.369524     2.38347e-01     3.87450e-01
  497.500     1.42861e+02        0.00000         9.05073e-01          0.94024       148.454     102.781     0.365705     2.43724e-01     4.12978e-01
  495.000     1.45727e+02        0.00000         9.11044e-01          0.94183       144.556     102.781     0.362040     2.49001e-01     4.39524e-01
  492.500     1.48534e+02        0.00000         9.16657e-01          0.94346       140.850     102.781     0.358518     2.54186e-01     4.67134e-01
  490.000     1.51285e+02        0.00000         9.21941e-01          0.94513       137.320     102.781     0.355127     2.59283e-01     4.95856e-01
  487.500     1.53984e+02        0.00000         9.26923e-01          0.94684       133.954     102.781     0.351859     2.64298e-01     5.25737e-01
  485.000     1.56634e+02        0.00000         9.31627e-01          0.94858       130.739     102.781     0.348707     2.69237e-01     5.56830e-01
  482.500     1.59237e+02        0.00000         9.36073e-01          0.95036       127.665     102.781     0.345662     2.74103e-01     5.89187e-01
  480.000     1.61795e+02        0.00000         9.40280e-01          0.95217       124.723     102.781     0.342719     2.78899e-01     6.22863e-01
  477.500     1.64311e+02        0.00000         9.44265e-01          0.95402       121.903     102.781     0.339872     2.83630e-01     6.57914e-01
  475.000     1.66786e+02        0.00000         9.48043e-01          0.95589       119.198     102.781     0.337115     2.88298e-01     6.94400e-01
  472.500     1.69221e+02        0.00000         9.51628e-01          0.95779       116.602     102.781     0.334445     2.92906e-01     7.32383e-01
  470.000     1.71619e+02        0.00000         9.55032e-01          0.95972       114.107     102.781     0.331856     2.97456e-01     7.71928e-01
  467.500     1.73981e+02        0.00000         9.58266e-01          0.96168       111.707     102.781     0.329344     3.01951e-01     8.13101e-01
  465.000     1.76307e+02        0.00000         9.61341e-01          0.96366       109.398     102.781     0.326906     3.06393e-01     8.55974e-01
  462.500     1.78598e+02        0.00000         9.64267e-01          0.96567       107.174     102.781     0.324538     3.10784e-01     9.00619e-01
  460.000     1.80857e+02        0.00000         9.67052e-01          0.96770       105.031     102.781     0.322237     3.15125e-01     9.47115e-01
  457.778     1.82837e+02        0.00000         9.69415e-01          0.96952       103.190     102.781     0.320247     3.18943e-01     9.90050e-01
  457.275     1.83282e+02        0.50000         9.69936e-01          0.96994       102.781     102.781     0.319803     3.19803e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   26.065     1.92499e+02        0.00000         1.19264e+00          1.07822       117.645     102.781     0.763260     7.37596e-01     6.65930e-01
   25.844     2.05386e+02        0.00000         1.27234e+00          1.14870       117.806     102.781     0.764959     7.39230e-01     6.61888e-01
   25.656     2.19137e+02        0.00000         1.35691e+00          1.22364       117.935     102.781     0.766630     7.40889e-01     6.58242e-01
   25.500     2.33808e+02        0.00000         1.44662e+00          1.30328       118.035     102.781     0.768278     7.42574e-01     6.55097e-01
   25.377     2.49461e+02        0.00000         1.54177e+00          1.38790       118.106     102.781     0.769908     7.44286e-01     6.52423e-01
   25.289     2.66162e+02        0.00000         1.64265e+00          1.47781       118.151     102.781     0.771523     7.46025e-01     6.50195e-01
   25.235     2.83982e+02        0.00000         1.74961e+00          1.57330       118.171     102.781     0.773128     7.47792e-01     6.48389e-01
   25.216     3.02994e+02        0.00000         1.86296e+00          1.67472       118.168     102.781     0.774725     7.49586e-01     6.46892e-01
   25.881     4.46004e+02        0.00000         2.69339e+00          2.42328       117.752     102.781     0.784252     7.60848e-01     6.44887e-01
   27.952     6.56513e+02        0.00000         3.85955e+00          3.48695       116.868     102.781     0.794065     7.72971e-01     6.53256e-01
   31.444     9.66379e+02        0.00000         5.49231e+00          4.99184       115.766     102.781     0.804300     7.85677e-01     6.68759e-01
   36.222     1.42250e+03        0.00000         7.77917e+00          7.11809       114.612     102.781     0.814765     7.98522e-01     6.88641e-01
   41.978     2.09390e+03        0.00000         1.09933e+01         10.12868       113.491     102.781     0.825029     8.10953e-01     7.09937e-01
   48.267     3.08220e+03        0.00000         1.55385e+01         14.41389       112.439     102.781     0.834576     8.22413e-01     7.32127e-01
   54.580     4.53696e+03        0.00000         2.20174e+01         20.55725       111.472     102.781     0.842975     8.32461e-01     7.54164e-01
   60.451     6.67835e+03        0.00000         3.13311e+01         29.43082       110.606     102.781     0.849983     8.40851e-01     7.75016e-01
   65.554     9.83046e+03        0.00000         4.48235e+01         42.33187       109.859     102.781     0.855561     8.47550e-01     7.93547e-01
   69.737     1.44703e+04        0.00000         6.44876e+01         61.18043       109.244     102.781     0.859830     8.52695e-01     8.09113e-01
   73.004     2.13001e+04        0.00000         9.32668e+01         88.80818       108.757     102.781     0.862995     8.56524e-01     8.21730e-01
   75.461     3.13536e+04        0.00000         1.35497e+02        129.38393       108.387     102.781     0.865284     8.59302e-01     8.31512e-01
   77.254     4.61521e+04        0.00000         1.97557e+02        189.04154       108.113     102.781     0.866911     8.61279e-01     8.38827e-01
   78.537     6.79353e+04        0.00000         2.88835e+02        276.80611       107.917     102.781     0.868051     8.62668e-01     8.44150e-01
   79.439     1.00000e+05        0.00000         4.23140e+02        405.95820       107.777     102.781     0.868842     8.63633e-01     8.47946e-01
END

$Env_BP << END
#   Temp       Sat Pres                                                                                     Liq Den      Gas Den           
#   (C)         (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
  457.275      183.282          0.5000            0.96994           0.96994        102.781     102.781     0.319803     0.319803     1.00000e+00
  456.771      183.727          1.0000            0.97035           0.97045        102.781     102.374     0.320662     0.319359     9.90051e-01
  455.000      185.279          1.0000            0.97182           0.97223        102.781     100.969     0.323665     0.317826     9.56038e-01
  452.500      187.443          1.0000            0.97392           0.97464        102.781      99.043     0.327868     0.315710     9.10308e-01
  450.000      189.578          1.0000            0.97604           0.97693        102.781      97.182     0.332026     0.313651     8.67098e-01
  447.500      191.683          1.0000            0.97817           0.97912        102.781      95.383     0.336143     0.311646     8.26235e-01
  445.000      193.760          1.0000            0.98033           0.98121        102.781      93.644     0.340218     0.309693     7.87562e-01
  442.500      195.808          1.0000            0.98250           0.98320        102.781      91.961     0.344253     0.307791     7.50932e-01
  440.000      197.829          1.0000            0.98469           0.98510        102.781      90.331     0.348250     0.305937     7.16215e-01
  437.500      199.823          1.0000            0.98689           0.98691        102.781      88.753     0.352208     0.304130     6.83287e-01
  435.000      201.791          1.0000            0.98912           0.98864        102.781      87.224     0.356129     0.302368     6.52036e-01
  432.500      203.732          1.0000            0.99136           0.99029        102.781      85.741     0.360014     0.300650     6.22360e-01
  430.000      205.647          1.0000            0.99361           0.99187        102.781      84.304     0.363863     0.298973     5.94162e-01
  427.500      207.537          1.0000            0.99588           0.99337        102.781      82.909     0.367678     0.297337     5.67355e-01
  425.000      209.402          1.0000            0.99816           0.99480        102.781      81.555     0.371458     0.295741     5.41856e-01
  422.500      211.242          1.0000            1.00046           0.99617        102.781      80.241     0.375206     0.294182     5.17590e-01
  420.000      213.057          1.0000            1.00277           0.99747        102.781      78.964     0.378921     0.292661     4.94487e-01
  417.500      214.849          1.0000            1.00509           0.99871        102.781      77.724     0.382604     0.291175     4.72480e-01
  415.000      216.616          1.0000            1.00742           0.99990        102.781      76.519     0.386255     0.289724     4.51510e-01
  412.500      218.359          1.0000            1.00977           1.00102        102.781      75.347     0.389876     0.288306     4.31520e-01
  410.000      220.079          1.0000            1.01213           1.00210        102.781      74.207     0.393467     0.286921     4.12455e-01
  407.500      221.776          1.0000            1.01449           1.00312        102.781      73.098     0.397028     0.285568     3.94268e-01
  405.000      223.449          1.0000            1.01687           1.00409        102.781      72.019     0.400560     0.284245     3.76912e-01
  402.500      225.100          1.0000            1.01926           1.00501        102.781      70.968     0.404063     0.282952     3.60343e-01
  400.000      226.728          1.0000            1.02165           1.00588        102.781      69.945     0.407538     0.281688     3.44521e-01
  397.500      228.333          1.0000            1.02406           1.00671        102.781      68.949     0.410986     0.280452     3.29408e-01
  395.000      229.915          1.0000            1.02647           1.00749        102.781      67.978     0.414406     0.279244     3.14969e-01
  392.500      231.475          1.0000            1.02889           1.00823        102.781      67.031     0.417799     0.278062     3.01169e-01
  390.000      233.013          1.0000            1.03132           1.00893        102.781      66.109     0.421166     0.276907     2.87977e-01
  387.500      234.528          1.0000            1.03376           1.00959        102.781      65.210     0.424507     0.275776     2.75364e-01
  385.000      236.022          1.0000            1.03620           1.01021        102.781      64.333     0.427822     0.274670     2.63302e-01
  382.500      237.493          1.0000            1.03865           1.01080        102.781      63.477     0.431112     0.273588     2.51764e-01
  380.000      238.943          1.0000            1.04110           1.01134        102.781      62.642     0.434377     0.272530     2.40725e-01
  377.500      240.371          1.0000            1.04356           1.01185        102.781      61.827     0.437618     0.271494     2.30163e-01
  375.000      241.777          1.0000            1.04603           1.01232        102.781      61.031     0.440834     0.270480     2.20054e-01
  372.500      243.161          1.0000            1.04850           1.01277        102.781      60.254     0.444026     0.269488     2.10379e-01
  370.000      244.523          1.0000            1.05097           1.01317        102.781      59.495     0.447195     0.268517     2.01117e-01
  367.500      245.864          1.0000            1.05345           1.01355        102.781      58.754     0.450341     0.267566     1.92249e-01
  365.000      247.183          1.0000            1.05593           1.01389        102.781      58.029     0.453464     0.266635     1.83757e-01
  362.500      248.481          1.0000            1.05841           1.01420        102.781      57.321     0.456563     0.265724     1.75626e-01
  360.000      249.757          1.0000            1.06089           1.01448        102.781      56.629     0.459641     0.264832     1.67839e-01
  357.500      251.012          1.0000            1.06338           1.01473        102.781      55.952     0.462697     0.263959     1.60380e-01
  355.000      252.245          1.0000            1.06587           1.01495        102.781      55.290     0.465730     0.263103     1.53236e-01
  352.500      253.457          1.0000            1.06836           1.01514        102.781      54.642     0.468742     0.262265     1.46392e-01
  350.000      254.647          1.0000            1.07085           1.01531        102.781      54.009     0.471733     0.261445     1.39837e-01
  347.500      255.816          1.0000            1.07334           1.01544        102.781      53.389     0.474703     0.260641     1.33557e-01
  345.000      256.963          1.0000            1.07583           1.01555        102.781      52.782     0.477652     0.259854     1.27540e-01
  342.500      258.089          1.0000            1.07832           1.01563        102.781      52.188     0.480581     0.259083     1.21776e-01
  340.000      259.193          1.0000            1.08081           1.01568        102.781      51.607     0.483489     0.258328     1.16254e-01
  337.500      260.276          1.0000            1.08330           1.01571        102.781      51.037     0.486377     0.257588     1.10964e-01
  335.000      261.337          1.0000            1.08578           1.01571        102.781      50.479     0.489245     0.256863     1.05896e-01
  332.500      262.377          1.0000            1.08827           1.01569        102.781      49.933     0.492094     0.256152     1.01041e-01
  330.000      263.395          1.0000            1.09075           1.01563        102.781      49.398     0.494923     0.255456     9.63901e-02
  327.500      264.392          1.0000            1.09323           1.01556        102.781      48.873     0.497733     0.254774     9.19347e-02
  325.000      265.367          1.0000            1.09570           1.01546        102.781      48.358     0.500524     0.254105     8.76671e-02
  322.500      266.320          1.0000            1.09817           1.01533        102.781      47.854     0.503297     0.253450     8.35795e-02
  320.000      267.252          1.0000            1.10063           1.01518        102.781      47.360     0.506050     0.252808     7.96647e-02
  317.500      268.162          1.0000            1.10309           1.01500        102.781      46.875     0.508786     0.252178     7.59155e-02
  315.000      269.050          1.0000            1.10554           1.01480        102.781      46.399     0.511503     0.251561     7.23254e-02
  312.500      269.916          1.0000            1.10799           1.01457        102.781      45.933     0.514202     0.250956     6.88879e-02
  310.000      270.760          1.0000            1.11043           1.01432        102.781      45.475     0.516884     0.250363     6.55969e-02
  307.500      271.583          1.0000            1.11286           1.01404        102.781      45.026     0.519547     0.249781     6.24465e-02
  305.000      272.383          1.0000            1.11529           1.01374        102.781      44.585     0.522194     0.249211     5.94312e-02
  302.500      273.161          1.0000            1.11771           1.01342        102.781      44.152     0.524823     0.248651     5.65454e-02
  300.000      273.918          1.0000            1.12011           1.01307        102.781      43.727     0.527435     0.248103     5.37841e-02
  297.500      274.652          1.0000            1.12251           1.01270        102.781      43.310     0.530030     0.247565     5.11422e-02
  295.000      275.363          1.0000            1.12490           1.01230        102.781      42.901     0.532608     0.247037     4.86151e-02
  292.500      276.053          1.0000            1.12728           1.01188        102.781      42.498     0.535170     0.246519     4.61982e-02
  290.000      276.720          1.0000            1.12965           1.01143        102.781      42.103     0.537715     0.246012     4.38871e-02
  287.500      277.364          1.0000            1.13200           1.01096        102.781      41.714     0.540245     0.245513     4.16776e-02
  285.000      277.986          1.0000            1.13435           1.01047        102.781      41.333     0.542758     0.245025     3.95657e-02
  282.500      278.586          1.0000            1.13668           1.00995        102.781      40.958     0.545255     0.244545     3.75475e-02
  280.000      279.162          1.0000            1.13900           1.00941        102.781      40.589     0.547736     0.244074     3.56193e-02
  277.500      279.716          1.0000            1.14130           1.00884        102.781      40.226     0.550202     0.243612     3.37775e-02
  275.000      280.247          1.0000            1.14359           1.00824        102.781      39.870     0.552652     0.243159     3.20187e-02
  272.500      280.755          1.0000            1.14586           1.00762        102.781      39.520     0.555087     0.242714     3.03395e-02
  270.000      281.240          1.0000            1.14812           1.00698        102.781      39.175     0.557506     0.242277     2.87368e-02
  267.500      281.702          1.0000            1.15036           1.00631        102.781      38.836     0.559911     0.241848     2.72076e-02
  265.000      282.141          1.0000            1.15259           1.00561        102.781      38.502     0.562301     0.241427     2.57489e-02
  262.500      282.556          1.0000            1.15479           1.00489        102.781      38.174     0.564675     0.241013     2.43578e-02
  260.000      282.948          1.0000            1.15698           1.00414        102.781      37.851     0.567036     0.240607     2.30316e-02
  257.500      283.316          1.0000            1.15915           1.00337        102.781      37.534     0.569382     0.240208     2.17678e-02
  255.000      283.661          1.0000            1.16130           1.00257        102.781      37.221     0.571713     0.239816     2.05637e-02
  252.500      283.981          1.0000            1.16342           1.00174        102.781      36.913     0.574030     0.239431     1.94171e-02
  250.000      284.278          1.0000            1.16553           1.00089        102.781      36.610     0.576333     0.239053     1.83254e-02
  247.500      284.551          1.0000            1.16761           1.00001        102.781      36.311     0.578622     0.238681     1.72865e-02
  245.000      284.800          1.0000            1.16967           0.99910        102.781      36.017     0.580898     0.238316     1.62982e-02
  242.500      285.025          1.0000            1.17171           0.99816        102.781      35.728     0.583159     0.237957     1.53584e-02
  240.000      285.225          1.0000            1.17372           0.99720        102.781      35.443     0.585407     0.237604     1.44650e-02
  237.500      285.401          1.0000            1.17571           0.99620        102.781      35.162     0.587641     0.237257     1.36162e-02
  235.000      285.552          1.0000            1.17767           0.99518        102.781      34.885     0.589862     0.236916     1.28101e-02
  232.500      285.679          1.0000            1.17960           0.99413        102.781      34.612     0.592070     0.236581     1.20448e-02
  230.000      285.780          1.0000            1.18150           0.99305        102.781      34.343     0.594265     0.236251     1.13187e-02
  227.500      285.857          1.0000            1.18338           0.99194        102.781      34.079     0.596447     0.235927     1.06300e-02
  225.000      285.909          1.0000            1.18522           0.99080        102.781      33.817     0.598615     0.235608     9.97718e-03
  222.500      285.935          1.0000            1.18703           0.98962        102.781      33.560     0.600771     0.235294     9.35861e-03
  220.000      285.936          1.0000            1.18881           0.98842        102.781      33.306     0.602915     0.234985     8.77282e-03
  217.500      285.912          1.0000            1.19056           0.98718        102.781      33.056     0.605045     0.234681     8.21837e-03
  215.000      285.862          1.0000            1.19228           0.98592        102.781      32.809     0.607163     0.234382     7.69386e-03
  212.500      285.786          1.0000            1.19396           0.98462        102.781      32.566     0.609269     0.234088     7.19796e-03
  210.000      285.684          1.0000            1.19560           0.98328        102.781      32.326     0.611363     0.233798     6.72937e-03
  207.500      285.556          1.0000            1.19720           0.98192        102.781      32.089     0.613444     0.233513     6.28685e-03
  205.000      285.402          1.0000            1.19877           0.98052        102.781      31.855     0.615514     0.233232     5.86920e-03
  202.500      285.222          1.0000            1.20029           0.97908        102.781      31.625     0.617571     0.232955     5.47527e-03
  200.000      285.015          1.0000            1.20178           0.97761        102.781      31.398     0.619617     0.232683     5.10394e-03
  197.500      284.781          1.0000            1.20322           0.97611        102.781      31.173     0.621650     0.232414     4.75415e-03
  195.000      284.520          1.0000            1.20462           0.97457        102.781      30.952     0.623673     0.232150     4.42486e-03
  192.500      284.233          1.0000            1.20598           0.97299        102.781      30.733     0.625683     0.231890     4.11509e-03
  190.000      283.918          1.0000            1.20729           0.97137        102.781      30.517     0.627682     0.231633     3.82388e-03
  187.500      283.576          1.0000            1.20855           0.96972        102.781      30.305     0.629670     0.231380     3.55032e-03
  185.000      283.206          1.0000            1.20976           0.96802        102.781      30.094     0.631647     0.231131     3.29353e-03
  182.500      282.808          1.0000            1.21092           0.96629        102.781      29.887     0.633612     0.230886     3.05266e-03
  180.000      282.383          1.0000            1.21203           0.96452        102.781      29.682     0.635566     0.230644     2.82690e-03
  177.500      281.929          1.0000            1.21309           0.96270        102.781      29.479     0.637509     0.230405     2.61547e-03
  175.000      281.447          1.0000            1.21409           0.96085        102.781      29.279     0.639442     0.230170     2.41762e-03
  172.500      280.937          1.0000            1.21504           0.95895        102.781      29.082     0.641363     0.229938     2.23264e-03
  170.000      280.398          1.0000            1.21593           0.95701        102.781      28.887     0.643274     0.229710     2.05982e-03
  167.500      279.830          1.0000            1.21676           0.95502        102.781      28.695     0.645174     0.229485     1.89851e-03
  165.000      279.234          1.0000            1.21752           0.95299        102.781      28.504     0.647063     0.229263     1.74809e-03
  162.500      278.608          1.0000            1.21823           0.95091        102.781      28.316     0.648942     0.229044     1.60794e-03
  160.000      277.952          1.0000            1.21887           0.94879        102.781      28.131     0.650811     0.228828     1.47748e-03
  157.500      277.267          1.0000            1.21944           0.94662        102.781      27.947     0.652669     0.228614     1.35616e-03
  155.000      276.552          1.0000            1.21994           0.94440        102.781      27.766     0.654517     0.228404     1.24344e-03
  152.500      275.807          1.0000            1.22037           0.94213        102.781      27.587     0.656355     0.228197     1.13883e-03
  150.000      275.031          1.0000            1.22073           0.93981        102.781      27.410     0.658183     0.227993     1.04184e-03
  147.500      274.225          1.0000            1.22102           0.93744        102.781      27.235     0.660000     0.227791     9.52009e-04
  145.000      273.388          1.0000            1.22122           0.93502        102.781      27.062     0.661808     0.227593     8.68894e-04
  142.500      272.521          1.0000            1.22135           0.93254        102.781      26.892     0.663606     0.227397     7.92079e-04
  140.000      271.622          1.0000            1.22140           0.93001        102.781      26.723     0.665394     0.227203     7.21166e-04
  137.500      270.691          1.0000            1.22136           0.92742        102.781      26.556     0.667172     0.227013     6.55776e-04
  135.000      269.729          1.0000            1.22124           0.92478        102.781      26.391     0.668941     0.226824     5.95549e-04
  132.500      268.735          1.0000            1.22102           0.92208        102.781      26.228     0.670700     0.226639     5.40145e-04
  130.000      267.708          1.0000            1.22072           0.91931        102.781      26.067     0.672450     0.226456     4.89238e-04
  127.500      266.650          1.0000            1.22032           0.91649        102.781      25.907     0.674190     0.226275     4.42524e-04
  125.000      265.558          1.0000            1.21982           0.91361        102.781      25.750     0.675921     0.226097     3.99710e-04
  122.500      264.433          1.0000            1.21923           0.91066        102.781      25.594     0.677643     0.225922     3.60523e-04
  120.000      263.275          1.0000            1.21853           0.90764        102.781      25.440     0.679355     0.225748     3.24704e-04
  117.500      262.084          1.0000            1.21772           0.90456        102.781      25.288     0.681058     0.225578     2.92007e-04
  115.000      260.859          1.0000            1.21681           0.90142        102.781      25.138     0.682752     0.225409     2.62203e-04
  112.500      259.599          1.0000            1.21578           0.89820        102.781      24.989     0.684437     0.225243     2.35074e-04
  110.000      258.306          1.0000            1.21464           0.89491        102.781      24.842     0.686114     0.225079     2.10416e-04
  107.500      256.977          1.0000            1.21338           0.89155        102.781      24.696     0.687781     0.224917     1.88038e-04
  105.000      255.614          1.0000            1.21200           0.88811        102.781      24.552     0.689439     0.224757     1.67760e-04
  102.500      254.215          1.0000            1.21050           0.88460        102.781      24.410     0.691089     0.224599     1.49414e-04
  100.000      252.780          1.0000            1.20886           0.88101        102.781      24.270     0.692730     0.224444     1.32842e-04
   97.500      251.310          1.0000            1.20709           0.87734        102.781      24.130     0.694362     0.224290     1.17898e-04
   95.000      249.803          1.0000            1.20518           0.87359        102.781      23.993     0.695986     0.224138     1.04443e-04
   92.500      248.260          1.0000            1.20313           0.86975        102.781      23.857     0.697601     0.223988     9.23516e-05
   90.000      246.680          1.0000            1.20094           0.86583        102.781      23.722     0.699208     0.223840     8.15035e-05
   87.500      245.062          1.0000            1.19859           0.86182        102.781      23.589     0.700806     0.223694     7.17886e-05
   85.000      243.407          1.0000            1.19609           0.85772        102.781      23.458     0.702396     0.223549     6.31047e-05
   82.500      241.714          1.0000            1.19344           0.85353        102.781      23.328     0.703978     0.223406     5.53571e-05
   80.000      239.982          1.0000            1.19061           0.84925        102.781      23.199     0.705551     0.223264     4.84582e-05
   77.500      238.212          1.0000            1.18762           0.84487        102.781      23.072     0.707116     0.223124     4.23273e-05
   75.000      236.402          1.0000            1.18446           0.84038        102.781      22.946     0.708674     0.222985     3.68901e-05
   72.500      234.554          1.0000            1.18111           0.83580        102.781      22.821     0.710223     0.222847     3.20780e-05
   70.000      232.665          1.0000            1.17758           0.83111        102.781      22.698     0.711764     0.222710     2.78285e-05
   67.500      230.736          1.0000            1.17386           0.82632        102.781      22.576     0.713297     0.222574     2.40839e-05
   65.000      228.766          1.0000            1.16994           0.82142        102.781      22.456     0.714822     0.222438     2.07918e-05
   62.500      226.755          1.0000            1.16582           0.81640        102.781      22.336     0.716340     0.222303     1.79042e-05
   60.000      224.703          1.0000            1.16149           0.81127        102.781      22.218     0.717849     0.222169     1.53775e-05
   57.500      222.608          1.0000            1.15694           0.80602        102.781      22.102     0.719351     0.222034     1.31720e-05
   55.000      220.471          1.0000            1.15217           0.80065        102.781      21.986     0.720845     0.221900     1.12516e-05
   52.500      218.292          1.0000            1.14717           0.79515        102.781      21.872     0.722332     0.221765     9.58392e-06
   50.000      216.069          1.0000            1.14194           0.78953        102.781      21.759     0.723811     0.221630     8.13952e-06
   47.500      213.802          1.0000            1.13646           0.78377        102.781      21.647     0.725282     0.221494     6.89194e-06
   45.000      211.491          1.0000            1.13072           0.77788        102.781      21.537     0.726746     0.221356     5.81742e-06
   42.500      209.135          1.0000            1.12473           0.77185        102.781      21.427     0.728203     0.221217     4.89464e-06
   40.000      206.734          1.0000            1.11847           0.76568        102.781      21.319     0.729652     0.221076     4.10457e-06
   37.500      204.288          1.0000            1.11193           0.75936        102.781      21.212     0.731094     0.220933     3.43022e-06
   35.000      201.795          1.0000            1.10510           0.75289        102.781      21.105     0.732528     0.220787     2.85648e-06
   32.500      199.255          1.0000            1.09798           0.74627        102.781      21.000     0.733955     0.220638     2.36996e-06
   30.000      196.668          1.0000            1.09055           0.73949        102.781      20.896     0.735376     0.220485     1.95880e-06
   27.500      194.033          1.0000            1.08281           0.73255        102.781      20.793     0.736788     0.220327     1.61258e-06
   26.065      192.499          1.0000            1.07821           0.72849        102.781      20.735     0.737596     0.220234     1.43953e-06
END

set output "Figures/Env_003_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:5.0e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_003_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "P-X Diagram for Lab2_Slimtube_Oil\n with Lab2_Slimtube_Gas at 95.6 C "
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   1.00000e-12        1.00000e+00        2.25378e-13        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   2.00000e-12        1.00000e+00        4.50756e-13        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   5.00000e-12        1.00000e+00        1.12689e-12        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   1.00000e-11        1.00000e+00        2.25378e-12        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   2.00000e-11        1.00000e+00        4.50756e-12        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   5.00000e-11        1.00000e+00        1.12689e-11        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   1.00000e-10        1.00000e+00        2.25378e-11        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   2.00000e-10        1.00000e+00        4.50756e-11        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   5.00000e-10        1.00000e+00        1.12689e-10        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   1.00000e-09        1.00000e+00        2.25378e-10        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   2.00000e-09        1.00000e+00        4.50756e-10        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   5.00000e-09        1.00000e+00        1.12689e-09        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   1.00000e-08        1.00000e+00        2.25378e-09        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   2.00000e-08        1.00000e+00        4.50756e-09        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   5.00000e-08        1.00000e+00        1.12689e-08        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   1.00000e-07        1.00000e+00        2.25378e-08        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   2.00000e-07        1.00000e+00        4.50756e-08        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   5.00000e-07        1.00000e+00        1.12689e-07        1.00000e+00       2.90805e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74994e-12     5.38238e-13
   1.00000e-06        9.99999e-01        2.25378e-07        1.00000e+00       2.90806e-09        0.00000         6.21994e-11          1.00000       602.889     102.781     0.919475     9.74995e-12     5.38238e-13
   2.00000e-06        9.99998e-01        4.50756e-07        1.00000e+00       2.90806e-09        0.00000         6.21995e-11          1.00000       602.889     102.781     0.919475     9.74995e-12     5.38238e-13
   5.00000e-06        9.99995e-01        1.12689e-06        9.99999e-01       2.90807e-09        0.00000         6.21997e-11          1.00000       602.889     102.781     0.919475     9.74995e-12     5.38238e-13
   1.00000e-05        9.99990e-01        2.25380e-06        9.99998e-01       2.90808e-09        0.00000         6.22000e-11          1.00000       602.889     102.780     0.919475     9.74997e-12     5.38238e-13
   2.00000e-05        9.99980e-01        4.50763e-06        9.99995e-01       2.90811e-09        0.00000         6.22006e-11          1.00000       602.889     102.780     0.919475     9.74999e-12     5.38238e-13
   5.00000e-05        9.99950e-01        1.12693e-05        9.99989e-01       2.90820e-09        0.00000         6.22025e-11          1.00000       602.889     102.777     0.919475     9.75005e-12     5.38238e-13
   1.00000e-04        9.99900e-01        2.25395e-05        9.99977e-01       2.90834e-09        0.00000         6.22056e-11          1.00000       602.889     102.773     0.919475     9.75016e-12     5.38238e-13
   2.00000e-04        9.99800e-01        4.50826e-05        9.99955e-01       2.90863e-09        0.00000         6.22118e-11          1.00000       602.889     102.765     0.919475     9.75038e-12     5.38238e-13
   5.00000e-04        9.99500e-01        1.12733e-04        9.99887e-01       2.90951e-09        0.00000         6.22305e-11          1.00000       602.889     102.741     0.919475     9.75104e-12     5.38238e-13
   1.00000e-03        9.99000e-01        2.25553e-04        9.99774e-01       2.91096e-09        0.00000         6.22616e-11          1.00000       602.889     102.702     0.919475     9.75214e-12     5.38238e-13
   2.00000e-03        9.98000e-01        4.51455e-04        9.99549e-01       2.91388e-09        0.00000         6.23240e-11          1.00000       602.889     102.622     0.919475     9.75435e-12     5.38238e-13
   5.00000e-03        9.95000e-01        1.13127e-03        9.98869e-01       2.92267e-09        0.00000         6.25119e-11          1.00000       602.889     102.383     0.919475     9.76099e-12     5.38238e-13
   1.00000e-02        9.90000e-01        2.27137e-03        9.97729e-01       2.93743e-09        0.00000         6.28276e-11          1.00000       602.889     101.985     0.919475     9.77214e-12     5.38238e-13
   2.00000e-02        9.80000e-01        4.57849e-03        9.95422e-01       2.96740e-09        0.00000         6.34687e-11          1.00000       602.889     101.189     0.919475     9.79479e-12     5.38238e-13
   3.00000e-02        9.70000e-01        6.92220e-03        9.93078e-01       2.99799e-09        0.00000         6.41231e-11          1.00000       602.889     100.393     0.919475     9.81791e-12     5.38238e-13
   4.00000e-02        9.60000e-01        9.30338e-03        9.90697e-01       3.02922e-09        0.00000         6.47910e-11          1.00000       602.889      99.597     0.919475     9.84150e-12     5.38238e-13
   5.00000e-02        9.50000e-01        1.17229e-02        9.88277e-01       3.06111e-09        0.00000         6.54730e-11          1.00000       602.889      98.800     0.919475     9.86560e-12     5.38238e-13
   6.00000e-02        9.40000e-01        1.41818e-02        9.85818e-01       3.09367e-09        0.00000         6.61695e-11          1.00000       602.889      98.004     0.919475     9.89020e-12     5.38238e-13
   7.00000e-02        9.30000e-01        1.66809e-02        9.83319e-01       3.12694e-09        0.00000         6.68810e-11          1.00000       602.889      97.208     0.919475     9.91534e-12     5.38238e-13
   8.00000e-02        9.20000e-01        1.92214e-02        9.80779e-01       3.16093e-09        0.00000         6.76080e-11          1.00000       602.889      96.412     0.919475     9.94102e-12     5.38238e-13
   9.00000e-02        9.10000e-01        2.18041e-02        9.78196e-01       3.19566e-09        0.00000         6.83510e-11          1.00000       602.889      95.616     0.919475     9.96727e-12     5.38238e-13
   1.00000e-01        9.00000e-01        2.44302e-02        9.75570e-01       3.23117e-09        0.00000         6.91104e-11          1.00000       602.889      94.820     0.919475     9.99410e-12     5.38238e-13
   1.10000e-01        8.90000e-01        2.71008e-02        9.72899e-01       3.26747e-09        0.00000         6.98869e-11          1.00000       602.889      94.023     0.919475     1.00215e-11     5.38238e-13
   1.20000e-01        8.80000e-01        2.98170e-02        9.70183e-01       3.30461e-09        0.00000         7.06811e-11          1.00000       602.889      93.227     0.919475     1.00496e-11     5.38238e-13
   1.30000e-01        8.70000e-01        3.25799e-02        9.67420e-01       3.34259e-09        0.00000         7.14935e-11          1.00000       602.889      92.431     0.919475     1.00783e-11     5.38238e-13
   1.40000e-01        8.60000e-01        3.53909e-02        9.64609e-01       3.38146e-09        0.00000         7.23249e-11          1.00000       602.889      91.635     0.919475     1.01077e-11     5.38238e-13
   1.50000e-01        8.50000e-01        3.82512e-02        9.61749e-01       3.42124e-09        0.00000         7.31757e-11          1.00000       602.889      90.839     0.919475     1.01377e-11     5.38238e-13
   1.60000e-01        8.40000e-01        4.11621e-02        9.58838e-01       3.46197e-09        0.00000         7.40469e-11          1.00000       602.889      90.043     0.919475     1.01685e-11     5.38238e-13
   1.70000e-01        8.30000e-01        4.41248e-02        9.55875e-01       3.50368e-09        0.00000         7.49390e-11          1.00000       602.889      89.246     0.919475     1.02000e-11     5.38238e-13
   1.80000e-01        8.20000e-01        4.71410e-02        9.52859e-01       3.54641e-09        0.00000         7.58529e-11          1.00000       602.889      88.450     0.919475     1.02323e-11     5.38238e-13
   1.90000e-01        8.10000e-01        5.02119e-02        9.49788e-01       3.59019e-09        0.00000         7.67893e-11          1.00000       602.889      87.654     0.919475     1.02654e-11     5.38238e-13
   2.00000e-01        8.00000e-01        5.33391e-02        9.46661e-01       3.63507e-09        0.00000         7.77492e-11          1.00000       602.889      86.858     0.919475     1.02993e-11     5.38238e-13
   2.10000e-01        7.90000e-01        5.65242e-02        9.43476e-01       3.68108e-09        0.00000         7.87334e-11          1.00000       602.889      86.062     0.919475     1.03341e-11     5.38238e-13
   2.20000e-01        7.80000e-01        5.97687e-02        9.40231e-01       3.72827e-09        0.00000         7.97428e-11          1.00000       602.889      85.266     0.919475     1.03697e-11     5.38238e-13
   2.30000e-01        7.70000e-01        6.30744e-02        9.36926e-01       3.77669e-09        0.00000         8.07784e-11          1.00000       602.889      84.469     0.919475     1.04063e-11     5.38238e-13
   2.40000e-01        7.60000e-01        6.64431e-02        9.33557e-01       3.82639e-09        0.00000         8.18413e-11          1.00000       602.889      83.673     0.919475     1.04439e-11     5.38238e-13
   2.50000e-01        7.50000e-01        6.98764e-02        9.30124e-01       3.87740e-09        0.00000         8.29325e-11          1.00000       602.889      82.877     0.919475     1.04824e-11     5.38238e-13
   2.60000e-01        7.40000e-01        7.33764e-02        9.26624e-01       3.92980e-09        0.00000         8.40532e-11          1.00000       602.889      82.081     0.919475     1.05220e-11     5.38238e-13
   2.70000e-01        7.30000e-01        7.69449e-02        9.23055e-01       3.98363e-09        0.00000         8.52046e-11          1.00000       602.889      81.285     0.919475     1.05627e-11     5.38238e-13
   2.80000e-01        7.20000e-01        8.05840e-02        9.19416e-01       4.03896e-09        0.00000         8.63880e-11          1.00000       602.889      80.489     0.919475     1.06045e-11     5.38238e-13
   2.90000e-01        7.10000e-01        8.42958e-02        9.15704e-01       4.09585e-09        0.00000         8.76048e-11          1.00000       602.889      79.692     0.919475     1.06475e-11     5.38238e-13
   3.00000e-01        7.00000e-01        8.80826e-02        9.11917e-01       4.15436e-09        0.00000         8.88562e-11          1.00000       602.889      78.896     0.919475     1.06917e-11     5.38238e-13
   3.10000e-01        6.90000e-01        9.19465e-02        9.08053e-01       4.21457e-09        0.00000         9.01440e-11          1.00000       602.889      78.100     0.919475     1.07372e-11     5.38238e-13
   3.20000e-01        6.80000e-01        9.58900e-02        9.04110e-01       4.27655e-09        0.00000         9.14697e-11          1.00000       602.889      77.304     0.919475     1.07840e-11     5.38238e-13
   3.30000e-01        6.70000e-01        9.99157e-02        9.00084e-01       4.34038e-09        0.00000         9.28349e-11          1.00000       602.889      76.508     0.919475     1.08323e-11     5.38238e-13
   3.40000e-01        6.60000e-01        1.04026e-01        8.95974e-01       4.40614e-09        0.00000         9.42415e-11          1.00000       602.889      75.712     0.919475     1.08819e-11     5.38238e-13
   3.50000e-01        6.50000e-01        1.08224e-01        8.91776e-01       4.47393e-09        0.00000         9.56913e-11          1.00000       602.889      74.915     0.919475     1.09332e-11     5.38238e-13
   3.60000e-01        6.40000e-01        1.12511e-01        8.87489e-01       4.54383e-09        0.00000         9.71865e-11          1.00000       602.889      74.119     0.919475     1.09860e-11     5.38238e-13
   3.70000e-01        6.30000e-01        1.16892e-01        8.83108e-01       4.61596e-09        0.00000         9.87292e-11          1.00000       602.889      73.323     0.919475     1.10405e-11     5.38238e-13
   3.80000e-01        6.20000e-01        1.21369e-01        8.78631e-01       4.69041e-09        0.00000         1.00322e-10          1.00000       602.889      72.527     0.919475     1.10968e-11     5.38238e-13
   3.90000e-01        6.10000e-01        1.25946e-01        8.74054e-01       4.76730e-09        0.00000         1.01966e-10          1.00000       602.889      71.731     0.919475     1.11549e-11     5.38238e-13
   4.00000e-01        6.00000e-01        1.30625e-01        8.69375e-01       4.84675e-09        0.00000         1.03666e-10          1.00000       602.889      70.935     0.919475     1.12149e-11     5.38238e-13
   4.10000e-01        5.90000e-01        1.35411e-01        8.64589e-01       4.92890e-09        0.00000         1.05423e-10          1.00000       602.889      70.138     0.919475     1.12770e-11     5.38238e-13
   4.20000e-01        5.80000e-01        1.40306e-01        8.59694e-01       5.01388e-09        0.00000         1.07240e-10          1.00000       602.889      69.342     0.919475     1.13412e-11     5.38238e-13
   4.30000e-01        5.70000e-01        1.45315e-01        8.54685e-01       5.10185e-09        0.00000         1.09122e-10          1.00000       602.889      68.546     0.919475     1.14076e-11     5.38238e-13
   4.40000e-01        5.60000e-01        1.50442e-01        8.49558e-01       5.19295e-09        0.00000         1.11070e-10          1.00000       602.889      67.750     0.919475     1.14765e-11     5.38238e-13
   4.50000e-01        5.50000e-01        1.55691e-01        8.44309e-01       5.28737e-09        0.00000         1.13090e-10          1.00000       602.889      66.954     0.919475     1.15478e-11     5.38238e-13
   4.60000e-01        5.40000e-01        1.61066e-01        8.38934e-01       5.38528e-09        0.00000         1.15184e-10          1.00000       602.889      66.158     0.919475     1.16218e-11     5.38238e-13
   4.70000e-01        5.30000e-01        1.66572e-01        8.33428e-01       5.48689e-09        0.00000         1.17357e-10          1.00000       602.889      65.361     0.919475     1.16986e-11     5.38238e-13
   4.80000e-01        5.20000e-01        1.72214e-01        8.27786e-01       5.59241e-09        0.00000         1.19614e-10          1.00000       602.889      64.565     0.919475     1.17783e-11     5.38238e-13
   4.90000e-01        5.10000e-01        1.77996e-01        8.22004e-01       5.70206e-09        0.00000         1.21960e-10          1.00000       602.889      63.769     0.919475     1.18612e-11     5.38238e-13
   5.00000e-01        5.00000e-01        1.83925e-01        8.16075e-01       5.81611e-09        0.00000         1.24399e-10          1.00000       602.889      62.973     0.919475     1.19474e-11     5.38238e-13
   5.10000e-01        4.90000e-01        1.90006e-01        8.09994e-01       5.93480e-09        0.00000         1.26937e-10          1.00000       602.889      62.177     0.919475     1.20371e-11     5.38238e-13
   5.20000e-01        4.80000e-01        1.96244e-01        8.03756e-01       6.05844e-09        0.00000         1.29582e-10          1.00000       602.889      61.381     0.919475     1.21305e-11     5.38238e-13
   5.30000e-01        4.70000e-01        2.02647e-01        7.97353e-01       6.18735e-09        0.00000         1.32339e-10          1.00000       602.889      60.584     0.919475     1.22279e-11     5.38238e-13
   5.40000e-01        4.60000e-01        2.09220e-01        7.90780e-01       6.32185e-09        0.00000         1.35216e-10          1.00000       602.889      59.788     0.919475     1.23295e-11     5.38238e-13
   5.50000e-01        4.50000e-01        2.15970e-01        7.84030e-01       6.46234e-09        0.00000         1.38221e-10          1.00000       602.889      58.992     0.919475     1.24357e-11     5.38238e-13
   5.60000e-01        4.40000e-01        2.22905e-01        7.77095e-01       6.60921e-09        0.00000         1.41362e-10          1.00000       602.889      58.196     0.919475     1.25467e-11     5.38238e-13
   5.70000e-01        4.30000e-01        2.30033e-01        7.69967e-01       6.76291e-09        0.00000         1.44650e-10          1.00000       602.889      57.400     0.919475     1.26628e-11     5.38238e-13
   5.80000e-01        4.20000e-01        2.37361e-01        7.62639e-01       6.92393e-09        0.00000         1.48094e-10          1.00000       602.889      56.604     0.919475     1.27845e-11     5.38238e-13
   5.90000e-01        4.10000e-01        2.44898e-01        7.55102e-01       7.09281e-09        0.00000         1.51706e-10          1.00000       602.889      55.807     0.919475     1.29121e-11     5.38238e-13
   6.00000e-01        4.00000e-01        2.52653e-01        7.47347e-01       7.27013e-09        0.00000         1.55498e-10          1.00000       602.889      55.011     0.919475     1.30461e-11     5.38238e-13
   6.10000e-01        3.90000e-01        2.60636e-01        7.39364e-01       7.45655e-09        0.00000         1.59486e-10          1.00000       602.889      54.215     0.919475     1.31869e-11     5.38238e-13
   6.20000e-01        3.80000e-01        2.68857e-01        7.31143e-01       7.65277e-09        0.00000         1.63683e-10          1.00000       602.889      53.419     0.919475     1.33352e-11     5.38238e-13
   6.30000e-01        3.70000e-01        2.77327e-01        7.22673e-01       7.85960e-09        0.00000         1.68106e-10          1.00000       602.889      52.623     0.919475     1.34915e-11     5.38238e-13
   6.40000e-01        3.60000e-01        2.86057e-01        7.13943e-01       8.07792e-09        0.00000         1.72776e-10          1.00000       602.889      51.827     0.919475     1.36565e-11     5.38238e-13
   6.50000e-01        3.50000e-01        2.95059e-01        7.04941e-01       8.30872e-09        0.00000         1.77712e-10          1.00000       602.889      51.030     0.919475     1.38309e-11     5.38238e-13
   6.60000e-01        3.40000e-01        3.04347e-01        6.95653e-01       8.55310e-09        0.00000         1.82939e-10          1.00000       602.889      50.234     0.919475     1.40155e-11     5.38238e-13
   6.70000e-01        3.30000e-01        3.13934e-01        6.86066e-01       8.81228e-09        0.00000         1.88483e-10          1.00000       602.889      49.438     0.919475     1.42114e-11     5.38238e-13
   6.80000e-01        3.20000e-01        3.23835e-01        6.76165e-01       9.08766e-09        0.00000         1.94373e-10          1.00000       602.889      48.642     0.919475     1.44195e-11     5.38238e-13
   6.90000e-01        3.10000e-01        3.34065e-01        6.65935e-01       9.38081e-09        0.00000         2.00643e-10          1.00000       602.889      47.846     0.919475     1.46410e-11     5.38238e-13
   7.00000e-01        3.00000e-01        3.44641e-01        6.55359e-01       9.69351e-09        0.00000         2.07331e-10          1.00000       602.889      47.050     0.919475     1.48773e-11     5.38238e-13
   7.10000e-01        2.90000e-01        3.55582e-01        6.44418e-01       1.00278e-08        0.00000         2.14481e-10          1.00000       602.889      46.253     0.919475     1.51298e-11     5.38238e-13
   7.20000e-01        2.80000e-01        3.66905e-01        6.33095e-01       1.03859e-08        0.00000         2.22141e-10          1.00000       602.889      45.457     0.919475     1.54005e-11     5.38238e-13
   7.30000e-01        2.70000e-01        3.78633e-01        6.21367e-01       1.07706e-08        0.00000         2.30368e-10          1.00000       602.889      44.661     0.919475     1.56911e-11     5.38238e-13
   7.40000e-01        2.60000e-01        3.90786e-01        6.09214e-01       1.11848e-08        0.00000         2.39228e-10          1.00000       602.889      43.865     0.919475     1.60041e-11     5.38238e-13
   7.50000e-01        2.50000e-01        4.03389e-01        5.96611e-01       1.16322e-08        0.00000         2.48797e-10          1.00000       602.889      43.069     0.919475     1.63422e-11     5.38238e-13
   7.60000e-01        2.40000e-01        4.16466e-01        5.83534e-01       1.21169e-08        0.00000         2.59164e-10          1.00000       602.889      42.273     0.919475     1.67084e-11     5.38238e-13
   7.70000e-01        2.30000e-01        4.30045e-01        5.69955e-01       1.26437e-08        0.00000         2.70432e-10          1.00000       602.889      41.476     0.919475     1.71065e-11     5.38238e-13
   7.80000e-01        2.20000e-01        4.44156e-01        5.55844e-01       1.32184e-08        0.00000         2.82724e-10          1.00000       602.889      40.680     0.919475     1.75408e-11     5.38238e-13
   7.90000e-01        2.10000e-01        4.58831e-01        5.41169e-01       1.38479e-08        0.00000         2.96187e-10          1.00000       602.889      39.884     0.919475     1.80164e-11     5.38238e-13
   8.00000e-01        2.00000e-01        4.74103e-01        5.25897e-01       1.45403e-08        0.00000         3.10997e-10          1.00000       602.889      39.088     0.919475     1.85396e-11     5.38238e-13
   8.10000e-01        1.90000e-01        4.90010e-01        5.09990e-01       1.53055e-08        0.00000         3.27365e-10          1.00000       602.889      38.292     0.919475     1.91179e-11     5.38238e-13
   8.20000e-01        1.80000e-01        5.06592e-01        4.93408e-01       1.61558e-08        0.00000         3.45552e-10          1.00000       602.889      37.496     0.919475     1.97604e-11     5.38238e-13
   8.30000e-01        1.70000e-01        5.23894e-01        4.76106e-01       1.71062e-08        0.00000         3.65879e-10          1.00000       602.889      36.699     0.919475     2.04785e-11     5.38238e-13
   8.40000e-01        1.60000e-01        5.41964e-01        4.58036e-01       1.81753e-08        0.00000         3.88746e-10          1.00000       602.889      35.903     0.919475     2.12864e-11     5.38238e-13
   8.50000e-01        1.50000e-01        5.60853e-01        4.39147e-01       1.93870e-08        0.00000         4.14662e-10          1.00000       602.889      35.107     0.919475     2.22020e-11     5.38238e-13
   8.60000e-01        1.40000e-01        5.80619e-01        4.19381e-01       2.07718e-08        0.00000         4.44281e-10          1.00000       602.889      34.311     0.919475     2.32484e-11     5.38238e-13
   8.70000e-01        1.30000e-01        6.01323e-01        3.98677e-01       2.23696e-08        0.00000         4.78457e-10          1.00000       602.889      33.515     0.919475     2.44558e-11     5.38238e-13
   8.80000e-01        1.20000e-01        6.23036e-01        3.76964e-01       2.42338e-08        0.00000         5.18328e-10          1.00000       602.889      32.719     0.919475     2.58644e-11     5.38238e-13
   8.90000e-01        1.10000e-01        6.45831e-01        3.54169e-01       2.64368e-08        0.00000         5.65449e-10          1.00000       602.889      31.922     0.919475     2.75291e-11     5.38238e-13
   9.00000e-01        1.00000e-01        6.69793e-01        3.30207e-01       2.90805e-08        0.00000         6.21994e-10          1.00000       602.889      31.126     0.919475     2.95267e-11     5.38238e-13
   9.10000e-01        9.00000e-02        6.95012e-01        3.04988e-01       3.23117e-08        0.00000         6.91104e-10          1.00000       602.889      30.330     0.919475     3.19683e-11     5.38238e-13
   9.20000e-01        8.00000e-02        7.21592e-01        2.78408e-01       3.63507e-08        0.00000         7.77492e-10          1.00000       602.889      29.534     0.919475     3.50203e-11     5.38238e-13
   9.30000e-01        7.00000e-02        7.49644e-01        2.50356e-01       4.15436e-08        0.00000         8.88562e-10          1.00000       602.889      28.738     0.919475     3.89443e-11     5.38238e-13
   9.40000e-01        6.00000e-02        7.79294e-01        2.20706e-01       4.84675e-08        0.00000         1.03666e-09          1.00000       602.889      27.942     0.919475     4.41762e-11     5.38238e-13
   9.50000e-01        5.00000e-02        8.10684e-01        1.89316e-01       5.81611e-08        0.00000         1.24399e-09          1.00000       602.889      27.145     0.919475     5.15009e-11     5.38238e-13
   9.60000e-01        4.00000e-02        8.43971e-01        1.56029e-01       7.27013e-08        0.00000         1.55498e-09          1.00000       602.889      26.349     0.919475     6.24881e-11     5.38238e-13
   9.70000e-01        3.00000e-02        8.79332e-01        1.20668e-01       9.69351e-08        0.00000         2.07331e-09          1.00000       602.889      25.553     0.919475     8.07999e-11     5.38238e-13
   9.80000e-01        2.00000e-02        9.16968e-01        8.30322e-02       1.45403e-07        0.00000         3.10997e-09          1.00000       602.889      24.757     0.919475     1.17424e-10     5.38238e-13
   9.90000e-01        1.00000e-02        9.57104e-01        4.28956e-02       2.90805e-07        0.00000         6.21994e-09          1.00000       602.889      23.961     0.919475     2.27295e-10     5.38238e-13
   9.95000e-01        5.00000e-03        9.78190e-01        2.18102e-02       5.81611e-07        0.00000         1.24399e-08          1.00000       602.889      23.563     0.919475     4.47037e-10     5.38238e-13
   9.98000e-01        2.00000e-03        9.91187e-01        8.81340e-03       1.45403e-06        0.00000         3.10997e-08          1.00000       602.889      23.324     0.919475     1.10626e-09     5.38239e-13
   9.99000e-01        1.00000e-03        9.95578e-01        4.42180e-03       2.90805e-06        0.00000         6.21994e-08          1.00000       602.889      23.244     0.919475     2.20497e-09     5.38239e-13
   9.99500e-01        5.00000e-04        9.97785e-01        2.21469e-03       5.81611e-06        0.00000         1.24399e-07          1.00000       602.889      23.204     0.919475     4.40240e-09     5.38239e-13
   9.99800e-01        2.00000e-04        9.99113e-01        8.86789e-04       1.45403e-05        0.00000         3.10997e-07          1.00000       602.889      23.181     0.919475     1.09947e-08     5.38239e-13
   9.99900e-01        1.00000e-04        9.99556e-01        4.43547e-04       2.90806e-05        0.00000         6.21995e-07          1.00000       602.889      23.173     0.919475     2.19818e-08     5.38240e-13
   9.99950e-01        5.00000e-05        9.99778e-01        2.21812e-04       5.81614e-05        0.00000         1.24399e-06          1.00000       602.889      23.169     0.919475     4.39562e-08     5.38242e-13
   9.99980e-01        2.00000e-05        9.99911e-01        8.87338e-05       1.45405e-04        0.00000         3.11001e-06          1.00000       602.888      23.166     0.919475     1.09880e-07     5.38247e-13
   9.99990e-01        1.00000e-05        9.99956e-01        4.43684e-05       2.90813e-04        0.00000         6.22008e-06          1.00000       602.887      23.165     0.919474     2.19756e-07     5.38255e-13
   9.99995e-01        5.00000e-06        9.99978e-01        2.21846e-05       5.81642e-04        0.00000         1.24405e-05          1.00000       602.885      23.165     0.919474     4.39516e-07     5.38272e-13
   9.99998e-01        2.00000e-06        9.99991e-01        8.87393e-06       1.45422e-03        0.00000         3.11033e-05          1.00000       602.878      23.165     0.919473     1.09887e-06     5.38321e-13
   9.99999e-01        1.00000e-06        9.99996e-01        4.43698e-06       2.90884e-03        0.00000         6.22140e-05          0.99999       602.866      23.165     0.919472     2.19804e-06     5.38404e-13
   1.00000e+00        5.00000e-07        9.99998e-01        2.21849e-06       5.81926e-03        0.00000         1.24457e-04          0.99999       602.843      23.165     0.919470     4.39729e-06     5.38570e-13
   1.00000e+00        2.00000e-07        9.99999e-01        8.87398e-07       1.45600e-02        0.00000         3.11364e-04          0.99997       602.775      23.165     0.919462     1.10024e-05     5.39069e-13
   1.00000e+00        1.00000e-07        1.00000e+00        4.43699e-07       2.91596e-02        0.00000         6.23465e-04          0.99994       602.660      23.165     0.919449     2.20353e-05     5.39904e-13
   1.00000e+00        5.00000e-08        1.00000e+00        2.21850e-07       5.84785e-02        0.00000         1.24989e-03          0.99988       602.431      23.165     0.919424     4.41938e-05     5.41584e-13
   1.00000e+00        2.00000e-08        1.00000e+00        8.87399e-08       1.47411e-01        0.00000         3.14733e-03          0.99969       601.735      23.165     0.919347     1.11424e-04     5.46711e-13
   1.00000e+00        1.00000e-08        1.00000e+00        4.43699e-08       2.99013e-01        0.00000         6.37248e-03          0.99936       600.551      23.165     0.919215     2.26088e-04     5.55562e-13
   1.00000e+00        5.00000e-09        1.00000e+00        2.21850e-08       6.15934e-01        0.00000         1.30768e-02          0.99869       598.091      23.165     0.918940     4.66032e-04     5.74531e-13
   1.00000e+00        3.12256e-09        1.00000e+00        1.38548e-08       1.02452e+00        0.00000         2.16453e-02          0.99782       594.944      23.165     0.918584     7.75852e-04     5.99943e-13
   1.00000e+00        2.00000e-09        1.00000e+00        8.87399e-09       1.70414e+00        0.00000         3.57140e-02          0.99638       589.774      23.165     0.917994     1.29239e-03     6.44717e-13
   1.00000e+00        1.37398e-09        1.00000e+00        6.09634e-09       2.72952e+00        0.00000         5.65155e-02          0.99421       582.122      23.165     0.917102     2.07452e-03     7.18650e-13
   1.00000e+00        1.00000e-09        1.00000e+00        4.43699e-09       4.37185e+00        0.00000         8.88094e-02          0.99075       570.228      23.165     0.915674     3.33434e-03     8.55063e-13
   1.00000e+00        8.56002e-10        1.00000e+00        3.79807e-09       5.88170e+00        0.00000         1.17438e-01          0.98759       559.676      23.165     0.914362     4.50024e-03     1.00311e-12
   1.00000e+00        7.69572e-10        1.00000e+00        3.41458e-09       7.91300e+00        0.00000         1.54443e-01          0.98337       546.036      23.165     0.912599     6.08045e-03     1.24329e-12
   1.00000e+00        7.39215e-10        1.00000e+00        3.27989e-09       1.06458e+01        0.00000         2.01687e-01          0.97774       528.649      23.165     0.910237     8.22749e-03     1.65897e-12
   1.00000e+00        7.39215e-10        1.00000e+00        3.27989e-09       1.06471e+01        0.00000         2.01709e-01          0.97774       528.641      23.165     0.910236     8.22849e-03     1.65919e-12
   1.00000e+00        7.60535e-10        1.00000e+00        3.37449e-09       1.33775e+01        0.00000         2.46244e-01          0.97217       512.315      23.165     0.907889     1.03979e-02     2.21237e-12
   1.00000e+00        8.36291e-10        1.00000e+00        3.71062e-09       1.68082e+01        0.00000         2.98805e-01          0.96527       493.190      23.165     0.904970     1.31578e-02     3.17347e-12
   1.00000e+00        1.00000e-09        1.00000e+00        4.43699e-09       2.11187e+01        0.00000         3.60125e-01          0.95675       471.193      23.165     0.901360     1.66794e-02     4.98635e-12
   1.00000e+00        1.32516e-09        1.00000e+00        5.87975e-09       2.64862e+01        0.00000         4.30249e-01          0.94639       446.682      23.165     0.896984     2.11477e-02     8.73025e-12
   1.00000e+00        2.00000e-09        1.00000e+00        8.87399e-09       3.32180e+01        0.00000         5.10299e-01          0.93380       419.951      23.165     0.891730     2.68801e-02     1.75360e-11
   1.00000e+00        3.00330e-09        1.00000e+00        1.33256e-08       3.92746e+01        0.00000         5.76469e-01          0.92290       399.240      23.165     0.887270     3.21566e-02     3.26564e-11
   1.00000e+00        5.00000e-09        1.00000e+00        2.21850e-08       4.64356e+01        0.00000         6.49366e-01          0.91056       378.272      23.165     0.882371     3.85347e-02     6.75447e-11
   1.00000e+00        1.00000e-08        1.00000e+00        4.43699e-08       5.57571e+01        0.00000         7.38174e-01          0.89548       355.797      23.165     0.876656     4.70495e-02     1.71146e-10
   1.00000e+00        2.00000e-08        1.00000e+00        8.87399e-08       6.48456e+01        0.00000         8.20511e-01          0.88193       338.182      23.165     0.871832     5.55595e-02     4.14860e-10
   1.00000e+00        3.10231e-08        1.00000e+00        1.37649e-07       7.05575e+01        0.00000         8.70923e-01          0.87403       328.894      23.165     0.869171     6.09996e-02     7.14958e-10
   1.00000e+00        5.00000e-08        1.00000e+00        2.21850e-07       7.67725e+01        0.00000         9.25032e-01          0.86601       320.093      23.165     0.866585     6.69872e-02     1.27746e-09
   1.00000e+00        1.00000e-07        1.00000e+00        4.43699e-07       8.58767e+01        0.00000         1.00342e+00          0.85539       309.240      23.165     0.863330     7.58613e-02     2.91781e-09
   1.00000e+00        2.00000e-07        9.99999e-01        8.87398e-07       9.51627e+01        0.00000         1.08272e+00          0.84599       300.161      23.165     0.860582     8.49985e-02     6.56008e-09
   1.00000e+00        5.00000e-07        9.99998e-01        2.21849e-06       1.07889e+02        0.00000         1.19065e+00          0.83553       290.130      23.165     0.857570     9.75724e-02     1.88000e-08
   9.99999e-01        1.00000e-06        9.99996e-01        4.43698e-06       1.18000e+02        0.00000         1.27571e+00          0.82923       283.583      23.165     0.855648     1.07528e-01     4.12723e-08
   9.99998e-01        2.00000e-06        9.99991e-01        8.87393e-06       1.28674e+02        0.00000         1.36457e+00          0.82449       277.617      23.165     0.853940     1.17929e-01     9.00473e-08
   9.99997e-01        3.15694e-06        9.99986e-01        1.40072e-05       1.36086e+02        0.00000         1.42553e+00          0.82232       273.888      23.165     0.852894     1.25052e-01     1.50153e-07
   9.99995e-01        5.00000e-06        9.99978e-01        2.21846e-05       1.43926e+02        0.00000         1.48922e+00          0.82099       270.215      23.165     0.851878     1.32471e-01     2.50991e-07
   9.99990e-01        1.00000e-05        9.99956e-01        4.43684e-05       1.56598e+02        0.00000         1.59013e+00          0.82081       264.708      23.165     0.850365     1.44167e-01     5.43695e-07
   9.99980e-01        2.00000e-05        9.99911e-01        8.87338e-05       1.70552e+02        0.00000         1.69800e+00          0.82322       259.061      23.166     0.848808     1.56560e-01     1.17738e-06
   9.99968e-01        3.17930e-05        9.99859e-01        1.41050e-04       1.80781e+02        0.00000         1.77470e+00          0.82655       255.111      23.167     0.847701     1.65289e-01     1.97511e-06
   9.99950e-01        5.00000e-05        9.99778e-01        2.21812e-04       1.91623e+02        0.00000         1.85374e+00          0.83135       251.051      23.169     0.846540     1.74201e-01     3.27732e-06
   9.99929e-01        7.10383e-05        9.99685e-01        3.15120e-04       2.00717e+02        0.00000         1.91822e+00          0.83629       247.729      23.170     0.845569     1.81403e-01     4.85918e-06
   9.99900e-01        1.00000e-04        9.99556e-01        4.43547e-04       2.10242e+02        0.00000         1.98398e+00          0.84226       244.319      23.173     0.844548     1.88682e-01     7.13845e-06
   9.99858e-01        1.42280e-04        9.99369e-01        6.30988e-04       2.20868e+02        0.00000         2.05526e+00          0.84980       240.593      23.176     0.843404     1.96491e-01     1.06290e-05
   9.99800e-01        2.00000e-04        9.99113e-01        8.86789e-04       2.32032e+02        0.00000         2.12781e+00          0.85858       236.762      23.181     0.842196     2.04352e-01     1.56381e-05
   9.99679e-01        3.20598e-04        9.98579e-01        1.42093e-03       2.49255e+02        0.00000         2.23527e+00          0.87362       231.018      23.190     0.840319     2.15829e-01     2.67922e-05
   9.99500e-01        5.00000e-04        9.97785e-01        2.21469e-03       2.67755e+02        0.00000         2.34503e+00          0.89147       225.071      23.204     0.838292     2.27347e-01     4.46794e-05
   9.99286e-01        7.14077e-04        9.96839e-01        3.16060e-03       2.84571e+02        0.00000         2.44007e+00          0.90892       219.870      23.221     0.836449     2.37158e-01     6.75777e-05
   9.99000e-01        1.00000e-03        9.95578e-01        4.42180e-03       3.02443e+02        0.00000         2.53655e+00          0.92853       214.555      23.244     0.834496     2.46971e-01     1.00265e-04
   9.98727e-01        1.27312e-03        9.94376e-01        5.62421e-03       3.16668e+02        0.00000         2.61027e+00          0.94480       210.482      23.266     0.832951     2.54374e-01     1.33372e-04
   9.98396e-01        1.60384e-03        9.92923e-01        7.07722e-03       3.31562e+02        0.00000         2.68474e+00          0.96236       206.364      23.292     0.831347     2.61775e-01     1.75589e-04
   9.98000e-01        2.00000e-03        9.91187e-01        8.81340e-03       3.47157e+02        0.00000         2.75996e+00          0.98125       202.211      23.324     0.829686     2.69175e-01     2.28879e-04
   9.97437e-01        2.56254e-03        9.88729e-01        1.12707e-02       3.66501e+02        0.00000         2.84966e+00          1.00530       197.280      23.369     0.827655     2.77907e-01     3.09071e-04
   9.96759e-01        3.24099e-03        9.85778e-01        1.42219e-02       3.86922e+02        0.00000         2.94042e+00          1.03133       192.329      23.423     0.825552     2.86647e-01     4.12096e-04
   9.95951e-01        4.04899e-03        9.82281e-01        1.77188e-02       4.08481e+02        0.00000         3.03226e+00          1.05944       187.374      23.487     0.823383     2.95400e-01     5.42885e-04
   9.95000e-01        5.00000e-03        9.78190e-01        2.18102e-02       4.31241e+02        0.00000         3.12523e+00          1.08971       182.432      23.563     0.821153     3.04173e-01     7.07075e-04
   9.93976e-01        6.02358e-03        9.73815e-01        2.61845e-02       4.53531e+02        0.00000         3.21274e+00          1.11988       177.862      23.644     0.819032     3.12352e-01     8.95210e-04
   9.92808e-01        7.19200e-03        9.68859e-01        3.11411e-02       4.76973e+02        0.00000         3.30137e+00          1.15213       173.328      23.737     0.816871     3.20560e-01     1.12343e-03
   9.91485e-01        8.51461e-03        9.63295e-01        3.67051e-02       5.01627e+02        0.00000         3.39124e+00          1.18655       168.841      23.843     0.814677     3.28802e-01     1.39805e-03
   9.90000e-01        1.00000e-02        9.57104e-01        4.28956e-02       5.27555e+02        0.00000         3.48248e+00          1.22326       164.413      23.961     0.812457     3.37082e-01     1.72598e-03
   9.88357e-01        1.16426e-02        9.50329e-01        4.96707e-02       5.54612e+02        0.00000         3.57452e+00          1.26210       160.086      24.092     0.810237     3.45340e-01     2.11151e-03
   9.86540e-01        1.34595e-02        9.42921e-01        5.70793e-02       5.83057e+02        0.00000         3.66823e+00          1.30347       155.839      24.236     0.808009     3.53640e-01     2.56476e-03
   9.84544e-01        1.54558e-02        9.34882e-01        6.51181e-02       6.12961e+02        0.00000         3.76382e+00          1.34751       151.680      24.395     0.805782     3.61984e-01     3.09404e-03
   9.82365e-01        1.76352e-02        9.26224e-01        7.37757e-02       6.44398e+02        0.00000         3.86151e+00          1.39439       147.618      24.569     0.803566     3.70371e-01     3.70804e-03
   9.80000e-01        2.00000e-02        9.16968e-01        8.30322e-02       6.77448e+02        0.00000         3.96159e+00          1.44428       143.662      24.757     0.801374     3.78798e-01     4.41572e-03
   9.77720e-01        2.22804e-02        9.08174e-01        9.18262e-02       7.08549e+02        0.00000         4.05369e+00          1.49176       140.210      24.938     0.799435     3.86392e-01     5.13802e-03
   9.75291e-01        2.47093e-02        8.98947e-01        1.01053e-01       7.41078e+02        0.00000         4.14821e+00          1.54194       136.854      25.132     0.797533     3.94011e-01     5.94949e-03
   9.72716e-01        2.72839e-02        8.89320e-01        1.10680e-01       7.75101e+02        0.00000         4.24542e+00          1.59496       133.602      25.337     0.795678     4.01648e-01     6.85627e-03
   9.70000e-01        3.00000e-02        8.79332e-01        1.20668e-01       8.10685e+02        0.00000         4.34564e+00          1.65098       130.458      25.553     0.793880     4.09299e-01     7.86403e-03
   9.67628e-01        3.23723e-02        8.70746e-01        1.29254e-01       8.41653e+02        0.00000         4.43190e+00          1.70016       127.918      25.742     0.792429     4.15691e-01     8.78664e-03
   9.65166e-01        3.48340e-02        8.61968e-01        1.38032e-01       8.73804e+02        0.00000         4.52070e+00          1.75163       125.458      25.938     0.791031     4.22080e-01     9.78540e-03
   9.62621e-01        3.73790e-02        8.53031e-01        1.46969e-01       9.07183e+02        0.00000         4.61231e+00          1.80546       123.082      26.141     0.789693     4.28459e-01     1.08619e-02
   9.60000e-01        4.00000e-02        8.43971e-01        1.56029e-01       9.41837e+02        0.00000         4.70696e+00          1.86175       120.792      26.349     0.788422     4.34820e-01     1.20168e-02
   9.56737e-01        4.32628e-02        8.32891e-01        1.67109e-01       9.85583e+02        0.00000         4.82608e+00          1.93334       118.135      26.609     0.786981     4.42488e-01     1.35199e-02
   9.53396e-01        4.66041e-02        8.21767e-01        1.78233e-01       1.03136e+03        0.00000         4.95063e+00          2.00881       115.611      26.875     0.785661     4.50099e-01     1.51339e-02
   9.50000e-01        5.00000e-02        8.10684e-01        1.89316e-01       1.07927e+03        0.00000         5.08122e+00          2.08830       113.222      27.145     0.784475     4.57634e-01     1.68518e-02
   9.46646e-01        5.33538e-02        7.99953e-01        2.00047e-01       1.12838e+03        0.00000         5.21572e+00          2.17024       111.016      27.412     0.783455     4.64923e-01     1.86255e-02
   9.43300e-01        5.66999e-02        7.89454e-01        2.10546e-01       1.17973e+03        0.00000         5.35736e+00          2.25626       108.947      27.679     0.782589     4.72092e-01     2.04724e-02
   9.40000e-01        6.00000e-02        7.79294e-01        2.20706e-01       1.23342e+03        0.00000         5.50689e+00          2.34643       107.018      27.942     0.781891     4.79114e-01     2.23711e-02
   9.36463e-01        6.35366e-02        7.68617e-01        2.31383e-01       1.29553e+03        0.00000         5.68218e+00          2.45084       105.055      28.223     0.781331     4.86659e-01     2.44944e-02
   9.33105e-01        6.68951e-02        7.58672e-01        2.41328e-01       1.36077e+03        0.00000         5.86939e+00          2.56033       103.271      28.491     0.781008     4.93942e-01     2.66011e-02
   9.30000e-01        7.00000e-02        7.49644e-01        2.50356e-01       1.42930e+03        0.00000         6.06991e+00          2.67483       101.670      28.738     0.780940     5.00917e-01     2.86359e-02
   9.27305e-01        7.26952e-02        7.41931e-01        2.58069e-01       1.49911e+03        0.00000         6.27871e+00          2.79062       100.294      28.952     0.781132     5.07346e-01     3.04831e-02
   9.24997e-01        7.50026e-02        7.35419e-01        2.64581e-01       1.57234e+03        0.00000         6.50292e+00          2.91079        99.095      29.136     0.781587     5.13396e-01     3.21431e-02
   9.23144e-01        7.68558e-02        7.30247e-01        2.69753e-01       1.64915e+03        0.00000         6.74405e+00          3.03513        98.074      29.284     0.782311     5.19031e-01     3.35578e-02
   9.21797e-01        7.82027e-02        7.26521e-01        2.73479e-01       1.72970e+03        0.00000         7.00359e+00          3.16339        97.229      29.391     0.783306     5.24224e-01     3.46774e-02
   9.20988e-01        7.90122e-02        7.24295e-01        2.75705e-01       1.81419e+03        0.00000         7.28297e+00          3.29540        96.553      29.455     0.784562     5.28963e-01     3.54668e-02
   9.20721e-01        7.92790e-02        7.23563e-01        2.76437e-01       1.90281e+03        0.00000         7.58353e+00          3.43104        96.039      29.477     0.786065     5.33252e-01     3.59104e-02
   9.33180e-01        6.68200e-02        7.58893e-01        2.41107e-01       2.82785e+03        0.00000         1.10390e+01          4.72550        96.295      28.485     0.804669     5.56038e-01     2.98546e-02
   9.51455e-01        4.85451e-02        8.15405e-01        1.84595e-01       4.20259e+03        0.00000         1.66727e+01          6.50635       100.404      27.030     0.825559     5.69515e-01     2.00373e-02
   9.64978e-01        3.50224e-02        8.61301e-01        1.38699e-01       6.24564e+03        0.00000         2.54858e+01          9.09992       105.512      25.953     0.843467     5.81049e-01     1.32739e-02
   9.73804e-01        2.61960e-02        8.93369e-01        1.06631e-01       9.28191e+03        0.00000         3.90216e+01         12.93125       110.499      25.250     0.857388     5.91220e-01     9.20946e-03
   9.79400e-01        2.06000e-02        9.14641e-01        8.53586e-02       1.37942e+04        0.00000         5.95529e+01         18.61167       114.831      24.805     0.867643     5.99698e-01     6.81547e-03
   9.82944e-01        1.70563e-02        9.28512e-01        7.14879e-02       2.05002e+04        0.00000         9.04283e+01         27.04395       118.316      24.523     0.874953     6.06374e-01     5.38721e-03
   9.85207e-01        1.47933e-02        9.37538e-01        6.24618e-02       3.04662e+04        0.00000         1.36610e+02         39.56807       120.973      24.342     0.880057     6.11397e-01     4.51575e-03
   9.86668e-01        1.33323e-02        9.43437e-01        5.65633e-02       4.52772e+04        0.00000         2.05472e+02         58.17494       122.922      24.226     0.883574     6.15053e-01     3.97165e-03
   9.87621e-01        1.23793e-02        9.47315e-01        5.26854e-02       6.72883e+04        0.00000         3.07980e+02         85.82306       124.314      24.150     0.885977     6.17650e-01     3.62514e-03
   9.88248e-01        1.17524e-02        9.49879e-01        5.01209e-02       1.00000e+05        0.00000         4.60444e+02        126.90895       125.289      24.100     0.887611     6.19464e-01     3.39678e-03
           NaN                NaN                NaN                NaN               NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   2.46663e-01        7.53337e-01        6.87235e-02        9.31277e-01       1.00000e+05        0.00000         3.51981e+02        323.02567        91.941      83.143     0.852071     8.39602e-01     7.18156e-01
   2.50000e-01        7.50000e-01        6.98764e-02        9.30124e-01       9.02254e+04        0.00000         3.17165e+02        290.75019        91.773      82.877     0.851614     8.38936e-01     7.15133e-01
   2.60000e-01        7.40000e-01        7.33764e-02        9.26624e-01       6.95876e+04        0.00000         2.43672e+02        222.62699        91.270      82.081     0.850236     8.36917e-01     7.06035e-01
   2.70000e-01        7.30000e-01        7.69449e-02        9.23055e-01       5.64344e+04        0.00000         1.96856e+02        179.23639        90.771      81.285     0.848844     8.34859e-01     6.96876e-01
   2.80000e-01        7.20000e-01        8.05840e-02        9.19416e-01       4.73178e+04        0.00000         1.64427e+02        149.18492        90.275      80.489     0.847436     8.32761e-01     6.87656e-01
   2.90000e-01        7.10000e-01        8.42958e-02        9.15704e-01       4.06258e+04        0.00000         1.40639e+02        127.14568        89.783      79.692     0.846012     8.30622e-01     6.78376e-01
   3.00000e-01        7.00000e-01        8.80826e-02        9.11917e-01       3.55037e+04        0.00000         1.22447e+02        110.29492        89.295      78.896     0.844573     8.28440e-01     6.69034e-01
   3.10000e-01        6.90000e-01        9.19465e-02        9.08053e-01       3.14565e+04        0.00000         1.08087e+02         96.99633        88.811      78.100     0.843119     8.26214e-01     6.59633e-01
   3.20000e-01        6.80000e-01        9.58900e-02        9.04110e-01       2.81773e+04        0.00000         9.64642e+01         86.23621        88.331      77.304     0.841649     8.23944e-01     6.50170e-01
   3.30000e-01        6.70000e-01        9.99157e-02        9.00084e-01       2.54660e+04        0.00000         8.68659e+01         77.35307        87.855      76.508     0.840162     8.21627e-01     6.40647e-01
   3.40000e-01        6.60000e-01        1.04026e-01        8.95974e-01       2.31864e+04        0.00000         7.88065e+01         69.89689        87.383      75.712     0.838660     8.19262e-01     6.31064e-01
   3.50000e-01        6.50000e-01        1.08224e-01        8.91776e-01       2.12425e+04        0.00000         7.19444e+01         63.55088        86.917      74.915     0.837142     8.16848e-01     6.21421e-01
   3.60000e-01        6.40000e-01        1.12511e-01        8.87489e-01       1.95650e+04        0.00000         6.60320e+01         58.08555        86.455      74.119     0.835607     8.14383e-01     6.11718e-01
   3.70000e-01        6.30000e-01        1.16892e-01        8.83108e-01       1.81023e+04        0.00000         6.08857e+01         53.33060        85.998      73.323     0.834056     8.11865e-01     6.01956e-01
   3.80000e-01        6.20000e-01        1.21369e-01        8.78631e-01       1.68153e+04        0.00000         5.63663e+01         49.15697        85.547      72.527     0.832488     8.09293e-01     5.92135e-01
   3.90000e-01        6.10000e-01        1.25946e-01        8.74054e-01       1.56740e+04        0.00000         5.23663e+01         45.46508        85.101      71.731     0.830904     8.06665e-01     5.82255e-01
   4.00000e-01        6.00000e-01        1.30625e-01        8.69375e-01       1.46546e+04        0.00000         4.88015e+01         42.17687        84.661      70.935     0.829303     8.03979e-01     5.72318e-01
   4.10000e-01        5.90000e-01        1.35411e-01        8.64589e-01       1.37385e+04        0.00000         4.56051e+01         39.23028        84.228      70.138     0.827686     8.01233e-01     5.62323e-01
   4.20000e-01        5.80000e-01        1.40306e-01        8.59694e-01       1.29104e+04        0.00000         4.27231e+01         36.57535        83.800      69.342     0.826052     7.98424e-01     5.52272e-01
   4.30000e-01        5.70000e-01        1.45315e-01        8.54685e-01       1.21580e+04        0.00000         4.01116e+01         34.17141        83.380      68.546     0.824401     7.95552e-01     5.42166e-01
   4.40000e-01        5.60000e-01        1.50442e-01        8.49558e-01       1.14713e+04        0.00000         3.77346e+01         31.98500        82.966      67.750     0.822734     7.92612e-01     5.32005e-01
   4.50000e-01        5.50000e-01        1.55691e-01        8.44309e-01       1.08418e+04        0.00000         3.55620e+01         29.98837        82.560      66.954     0.821049     7.89604e-01     5.21790e-01
   4.60000e-01        5.40000e-01        1.61066e-01        8.38934e-01       1.02625e+04        0.00000         3.35690e+01         28.15828        82.161      66.158     0.819348     7.86524e-01     5.11522e-01
   4.70000e-01        5.30000e-01        1.66572e-01        8.33428e-01       9.72743e+03        0.00000         3.17342e+01         26.47515        81.771      65.361     0.817631     7.83370e-01     5.01204e-01
   4.80000e-01        5.20000e-01        1.72214e-01        8.27786e-01       9.23157e+03        0.00000         3.00398e+01         24.92233        81.390      64.565     0.815896     7.80139e-01     4.90835e-01
   4.90000e-01        5.10000e-01        1.77996e-01        8.22004e-01       8.77061e+03        0.00000         2.84703e+01         23.48559        81.017      63.769     0.814146     7.76828e-01     4.80418e-01
   5.00000e-01        5.00000e-01        1.83925e-01        8.16075e-01       8.34084e+03        0.00000         2.70126e+01         22.15271        80.655      62.973     0.812379     7.73433e-01     4.69954e-01
   5.10000e-01        4.90000e-01        1.90006e-01        8.09994e-01       7.93904e+03        0.00000         2.56553e+01         20.91310        80.302      62.177     0.810595     7.69952e-01     4.59446e-01
   5.20000e-01        4.80000e-01        1.96244e-01        8.03756e-01       7.56242e+03        0.00000         2.43884e+01         19.75756        79.960      61.381     0.808796     7.66381e-01     4.48894e-01
   5.30000e-01        4.70000e-01        2.02647e-01        7.97353e-01       7.20854e+03        0.00000         2.32032e+01         18.67807        79.630      60.584     0.806981     7.62716e-01     4.38302e-01
   5.40000e-01        4.60000e-01        2.09220e-01        7.90780e-01       6.87526e+03        0.00000         2.20921e+01         17.66755        79.312      59.788     0.805151     7.58952e-01     4.27629e-01
   5.50000e-01        4.50000e-01        2.15970e-01        7.84030e-01       6.56067e+03        0.00000         2.10484e+01         16.71980        79.007      58.992     0.803305     7.55086e-01     4.16906e-01
   5.60000e-01        4.40000e-01        2.22905e-01        7.77095e-01       6.26309e+03        0.00000         2.00661e+01         15.82930        78.715      58.196     0.801444     7.51113e-01     4.06147e-01
   5.70000e-01        4.30000e-01        2.30033e-01        7.69967e-01       5.98103e+03        0.00000         1.91398e+01         14.99115        78.439      57.400     0.799568     7.47028e-01     3.95356e-01
   5.80000e-01        4.20000e-01        2.37361e-01        7.62639e-01       5.71314e+03        0.00000         1.82648e+01         14.20097        78.178      56.604     0.797678     7.42825e-01     3.84534e-01
   5.90000e-01        4.10000e-01        2.44898e-01        7.55102e-01       5.45821e+03        0.00000         1.74369e+01         13.45484        77.933      55.807     0.795774     7.38498e-01     3.73686e-01
   6.00000e-01        4.00000e-01        2.52653e-01        7.47347e-01       5.21514e+03        0.00000         1.66521e+01         12.74921        77.706      55.011     0.793856     7.34041e-01     3.62816e-01
   6.10000e-01        3.90000e-01        2.60636e-01        7.39364e-01       4.98295e+03        0.00000         1.59069e+01         12.08088        77.499      54.215     0.791924     7.29447e-01     3.51926e-01
   6.20000e-01        3.80000e-01        2.68857e-01        7.31143e-01       4.76070e+03        0.00000         1.51981e+01         11.44694        77.312      53.419     0.789978     7.24707e-01     3.41023e-01
   6.30000e-01        3.70000e-01        2.77327e-01        7.22673e-01       4.54756e+03        0.00000         1.45228e+01         10.84470        77.148      52.623     0.788019     7.19814e-01     3.30111e-01
   6.40000e-01        3.60000e-01        2.86057e-01        7.13943e-01       4.34272e+03        0.00000         1.38781e+01         10.27171        77.007      51.827     0.786046     7.14755e-01     3.19194e-01
   6.50000e-01        3.50000e-01        2.95059e-01        7.04941e-01       4.14543e+03        0.00000         1.32615e+01          9.72567        76.893      51.030     0.784059     7.09521e-01     3.08228e-01
   6.60000e-01        3.40000e-01        3.04347e-01        6.95653e-01       3.95496e+03        0.00000         1.26704e+01          9.20440        76.807      50.234     0.782056     7.04098e-01     2.97249e-01
   6.70000e-01        3.30000e-01        3.13934e-01        6.86066e-01       3.77060e+03        0.00000         1.21022e+01          8.70582        76.751      49.438     0.780036     6.98471e-01     2.86283e-01
   6.80000e-01        3.20000e-01        3.23835e-01        6.76165e-01       3.59158e+03        0.00000         1.15547e+01          8.22788        76.729      48.642     0.777994     6.92619e-01     2.75044e-01
   6.90000e-01        3.10000e-01        3.34065e-01        6.65935e-01       3.41714e+03        0.00000         1.10250e+01          7.76852        76.745      47.846     0.775927     6.86521e-01     2.63319e-01
   7.00000e-01        3.00000e-01        3.44641e-01        6.55359e-01       3.24638e+03        0.00000         1.05102e+01          7.32554        76.801      47.050     0.773826     6.80145e-01     2.51594e-01
   7.10000e-01        2.90000e-01        3.55582e-01        6.44418e-01       3.07826e+03        0.00000         1.00070e+01          6.89648        76.904      46.253     0.771678     6.73453e-01     2.39873e-01
   7.20000e-01        2.80000e-01        3.66905e-01        6.33095e-01       2.91140e+03        0.00000         9.51096e+00          6.47833        77.059      45.457     0.769462     6.66389e-01     2.28162e-01
   7.30000e-01        2.70000e-01        3.78633e-01        6.21367e-01       2.74385e+03        0.00000         9.01581e+00          6.06705        77.274      44.661     0.767141     6.58867e-01     2.16461e-01
   7.40000e-01        2.60000e-01        3.90786e-01        6.09214e-01       2.57245e+03        0.00000         8.51164e+00          5.65635        77.561      43.865     0.764645     6.50748e-01     2.04767e-01
   7.45194e-01        2.54806e-01        3.97274e-01        6.02726e-01       2.48010e+03        0.00000         8.24060e+00          5.43979        77.743      43.451     0.763238     6.46215e-01     1.98690e-01
   7.50000e-01        2.50000e-01        4.03389e-01        5.96611e-01       2.39107e+03        0.00000         7.97935e+00          5.23443        77.938      43.069     0.761828     6.41757e-01     1.93056e-01
   7.55368e-01        2.44632e-01        4.10348e-01        5.89652e-01       2.28497e+03        0.00000         7.66770e+00          4.99451        78.189      42.641     0.760064     6.36364e-01     1.86739e-01
   7.60000e-01        2.40000e-01        4.16466e-01        5.83534e-01       2.18359e+03        0.00000         7.36894e+00          4.77055        78.446      42.273     0.758271     6.31172e-01     1.81244e-01
   7.64143e-01        2.35857e-01        4.22030e-01        5.77970e-01       2.07742e+03        0.00000         7.05431e+00          4.54211        78.724      41.943     0.756246     6.25762e-01     1.76248e-01
   7.67200e-01        2.32800e-01        4.26191e-01        5.73809e-01       1.97641e+03        0.00000         6.75241e+00          4.33108        78.985      41.699     0.754136     6.20722e-01     1.72433e-01
   7.69080e-01        2.30920e-01        4.28775e-01        5.71225e-01       1.88032e+03        0.00000         6.46201e+00          4.13643        79.217      41.550     0.751914     6.16112e-01     1.69889e-01
   7.69718e-01        2.30282e-01        4.29655e-01        5.70345e-01       1.78890e+03        0.00000         6.18211e+00          3.95703        79.409      41.499     0.749557     6.11981e-01     1.68683e-01
   7.69718e-01        2.30282e-01        4.29655e-01        5.70345e-01       1.78869e+03        0.00000         6.18148e+00          3.95663        79.409      41.499     0.749551     6.11972e-01     1.68682e-01
   7.69100e-01        2.30900e-01        4.28802e-01        5.71198e-01       1.70350e+03        0.00000         5.91692e+00          3.79467        79.550      41.548     0.747092     6.08423e-01     1.68846e-01
   7.67254e-01        2.32746e-01        4.26265e-01        5.73735e-01       1.62237e+03        0.00000         5.66124e+00          3.64501        79.638      41.695     0.744469     6.05373e-01     1.70362e-01
   7.64204e-01        2.35796e-01        4.22112e-01        5.77888e-01       1.54511e+03        0.00000         5.41416e+00          3.50643        79.671      41.938     0.741678     6.02817e-01     1.73231e-01
   7.60000e-01        2.40000e-01        4.16466e-01        5.83534e-01       1.47152e+03        0.00000         5.17555e+00          3.37777        79.649      42.273     0.738717     6.00733e-01     1.77449e-01
   7.55399e-01        2.44601e-01        4.10388e-01        5.89612e-01       1.40971e+03        0.00000         4.97267e+00          3.27192        79.586      42.639     0.735973     5.99267e-01     1.82264e-01
   7.50000e-01        2.50000e-01        4.03389e-01        5.96611e-01       1.35050e+03        0.00000         4.77624e+00          3.17218        79.482      43.069     0.733103     5.98118e-01     1.88114e-01
   7.45221e-01        2.54779e-01        3.97308e-01        6.02692e-01       1.30565e+03        0.00000         4.62614e+00          3.09753        79.374      43.449     0.730757     5.97420e-01     1.93448e-01
   7.40000e-01        2.60000e-01        3.90786e-01        6.09214e-01       1.26229e+03        0.00000         4.47998e+00          3.02599        79.244      43.865     0.728336     5.96890e-01     1.99433e-01
   7.35150e-01        2.64850e-01        3.84838e-01        6.15162e-01       1.22599e+03        0.00000         4.35686e+00          2.96648        79.113      44.251     0.726185     5.96558e-01     2.05136e-01
   7.30000e-01        2.70000e-01        3.78633e-01        6.21367e-01       1.19073e+03        0.00000         4.23661e+00          2.90896        78.967      44.661     0.723979     5.96336e-01     2.11345e-01
   7.25113e-01        2.74887e-01        3.72850e-01        6.27150e-01       1.15984e+03        0.00000         4.13072e+00          2.85872        78.822      45.050     0.721945     5.96224e-01     2.17383e-01
   7.20000e-01        2.80000e-01        3.66905e-01        6.33095e-01       1.12975e+03        0.00000         4.02710e+00          2.80988        78.664      45.457     0.719867     5.96190e-01     2.23856e-01
   7.10000e-01        2.90000e-01        3.55582e-01        6.44418e-01       1.07628e+03        0.00000         3.84176e+00          2.72319        78.339      46.253     0.715915     5.96318e-01     2.36994e-01
   7.00000e-01        3.00000e-01        3.44641e-01        6.55359e-01       1.02850e+03        0.00000         3.67485e+00          2.64565        77.996      47.050     0.712070     5.96643e-01     2.50803e-01
   6.90000e-01        3.10000e-01        3.34065e-01        6.65935e-01       9.85242e+02        0.00000         3.52258e+00          2.57521        77.633      47.846     0.708296     5.97117e-01     2.65337e-01
   6.80000e-01        3.20000e-01        3.23835e-01        6.76165e-01       9.45681e+02        0.00000         3.38232e+00          2.51046        77.251      48.642     0.704566     5.97707e-01     2.80662e-01
   6.70000e-01        3.30000e-01        3.13934e-01        6.86066e-01       9.09223e+02        0.00000         3.25215e+00          2.45039        76.850      49.438     0.700858     5.98388e-01     2.96854e-01
   6.60000e-01        3.40000e-01        3.04347e-01        6.95653e-01       8.75419e+02        0.00000         3.13057e+00          2.39426        76.428      50.234     0.697154     5.99144e-01     3.14003e-01
   6.50000e-01        3.50000e-01        2.95059e-01        7.04941e-01       8.43916e+02        0.00000         3.01644e+00          2.34148        75.983      51.030     0.693435     5.99962e-01     3.32213e-01
   6.40000e-01        3.60000e-01        2.86057e-01        7.13943e-01       8.14433e+02        0.00000         2.90881e+00          2.29162        75.513      51.827     0.689685     6.00831e-01     3.51609e-01
   6.30000e-01        3.70000e-01        2.77327e-01        7.22673e-01       7.86742e+02        0.00000         2.80691e+00          2.24430        75.018      52.623     0.685889     6.01744e-01     3.72335e-01
   6.20000e-01        3.80000e-01        2.68857e-01        7.31143e-01       7.60655e+02        0.00000         2.71010e+00          2.19924        74.493      53.419     0.682029     6.02695e-01     3.94562e-01
   6.10000e-01        3.90000e-01        2.60636e-01        7.39364e-01       7.36014e+02        0.00000         2.61784e+00          2.15619        73.936      54.215     0.678088     6.03678e-01     4.18497e-01
   6.00000e-01        4.00000e-01        2.52653e-01        7.47347e-01       7.12684e+02        0.00000         2.52964e+00          2.11496        73.344      55.011     0.674047     6.04690e-01     4.44388e-01
   5.90000e-01        4.10000e-01        2.44898e-01        7.55102e-01       6.90552e+02        0.00000         2.44511e+00          2.07538        72.714      55.807     0.669884     6.05728e-01     4.72539e-01
   5.80000e-01        4.20000e-01        2.37361e-01        7.62639e-01       6.69520e+02        0.00000         2.36387e+00          2.03730        72.039      56.604     0.665575     6.06789e-01     5.03323e-01
   5.70000e-01        4.30000e-01        2.30033e-01        7.69967e-01       6.49504e+02        0.00000         2.28558e+00          2.00063        71.316      57.400     0.661091     6.07871e-01     5.37209e-01
   5.60000e-01        4.40000e-01        2.22905e-01        7.77095e-01       6.30429e+02        0.00000         2.20994e+00          1.96524        70.539      58.196     0.656400     6.08974e-01     5.74792e-01
   5.50000e-01        4.50000e-01        2.15970e-01        7.84030e-01       6.12233e+02        0.00000         2.13667e+00          1.93107        69.698      58.992     0.651459     6.10095e-01     6.16839e-01
   5.40000e-01        4.60000e-01        2.09220e-01        7.90780e-01       5.94860e+02        0.00000         2.06548e+00          1.89805        68.786      59.788     0.646220     6.11235e-01     6.64365e-01
   5.30000e-01        4.70000e-01        2.02647e-01        7.97353e-01       5.78262e+02        0.00000         1.99609e+00          1.86613        67.790      60.584     0.640617     6.12393e-01     7.18738e-01
   5.20000e-01        4.80000e-01        1.96244e-01        8.03756e-01       5.62401e+02        0.00000         1.92821e+00          1.83526        66.696      61.381     0.634568     6.13571e-01     7.81860e-01
   5.10000e-01        4.90000e-01        1.90006e-01        8.09994e-01       5.47242e+02        0.00000         1.86151e+00          1.80544        65.484      62.177     0.627963     6.14769e-01     8.56453e-01
   5.00000e-01        5.00000e-01        1.83925e-01        8.16075e-01       5.32760e+02        0.00000         1.79563e+00          1.77664        64.128      62.973     0.620650     6.15988e-01     9.46581e-01
   4.95824e-01        5.04176e-01        1.81431e-01        8.18569e-01       5.26908e+02        0.00000         1.76831e+00          1.76492        63.514      63.305     0.617352     6.16505e-01     9.90051e-01
   4.94944e-01        5.05056e-01        1.80909e-01        8.19091e-01       5.25688e+02        0.50000         1.76247e+00          1.76247        63.375      63.375     0.616614     6.16614e-01     1.00000e+00
END

$Env_BP << END
#                                                                              Sat Pres                                                                                     Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
   4.94944e-01          0.50506          1.80909e-01          0.81909          525.688          0.5000            1.76247           1.76247         63.375     63.3755     0.616614     0.616614     1.00000e+00
   4.94064e-01          0.50594          1.80388e-01          0.81961          524.475          1.0000            1.76004           1.75664         63.446     63.2355     0.616724     0.615869     9.89965e-01
   4.90000e-01          0.51000          1.77996e-01          0.82200          518.936          1.0000            1.74889           1.73011         63.769     62.5920     0.617232     0.612414     9.44647e-01
   4.80000e-01          0.52000          1.72214e-01          0.82779          505.762          1.0000            1.72222           1.66437         64.565     60.8264     0.618505     0.602939     8.31239e-01
   4.70000e-01          0.53000          1.66572e-01          0.83343          493.239          1.0000            1.69670           1.59765         65.361     58.7582     0.619811     0.591740     7.15034e-01
   4.60000e-01          0.54000          1.61066e-01          0.83893          481.389          1.0000            1.67247           1.52896         66.158     56.2852     0.621159     0.578068     5.94920e-01
   4.50000e-01          0.55000          1.55691e-01          0.84431          470.252          1.0000            1.64972           1.45745         66.954     53.2878     0.622561     0.560856     4.71105e-01
   4.40000e-01          0.56000          1.50442e-01          0.84956          459.891          1.0000            1.62871           1.38415         67.750     49.7570     0.624032     0.539277     3.49436e-01
   4.30000e-01          0.57000          1.45315e-01          0.85468          450.350          1.0000            1.60966           1.31550         68.546     46.1088     0.625584     0.514910     2.46008e-01
   4.20000e-01          0.58000          1.40306e-01          0.85969          441.578          1.0000            1.59249           1.25915         69.342     42.9936     0.627214     0.491838     1.73152e-01
   4.10000e-01          0.59000          1.35411e-01          0.86459          433.449          1.0000            1.57687           1.21542         70.138     40.5840     0.628904     0.472121     1.25871e-01
   4.00000e-01          0.60000          1.30625e-01          0.86937          425.836          1.0000            1.56245           1.18088         70.935     38.7210     0.630637     0.455480     9.46205e-02
   3.90000e-01          0.61000          1.25946e-01          0.87405          418.644          1.0000            1.54898           1.15264         71.731     37.2362     0.632397     0.441167     7.30277e-02
   3.80000e-01          0.62000          1.21369e-01          0.87863          411.802          1.0000            1.53626           1.12882         72.527     36.0152     0.634176     0.428585     5.74884e-02
   3.70000e-01          0.63000          1.16892e-01          0.88311          405.260          1.0000            1.52415           1.10825         73.323     34.9849     0.635965     0.417316     4.59384e-02
   3.60000e-01          0.64000          1.12511e-01          0.88749          398.981          1.0000            1.51256           1.09016         74.119     34.0973     0.637759     0.407069     3.71360e-02
   3.50000e-01          0.65000          1.08224e-01          0.89178          392.933          1.0000            1.50140           1.07403         74.915     33.3200     0.639556     0.397641     3.02956e-02
   3.40000e-01          0.66000          1.04026e-01          0.89597          387.092          1.0000            1.49062           1.05950         75.712     32.6302     0.641351     0.388883     2.48973e-02
   3.30000e-01          0.67000          9.99157e-02          0.90008          381.439          1.0000            1.48016           1.04629         76.508     32.0115     0.643141     0.380685     2.05841e-02
   3.20000e-01          0.68000          9.58900e-02          0.90411          375.957          1.0000            1.46999           1.03420         77.304     31.4516     0.644926     0.372961     1.71031e-02
   3.10000e-01          0.69000          9.19465e-02          0.90805          370.632          1.0000            1.46007           1.02306         78.100     30.9409     0.646704     0.365646     1.42702e-02
   3.00000e-01          0.70000          8.80826e-02          0.91192          365.453          1.0000            1.45038           1.01276         78.896     30.4723     0.648472     0.358687     1.19489e-02
   2.90000e-01          0.71000          8.42958e-02          0.91570          360.408          1.0000            1.44089           1.00319         79.692     30.0398     0.650231     0.352041     1.00356e-02
   2.80000e-01          0.72000          8.05840e-02          0.91942          355.490          1.0000            1.43157           0.99428         80.489     29.6387     0.651980     0.345673     8.45073e-03
   2.70000e-01          0.73000          7.69449e-02          0.92306          350.689          1.0000            1.42242           0.98594         81.285     29.2653     0.653717     0.339555     7.13241e-03
   2.60000e-01          0.74000          7.33764e-02          0.92662          346.000          1.0000            1.41341           0.97814         82.081     28.9164     0.655442     0.333662     6.03177e-03
   2.50000e-01          0.75000          6.98764e-02          0.93012          341.415          1.0000            1.40454           0.97081         82.877     28.5893     0.657155     0.327974     5.10996e-03
   2.40000e-01          0.76000          6.64431e-02          0.93356          336.930          1.0000            1.39579           0.96391         83.673     28.2816     0.658856     0.322473     4.33578e-03
   2.30000e-01          0.77000          6.30744e-02          0.93693          332.538          1.0000            1.38716           0.95741         84.469     27.9917     0.660543     0.317144     3.68402e-03
   2.20000e-01          0.78000          5.97687e-02          0.94023          328.236          1.0000            1.37862           0.95129         85.266     27.7177     0.662218     0.311974     3.13414e-03
   2.10000e-01          0.79000          5.65242e-02          0.94348          324.018          1.0000            1.37018           0.94550         86.062     27.4582     0.663879     0.306951     2.66934e-03
   2.00000e-01          0.80000          5.33391e-02          0.94666          319.882          1.0000            1.36182           0.94002         86.858     27.2121     0.665526     0.302065     2.27580e-03
   1.90000e-01          0.81000          5.02119e-02          0.94979          315.823          1.0000            1.35354           0.93484         87.654     26.9783     0.667160     0.297308     1.94209e-03
   1.80000e-01          0.82000          4.71410e-02          0.95286          311.839          1.0000            1.34534           0.92994         88.450     26.7557     0.668780     0.292671     1.65873e-03
   1.70000e-01          0.83000          4.41248e-02          0.95588          307.926          1.0000            1.33721           0.92529         89.246     26.5435     0.670386     0.288147     1.41783e-03
   1.60000e-01          0.84000          4.11621e-02          0.95884          304.081          1.0000            1.32913           0.92088         90.043     26.3411     0.671979     0.283730     1.21280e-03
   1.50000e-01          0.85000          3.82512e-02          0.96175          300.302          1.0000            1.32112           0.91670         90.839     26.1476     0.673558     0.279415     1.03814e-03
   1.40000e-01          0.86000          3.53909e-02          0.96461          296.587          1.0000            1.31315           0.91273         91.635     25.9626     0.675123     0.275195     8.89191e-04
   1.30000e-01          0.87000          3.25799e-02          0.96742          292.932          1.0000            1.30524           0.90897         92.431     25.7854     0.676674     0.271068     7.62075e-04
   1.20000e-01          0.88000          2.98170e-02          0.97018          289.336          1.0000            1.29738           0.90540         93.227     25.6156     0.678212     0.267027     6.53505e-04
   1.10000e-01          0.89000          2.71008e-02          0.97290          285.797          1.0000            1.28956           0.90200         94.023     25.4527     0.679736     0.263069     5.60708e-04
   1.00000e-01          0.90000          2.44302e-02          0.97557          282.313          1.0000            1.28177           0.89878         94.820     25.2963     0.681246     0.259191     4.81339e-04
   9.00000e-02          0.91000          2.18041e-02          0.97820          278.882          1.0000            1.27403           0.89573         95.616     25.1461     0.682743     0.255389     4.13411e-04
   8.00000e-02          0.92000          1.92214e-02          0.98078          275.503          1.0000            1.26632           0.89283         96.412     25.0018     0.684227     0.251661     3.55242e-04
   7.00000e-02          0.93000          1.66809e-02          0.98332          272.173          1.0000            1.25864           0.89007         97.208     24.8629     0.685697     0.248003     3.05400e-04
   6.00000e-02          0.94000          1.41818e-02          0.98582          268.892          1.0000            1.25099           0.88746         98.004     24.7292     0.687154     0.244413     2.62672e-04
   5.00000e-02          0.95000          1.17229e-02          0.98828          265.657          1.0000            1.24337           0.88498         98.800     24.6005     0.688598     0.240888     2.26023e-04
   4.00000e-02          0.96000          9.30338e-03          0.99070          262.468          1.0000            1.23577           0.88264         99.597     24.4765     0.690029     0.237427     1.94572e-04
   3.00000e-02          0.97000          6.92220e-03          0.99308          259.323          1.0000            1.22820           0.88041        100.393     24.3570     0.691447     0.234026     1.67570e-04
   2.00000e-02          0.98000          4.57849e-03          0.99542          256.221          1.0000            1.22065           0.87831        101.189     24.2418     0.692853     0.230685     1.44377e-04
   1.00000e-02          0.99000          2.27137e-03          0.99773          253.161          1.0000            1.21313           0.87631        101.985     24.1306     0.694245     0.227401     1.24446e-04
   5.00000e-03          0.99500          1.13127e-03          0.99887          251.646          1.0000            1.20937           0.87536        102.383     24.0765     0.694937     0.225779     1.15555e-04
   2.00000e-03          0.99800          4.51455e-04          0.99955          250.742          1.0000            1.20712           0.87480        102.622     24.0445     0.695351     0.224813     1.10534e-04
   1.00000e-03          0.99900          2.25553e-04          0.99977          250.441          1.0000            1.20637           0.87461        102.702     24.0339     0.695488     0.224492     1.08911e-04
   5.00000e-04          0.99950          1.12733e-04          0.99989          250.291          1.0000            1.20599           0.87452        102.741     24.0286     0.695557     0.224332     1.08108e-04
   2.00000e-04          0.99980          4.50826e-05          0.99995          250.201          1.0000            1.20577           0.87447        102.765     24.0255     0.695598     0.224236     1.07629e-04
   1.00000e-04          0.99990          2.25395e-05          0.99998          250.171          1.0000            1.20569           0.87445        102.773     24.0244     0.695612     0.224204     1.07470e-04
   5.00000e-05          0.99995          1.12693e-05          0.99999          250.156          1.0000            1.20565           0.87444        102.777     24.0239     0.695619     0.224188     1.07391e-04
   2.00000e-05          0.99998          4.50763e-06          1.00000          250.147          1.0000            1.20563           0.87443        102.780     24.0236     0.695623     0.224178     1.07343e-04
   1.00000e-05          0.99999          2.25380e-06          1.00000          250.144          1.0000            1.20562           0.87443        102.780     24.0235     0.695624     0.224175     1.07327e-04
   5.00000e-06          0.99999          1.12689e-06          1.00000          250.143          1.0000            1.20562           0.87443        102.781     24.0234     0.695625     0.224173     1.07319e-04
   2.00000e-06          1.00000          4.50756e-07          1.00000          250.142          1.0000            1.20562           0.87443        102.781     24.0234     0.695625     0.224172     1.07314e-04
   1.00000e-06          1.00000          2.25378e-07          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07313e-04
   5.00000e-07          1.00000          1.12689e-07          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07312e-04
   2.00000e-07          1.00000          4.50756e-08          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   1.00000e-07          1.00000          2.25378e-08          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   5.00000e-08          1.00000          1.12689e-08          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   2.00000e-08          1.00000          4.50756e-09          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   1.00000e-08          1.00000          2.25378e-09          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   5.00000e-09          1.00000          1.12689e-09          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   2.00000e-09          1.00000          4.50756e-10          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   1.00000e-09          1.00000          2.25378e-10          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   5.00000e-10          1.00000          1.12689e-10          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   2.00000e-10          1.00000          4.50756e-11          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   1.00000e-10          1.00000          2.25378e-11          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   5.00000e-11          1.00000          1.12689e-11          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   2.00000e-11          1.00000          4.50756e-12          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   1.00000e-11          1.00000          2.25378e-12          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   5.00000e-12          1.00000          1.12689e-12          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   2.00000e-12          1.00000          4.50756e-13          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   1.00000e-12          1.00000          2.25378e-13          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
   0.00000e+00          1.00000          0.00000e+00          1.00000          250.141          1.0000            1.20562           0.87443        102.781     24.0234     0.695626     0.224172     1.07311e-04
END

set output "Figures/Env_004_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:1.0e+03] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_004_P_vs_Wi_1.pdf"
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:1.0e+03] \
     $Env_DP using 3:5 with lines title "Dew Points", \
     $Env_BP using 3:5 with lines title "Bubble Points"

set output "Figures/Env_004_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_004_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (bar)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "P-T Diagram for Lab3_Surface_Oil"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   32.274     1.00000e-13        0.00000         2.54589e-15          1.00000       602.891     98.4676     0.932527     3.87753e-16     1.69650e-17
   32.500     1.04807e-13        0.00000         2.66642e-15          1.00000       602.891     98.4676     0.932485     4.06093e-16     1.77609e-17
   35.000     1.75425e-13        0.00000         4.42903e-15          1.00000       602.891     98.4676     0.932019     6.74199e-16     2.93728e-17
   37.500     2.90808e-13        0.00000         7.28676e-15          1.00000       602.891     98.4676     0.931549     1.10865e-15     4.81261e-17
   40.000     4.77578e-13        0.00000         1.18771e-14          1.00000       602.891     98.4676     0.931075     1.80614e-15     7.81406e-17
   42.500     7.77155e-13        0.00000         1.91842e-14          1.00000       602.891     98.4676     0.930597     2.91582e-15     1.25757e-16
   45.000     1.25342e-12        0.00000         3.07136e-14          1.00000       602.891     98.4676     0.930115     4.66576e-15     2.00652e-16
   47.500     2.00403e-12        0.00000         4.87492e-14          1.00000       602.891     98.4676     0.929629     7.40172e-15     3.17472e-16
   50.000     3.17708e-12        0.00000         7.67270e-14          1.00000       602.891     98.4676     0.929139     1.16435e-14     4.98205e-16
   52.500     4.99527e-12        0.00000         1.19774e-13          1.00000       602.891     98.4676     0.928646     1.81663e-14     7.75600e-16
   55.000     7.79080e-12        0.00000         1.85480e-13          1.00000       602.891     98.4676     0.928148     2.81170e-14     1.19806e-15
   57.500     1.20555e-11        0.00000         2.84995e-13          1.00000       602.891     98.4676     0.927646     4.31792e-14     1.83661e-15
   60.000     1.85117e-11        0.00000         4.34576e-13          1.00000       602.891     98.4676     0.927139     6.58060e-14     2.79466e-15
   62.500     2.82129e-11        0.00000         6.57749e-13          1.00000       602.891     98.4676     0.926629     9.95453e-14     4.22175e-15
   65.000     4.26843e-11        0.00000         9.88321e-13          1.00000       602.891     98.4676     0.926115     1.49492e-13     6.33259e-15
   67.500     6.41180e-11        0.00000         1.47453e-12          1.00000       602.890     98.4676     0.925596     2.22911e-13     9.43342e-15
   70.000     9.56438e-11        0.00000         2.18475e-12          1.00000       602.890     98.4676     0.925073     3.30090e-13     1.39581e-14
   72.500     1.41700e-10        0.00000         3.21520e-12          1.00000       602.890     98.4676     0.924546     4.85503e-13     2.05173e-14
   75.000     2.08538e-10        0.00000         4.70050e-12          1.00000       602.890     98.4676     0.924014     7.09379e-13     2.99652e-14
   77.500     3.04910e-10        0.00000         6.82771e-12          1.00000       602.890     98.4676     0.923478     1.02981e-12     4.34892e-14
   80.000     4.42988e-10        0.00000         9.85517e-12          1.00000       602.890     98.4676     0.922938     1.48557e-12     6.27300e-14
   82.500     6.39601e-10        0.00000         1.41375e-11          1.00000       602.890     98.4676     0.922393     2.12983e-12     8.99413e-14
   85.000     9.17876e-10        0.00000         2.01588e-11          1.00000       602.889     98.4676     0.921844     3.03514e-12     1.28201e-13
   87.500     1.30941e-09        0.00000         2.85756e-11          1.00000       602.889     98.4676     0.921290     4.29980e-12     1.81690e-13
   90.000     1.85712e-09        0.00000         4.02738e-11          1.00000       602.889     98.4676     0.920732     6.05637e-12     2.56053e-13
   92.500     2.61898e-09        0.00000         5.64420e-11          1.00000       602.888     98.4676     0.920169     8.48255e-12     3.58875e-13
   95.000     3.67290e-09        0.00000         7.86661e-11          1.00000       602.888     98.4676     0.919601     1.18153e-11     5.00293e-13
   97.500     5.12297e-09        0.00000         1.09051e-10          1.00000       602.888     98.4676     0.919029     1.63688e-11     6.93782e-13
  100.000     7.10755e-09        0.00000         1.50377e-10          1.00000       602.887     98.4676     0.918452     2.25578e-11     9.57169e-13
  102.500     9.80967e-09        0.00000         2.06296e-10          1.00000       602.887     98.4676     0.917871     3.09265e-11     1.31392e-12
  105.000     1.34702e-08        0.00000         2.81583e-10          1.00000       602.886     98.4676     0.917284     4.21860e-11     1.79479e-12
  107.500     1.84045e-08        0.00000         3.82450e-10          1.00000       602.885     98.4676     0.916693     5.72607e-11     2.43985e-12
  110.000     2.50236e-08        0.00000         5.16940e-10          1.00000       602.884     98.4676     0.916097     7.73465e-11     3.30114e-12
  112.500     3.38609e-08        0.00000         6.95420e-10          1.00000       602.884     98.4676     0.915496     1.03983e-10     4.44590e-12
  115.000     4.56047e-08        0.00000         9.31194e-10          1.00000       602.883     98.4676     0.914890     1.39146e-10     5.96062e-12
  117.500     6.11404e-08        0.00000         1.24125e-09          1.00000       602.881     98.4676     0.914279     1.85353e-10     7.95610e-12
  120.000     8.16007e-08        0.00000         1.64720e-09          1.00000       602.880     98.4676     0.913663     2.45807e-10     1.05737e-11
  122.500     1.08429e-07        0.00000         2.17641e-09          1.00000       602.879     98.4676     0.913042     3.24560e-10     1.39928e-11
  125.000     1.43458e-07        0.00000         2.86339e-09          1.00000       602.877     98.4676     0.912415     4.26714e-10     1.84407e-11
  127.500     1.89002e-07        0.00000         3.75148e-09          1.00000       602.876     98.4676     0.911784     5.58677e-10     2.42035e-11
  130.000     2.47975e-07        0.00000         4.89492e-09          1.00000       602.874     98.4676     0.911147     7.28452e-10     3.16406e-11
  132.500     3.24031e-07        0.00000         6.36126e-09          1.00000       602.872     98.4676     0.910505     9.46006e-10     4.12013e-11
  135.000     4.21731e-07        0.00000         8.23438e-09          1.00000       602.870     98.4676     0.909858     1.22370e-09     5.34453e-11
  137.500     5.46750e-07        0.00000         1.06180e-08          1.00000       602.867     98.4676     0.909206     1.57680e-09     6.90676e-11
  140.000     7.06124e-07        0.00000         1.36399e-08          1.00000       602.864     98.4676     0.908547     2.02410e-09     8.89279e-11
  142.500     9.08539e-07        0.00000         1.74570e-08          1.00000       602.861     98.4676     0.907884     2.58866e-09     1.14086e-10
  145.000     1.16468e-06        0.00000         2.22611e-08          1.00000       602.858     98.4676     0.907215     3.29864e-09     1.45842e-10
  147.500     1.48766e-06        0.00000         2.82862e-08          1.00000       602.855     98.4676     0.906540     4.18835e-09     1.85792e-10
  150.000     1.89349e-06        0.00000         3.58166e-08          1.00000       602.851     98.4676     0.905860     5.29943e-09     2.35879e-10
  152.500     2.40168e-06        0.00000         4.51963e-08          1.00000       602.846     98.4676     0.905174     6.68223e-09     2.98469e-10
  155.000     3.03589e-06        0.00000         5.68407e-08          1.00000       602.842     98.4676     0.904482     8.39749e-09     3.76429e-10
  157.500     3.82477e-06        0.00000         7.12494e-08          1.00000       602.837     98.4676     0.903784     1.05182e-08     4.73227e-10
  160.000     4.80285e-06        0.00000         8.90217e-08          1.00000       602.831     98.4676     0.903081     1.31317e-08     5.93040e-10
  162.500     6.01167e-06        0.00000         1.10874e-07          1.00000       602.825     98.4676     0.902372     1.63424e-08     7.40888e-10
  165.000     7.50098e-06        0.00000         1.37660e-07          1.00000       602.819     98.4676     0.901656     2.02747e-08     9.22784e-10
  167.500     9.33025e-06        0.00000         1.70394e-07          1.00000       602.812     98.4676     0.900935     2.50760e-08     1.14591e-09
  170.000     1.15703e-05        0.00000         2.10279e-07          1.00000       602.804     98.4676     0.900207     3.09211e-08     1.41883e-09
  172.500     1.43054e-05        0.00000         2.58734e-07          1.00000       602.796     98.4676     0.899474     3.80159e-08     1.75170e-09
  175.000     1.76351e-05        0.00000         3.17434e-07          1.00000       602.787     98.4676     0.898734     4.66030e-08     2.15656e-09
  177.500     2.16772e-05        0.00000         3.88344e-07          1.00000       602.778     98.4676     0.897987     5.69671e-08     2.64765e-09
  180.000     2.65705e-05        0.00000         4.73769e-07          1.00000       602.768     98.4676     0.897235     6.94411e-08     3.24173e-09
  182.500     3.24778e-05        0.00000         5.76400e-07          1.00000       602.757     98.4676     0.896476     8.44140e-08     3.95851e-09
  185.000     3.95901e-05        0.00000         6.99376e-07          1.00000       602.745     98.4676     0.895710     1.02338e-07     4.82110e-09
  187.500     4.81305e-05        0.00000         8.46343e-07          1.00000       602.732     98.4676     0.894938     1.23740e-07     5.85653e-09
  190.000     5.83591e-05        0.00000         1.02153e-06          1.00000       602.718     98.4676     0.894159     1.49227e-07     7.09635e-09
  192.500     7.05782e-05        0.00000         1.22984e-06          1.00000       602.703     98.4676     0.893374     1.79503e-07     8.57726e-09
  195.000     8.51386e-05        0.00000         1.47690e-06          1.00000       602.688     98.4676     0.892581     2.15378e-07     1.03419e-08
  197.500     1.02446e-04        0.00000         1.76923e-06          1.00000       602.671     98.4676     0.891782     2.57785e-07     1.24397e-08
  200.000     1.22969e-04        0.00000         2.11428e-06          1.00000       602.653     98.4676     0.890976     3.07791e-07     1.49277e-08
  202.500     1.47246e-04        0.00000         2.52061e-06          1.00000       602.633     98.4676     0.890162     3.66620e-07     1.78718e-08
  205.000     1.75897e-04        0.00000         2.99799e-06          1.00000       602.612     98.4676     0.889342     4.35668e-07     2.13479e-08
  207.500     2.09633e-04        0.00000         3.55758e-06          1.00000       602.590     98.4676     0.888514     5.16525e-07     2.54429e-08
  210.000     2.49265e-04        0.00000         4.21206e-06          1.00000       602.567     98.4676     0.887679     6.10999e-07     3.02569e-08
  212.500     2.95720e-04        0.00000         4.97585e-06          1.00000       602.542     98.4676     0.886837     7.21139e-07     3.59038e-08
  215.000     3.50055e-04        0.00000         5.86528e-06          1.00000       602.515     98.4676     0.885987     8.49267e-07     4.25141e-08
  217.500     4.13467e-04        0.00000         6.89882e-06          0.99999       602.486     98.4676     0.885130     9.98000e-07     5.02363e-08
  220.000     4.87317e-04        0.00000         8.09732e-06          0.99999       602.456     98.4676     0.884264     1.17029e-06     5.92391e-08
  222.500     5.73143e-04        0.00000         9.48425e-06          0.99999       602.424     98.4676     0.883391     1.36946e-06     6.97143e-08
  225.000     6.72684e-04        0.00000         1.10860e-05          0.99999       602.390     98.4676     0.882511     1.59924e-06     8.18787e-08
  227.500     7.87897e-04        0.00000         1.29321e-05          0.99999       602.353     98.4676     0.881622     1.86380e-06     9.59779e-08
  230.000     9.20986e-04        0.00000         1.50558e-05          0.99999       602.315     98.4676     0.880725     2.16780e-06     1.12289e-07
  232.500     1.07442e-03        0.00000         1.74941e-05          0.99999       602.274     98.4676     0.879820     2.51647e-06     1.31124e-07
  235.000     1.25098e-03        0.00000         2.02883e-05          0.99998       602.231     98.4676     0.878906     2.91558e-06     1.52833e-07
  237.500     1.45376e-03        0.00000         2.34844e-05          0.99998       602.185     98.4676     0.877985     3.37161e-06     1.77811e-07
  240.000     1.68622e-03        0.00000         2.71334e-05          0.99998       602.136     98.4676     0.877054     3.89169e-06     2.06500e-07
  242.500     1.95222e-03        0.00000         3.12921e-05          0.99998       602.085     98.4676     0.876115     4.48376e-06     2.39394e-07
  245.000     2.25604e-03        0.00000         3.60234e-05          0.99997       602.031     98.4676     0.875167     5.15658e-06     2.77044e-07
  247.500     2.60245e-03        0.00000         4.13965e-05          0.99997       601.973     98.4676     0.874211     5.91982e-06     3.20068e-07
  250.000     2.99673e-03        0.00000         4.74881e-05          0.99997       601.913     98.4676     0.873245     6.78416e-06     3.69151e-07
  252.500     3.44473e-03        0.00000         5.43827e-05          0.99996       601.849     98.4676     0.872270     7.76130e-06     4.25055e-07
  255.000     3.95290e-03        0.00000         6.21731e-05          0.99996       601.782     98.4676     0.871286     8.86414e-06     4.88629e-07
  257.500     4.52836e-03        0.00000         7.09612e-05          0.99995       601.710     98.4676     0.870292     1.01068e-05     5.60811e-07
  260.000     5.17896e-03        0.00000         8.08590e-05          0.99994       601.636     98.4676     0.869289     1.15047e-05     6.42642e-07
  262.500     5.91331e-03        0.00000         9.19887e-05          0.99994       601.557     98.4676     0.868276     1.30748e-05     7.35270e-07
  265.000     6.74090e-03        0.00000         1.04484e-04          0.99993       601.474     98.4676     0.867253     1.48356e-05     8.39967e-07
  267.500     7.67208e-03        0.00000         1.18492e-04          0.99992       601.386     98.4676     0.866220     1.68070e-05     9.58131e-07
  270.000     8.71822e-03        0.00000         1.34170e-04          0.99991       601.294     98.4676     0.865177     1.90110e-05     1.09130e-06
  272.500     9.89173e-03        0.00000         1.51693e-04          0.99990       601.197     98.4676     0.864123     2.14714e-05     1.24118e-06
  275.000     1.12062e-02        0.00000         1.71248e-04          0.99989       601.096     98.4676     0.863059     2.42138e-05     1.40963e-06
  277.500     1.26762e-02        0.00000         1.93040e-04          0.99988       600.989     98.4676     0.861984     2.72663e-05     1.59868e-06
  280.000     1.43181e-02        0.00000         2.17290e-04          0.99986       600.877     98.4676     0.860898     3.06591e-05     1.81058e-06
  282.500     1.61490e-02        0.00000         2.44238e-04          0.99985       600.759     98.4676     0.859802     3.44247e-05     2.04778e-06
  285.000     1.81881e-02        0.00000         2.74142e-04          0.99983       600.635     98.4676     0.858694     3.85984e-05     2.31295e-06
  287.500     2.04559e-02        0.00000         3.07282e-04          0.99982       600.505     98.4676     0.857574     4.32181e-05     2.60902e-06
  290.000     2.29745e-02        0.00000         3.43959e-04          0.99980       600.369     98.4676     0.856443     4.83247e-05     2.93919e-06
  292.500     2.57679e-02        0.00000         3.84498e-04          0.99977       600.227     98.4676     0.855300     5.39620e-05     3.30692e-06
  295.000     2.88621e-02        0.00000         4.29246e-04          0.99975       600.077     98.4676     0.854145     6.01773e-05     3.71600e-06
  297.500     3.22851e-02        0.00000         4.78579e-04          0.99973       599.921     98.4676     0.852978     6.70209e-05     4.17055e-06
  300.000     3.60668e-02        0.00000         5.32898e-04          0.99970       599.757     98.4676     0.851798     7.45470e-05     4.67503e-06
  302.500     4.02398e-02        0.00000         5.92634e-04          0.99967       599.585     98.4676     0.850605     8.28135e-05     5.23431e-06
  305.000     4.48389e-02        0.00000         6.58247e-04          0.99964       599.406     98.4676     0.849399     9.18822e-05     5.85365e-06
  307.500     4.99012e-02        0.00000         7.30229e-04          0.99960       599.218     98.4676     0.848181     1.01819e-04     6.53875e-06
  310.000     5.54670e-02        0.00000         8.09107e-04          0.99956       599.021     98.4676     0.846948     1.12695e-04     7.29578e-06
  312.500     6.15792e-02        0.00000         8.95441e-04          0.99952       598.816     98.4676     0.845702     1.24584e-04     8.13143e-06
  315.000     6.82835e-02        0.00000         9.89830e-04          0.99948       598.601     98.4676     0.844442     1.37567e-04     9.05293e-06
  317.500     7.56290e-02        0.00000         1.09291e-03          0.99943       598.376     98.4676     0.843167     1.51728e-04     1.00681e-05
  320.000     8.36682e-02        0.00000         1.20536e-03          0.99938       598.141     98.4676     0.841878     1.67157e-04     1.11853e-05
  322.500     9.24570e-02        0.00000         1.32790e-03          0.99933       597.896     98.4676     0.840574     1.83950e-04     1.24137e-05
  325.000     1.02055e-01        0.00000         1.46128e-03          0.99927       597.640     98.4676     0.839255     2.02209e-04     1.37630e-05
  327.500     1.12525e-01        0.00000         1.60634e-03          0.99920       597.373     98.4676     0.837921     2.22041e-04     1.52439e-05
  330.000     1.23935e-01        0.00000         1.76391e-03          0.99914       597.094     98.4676     0.836570     2.43559e-04     1.68676e-05
  332.500     1.36358e-01        0.00000         1.93492e-03          0.99906       596.803     98.4676     0.835203     2.66885e-04     1.86465e-05
  335.000     1.49868e-01        0.00000         2.12032e-03          0.99899       596.499     98.4676     0.833820     2.92144e-04     2.05937e-05
  337.500     1.64547e-01        0.00000         2.32113e-03          0.99890       596.182     98.4676     0.832420     3.19472e-04     2.27233e-05
  340.000     1.80481e-01        0.00000         2.53843e-03          0.99882       595.852     98.4676     0.831002     3.49010e-04     2.50506e-05
  342.500     1.97760e-01        0.00000         2.77336e-03          0.99872       595.507     98.4676     0.829567     3.80908e-04     2.75920e-05
  345.000     2.16482e-01        0.00000         3.02711e-03          0.99862       595.147     98.4676     0.828114     4.15323e-04     3.03651e-05
  347.500     2.36748e-01        0.00000         3.30095e-03          0.99852       594.773     98.4676     0.826643     4.52423e-04     3.33886e-05
  350.000     2.58667e-01        0.00000         3.59622e-03          0.99840       594.382     98.4676     0.825152     4.92382e-04     3.66830e-05
  352.500     2.82352e-01        0.00000         3.91431e-03          0.99828       593.975     98.4676     0.823642     5.35384e-04     4.02699e-05
  355.000     3.07925e-01        0.00000         4.25671e-03          0.99816       593.551     98.4676     0.822113     5.81624e-04     4.41727e-05
  357.500     3.35512e-01        0.00000         4.62496e-03          0.99802       593.109     98.4676     0.820563     6.31305e-04     4.84165e-05
  360.000     3.65249e-01        0.00000         5.02072e-03          0.99788       592.649     98.4676     0.818992     6.84644e-04     5.30283e-05
  362.500     3.97278e-01        0.00000         5.44570e-03          0.99773       592.170     98.4676     0.817400     7.41865e-04     5.80368e-05
  365.000     4.31749e-01        0.00000         5.90172e-03          0.99757       591.670     98.4676     0.815786     8.03206e-04     6.34732e-05
  367.500     4.68821e-01        0.00000         6.39066e-03          0.99740       591.150     98.4676     0.814150     8.68916e-04     6.93706e-05
  370.000     5.08661e-01        0.00000         6.91454e-03          0.99722       590.609     98.4676     0.812491     9.39259e-04     7.57648e-05
  372.500     5.51444e-01        0.00000         7.47545e-03          0.99703       590.045     98.4676     0.810808     1.01451e-03     8.26941e-05
  375.000     5.97358e-01        0.00000         8.07561e-03          0.99683       589.458     98.4676     0.809101     1.09496e-03     9.01997e-05
  377.500     6.46597e-01        0.00000         8.71731e-03          0.99662       588.847     98.4676     0.807369     1.18091e-03     9.83258e-05
  380.000     6.99369e-01        0.00000         9.40300e-03          0.99640       588.211     98.4676     0.805612     1.27268e-03     1.07120e-04
  382.500     7.55891e-01        0.00000         1.01352e-02          0.99617       587.548     98.4676     0.803828     1.37061e-03     1.16633e-04
  385.000     8.16393e-01        0.00000         1.09167e-02          0.99592       586.859     98.4676     0.802017     1.47505e-03     1.26920e-04
  387.500     8.81117e-01        0.00000         1.17501e-02          0.99567       586.141     98.4676     0.800179     1.58638e-03     1.38040e-04
  390.000     9.50318e-01        0.00000         1.26386e-02          0.99540       585.394     98.4676     0.798312     1.70498e-03     1.50057e-04
  392.500     1.02427e+00        0.00000         1.35851e-02          0.99511       584.616     98.4676     0.796416     1.83127e-03     1.63038e-04
  395.000     1.10325e+00        0.00000         1.45930e-02          0.99482       583.807     98.4676     0.794489     1.96569e-03     1.77058e-04
  397.500     1.18756e+00        0.00000         1.56657e-02          0.99451       582.964     98.4676     0.792532     2.10867e-03     1.92196e-04
  400.000     1.27751e+00        0.00000         1.68067e-02          0.99418       582.086     98.4676     0.790542     2.26072e-03     2.08538e-04
  402.500     1.37345e+00        0.00000         1.80199e-02          0.99384       581.173     98.4676     0.788519     2.42234e-03     2.26176e-04
  405.000     1.47573e+00        0.00000         1.93091e-02          0.99348       580.221     98.4676     0.786461     2.59406e-03     2.45211e-04
  407.500     1.58471e+00        0.00000         2.06787e-02          0.99311       579.231     98.4676     0.784369     2.77644e-03     2.65749e-04
  410.000     1.70080e+00        0.00000         2.21330e-02          0.99272       578.199     98.4676     0.782239     2.97009e-03     2.87909e-04
  412.500     1.82441e+00        0.00000         2.36767e-02          0.99231       577.125     98.4676     0.780073     3.17564e-03     3.11818e-04
  415.000     1.95599e+00        0.00000         2.53146e-02          0.99189       576.006     98.4676     0.777866     3.39376e-03     3.37612e-04
  417.500     2.09600e+00        0.00000         2.70519e-02          0.99144       574.840     98.4676     0.775620     3.62516e-03     3.65441e-04
  420.000     2.24495e+00        0.00000         2.88941e-02          0.99098       573.625     98.4676     0.773331     3.87058e-03     3.95469e-04
  422.500     2.40337e+00        0.00000         3.08468e-02          0.99049       572.359     98.4676     0.770999     4.13084e-03     4.27870e-04
  425.000     2.57182e+00        0.00000         3.29162e-02          0.98999       571.039     98.4676     0.768622     4.40678e-03     4.62839e-04
  427.500     2.75089e+00        0.00000         3.51087e-02          0.98946       569.663     98.4676     0.766199     4.69931e-03     5.00586e-04
  430.000     2.94124e+00        0.00000         3.74312e-02          0.98891       568.228     98.4676     0.763726     5.00939e-03     5.41341e-04
  432.500     3.14354e+00        0.00000         3.98908e-02          0.98834       566.732     98.4676     0.761203     5.33807e-03     5.85356e-04
  435.000     3.35853e+00        0.00000         4.24953e-02          0.98774       565.170     98.4676     0.758627     5.68644e-03     6.32908e-04
  437.500     3.58699e+00        0.00000         4.52528e-02          0.98712       563.540     98.4676     0.755996     6.05569e-03     6.84301e-04
  440.000     3.82975e+00        0.00000         4.81720e-02          0.98647       561.838     98.4676     0.753307     6.44709e-03     7.39870e-04
  442.500     4.08774e+00        0.00000         5.12622e-02          0.98580       560.060     98.4676     0.750559     6.86203e-03     7.99986e-04
  445.000     4.36190e+00        0.00000         5.45335e-02          0.98510       558.202     98.4676     0.747748     7.30197e-03     8.65056e-04
  447.500     4.65331e+00        0.00000         5.79963e-02          0.98437       556.261     98.4676     0.744871     7.76852e-03     9.35536e-04
  450.000     4.96308e+00        0.00000         6.16621e-02          0.98361       554.230     98.4676     0.741926     8.26340e-03     1.01193e-03
  452.500     5.29246e+00        0.00000         6.55432e-02          0.98282       552.105     98.4676     0.738907     8.78851e-03     1.09480e-03
  455.000     5.64279e+00        0.00000         6.96528e-02          0.98200       549.880     98.4676     0.735813     9.34590e-03     1.18478e-03
  457.500     6.01552e+00        0.00000         7.40053e-02          0.98114       547.549     98.4676     0.732639     9.93780e-03     1.28256e-03
  460.000     6.41226e+00        0.00000         7.86161e-02          0.98025       545.105     98.4676     0.729379     1.05667e-02     1.38895e-03
  462.500     6.83477e+00        0.50000         9.79328e-01          0.97933        98.468     98.4676     0.011235     1.12353e-02     1.00000e+00
  465.000     7.28497e+00        0.00000         8.86815e-02          0.97836       539.851     98.4676     0.722586     1.19465e-02     1.63126e-03
  467.500     7.76501e+00        0.00000         9.41747e-02          0.97736       537.023     98.4676     0.719040     1.27038e-02     1.76935e-03
  470.000     8.27727e+00        0.00000         1.00004e-01          0.97631       534.049     98.4676     0.715387     1.35108e-02     1.92045e-03
  472.500     8.82440e+00        0.00000         1.06193e-01          0.97522       530.917     98.4676     0.711619     1.43716e-02     2.08608e-03
  475.000     9.40938e+00        0.00000         1.12769e-01          0.97409       527.617     98.4676     0.707727     1.52909e-02     2.26799e-03
  477.500     1.00356e+01        0.00000         1.19763e-01          0.97290       524.134     98.4676     0.703702     1.62741e-02     2.46825e-03
  480.000     1.07068e+01        0.00000         1.27209e-01          0.97166       520.452     98.4676     0.699533     1.73270e-02     2.68925e-03
  482.500     1.14275e+01        0.00000         1.35144e-01          0.97037       516.555     98.4676     0.695209     1.84566e-02     2.93383e-03
  485.000     1.22026e+01        0.00000         1.43612e-01          0.96902       512.423     98.4676     0.690716     1.96708e-02     3.20535e-03
  487.500     1.30380e+01        0.00000         1.52663e-01          0.96760       508.033     98.4676     0.686037     2.09791e-02     3.50785e-03
  490.000     1.39405e+01        0.00000         1.62356e-01          0.96612       503.358     98.4676     0.681153     2.23923e-02     3.84624e-03
  492.500     1.49185e+01        0.00000         1.72757e-01          0.96456       498.366     98.4676     0.676041     2.39235e-02     4.22653e-03
  495.000     1.59817e+01        0.00000         1.83948e-01          0.96292       493.021     98.4676     0.670676     2.55885e-02     4.65621e-03
  497.500     1.71422e+01        0.00000         1.96025e-01          0.96120       487.276     98.4676     0.665023     2.74067e-02     5.14473e-03
  500.000     1.84149e+01        0.00000         2.09108e-01          0.95937       481.075     98.4676     0.659042     2.94021e-02     5.70427e-03
  502.500     1.98189e+01        0.00000         2.23344e-01          0.95743       474.348     98.4676     0.652680     3.16058e-02     6.35083e-03
  505.000     2.13790e+01        0.00000         2.38927e-01          0.95536       467.003     98.4676     0.645871     3.40579e-02     7.10606e-03
  507.500     2.31289e+01        0.00000         2.56109e-01          0.95314       458.919     98.4676     0.638522     3.68130e-02     8.00020e-03
  510.000     2.51155e+01        0.00000         2.75243e-01          0.95074       449.927     98.4676     0.630507     3.99480e-02     9.07734e-03
  512.500     2.74090e+01        0.00000         2.96844e-01          0.94812       439.778     98.4676     0.621635     4.35774e-02     1.04055e-02
  515.000     3.01216e+01        0.00000         3.21726e-01          0.94520       428.077     98.4676     0.611604     4.78857e-02     1.20981e-02
  517.500     3.34561e+01        0.00000         3.51340e-01          0.94186       414.120     98.4676     0.599867     5.32064e-02     1.43687e-02
  520.000     3.78609e+01        0.00000         3.88846e-01          0.93784       396.367     98.4676     0.585223     6.02789e-02     1.77096e-02
  522.500     4.49356e+01        0.00000         4.45358e-01          0.93220       369.386     98.4676     0.563386     7.17497e-02     2.39688e-02
  523.336     4.96443e+01        0.00000         4.80515e-01          0.92894       352.422     98.4676     0.549812     7.94627e-02     2.88117e-02
  523.634     5.48465e+01        0.00000         5.17169e-01          0.92576       334.560     98.4676     0.535569     8.80582e-02     3.48654e-02
  523.634     5.48848e+01        0.00000         5.17431e-01          0.92574       334.432     98.4676     0.535467     8.81218e-02     3.49129e-02
  523.362     6.01395e+01        0.00000         5.52202e-01          0.92294       317.296     98.4676     0.521794     9.68841e-02     4.18642e-02
  522.500     6.58973e+01        0.00000         5.87843e-01          0.92033       299.513     98.4676     0.507535     1.06577e-01     5.05523e-02
  520.000     7.53543e+01        0.00000         6.41148e-01          0.91697       272.443     98.4676     0.485551     1.22703e-01     6.76303e-02
  517.500     8.21290e+01        0.00000         6.75622e-01          0.91524       254.587     98.4676     0.470772     1.34411e-01     8.23756e-02
  515.000     8.78210e+01        0.00000         7.02371e-01          0.91420       240.514     98.4676     0.458912     1.44346e-01     9.66637e-02
  512.500     9.28785e+01        0.00000         7.24551e-01          0.91359       228.686     98.4676     0.448769     1.53248e-01     1.11016e-01
  510.000     9.75041e+01        0.00000         7.43603e-01          0.91326       218.398     98.4676     0.439797     1.61451e-01     1.25676e-01
  507.500     1.01810e+02        0.00000         7.60337e-01          0.91317       209.257     98.4676     0.431692     1.69139e-01     1.40790e-01
  505.000     1.05866e+02        0.00000         7.75261e-01          0.91326       201.013     98.4676     0.424265     1.76425e-01     1.56458e-01
  502.500     1.09720e+02        0.00000         7.88723e-01          0.91350       193.499     98.4676     0.417388     1.83388e-01     1.72760e-01
  500.000     1.13404e+02        0.00000         8.00971e-01          0.91387       186.593     98.4676     0.410970     1.90080e-01     1.89764e-01
  497.500     1.16943e+02        0.00000         8.12191e-01          0.91436       180.205     98.4676     0.404942     1.96544e-01     2.07528e-01
  495.000     1.20357e+02        0.00000         8.22527e-01          0.91495       174.263     98.4676     0.399252     2.02808e-01     2.26111e-01
  492.500     1.23660e+02        0.00000         8.32094e-01          0.91564       168.713     98.4676     0.393860     2.08899e-01     2.45566e-01
  490.000     1.26864e+02        0.00000         8.40982e-01          0.91640       163.509     98.4676     0.388733     2.14834e-01     2.65949e-01
  487.500     1.29979e+02        0.00000         8.49268e-01          0.91725       158.614     98.4676     0.383842     2.20629e-01     2.87315e-01
  485.000     1.33013e+02        0.00000         8.57016e-01          0.91816       153.997     98.4676     0.379165     2.26298e-01     3.09717e-01
  482.500     1.35972e+02        0.00000         8.64279e-01          0.91914       149.632     98.4676     0.374683     2.31851e-01     3.33215e-01
  480.000     1.38863e+02        0.00000         8.71103e-01          0.92018       145.495     98.4676     0.370381     2.37297e-01     3.57867e-01
  477.500     1.41690e+02        0.00000         8.77528e-01          0.92127       141.567     98.4676     0.366242     2.42645e-01     3.83733e-01
  475.000     1.44458e+02        0.00000         8.83588e-01          0.92243       137.832     98.4676     0.362256     2.47902e-01     4.10879e-01
  472.500     1.47169e+02        0.00000         8.89313e-01          0.92363       134.273     98.4676     0.358412     2.53073e-01     4.39369e-01
  470.000     1.49829e+02        0.00000         8.94730e-01          0.92488       130.878     98.4676     0.354700     2.58163e-01     4.69274e-01
  467.500     1.52439e+02        0.00000         8.99862e-01          0.92617       127.636     98.4676     0.351112     2.63177e-01     5.00666e-01
  465.000     1.55001e+02        0.00000         9.04730e-01          0.92752       124.535     98.4676     0.347639     2.68120e-01     5.33622e-01
  462.500     1.57519e+02        0.00000         9.09354e-01          0.92890       121.566     98.4676     0.344276     2.72995e-01     5.68222e-01
  460.000     1.59994e+02        0.00000         9.13749e-01          0.93032       118.720     98.4676     0.341016     2.77805e-01     6.04550e-01
  457.500     1.62429e+02        0.00000         9.17932e-01          0.93178       115.990     98.4676     0.337854     2.82553e-01     6.42694e-01
  455.000     1.64824e+02        0.00000         9.21917e-01          0.93328       113.368     98.4676     0.334784     2.87242e-01     6.82748e-01
  452.500     1.67181e+02        0.00000         9.25715e-01          0.93481       110.849     98.4676     0.331802     2.91874e-01     7.24809e-01
  450.000     1.69501e+02        0.00000         9.29338e-01          0.93637       108.426     98.4676     0.328904     2.96452e-01     7.68982e-01
  447.500     1.71786e+02        0.00000         9.32798e-01          0.93797       106.094     98.4676     0.326086     3.00977e-01     8.15374e-01
  445.000     1.74038e+02        0.00000         9.36102e-01          0.93960       103.847     98.4676     0.323344     3.05452e-01     8.64101e-01
  442.500     1.76256e+02        0.00000         9.39261e-01          0.94126       101.682     98.4676     0.320674     3.09879e-01     9.15285e-01
  440.000     1.78442e+02        0.00000         9.42282e-01          0.94295        99.593     98.4676     0.318075     3.14257e-01     9.69052e-01
  439.056     1.79259e+02        0.00000         9.43389e-01          0.94360        98.824     98.4676     0.317112     3.15899e-01     9.90049e-01
  438.615     1.79639e+02        0.50000         9.43899e-01          0.94390        98.468     98.4676     0.316664     3.16664e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   16.946     1.89264e+02        0.00000         1.39920e+00          1.05108       142.829     98.4676     0.800993     7.35108e-01     2.99231e-01
   16.945     1.94354e+02        0.00000         1.43579e+00          1.07852       142.790     98.4676     0.801360     7.35671e-01     2.98896e-01
   17.308     2.87116e+02        0.00000         2.09090e+00          1.57199       141.947     98.4676     0.807106     7.44704e-01     2.95769e-01
   18.564     4.24150e+02        0.00000         3.02355e+00          2.28045       140.674     98.4676     0.813626     7.55092e-01     2.96161e-01
   20.910     6.26589e+02        0.00000         4.34310e+00          3.29158       139.139     98.4676     0.821033     7.66657e-01     2.99942e-01
   24.429     9.25647e+02        0.00000         6.20459e+00          4.72858       137.533     98.4676     0.829287     7.79063e-01     3.06595e-01
   29.043     1.36744e+03        0.00000         8.83201e+00          6.76802       136.011     98.4676     0.838115     7.91810e-01     3.15413e-01
   34.503     2.02009e+03        0.00000         1.25538e+01          9.66843       134.648     98.4676     0.847034     8.04291e-01     3.25671e-01
   40.412     2.98424e+03        0.00000         1.78571e+01         13.81452       133.460     98.4676     0.855490     8.15895e-01     3.35157e-01
   46.306     4.40856e+03        0.00000         2.54702e+01         19.78327       132.433     98.4676     0.863012     8.26128e-01     3.44340e-01
   51.759     6.51268e+03        0.00000         3.64831e+01         28.43972       131.555     98.4676     0.869321     8.34702e-01     3.53039e-01
   56.475     9.62106e+03        0.00000         5.25245e+01         41.07493       130.821     98.4676     0.874349     8.41560e-01     3.60826e-01
   60.321     1.42130e+04        0.00000         7.60158e+01         59.60630       130.227     98.4676     0.878191     8.46827e-01     3.67411e-01
   63.310     2.09966e+04        0.00000         1.10545e+02         86.87153       129.762     98.4676     0.881031     8.50741e-01     3.72556e-01
   65.546     3.10178e+04        0.00000         1.61414e+02        127.06321       129.412     98.4676     0.883079     8.53574e-01     3.76211e-01
   67.170     4.58220e+04        0.00000         2.36457e+02        186.37245       129.155     98.4676     0.884527     8.55587e-01     3.78929e-01
   68.326     6.76920e+04        0.00000         3.47238e+02        273.94135       128.971     98.4676     0.885539     8.56995e-01     3.80896e-01
   69.136     1.00000e+05        0.00000         5.10835e+02        403.27134       128.841     98.4676     0.886238     8.57971e-01     3.82290e-01
END

$Env_BP << END
#   Temp      Sat Pres                                                                                     Liq Den      Gas Den           
#   (C)         (bar)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   ----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
  462.500       6.8348         0.5000            0.97933           0.97933        98.4676     98.4676     0.011235     0.011235     1.00000e+00
      NaN          NaN            NaN                NaN               NaN            NaN         NaN          NaN          NaN             NaN
  438.615     179.6394         0.5000            0.94390           0.94390        98.4676     98.4676     0.316664     0.316664     1.00000e+00
  438.173     180.0191         1.0000            0.94420           0.94441        98.4676     98.1132     0.317428     0.316217     9.90048e-01
  437.500     180.5965         1.0000            0.94467           0.94517        98.4676     97.5775     0.318591     0.315542     9.75098e-01
  435.000     182.7207         1.0000            0.94641           0.94794        98.4676     95.6312     0.322880     0.313074     9.21757e-01
  432.500     184.8152         1.0000            0.94819           0.95059        98.4676     93.7509     0.327125     0.310667     8.71654e-01
  430.000     186.8806         1.0000            0.94998           0.95313        98.4676     91.9332     0.331329     0.308319     8.24556e-01
  427.500     188.9176         1.0000            0.95181           0.95557        98.4676     90.1752     0.335492     0.306029     7.80248e-01
  425.000     190.9267         1.0000            0.95365           0.95790        98.4676     88.4742     0.339616     0.303794     7.38536e-01
  422.500     192.9085         1.0000            0.95552           0.96014        98.4676     86.8275     0.343700     0.301611     6.99242e-01
  420.000     194.8636         1.0000            0.95741           0.96229        98.4676     85.2327     0.347747     0.299481     6.62201e-01
  417.500     196.7922         1.0000            0.95933           0.96435        98.4676     83.6875     0.351757     0.297399     6.27264e-01
  415.000     198.6950         1.0000            0.96126           0.96633        98.4676     82.1896     0.355731     0.295366     5.94292e-01
  412.500     200.5722         1.0000            0.96322           0.96823        98.4676     80.7372     0.359669     0.293378     5.63159e-01
  410.000     202.4244         1.0000            0.96519           0.97006        98.4676     79.3283     0.363573     0.291436     5.33748e-01
  407.500     204.2517         1.0000            0.96719           0.97181        98.4676     77.9610     0.367443     0.289537     5.05950e-01
  405.000     206.0546         1.0000            0.96920           0.97349        98.4676     76.6337     0.371280     0.287681     4.79666e-01
  402.500     207.8333         1.0000            0.97123           0.97511        98.4676     75.3447     0.375084     0.285865     4.54802e-01
  400.000     209.5881         1.0000            0.97328           0.97666        98.4676     74.0926     0.378856     0.284088     4.31273e-01
  397.500     211.3193         1.0000            0.97535           0.97815        98.4676     72.8758     0.382597     0.282351     4.08998e-01
  395.000     213.0271         1.0000            0.97743           0.97957        98.4676     71.6930     0.386307     0.280650     3.87904e-01
  392.500     214.7118         1.0000            0.97953           0.98095        98.4676     70.5429     0.389987     0.278986     3.67922e-01
  390.000     216.3736         1.0000            0.98165           0.98226        98.4676     69.4242     0.393637     0.277358     3.48987e-01
  387.500     218.0126         1.0000            0.98378           0.98353        98.4676     68.3358     0.397257     0.275764     3.31040e-01
  385.000     219.6291         1.0000            0.98592           0.98474        98.4676     67.2765     0.400849     0.274203     3.14024e-01
  382.500     221.2232         1.0000            0.98808           0.98591        98.4676     66.2454     0.404412     0.272675     2.97887e-01
  380.000     222.7951         1.0000            0.99026           0.98702        98.4676     65.2413     0.407948     0.271178     2.82580e-01
  377.500     224.3449         1.0000            0.99244           0.98809        98.4676     64.2633     0.411455     0.269713     2.68058e-01
  375.000     225.8727         1.0000            0.99464           0.98911        98.4676     63.3105     0.414936     0.268277     2.54277e-01
  372.500     227.3787         1.0000            0.99685           0.99009        98.4676     62.3820     0.418390     0.266871     2.41198e-01
  370.000     228.8630         1.0000            0.99908           0.99103        98.4676     61.4769     0.421817     0.265494     2.28782e-01
  367.500     230.3257         1.0000            1.00131           0.99193        98.4676     60.5945     0.425219     0.264144     2.16995e-01
  365.000     231.7669         1.0000            1.00356           0.99278        98.4676     59.7340     0.428595     0.262822     2.05803e-01
  362.500     233.1867         1.0000            1.00581           0.99360        98.4676     58.8947     0.431945     0.261527     1.95174e-01
  360.000     234.5851         1.0000            1.00808           0.99438        98.4676     58.0758     0.435271     0.260257     1.85080e-01
  357.500     235.9623         1.0000            1.01035           0.99512        98.4676     57.2766     0.438572     0.259013     1.75492e-01
  355.000     237.3182         1.0000            1.01264           0.99583        98.4676     56.4966     0.441848     0.257794     1.66385e-01
  352.500     238.6530         1.0000            1.01493           0.99650        98.4676     55.7352     0.445100     0.256599     1.57733e-01
  350.000     239.9667         1.0000            1.01723           0.99713        98.4676     54.9916     0.448329     0.255427     1.49514e-01
  347.500     241.2593         1.0000            1.01954           0.99774        98.4676     54.2654     0.451534     0.254279     1.41705e-01
  345.000     242.5310         1.0000            1.02186           0.99831        98.4676     53.5560     0.454716     0.253154     1.34286e-01
  342.500     243.7816         1.0000            1.02419           0.99884        98.4676     52.8629     0.457876     0.252050     1.27237e-01
  340.000     245.0112         1.0000            1.02652           0.99935        98.4676     52.1856     0.461012     0.250969     1.20540e-01
  337.500     246.2200         1.0000            1.02886           0.99982        98.4676     51.5236     0.464126     0.249908     1.14177e-01
  335.000     247.4077         1.0000            1.03120           1.00026        98.4676     50.8764     0.467218     0.248869     1.08132e-01
  332.500     248.5746         1.0000            1.03355           1.00068        98.4676     50.2436     0.470288     0.247849     1.02389e-01
  330.000     249.7205         1.0000            1.03590           1.00106        98.4676     49.6248     0.473337     0.246850     9.69322e-02
  327.500     250.8456         1.0000            1.03826           1.00142        98.4676     49.0195     0.476364     0.245870     9.17488e-02
  325.000     251.9497         1.0000            1.04062           1.00174        98.4676     48.4274     0.479369     0.244909     8.68249e-02
  322.500     253.0329         1.0000            1.04299           1.00204        98.4676     47.8480     0.482354     0.243968     8.21480e-02
  320.000     254.0951         1.0000            1.04536           1.00231        98.4676     47.2811     0.485319     0.243044     7.77059e-02
  317.500     255.1363         1.0000            1.04773           1.00255        98.4676     46.7261     0.488262     0.242138     7.34872e-02
  315.000     256.1566         1.0000            1.05010           1.00276        98.4676     46.1829     0.491186     0.241250     6.94812e-02
  312.500     257.1559         1.0000            1.05248           1.00294        98.4676     45.6510     0.494089     0.240380     6.56775e-02
  310.000     258.1341         1.0000            1.05485           1.00310        98.4676     45.1302     0.496972     0.239526     6.20663e-02
  307.500     259.0912         1.0000            1.05723           1.00323        98.4676     44.6202     0.499836     0.238689     5.86384e-02
  305.000     260.0272         1.0000            1.05961           1.00334        98.4676     44.1205     0.502680     0.237869     5.53849e-02
  302.500     260.9420         1.0000            1.06199           1.00342        98.4676     43.6311     0.505505     0.237064     5.22973e-02
  300.000     261.8357         1.0000            1.06436           1.00347        98.4676     43.1515     0.508311     0.236275     4.93677e-02
  297.500     262.7080         1.0000            1.06674           1.00350        98.4676     42.6816     0.511098     0.235502     4.65885e-02
  295.000     263.5591         1.0000            1.06911           1.00350        98.4676     42.2210     0.513866     0.234744     4.39525e-02
  292.500     264.3888         1.0000            1.07149           1.00347        98.4676     41.7695     0.516616     0.234000     4.14526e-02
  290.000     265.1970         1.0000            1.07386           1.00342        98.4676     41.3269     0.519347     0.233271     3.90825e-02
  287.500     265.9838         1.0000            1.07622           1.00334        98.4676     40.8929     0.522060     0.232557     3.68357e-02
  285.000     266.7490         1.0000            1.07859           1.00323        98.4676     40.4673     0.524755     0.231857     3.47064e-02
  282.500     267.4925         1.0000            1.08094           1.00310        98.4676     40.0500     0.527432     0.231171     3.26889e-02
  280.000     268.2144         1.0000            1.08330           1.00295        98.4676     39.6406     0.530092     0.230498     3.07777e-02
  277.500     268.9144         1.0000            1.08564           1.00277        98.4676     39.2390     0.532734     0.229839     2.89677e-02
  275.000     269.5927         1.0000            1.08799           1.00256        98.4676     38.8450     0.535358     0.229192     2.72541e-02
  272.500     270.2489         1.0000            1.09032           1.00232        98.4676     38.4584     0.537966     0.228559     2.56320e-02
  270.000     270.8831         1.0000            1.09265           1.00206        98.4676     38.0790     0.540556     0.227939     2.40971e-02
  267.500     271.4952         1.0000            1.09497           1.00178        98.4676     37.7066     0.543129     0.227331     2.26450e-02
  265.000     272.0851         1.0000            1.09728           1.00146        98.4676     37.3411     0.545686     0.226735     2.12717e-02
  262.500     272.6527         1.0000            1.09958           1.00112        98.4676     36.9822     0.548226     0.226152     1.99734e-02
  260.000     273.1978         1.0000            1.10188           1.00076        98.4676     36.6299     0.550750     0.225581     1.87463e-02
  257.500     273.7205         1.0000            1.10416           1.00036        98.4676     36.2840     0.553257     0.225021     1.75869e-02
  255.000     274.2205         1.0000            1.10643           0.99994        98.4676     35.9443     0.555748     0.224473     1.64919e-02
  252.500     274.6978         1.0000            1.10869           0.99949        98.4676     35.6107     0.558223     0.223936     1.54580e-02
  250.000     275.1522         1.0000            1.11094           0.99902        98.4676     35.2830     0.560682     0.223411     1.44822e-02
  247.500     275.5837         1.0000            1.11317           0.99852        98.4676     34.9611     0.563126     0.222896     1.35615e-02
  245.000     275.9922         1.0000            1.11539           0.99799        98.4676     34.6448     0.565554     0.222393     1.26932e-02
  242.500     276.3774         1.0000            1.11759           0.99743        98.4676     34.3341     0.567966     0.221900     1.18746e-02
  240.000     276.7393         1.0000            1.11978           0.99684        98.4676     34.0287     0.570363     0.221418     1.11032e-02
  237.500     277.0778         1.0000            1.12196           0.99622        98.4676     33.7287     0.572745     0.220946     1.03766e-02
  235.000     277.3927         1.0000            1.12411           0.99558        98.4676     33.4338     0.575112     0.220485     9.69240e-03
  232.500     277.6839         1.0000            1.12625           0.99490        98.4676     33.1439     0.577463     0.220034     9.04846e-03
  230.000     277.9512         1.0000            1.12837           0.99420        98.4676     32.8590     0.579800     0.219593     8.44267e-03
  227.500     278.1946         1.0000            1.13047           0.99346        98.4676     32.5789     0.582122     0.219162     7.87305e-03
  225.000     278.4138         1.0000            1.13255           0.99270        98.4676     32.3035     0.584430     0.218740     7.33768e-03
  222.500     278.6088         1.0000            1.13461           0.99190        98.4676     32.0327     0.586723     0.218328     6.83475e-03
  220.000     278.7793         1.0000            1.13664           0.99108        98.4676     31.7664     0.589002     0.217926     6.36251e-03
  217.500     278.9253         1.0000            1.13865           0.99022        98.4676     31.5045     0.591267     0.217533     5.91934e-03
  215.000     279.0465         1.0000            1.14064           0.98932        98.4676     31.2470     0.593517     0.217149     5.50364e-03
  212.500     279.1428         1.0000            1.14260           0.98840        98.4676     30.9937     0.595753     0.216775     5.11393e-03
  210.000     279.2141         1.0000            1.14454           0.98744        98.4676     30.7445     0.597976     0.216410     4.74878e-03
  207.500     279.2602         1.0000            1.14645           0.98645        98.4676     30.4994     0.600185     0.216053     4.40683e-03
  205.000     279.2809         1.0000            1.14833           0.98543        98.4676     30.2582     0.602380     0.215706     4.08679e-03
  202.500     279.2760         1.0000            1.15018           0.98437        98.4676     30.0209     0.604561     0.215367     3.78742e-03
  200.000     279.2454         1.0000            1.15200           0.98327        98.4676     29.7875     0.606730     0.215037     3.50757e-03
  197.500     279.1888         1.0000            1.15378           0.98214        98.4676     29.5578     0.608884     0.214715     3.24611e-03
  195.000     279.1062         1.0000            1.15554           0.98098        98.4676     29.3317     0.611026     0.214402     3.00199e-03
  192.500     278.9973         1.0000            1.15726           0.97977        98.4676     29.1092     0.613154     0.214097     2.77421e-03
  190.000     278.8618         1.0000            1.15894           0.97853        98.4676     28.8902     0.615270     0.213801     2.56180e-03
  187.500     278.6998         1.0000            1.16059           0.97725        98.4676     28.6746     0.617372     0.213513     2.36386e-03
  185.000     278.5108         1.0000            1.16220           0.97593        98.4676     28.4625     0.619462     0.213233     2.17954e-03
  182.500     278.2948         1.0000            1.16376           0.97457        98.4676     28.2536     0.621539     0.212961     2.00800e-03
  180.000     278.0515         1.0000            1.16529           0.97317        98.4676     28.0480     0.623603     0.212697     1.84849e-03
  177.500     277.7807         1.0000            1.16677           0.97173        98.4676     27.8456     0.625655     0.212441     1.70026e-03
  175.000     277.4822         1.0000            1.16821           0.97025        98.4676     27.6463     0.627695     0.212193     1.56261e-03
  172.500     277.1558         1.0000            1.16961           0.96873        98.4676     27.4500     0.629722     0.211952     1.43489e-03
  170.000     276.8013         1.0000            1.17096           0.96716        98.4676     27.2568     0.631737     0.211719     1.31647e-03
  167.500     276.4184         1.0000            1.17225           0.96554        98.4676     27.0665     0.633739     0.211494     1.20676e-03
  165.000     276.0069         1.0000            1.17350           0.96389        98.4676     26.8791     0.635730     0.211277     1.10520e-03
  162.500     275.5665         1.0000            1.17470           0.96218        98.4676     26.6945     0.637709     0.211067     1.01126e-03
  160.000     275.0971         1.0000            1.17584           0.96043        98.4676     26.5128     0.639676     0.210864     9.24442e-04
  157.500     274.5984         1.0000            1.17692           0.95863        98.4676     26.3337     0.641631     0.210669     8.44275e-04
  155.000     274.0701         1.0000            1.17795           0.95678        98.4676     26.1574     0.643574     0.210481     7.70314e-04
  152.500     273.5120         1.0000            1.17892           0.95488        98.4676     25.9837     0.645506     0.210300     7.02138e-04
  150.000     272.9238         1.0000            1.17982           0.95293        98.4676     25.8126     0.647426     0.210127     6.39351e-04
  147.500     272.3053         1.0000            1.18066           0.95093        98.4676     25.6440     0.649335     0.209961     5.81581e-04
  145.000     271.6562         1.0000            1.18144           0.94888        98.4676     25.4780     0.651233     0.209801     5.28478e-04
  142.500     270.9762         1.0000            1.18214           0.94677        98.4676     25.3144     0.653119     0.209649     4.79710e-04
  140.000     270.2651         1.0000            1.18278           0.94460        98.4676     25.1532     0.654995     0.209504     4.34969e-04
  137.500     269.5226         1.0000            1.18334           0.94238        98.4676     24.9944     0.656859     0.209366     3.93963e-04
  135.000     268.7483         1.0000            1.18383           0.94010        98.4676     24.8379     0.658712     0.209234     3.56418e-04
  132.500     267.9421         1.0000            1.18424           0.93776        98.4676     24.6838     0.660554     0.209110     3.22079e-04
  130.000     267.1035         1.0000            1.18457           0.93536        98.4676     24.5318     0.662386     0.208992     2.90705e-04
  127.500     266.2324         1.0000            1.18482           0.93290        98.4676     24.3821     0.664206     0.208881     2.62072e-04
  125.000     265.3283         1.0000            1.18498           0.93038        98.4676     24.2346     0.666017     0.208776     2.35968e-04
  122.500     264.3911         1.0000            1.18505           0.92779        98.4676     24.0892     0.667816     0.208678     2.12199e-04
  120.000     263.4202         1.0000            1.18504           0.92513        98.4676     23.9460     0.669605     0.208587     1.90579e-04
  117.500     262.4156         1.0000            1.18492           0.92240        98.4676     23.8048     0.671384     0.208502     1.70939e-04
  115.000     261.3767         1.0000            1.18471           0.91961        98.4676     23.6656     0.673152     0.208424     1.53118e-04
  112.500     260.3033         1.0000            1.18440           0.91675        98.4676     23.5285     0.674910     0.208352     1.36968e-04
  110.000     259.1950         1.0000            1.18399           0.91381        98.4676     23.3933     0.676657     0.208286     1.22351e-04
  107.500     258.0515         1.0000            1.18347           0.91080        98.4676     23.2600     0.678395     0.208226     1.09138e-04
  105.000     256.8724         1.0000            1.18284           0.90771        98.4676     23.1287     0.680123     0.208173     9.72109e-05
  102.500     255.6574         1.0000            1.18209           0.90454        98.4676     22.9992     0.681840     0.208126     8.64586e-05
  100.000     254.4061         1.0000            1.18123           0.90129        98.4676     22.8716     0.683548     0.208085     7.67787e-05
   97.500     253.1180         1.0000            1.18024           0.89797        98.4676     22.7458     0.685246     0.208050     6.80768e-05
   95.000     251.7930         1.0000            1.17913           0.89455        98.4676     22.6218     0.686934     0.208020     6.02654e-05
   92.500     250.4304         1.0000            1.17789           0.89105        98.4676     22.4996     0.688612     0.207997     5.32636e-05
   90.000     249.0301         1.0000            1.17652           0.88747        98.4676     22.3790     0.690281     0.207980     4.69971e-05
   87.500     247.5914         1.0000            1.17501           0.88379        98.4676     22.2602     0.691940     0.207968     4.13973e-05
   85.000     246.1141         1.0000            1.17335           0.88002        98.4676     22.1431     0.693590     0.207962     3.64013e-05
   82.500     244.5977         1.0000            1.17155           0.87615        98.4676     22.0276     0.695231     0.207961     3.19513e-05
   80.000     243.0418         1.0000            1.16959           0.87219        98.4676     21.9137     0.696862     0.207966     2.79941e-05
   77.500     241.4460         1.0000            1.16748           0.86813        98.4676     21.8014     0.698483     0.207977     2.44811e-05
   75.000     239.8098         1.0000            1.16520           0.86396        98.4676     21.6907     0.700096     0.207992     2.13680e-05
   72.500     238.1327         1.0000            1.16276           0.85969        98.4676     21.5816     0.701699     0.208013     1.86142e-05
   70.000     236.4143         1.0000            1.16014           0.85531        98.4676     21.4739     0.703294     0.208039     1.61826e-05
   67.500     234.6542         1.0000            1.15735           0.85082        98.4676     21.3678     0.704879     0.208070     1.40397e-05
   65.000     232.8518         1.0000            1.15437           0.84621        98.4676     21.2631     0.706456     0.208105     1.21547e-05
   62.500     231.0067         1.0000            1.15120           0.84149        98.4676     21.1599     0.708023     0.208146     1.05000e-05
   60.000     229.1183         1.0000            1.14783           0.83665        98.4676     21.0581     0.709582     0.208191     9.05028e-06
   57.500     227.1862         1.0000            1.14425           0.83168        98.4676     20.9577     0.711132     0.208240     7.78287e-06
   55.000     225.2099         1.0000            1.14047           0.82659        98.4676     20.8587     0.712674     0.208294     6.67721e-06
   52.500     223.1887         1.0000            1.13647           0.82137        98.4676     20.7611     0.714206     0.208352     5.71477e-06
   50.000     221.1223         1.0000            1.13224           0.81601        98.4676     20.6648     0.715730     0.208414     4.87890e-06
   47.500     219.0100         1.0000            1.12778           0.81052        98.4676     20.5698     0.717246     0.208480     4.15463e-06
   45.000     216.8513         1.0000            1.12308           0.80489        98.4676     20.4760     0.718753     0.208549     3.52857e-06
   42.500     214.6456         1.0000            1.11813           0.79911        98.4676     20.3836     0.720252     0.208622     2.98873e-06
   40.000     212.3923         1.0000            1.11292           0.79318        98.4676     20.2924     0.721743     0.208697     2.52442e-06
   37.500     210.0909         1.0000            1.10744           0.78709        98.4676     20.2025     0.723225     0.208776     2.12610e-06
   35.000     207.7407         1.0000            1.10169           0.78085        98.4676     20.1137     0.724700     0.208857     1.78532e-06
   32.500     205.3411         1.0000            1.09566           0.77445        98.4676     20.0261     0.726166     0.208941     1.49457e-06
   30.000     202.8915         1.0000            1.08933           0.76788        98.4676     19.9398     0.727624     0.209026     1.24721e-06
   27.500     200.3913         1.0000            1.08269           0.76113        98.4676     19.8545     0.729074     0.209114     1.03739e-06
   25.000     197.8398         1.0000            1.07574           0.75421        98.4676     19.7704     0.730516     0.209202     8.59954e-07
   22.500     195.2363         1.0000            1.06847           0.74711        98.4676     19.6873     0.731950     0.209291     7.10370e-07
   20.000     192.5802         1.0000            1.06085           0.73982        98.4676     19.6054     0.733376     0.209381     5.84679e-07
   17.500     189.8707         1.0000            1.05289           0.73234        98.4676     19.5245     0.734794     0.209470     4.79418e-07
   16.946     189.2631         1.0000            1.05107           0.73065        98.4676     19.5067     0.735108     0.209490     4.58550e-07
END

set output "Figures/Env_005_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:5.0e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_005_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "P-X Diagram for Lab3_Surface_Oil\n with Lab3_Swelling_Gas at 95.5 C "
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   1.00000e-12        1.00000e+00        2.33504e-13        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   2.00000e-12        1.00000e+00        4.67009e-13        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   5.00000e-12        1.00000e+00        1.16752e-12        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   1.00000e-11        1.00000e+00        2.33504e-12        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   2.00000e-11        1.00000e+00        4.67009e-12        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   5.00000e-11        1.00000e+00        1.16752e-11        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   1.00000e-10        1.00000e+00        2.33504e-11        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   2.00000e-10        1.00000e+00        4.67009e-11        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   5.00000e-10        1.00000e+00        1.16752e-10        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   1.00000e-09        1.00000e+00        2.33504e-10        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   2.00000e-09        1.00000e+00        4.67009e-10        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   5.00000e-09        1.00000e+00        1.16752e-09        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   1.00000e-08        1.00000e+00        2.33504e-09        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   2.00000e-08        1.00000e+00        4.67009e-09        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   5.00000e-08        1.00000e+00        1.16752e-08        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   1.00000e-07        1.00000e+00        2.33504e-08        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   2.00000e-07        1.00000e+00        4.67009e-08        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   5.00000e-07        1.00000e+00        1.16752e-07        1.00000e+00       3.92735e-09        0.00000         8.40121e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   1.00000e-06        9.99999e-01        2.33505e-07        1.00000e+00       3.92735e-09        0.00000         8.40122e-11         1.00000        602.888     98.4676     0.919487     1.26167e-11     5.34324e-13
   2.00000e-06        9.99998e-01        4.67010e-07        1.00000e+00       3.92736e-09        0.00000         8.40123e-11         1.00000        602.888     98.4675     0.919487     1.26167e-11     5.34324e-13
   5.00000e-06        9.99995e-01        1.16753e-06        9.99999e-01       3.92737e-09        0.00000         8.40125e-11         1.00000        602.888     98.4673     0.919487     1.26167e-11     5.34324e-13
   1.00000e-05        9.99990e-01        2.33506e-06        9.99998e-01       3.92739e-09        0.00000         8.40129e-11         1.00000        602.888     98.4669     0.919487     1.26167e-11     5.34324e-13
   2.00000e-05        9.99980e-01        4.67016e-06        9.99995e-01       3.92743e-09        0.00000         8.40138e-11         1.00000        602.888     98.4661     0.919487     1.26167e-11     5.34324e-13
   5.00000e-05        9.99950e-01        1.16757e-05        9.99988e-01       3.92754e-09        0.00000         8.40163e-11         1.00000        602.888     98.4639     0.919487     1.26168e-11     5.34324e-13
   1.00000e-04        9.99900e-01        2.33522e-05        9.99977e-01       3.92774e-09        0.00000         8.40205e-11         1.00000        602.888     98.4601     0.919487     1.26170e-11     5.34324e-13
   2.00000e-04        9.99800e-01        4.67081e-05        9.99953e-01       3.92813e-09        0.00000         8.40289e-11         1.00000        602.888     98.4525     0.919487     1.26172e-11     5.34324e-13
   5.00000e-04        9.99500e-01        1.16797e-04        9.99883e-01       3.92931e-09        0.00000         8.40541e-11         1.00000        602.888     98.4299     0.919487     1.26181e-11     5.34324e-13
   1.00000e-03        9.99000e-01        2.33684e-04        9.99766e-01       3.93128e-09        0.00000         8.40962e-11         1.00000        602.888     98.3922     0.919487     1.26196e-11     5.34324e-13
   2.00000e-03        9.98000e-01        4.67726e-04        9.99532e-01       3.93522e-09        0.00000         8.41804e-11         1.00000        602.888     98.3167     0.919487     1.26226e-11     5.34324e-13
   5.00000e-03        9.95000e-01        1.17201e-03        9.98828e-01       3.94708e-09        0.00000         8.44343e-11         1.00000        602.888     98.0903     0.919487     1.26315e-11     5.34324e-13
   1.00000e-02        9.90000e-01        2.35308e-03        9.97647e-01       3.96702e-09        0.00000         8.48607e-11         1.00000        602.888     97.7129     0.919487     1.26464e-11     5.34324e-13
   2.00000e-02        9.80000e-01        4.74280e-03        9.95257e-01       4.00750e-09        0.00000         8.57266e-11         1.00000        602.888     96.9581     0.919487     1.26768e-11     5.34324e-13
   3.00000e-02        9.70000e-01        7.17001e-03        9.92830e-01       4.04881e-09        0.00000         8.66104e-11         1.00000        602.888     96.2034     0.919487     1.27078e-11     5.34324e-13
   4.00000e-02        9.60000e-01        9.63560e-03        9.90364e-01       4.09099e-09        0.00000         8.75126e-11         1.00000        602.888     95.4486     0.919487     1.27394e-11     5.34324e-13
   5.00000e-02        9.50000e-01        1.21405e-02        9.87859e-01       4.13405e-09        0.00000         8.84338e-11         1.00000        602.888     94.6939     0.919487     1.27717e-11     5.34324e-13
   6.00000e-02        9.40000e-01        1.46857e-02        9.85314e-01       4.17803e-09        0.00000         8.93746e-11         1.00000        602.888     93.9391     0.919487     1.28047e-11     5.34324e-13
   7.00000e-02        9.30000e-01        1.72720e-02        9.82728e-01       4.22295e-09        0.00000         9.03356e-11         1.00000        602.888     93.1844     0.919487     1.28384e-11     5.34324e-13
   8.00000e-02        9.20000e-01        1.99007e-02        9.80099e-01       4.26886e-09        0.00000         9.13175e-11         1.00000        602.888     92.4296     0.919487     1.28728e-11     5.34324e-13
   9.00000e-02        9.10000e-01        2.25726e-02        9.77427e-01       4.31577e-09        0.00000         9.23210e-11         1.00000        602.888     91.6749     0.919487     1.29080e-11     5.34324e-13
   1.00000e-01        9.00000e-01        2.52888e-02        9.74711e-01       4.36372e-09        0.00000         9.33468e-11         1.00000        602.888     90.9201     0.919487     1.29440e-11     5.34324e-13
   1.10000e-01        8.90000e-01        2.80506e-02        9.71949e-01       4.41275e-09        0.00000         9.43956e-11         1.00000        602.888     90.1654     0.919487     1.29808e-11     5.34324e-13
   1.20000e-01        8.80000e-01        3.08589e-02        9.69141e-01       4.46289e-09        0.00000         9.54683e-11         1.00000        602.888     89.4106     0.919487     1.30184e-11     5.34324e-13
   1.30000e-01        8.70000e-01        3.37151e-02        9.66285e-01       4.51419e-09        0.00000         9.65656e-11         1.00000        602.888     88.6559     0.919487     1.30569e-11     5.34324e-13
   1.40000e-01        8.60000e-01        3.66203e-02        9.63380e-01       4.56668e-09        0.00000         9.76885e-11         1.00000        602.888     87.9011     0.919487     1.30962e-11     5.34324e-13
   1.50000e-01        8.50000e-01        3.95759e-02        9.60424e-01       4.62041e-09        0.00000         9.88377e-11         1.00000        602.888     87.1464     0.919487     1.31365e-11     5.34324e-13
   1.60000e-01        8.40000e-01        4.25831e-02        9.57417e-01       4.67541e-09        0.00000         1.00014e-10         1.00000        602.888     86.3916     0.919487     1.31778e-11     5.34324e-13
   1.70000e-01        8.30000e-01        4.56433e-02        9.54357e-01       4.73174e-09        0.00000         1.01219e-10         1.00000        602.888     85.6369     0.919487     1.32201e-11     5.34324e-13
   1.80000e-01        8.20000e-01        4.87579e-02        9.51242e-01       4.78945e-09        0.00000         1.02454e-10         1.00000        602.888     84.8821     0.919487     1.32634e-11     5.34324e-13
   1.90000e-01        8.10000e-01        5.19284e-02        9.48072e-01       4.84858e-09        0.00000         1.03719e-10         1.00000        602.888     84.1274     0.919487     1.33077e-11     5.34324e-13
   2.00000e-01        8.00000e-01        5.51563e-02        9.44844e-01       4.90918e-09        0.00000         1.05015e-10         1.00000        602.888     83.3726     0.919487     1.33532e-11     5.34324e-13
   2.10000e-01        7.90000e-01        5.84432e-02        9.41557e-01       4.97133e-09        0.00000         1.06344e-10         1.00000        602.888     82.6179     0.919487     1.33998e-11     5.34324e-13
   2.20000e-01        7.80000e-01        6.17907e-02        9.38209e-01       5.03506e-09        0.00000         1.07708e-10         1.00000        602.888     81.8631     0.919487     1.34476e-11     5.34324e-13
   2.30000e-01        7.70000e-01        6.52005e-02        9.34800e-01       5.10045e-09        0.00000         1.09107e-10         1.00000        602.888     81.1084     0.919487     1.34966e-11     5.34324e-13
   2.40000e-01        7.60000e-01        6.86743e-02        9.31326e-01       5.16756e-09        0.00000         1.10542e-10         1.00000        602.888     80.3536     0.919487     1.35470e-11     5.34324e-13
   2.50000e-01        7.50000e-01        7.22141e-02        9.27786e-01       5.23646e-09        0.00000         1.12016e-10         1.00000        602.888     79.5989     0.919487     1.35987e-11     5.34324e-13
   2.60000e-01        7.40000e-01        7.58215e-02        9.24178e-01       5.30723e-09        0.00000         1.13530e-10         1.00000        602.888     78.8441     0.919487     1.36518e-11     5.34324e-13
   2.70000e-01        7.30000e-01        7.94988e-02        9.20501e-01       5.37993e-09        0.00000         1.15085e-10         1.00000        602.888     78.0894     0.919487     1.37063e-11     5.34324e-13
   2.80000e-01        7.20000e-01        8.32478e-02        9.16752e-01       5.45465e-09        0.00000         1.16683e-10         1.00000        602.888     77.3346     0.919487     1.37623e-11     5.34324e-13
   2.90000e-01        7.10000e-01        8.70707e-02        9.12929e-01       5.53148e-09        0.00000         1.18327e-10         1.00000        602.888     76.5799     0.919487     1.38200e-11     5.34324e-13
   3.00000e-01        7.00000e-01        9.09697e-02        9.09030e-01       5.61050e-09        0.00000         1.20017e-10         1.00000        602.888     75.8251     0.919487     1.38793e-11     5.34324e-13
   3.10000e-01        6.90000e-01        9.49471e-02        9.05053e-01       5.69181e-09        0.00000         1.21757e-10         1.00000        602.888     75.0704     0.919487     1.39402e-11     5.34324e-13
   3.20000e-01        6.80000e-01        9.90053e-02        9.00995e-01       5.77551e-09        0.00000         1.23547e-10         1.00000        602.888     74.3156     0.919487     1.40030e-11     5.34324e-13
   3.30000e-01        6.70000e-01        1.03147e-01        8.96853e-01       5.86171e-09        0.00000         1.25391e-10         1.00000        602.888     73.5609     0.919487     1.40677e-11     5.34324e-13
   3.40000e-01        6.60000e-01        1.07374e-01        8.92626e-01       5.95053e-09        0.00000         1.27291e-10         1.00000        602.888     72.8061     0.919487     1.41343e-11     5.34324e-13
   3.50000e-01        6.50000e-01        1.11690e-01        8.88310e-01       6.04207e-09        0.00000         1.29249e-10         1.00000        602.888     72.0514     0.919487     1.42030e-11     5.34324e-13
   3.60000e-01        6.40000e-01        1.16097e-01        8.83903e-01       6.13648e-09        0.00000         1.31269e-10         1.00000        602.888     71.2966     0.919487     1.42738e-11     5.34324e-13
   3.70000e-01        6.30000e-01        1.20599e-01        8.79401e-01       6.23388e-09        0.00000         1.33353e-10         1.00000        602.888     70.5419     0.919487     1.43469e-11     5.34324e-13
   3.80000e-01        6.20000e-01        1.25198e-01        8.74802e-01       6.33443e-09        0.00000         1.35503e-10         1.00000        602.888     69.7871     0.919487     1.44223e-11     5.34324e-13
   3.90000e-01        6.10000e-01        1.29897e-01        8.70103e-01       6.43827e-09        0.00000         1.37725e-10         1.00000        602.888     69.0324     0.919487     1.45002e-11     5.34324e-13
   4.00000e-01        6.00000e-01        1.34701e-01        8.65299e-01       6.54558e-09        0.00000         1.40020e-10         1.00000        602.888     68.2776     0.919487     1.45807e-11     5.34324e-13
   4.10000e-01        5.90000e-01        1.39612e-01        8.60388e-01       6.65652e-09        0.00000         1.42393e-10         1.00000        602.888     67.5229     0.919487     1.46639e-11     5.34324e-13
   4.20000e-01        5.80000e-01        1.44633e-01        8.55367e-01       6.77129e-09        0.00000         1.44848e-10         1.00000        602.888     66.7681     0.919487     1.47500e-11     5.34324e-13
   4.30000e-01        5.70000e-01        1.49770e-01        8.50230e-01       6.89008e-09        0.00000         1.47390e-10         1.00000        602.888     66.0134     0.919487     1.48391e-11     5.34324e-13
   4.40000e-01        5.60000e-01        1.55026e-01        8.44974e-01       7.01312e-09        0.00000         1.50022e-10         1.00000        602.888     65.2586     0.919487     1.49314e-11     5.34324e-13
   4.50000e-01        5.50000e-01        1.60404e-01        8.39596e-01       7.14063e-09        0.00000         1.52749e-10         1.00000        602.888     64.5039     0.919487     1.50271e-11     5.34324e-13
   4.60000e-01        5.40000e-01        1.65910e-01        8.34090e-01       7.27287e-09        0.00000         1.55578e-10         1.00000        602.888     63.7491     0.919487     1.51263e-11     5.34324e-13
   4.70000e-01        5.30000e-01        1.71548e-01        8.28452e-01       7.41009e-09        0.00000         1.58513e-10         1.00000        602.888     62.9944     0.919487     1.52292e-11     5.34324e-13
   4.80000e-01        5.20000e-01        1.77322e-01        8.22678e-01       7.55259e-09        0.00000         1.61562e-10         1.00000        602.888     62.2396     0.919487     1.53361e-11     5.34324e-13
   4.90000e-01        5.10000e-01        1.83238e-01        8.16762e-01       7.70068e-09        0.00000         1.64730e-10         1.00000        602.888     61.4849     0.919487     1.54472e-11     5.34324e-13
   5.00000e-01        5.00000e-01        1.89302e-01        8.10698e-01       7.85469e-09        0.00000         1.68024e-10         1.00000        602.888     60.7301     0.919487     1.55627e-11     5.34324e-13
   5.10000e-01        4.90000e-01        1.95518e-01        8.04482e-01       8.01499e-09        0.00000         1.71453e-10         1.00000        602.888     59.9754     0.919487     1.56830e-11     5.34324e-13
   5.20000e-01        4.80000e-01        2.01892e-01        7.98108e-01       8.18197e-09        0.00000         1.75025e-10         1.00000        602.888     59.2206     0.919487     1.58082e-11     5.34324e-13
   5.30000e-01        4.70000e-01        2.08431e-01        7.91569e-01       8.35606e-09        0.00000         1.78749e-10         1.00000        602.888     58.4659     0.919487     1.59388e-11     5.34324e-13
   5.40000e-01        4.60000e-01        2.15141e-01        7.84859e-01       8.53771e-09        0.00000         1.82635e-10         1.00000        602.888     57.7111     0.919487     1.60751e-11     5.34324e-13
   5.50000e-01        4.50000e-01        2.22029e-01        7.77971e-01       8.72744e-09        0.00000         1.86694e-10         1.00000        602.888     56.9564     0.919487     1.62174e-11     5.34324e-13
   5.60000e-01        4.40000e-01        2.29101e-01        7.70899e-01       8.92579e-09        0.00000         1.90937e-10         1.00000        602.888     56.2016     0.919487     1.63662e-11     5.34324e-13
   5.70000e-01        4.30000e-01        2.36367e-01        7.63633e-01       9.13337e-09        0.00000         1.95377e-10         1.00000        602.888     55.4469     0.919487     1.65219e-11     5.34324e-13
   5.80000e-01        4.20000e-01        2.43833e-01        7.56167e-01       9.35083e-09        0.00000         2.00029e-10         1.00000        602.888     54.6921     0.919487     1.66850e-11     5.34324e-13
   5.90000e-01        4.10000e-01        2.51507e-01        7.48493e-01       9.57890e-09        0.00000         2.04908e-10         1.00000        602.888     53.9374     0.919487     1.68561e-11     5.34324e-13
   6.00000e-01        4.00000e-01        2.59400e-01        7.40600e-01       9.81837e-09        0.00000         2.10030e-10         1.00000        602.888     53.1826     0.919487     1.70357e-11     5.34324e-13
   6.10000e-01        3.90000e-01        2.67520e-01        7.32480e-01       1.00701e-08        0.00000         2.15416e-10         1.00000        602.888     52.4279     0.919487     1.72246e-11     5.34324e-13
   6.20000e-01        3.80000e-01        2.75877e-01        7.24123e-01       1.03351e-08        0.00000         2.21084e-10         1.00000        602.888     51.6731     0.919487     1.74234e-11     5.34324e-13
   6.30000e-01        3.70000e-01        2.84482e-01        7.15518e-01       1.06145e-08        0.00000         2.27060e-10         1.00000        602.888     50.9184     0.919487     1.76329e-11     5.34324e-13
   6.40000e-01        3.60000e-01        2.93346e-01        7.06654e-01       1.09093e-08        0.00000         2.33367e-10         1.00000        602.888     50.1636     0.919487     1.78541e-11     5.34324e-13
   6.50000e-01        3.50000e-01        3.02480e-01        6.97520e-01       1.12210e-08        0.00000         2.40035e-10         1.00000        602.888     49.4089     0.919487     1.80879e-11     5.34324e-13
   6.60000e-01        3.40000e-01        3.11898e-01        6.88102e-01       1.15510e-08        0.00000         2.47094e-10         1.00000        602.888     48.6541     0.919487     1.83355e-11     5.34324e-13
   6.70000e-01        3.30000e-01        3.21613e-01        6.78387e-01       1.19011e-08        0.00000         2.54582e-10         1.00000        602.888     47.8994     0.919487     1.85980e-11     5.34324e-13
   6.80000e-01        3.20000e-01        3.31639e-01        6.68361e-01       1.22730e-08        0.00000         2.62538e-10         1.00000        602.888     47.1446     0.919487     1.88770e-11     5.34324e-13
   6.90000e-01        3.10000e-01        3.41991e-01        6.58009e-01       1.26689e-08        0.00000         2.71007e-10         1.00000        602.888     46.3899     0.919487     1.91740e-11     5.34324e-13
   7.00000e-01        3.00000e-01        3.52685e-01        6.47315e-01       1.30912e-08        0.00000         2.80040e-10         1.00000        602.888     45.6351     0.919487     1.94908e-11     5.34324e-13
   7.10000e-01        2.90000e-01        3.63740e-01        6.36260e-01       1.35426e-08        0.00000         2.89697e-10         1.00000        602.888     44.8804     0.919487     1.98294e-11     5.34324e-13
   7.20000e-01        2.80000e-01        3.75172e-01        6.24828e-01       1.40262e-08        0.00000         3.00043e-10         1.00000        602.888     44.1256     0.919487     2.01922e-11     5.34324e-13
   7.30000e-01        2.70000e-01        3.87002e-01        6.12998e-01       1.45457e-08        0.00000         3.11156e-10         1.00000        602.888     43.3709     0.919487     2.05819e-11     5.34324e-13
   7.40000e-01        2.60000e-01        3.99251e-01        6.00749e-01       1.51052e-08        0.00000         3.23123e-10         1.00000        602.888     42.6161     0.919487     2.10016e-11     5.34324e-13
   7.50000e-01        2.50000e-01        4.11942e-01        5.88058e-01       1.57094e-08        0.00000         3.36048e-10         1.00000        602.888     41.8614     0.919487     2.14548e-11     5.34324e-13
   7.60000e-01        2.40000e-01        4.25099e-01        5.74901e-01       1.63639e-08        0.00000         3.50050e-10         1.00000        602.888     41.1066     0.919487     2.19458e-11     5.34324e-13
   7.70000e-01        2.30000e-01        4.38748e-01        5.61252e-01       1.70754e-08        0.00000         3.65270e-10         1.00000        602.888     40.3519     0.919487     2.24795e-11     5.34324e-13
   7.80000e-01        2.20000e-01        4.52918e-01        5.47082e-01       1.78516e-08        0.00000         3.81873e-10         1.00000        602.888     39.5971     0.919487     2.30617e-11     5.34324e-13
   7.90000e-01        2.10000e-01        4.67638e-01        5.32362e-01       1.87017e-08        0.00000         4.00058e-10         1.00000        602.888     38.8424     0.919487     2.36994e-11     5.34324e-13
   8.00000e-01        2.00000e-01        4.82942e-01        5.17058e-01       1.96367e-08        0.00000         4.20060e-10         1.00000        602.888     38.0876     0.919487     2.44008e-11     5.34324e-13
   8.10000e-01        1.90000e-01        4.98864e-01        5.01136e-01       2.06702e-08        0.00000         4.42169e-10         1.00000        602.888     37.3329     0.919487     2.51761e-11     5.34324e-13
   8.20000e-01        1.80000e-01        5.15443e-01        4.84557e-01       2.18186e-08        0.00000         4.66734e-10         1.00000        602.888     36.5781     0.919487     2.60375e-11     5.34324e-13
   8.30000e-01        1.70000e-01        5.32721e-01        4.67279e-01       2.31020e-08        0.00000         4.94189e-10         1.00000        602.888     35.8234     0.919487     2.70003e-11     5.34324e-13
   8.40000e-01        1.60000e-01        5.50743e-01        4.49257e-01       2.45459e-08        0.00000         5.25076e-10         1.00000        602.888     35.0686     0.919487     2.80834e-11     5.34324e-13
   8.50000e-01        1.50000e-01        5.69558e-01        4.30442e-01       2.61823e-08        0.00000         5.60081e-10         1.00000        602.888     34.3139     0.919487     2.93109e-11     5.34324e-13
   8.60000e-01        1.40000e-01        5.89219e-01        4.10781e-01       2.80525e-08        0.00000         6.00086e-10         1.00000        602.888     33.5591     0.919487     3.07138e-11     5.34324e-13
   8.70000e-01        1.30000e-01        6.09784e-01        3.90216e-01       3.02104e-08        0.00000         6.46247e-10         1.00000        602.888     32.8044     0.919487     3.23325e-11     5.34324e-13
   8.80000e-01        1.20000e-01        6.31318e-01        3.68682e-01       3.27279e-08        0.00000         7.00101e-10         1.00000        602.888     32.0496     0.919487     3.42210e-11     5.34324e-13
   8.90000e-01        1.10000e-01        6.53891e-01        3.46109e-01       3.57032e-08        0.00000         7.63746e-10         1.00000        602.888     31.2949     0.919487     3.64529e-11     5.34324e-13
   9.00000e-01        1.00000e-01        6.77580e-01        3.22420e-01       3.92735e-08        0.00000         8.40121e-10         1.00000        602.888     30.5401     0.919487     3.91311e-11     5.34324e-13
   9.10000e-01        9.00000e-02        7.02469e-01        2.97531e-01       4.36372e-08        0.00000         9.33468e-10         1.00000        602.888     29.7854     0.919487     4.24045e-11     5.34324e-13
   9.20000e-01        8.00000e-02        7.28652e-01        2.71348e-01       4.90918e-08        0.00000         1.05015e-09         1.00000        602.888     29.0306     0.919487     4.64962e-11     5.34324e-13
   9.30000e-01        7.00000e-02        7.56233e-01        2.43767e-01       5.61050e-08        0.00000         1.20017e-09         1.00000        602.888     28.2759     0.919487     5.17570e-11     5.34324e-13
   9.40000e-01        6.00000e-02        7.85326e-01        2.14674e-01       6.54558e-08        0.00000         1.40020e-09         1.00000        602.888     27.5211     0.919487     5.87714e-11     5.34324e-13
   9.50000e-01        5.00000e-02        8.16061e-01        1.83939e-01       7.85469e-08        0.00000         1.68024e-09         1.00000        602.888     26.7664     0.919487     6.85915e-11     5.34324e-13
   9.60000e-01        4.00000e-02        8.48579e-01        1.51421e-01       9.81837e-08        0.00000         2.10030e-09         1.00000        602.888     26.0116     0.919487     8.33218e-11     5.34324e-13
   9.70000e-01        3.00000e-02        8.83041e-01        1.16959e-01       1.30912e-07        0.00000         2.80040e-09         1.00000        602.888     25.2569     0.919487     1.07872e-10     5.34324e-13
   9.80000e-01        2.00000e-02        9.19625e-01        8.03747e-02       1.96367e-07        0.00000         4.20060e-09         1.00000        602.888     24.5021     0.919487     1.56973e-10     5.34324e-13
   9.90000e-01        1.00000e-02        9.58535e-01        4.14646e-02       3.92735e-07        0.00000         8.40121e-09         1.00000        602.888     23.7474     0.919487     3.04275e-10     5.34324e-13
   9.95000e-01        5.00000e-03        9.78933e-01        2.10671e-02       7.85470e-07        0.00000         1.68024e-08         1.00000        602.888     23.3700     0.919487     5.98880e-10     5.34324e-13
   9.98000e-01        2.00000e-03        9.91491e-01        8.50928e-03       1.96367e-06        0.00000         4.20060e-08         1.00000        602.888     23.1436     0.919487     1.48269e-09     5.34324e-13
   9.99000e-01        1.00000e-03        9.95731e-01        4.26856e-03       3.92735e-06        0.00000         8.40121e-08         1.00000        602.888     23.0681     0.919487     2.95572e-09     5.34324e-13
   9.99500e-01        5.00000e-04        9.97862e-01        2.13778e-03       7.85470e-06        0.00000         1.68024e-07         1.00000        602.888     23.0304     0.919487     5.90177e-09     5.34325e-13
   9.99800e-01        2.00000e-04        9.99144e-01        8.55953e-04       1.96368e-05        0.00000         4.20061e-07         1.00000        602.888     23.0077     0.919487     1.47399e-08     5.34325e-13
   9.99900e-01        1.00000e-04        9.99572e-01        4.28117e-04       3.92736e-05        0.00000         8.40124e-07         1.00000        602.888     23.0002     0.919487     2.94702e-08     5.34326e-13
   9.99950e-01        5.00000e-05        9.99786e-01        2.14094e-04       7.85475e-05        0.00000         1.68025e-06         1.00000        602.887     22.9964     0.919487     5.89310e-08     5.34329e-13
   9.99980e-01        2.00000e-05        9.99914e-01        8.56458e-05       1.96371e-04        0.00000         4.20067e-06         1.00000        602.887     22.9941     0.919487     1.47315e-07     5.34335e-13
   9.99990e-01        1.00000e-05        9.99957e-01        4.28243e-05       3.92749e-04        0.00000         8.40148e-06         1.00000        602.885     22.9934     0.919487     2.94625e-07     5.34346e-13
   9.99995e-01        5.00000e-06        9.99979e-01        2.14125e-05       7.85527e-04        0.00000         1.68035e-05         1.00000        602.882     22.9930     0.919487     5.89263e-07     5.34368e-13
   9.99998e-01        2.00000e-06        9.99991e-01        8.56509e-06       1.96404e-03        0.00000         4.20129e-05         1.00000        602.874     22.9928     0.919486     1.47331e-06     5.34435e-13
   9.99999e-01        1.00000e-06        9.99996e-01        4.28256e-06       3.92879e-03        0.00000         8.40394e-05         0.99999        602.860     22.9927     0.919484     2.94716e-06     5.34545e-13
   1.00000e+00        5.00000e-07        9.99998e-01        2.14128e-06       7.86048e-03        0.00000         1.68133e-04         0.99998        602.831     22.9927     0.919481     5.89654e-06     5.34766e-13
   1.00000e+00        2.00000e-07        9.99999e-01        8.56514e-07       1.96730e-02        0.00000         4.20744e-04         0.99996        602.746     22.9926     0.919472     1.47580e-05     5.35432e-13
   1.00000e+00        1.00000e-07        1.00000e+00        4.28257e-07       3.94188e-02        0.00000         8.42861e-04         0.99992        602.604     22.9926     0.919456     2.95719e-05     5.36545e-13
   1.00000e+00        5.00000e-08        1.00000e+00        2.14129e-07       7.91316e-02        0.00000         1.69126e-03         0.99983        602.318     22.9926     0.919424     5.93693e-05     5.38792e-13
   1.00000e+00        2.00000e-08        1.00000e+00        8.56515e-08       2.00084e-01        0.00000         4.27063e-03         0.99958        601.448     22.9926     0.919328     1.50153e-04     5.45693e-13
   1.00000e+00        1.00000e-08        1.00000e+00        4.28257e-08       4.08044e-01        0.00000         8.68935e-03         0.99914        599.958     22.9926     0.919163     3.06351e-04     5.57765e-13
   1.00000e+00        5.00000e-09        1.00000e+00        2.14129e-08       8.50665e-01        0.00000         1.80268e-02         0.99822        596.809     22.9926     0.918812     6.39254e-04     5.84352e-13
   1.00000e+00        3.09985e-09        1.00000e+00        1.32753e-08       1.45166e+00        0.00000         3.05607e-02         0.99696        592.579     22.9926     0.918334     1.09227e-03     6.22484e-13
   1.00000e+00        2.00000e-09        1.00000e+00        8.56515e-09       2.47727e+00        0.00000         5.15734e-02         0.99482        585.485     22.9926     0.917520     1.86796e-03     6.93366e-13
   1.00000e+00        1.53985e-09        1.00000e+00        6.59451e-09       3.56287e+00        0.00000         7.33126e-02         0.99257        578.142     22.9926     0.916659     2.69265e-03     7.77166e-13
   1.00000e+00        1.23989e-09        1.00000e+00        5.30993e-09       5.12420e+00        0.00000         1.03707e-01         0.98934        567.874     22.9926     0.915421     3.88527e-03     9.15664e-13
   1.00000e+00        1.06495e-09        1.00000e+00        4.56074e-09       7.36974e+00        0.00000         1.45711e-01         0.98473        553.691     22.9926     0.913645     5.61403e-03     1.15897e-12
   1.00000e+00        1.00393e-09        1.00000e+00        4.29942e-09       1.05993e+01        0.00000         2.02845e-01         0.97817        534.445     22.9926     0.911104     8.12836e-03     1.62563e-12
   1.00000e+00        1.00393e-09        1.00000e+00        4.29942e-09       1.06011e+01        0.00000         2.02876e-01         0.97817        534.435     22.9926     0.911102     8.12977e-03     1.62594e-12
   1.00000e+00        1.03744e-09        1.00000e+00        4.44289e-09       1.35432e+01        0.00000         2.51854e-01         0.97227        518.020     22.9926     0.908805     1.04490e-02     2.21158e-12
   1.00000e+00        1.15855e-09        1.00000e+00        4.96159e-09       1.73018e+01        0.00000         3.10615e-01         0.96484        498.497     22.9926     0.905904     1.34517e-02     3.27302e-12
   1.00000e+00        1.42880e-09        1.00000e+00        6.11892e-09       2.21034e+01        0.00000         3.80229e-01         0.95553        475.738     22.9926     0.902266     1.73522e-02     5.39043e-12
   1.00000e+00        2.00000e-09        1.00000e+00        8.56515e-09       2.82377e+01        0.00000         4.61658e-01         0.94396        449.883     22.9926     0.897760     2.24396e-02     1.01588e-11
   1.00000e+00        2.96329e-09        1.00000e+00        1.26905e-08       3.45046e+01        0.00000         5.37784e-01         0.93254        426.780     22.9926     0.893356     2.77556e-02     1.93108e-11
   1.00000e+00        5.00000e-09        1.00000e+00        2.14129e-08       4.21624e+01        0.00000         6.23278e-01         0.91917        402.497     22.9926     0.888297     3.44088e-02     4.19772e-11
   1.00000e+00        6.91797e-09        1.00000e+00        2.96267e-08       4.66977e+01        0.00000         6.70860e-01         0.91158        389.911     22.9926     0.885485     3.84274e-02     6.61486e-11
   1.00000e+00        1.00000e-08        1.00000e+00        4.28257e-08       5.17209e+01        0.00000         7.21478e-01         0.90347        377.347     22.9926     0.882542     4.29429e-02     1.08917e-10
   1.00000e+00        2.00000e-08        1.00000e+00        8.56515e-08       6.09588e+01        0.00000         8.10212e-01         0.88943        357.530     22.9926     0.877611     5.14118e-02     2.68309e-10
   1.00000e+00        3.09617e-08        1.00000e+00        1.32596e-07       6.67122e+01        0.00000         8.63371e-01         0.88130        347.039     22.9926     0.874857     5.67836e-02     4.65062e-10
   1.00000e+00        5.00000e-08        1.00000e+00        2.14129e-07       7.30086e+01        0.00000         9.20232e-01         0.87295        336.935     22.9926     0.872116     6.27369e-02     8.39562e-10
   1.00000e+00        1.00000e-07        1.00000e+00        4.28257e-07       8.21641e+01        0.00000         1.00116e+00         0.86192        324.408     22.9926     0.868606     7.15083e-02     1.93685e-09
   1.00000e+00        2.00000e-07        9.99999e-01        8.56514e-07       9.14689e+01        0.00000         1.08193e+00         0.85209        313.814     22.9926     0.865563     8.05244e-02     4.39294e-09
   1.00000e+00        5.00000e-07        9.99998e-01        2.14128e-06       1.04167e+02        0.00000         1.19047e+00         0.84102        302.001     22.9927     0.862128     9.29102e-02     1.27176e-08
   9.99999e-01        1.00000e-06        9.99996e-01        4.28256e-06       1.14211e+02        0.00000         1.27515e+00         0.83422        294.264     22.9927     0.859880     1.02700e-01     2.81075e-08
   9.99998e-01        2.00000e-06        9.99991e-01        8.56509e-06       1.24769e+02        0.00000         1.36298e+00         0.82890        287.239     22.9928     0.857854     1.12914e-01     6.16907e-08
   9.99995e-01        5.00000e-06        9.99979e-01        2.14125e-05       1.39774e+02        0.00000         1.48536e+00         0.82451        278.626     22.9930     0.855398     1.27168e-01     1.73114e-07
   9.99990e-01        1.00000e-05        9.99957e-01        4.28243e-05       1.52165e+02        0.00000         1.58386e+00         0.82353        272.341     22.9934     0.853617     1.38609e-01     3.76596e-07
   9.99980e-01        2.00000e-05        9.99914e-01        8.56458e-05       1.65729e+02        0.00000         1.68863e+00         0.82495        266.032     22.9941     0.851822     1.50709e-01     8.18407e-07
   9.99968e-01        3.17610e-05        9.99864e-01        1.36004e-04       1.75595e+02        0.00000         1.76267e+00         0.82748        261.711     22.9950     0.850578     1.59199e-01     1.37403e-06
   9.99950e-01        5.00000e-05        9.99786e-01        2.14094e-04       1.86048e+02        0.00000         1.83903e+00         0.83140        257.318     22.9964     0.849294     1.67891e-01     2.28615e-06
   9.99900e-01        1.00000e-04        9.99572e-01        4.28117e-04       2.03839e+02        0.00000         1.96398e+00         0.84064        250.184     23.0002     0.847150     1.81954e-01     4.98845e-06
   9.99858e-01        1.42183e-04        9.99391e-01        6.08627e-04       2.13905e+02        0.00000         2.03188e+00         0.84712        246.303     23.0034     0.845947     1.89505e-01     7.42647e-06
   9.99800e-01        2.00000e-04        9.99144e-01        8.55953e-04       2.24467e+02        0.00000         2.10101e+00         0.85475        242.336     23.0077     0.844687     1.97123e-01     1.09387e-05
   9.99680e-01        3.20159e-04        9.98630e-01        1.36966e-03       2.40575e+02        0.00000         2.20236e+00         0.86783        236.479     23.0168     0.842767     2.08166e-01     1.87143e-05
   9.99500e-01        5.00000e-04        9.97862e-01        2.13778e-03       2.57839e+02        0.00000         2.30579e+00         0.88348        230.443     23.0304     0.840709     2.19283e-01     3.12484e-05
   9.99287e-01        7.13391e-04        9.96952e-01        3.04801e-03       2.73312e+02        0.00000         2.39420e+00         0.89868        225.238     23.0465     0.838866     2.28670e-01     4.71834e-05
   9.99000e-01        1.00000e-03        9.95731e-01        4.26856e-03       2.89714e+02        0.00000         2.48378e+00         0.91582        219.925     23.0681     0.836917     2.38081e-01     7.00239e-05
   9.98571e-01        1.42903e-03        9.93909e-01        6.09137e-03       3.09215e+02        0.00000         2.58517e+00         0.93732        213.876     23.1005     0.834613     2.48625e-01     1.06716e-04
   9.98000e-01        2.00000e-03        9.91491e-01        8.50928e-03       3.30029e+02        0.00000         2.68776e+00         0.96140        207.731     23.1436     0.832176     2.59197e-01     1.59374e-04
   9.97444e-01        2.55615e-03        9.89144e-01        1.08558e-02       3.47012e+02        0.00000         2.76753e+00         0.98177        202.947     23.1856     0.830208     2.67366e-01     2.14233e-04
   9.96770e-01        3.23045e-03        9.86311e-01        1.36895e-02       3.64868e+02        0.00000         2.84791e+00         1.00378        198.132     23.2364     0.828164     2.75562e-01     2.84869e-04
   9.95961e-01        4.03930e-03        9.82928e-01        1.70722e-02       3.83644e+02        0.00000         2.92888e+00         1.02751        193.297     23.2975     0.826044     2.83794e-01     3.74922e-04
   9.95000e-01        5.00000e-03        9.78933e-01        2.10671e-02       4.03385e+02        0.00000         3.01042e+00         1.05303        188.453     23.3700     0.823852     2.92071e-01     4.88685e-04
   9.93992e-01        6.00846e-03        9.74766e-01        2.52340e-02       4.22003e+02        0.00000         3.08422e+00         1.07759        184.100     23.4461     0.821820     2.99561e-01     6.15365e-04
   9.92832e-01        7.16820e-03        9.70007e-01        2.99926e-02       4.41479e+02        0.00000         3.15847e+00         1.10373        179.758     23.5337     0.819734     3.07105e-01     7.69536e-04
   9.91506e-01        8.49365e-03        9.64612e-01        3.53880e-02       4.61854e+02        0.00000         3.23320e+00         1.13155        175.435     23.6337     0.817595     3.14712e-01     9.56095e-04
   9.90000e-01        1.00000e-02        9.58535e-01        4.14646e-02       4.83170e+02        0.00000         3.30842e+00         1.16114        171.137     23.7474     0.815407     3.22390e-01     1.18068e-03
   9.87980e-01        1.20202e-02        9.50477e-01        4.95232e-02       5.09443e+02        0.00000         3.39735e+00         1.19826        166.137     23.8999     0.812779     3.31506e-01     1.50156e-03
   9.85661e-01        1.43393e-02        9.41351e-01        5.86487e-02       5.37145e+02        0.00000         3.48704e+00         1.23814        161.193     24.0749     0.810090     3.40752e-01     1.89607e-03
   9.83012e-01        1.69879e-02        9.31091e-01        6.89093e-02       5.66354e+02        0.00000         3.57755e+00         1.28099        156.317     24.2748     0.807346     3.50145e-01     2.37876e-03
   9.80000e-01        2.00000e-02        9.19625e-01        8.03747e-02       5.97150e+02        0.00000         3.66892e+00         1.32707        151.515     24.5021     0.804549     3.59705e-01     2.96710e-03
   9.77022e-01        2.29784e-02        9.08495e-01        9.15045e-02       6.25597e+02        0.00000         3.75001e+00         1.37043        147.363     24.7269     0.802051     3.68263e-01     3.58801e-03
   9.73701e-01        2.62991e-02        8.96322e-01        1.03678e-01       6.55398e+02        0.00000         3.83183e+00         1.41672        143.277     24.9776     0.799516     3.76984e-01     4.32408e-03
   9.70000e-01        3.00000e-02        8.83041e-01        1.16959e-01       6.86619e+02        0.00000         3.91442e+00         1.46617        139.261     25.2569     0.796945     3.85889e-01     5.19642e-03
   9.66942e-01        3.30577e-02        8.72287e-01        1.27713e-01       7.11045e+02        0.00000         3.97693e+00         1.50557        136.289     25.4877     0.794988     3.92715e-01     5.95685e-03
   9.63619e-01        3.63807e-02        8.60818e-01        1.39182e-01       7.36339e+02        0.00000         4.03982e+00         1.54706        133.355     25.7385     0.793008     3.99673e-01     6.82251e-03
   9.60000e-01        4.00000e-02        8.48579e-01        1.51421e-01       7.62533e+02        0.00000         4.10302e+00         1.59081        130.458     26.0116     0.790999     4.06781e-01     7.81019e-03
   9.55280e-01        4.47201e-02        8.32998e-01        1.67002e-01       7.94735e+02        0.00000         4.17804e+00         1.64576        127.070     26.3679     0.788579     4.15415e-01     9.16581e-03
   9.50000e-01        5.00000e-02        8.16061e-01        1.83939e-01       8.28297e+02        0.00000         4.25302e+00         1.70455        123.718     26.7664     0.786093     4.24343e-01     1.07689e-02
   9.45273e-01        5.47271e-02        8.01319e-01        1.98681e-01       8.56241e+02        0.00000         4.31278e+00         1.75485        121.044     27.1232     0.784034     4.31767e-01     1.22781e-02
   9.40000e-01        6.00000e-02        7.85326e-01        2.14674e-01       8.85128e+02        0.00000         4.37167e+00         1.80832        118.369     27.5211     0.781892     4.39489e-01     1.40402e-02
   9.35287e-01        6.47130e-02        7.71418e-01        2.28582e-01       9.08933e+02        0.00000         4.41764e+00         1.85374        116.212     27.8768     0.780092     4.45943e-01     1.56822e-02
   9.30000e-01        7.00000e-02        7.56233e-01        2.43767e-01       9.33377e+02        0.00000         4.46188e+00         1.90192        114.022     28.2759     0.778180     4.52723e-01     1.75960e-02
   9.20000e-01        8.00000e-02        7.28652e-01        2.71348e-01       9.73052e+02        0.00000         4.52478e+00         1.98469        110.434     29.0306     0.774806     4.64357e-01     2.14108e-02
   9.10000e-01        9.00000e-02        7.02469e-01        2.97531e-01       1.00409e+03        0.00000         4.56091e+00         2.05589        107.436     29.7854     0.771653     4.74602e-01     2.54626e-02
   9.00000e-01        1.00000e-01        6.77580e-01        3.22420e-01       1.02656e+03        0.00000         4.57102e+00         2.11495        104.905     30.5401     0.768635     4.83623e-01     2.97329e-02
   8.90000e-01        1.10000e-01        6.53891e-01        3.46109e-01       1.04073e+03        0.00000         4.55644e+00         2.16168        102.750     31.2949     0.765684     4.91557e-01     3.42077e-02
   8.80000e-01        1.20000e-01        6.31318e-01        3.68682e-01       1.04717e+03        0.00000         4.51925e+00         2.19634        100.898     32.0496     0.762755     4.98530e-01     3.88774e-02
   8.70000e-01        1.30000e-01        6.09784e-01        3.90216e-01       1.04665e+03        0.00000         4.46225e+00         2.21965         99.290     32.8044     0.759814     5.04663e-01     4.37379e-02
   8.60000e-01        1.40000e-01        5.89219e-01        4.10781e-01       1.04016e+03        0.00000         4.38868e+00         2.23271         97.879     33.5591     0.756844     5.10069e-01     4.87899e-02
   8.50000e-01        1.50000e-01        5.69558e-01        4.30442e-01       1.02872e+03        0.00000         4.30192e+00         2.23683         96.625     34.3139     0.753835     5.14856e-01     5.40386e-02
   8.40000e-01        1.60000e-01        5.50743e-01        4.49257e-01       1.01336e+03        0.00000         4.20522e+00         2.23340         95.496     35.0686     0.750782     5.19121e-01     5.94937e-02
   8.30000e-01        1.70000e-01        5.32721e-01        4.67279e-01       9.95022e+02        0.00000         4.10150e+00         2.22378         94.467     35.8234     0.747686     5.22949e-01     6.51686e-02
   8.20000e-01        1.80000e-01        5.15443e-01        4.84557e-01       9.74514e+02        0.00000         3.99324e+00         2.20919         93.514     36.5781     0.744547     5.26416e-01     7.10802e-02
   8.10000e-01        1.90000e-01        4.98864e-01        5.01136e-01       9.52520e+02        0.00000         3.88245e+00         2.19070         92.622     37.3329     0.741365     5.29583e-01     7.72490e-02
   8.00000e-01        2.00000e-01        4.82942e-01        5.17058e-01       9.29590e+02        0.00000         3.77070e+00         2.16923         91.774     38.0876     0.738140     5.32501e-01     8.36990e-02
   7.90000e-01        2.10000e-01        4.67638e-01        5.32362e-01       9.06156e+02        0.00000         3.65919e+00         2.14552         90.958     38.8424     0.734871     5.35215e-01     9.04582e-02
   7.80000e-01        2.20000e-01        4.52918e-01        5.47082e-01       8.82550e+02        0.00000         3.54878e+00         2.12016         90.164     39.5971     0.731553     5.37758e-01     9.75589e-02
   7.70000e-01        2.30000e-01        4.38748e-01        5.61252e-01       8.59025e+02        0.00000         3.44009e+00         2.09362         89.382     40.3519     0.728181     5.40160e-01     1.05039e-01
   7.60000e-01        2.40000e-01        4.25099e-01        5.74901e-01       8.35764e+02        0.00000         3.33354e+00         2.06630         88.605     41.1066     0.724750     5.42443e-01     1.12942e-01
   7.50000e-01        2.50000e-01        4.11942e-01        5.88058e-01       8.12902e+02        0.00000         3.22940e+00         2.03847         87.825     41.8614     0.721251     5.44626e-01     1.21318e-01
   7.40000e-01        2.60000e-01        3.99251e-01        6.00749e-01       7.90536e+02        0.00000         3.12780e+00         2.01038         87.035     42.6161     0.717673     5.46725e-01     1.30230e-01
   7.30000e-01        2.70000e-01        3.87002e-01        6.12998e-01       7.68730e+02        0.00000         3.02880e+00         1.98220         86.228     43.3709     0.714004     5.48753e-01     1.39747e-01
   7.20000e-01        2.80000e-01        3.75172e-01        6.24828e-01       7.47527e+02        0.00000         2.93240e+00         1.95406         85.397     44.1256     0.710228     5.50720e-01     1.49957e-01
   7.10000e-01        2.90000e-01        3.63740e-01        6.36260e-01       7.26953e+02        0.00000         2.83854e+00         1.92608         84.536     44.8804     0.706329     5.52636e-01     1.60965e-01
   7.00000e-01        3.00000e-01        3.52685e-01        6.47315e-01       7.07022e+02        0.00000         2.74711e+00         1.89835         83.638     45.6351     0.702285     5.54508e-01     1.72900e-01
   6.90000e-01        3.10000e-01        3.41991e-01        6.58009e-01       6.87737e+02        0.00000         2.65799e+00         1.87092         82.695     46.3899     0.698071     5.56343e-01     1.85922e-01
   6.80000e-01        3.20000e-01        3.31639e-01        6.68361e-01       6.69098e+02        0.00000         2.57101e+00         1.84385         81.697     47.1446     0.693655     5.58147e-01     2.00235e-01
   6.70000e-01        3.30000e-01        3.21613e-01        6.78387e-01       6.51099e+02        0.00000         2.48600e+00         1.81718         80.634     47.8994     0.688998     5.59924e-01     2.16101e-01
   6.60000e-01        3.40000e-01        3.11898e-01        6.88102e-01       6.33731e+02        0.00000         2.40273e+00         1.79096         79.495     48.6541     0.684052     5.61681e-01     2.33867e-01
   6.50000e-01        3.50000e-01        3.02480e-01        6.97520e-01       6.16986e+02        0.00000         2.32095e+00         1.76522         78.262     49.4089     0.678754     5.63421e-01     2.53999e-01
   6.40000e-01        3.60000e-01        2.93346e-01        7.06654e-01       6.00856e+02        0.00000         2.24037e+00         1.74000         76.918     50.1636     0.673021     5.65148e-01     2.77146e-01
   6.30000e-01        3.70000e-01        2.84482e-01        7.15518e-01       5.85333e+02        0.00000         2.16060e+00         1.71532         75.436     50.9184     0.666740     5.66869e-01     3.04245e-01
   6.20000e-01        3.80000e-01        2.75877e-01        7.24123e-01       5.70413e+02        0.00000         2.08116e+00         1.69125         73.781     51.6731     0.659751     5.68587e-01     3.36703e-01
   6.10000e-01        3.90000e-01        2.67520e-01        7.32480e-01       5.56098e+02        0.00000         2.00139e+00         1.66784         71.904     52.4279     0.651818     5.70309e-01     3.76762e-01
   6.00000e-01        4.00000e-01        2.59400e-01        7.40600e-01       5.42397e+02        0.00000         1.92032e+00         1.64517         69.731     53.1826     0.642573     5.72043e-01     4.28251e-01
   5.90000e-01        4.10000e-01        2.51507e-01        7.48493e-01       5.29335e+02        0.00000         1.83644e+00         1.62336         67.143     53.9374     0.631400     5.73796e-01     4.98354e-01
   5.80000e-01        4.20000e-01        2.43833e-01        7.56167e-01       5.16957e+02        0.00000         1.74729e+00         1.60259         63.940     54.6921     0.617186     5.75585e-01     6.02308e-01
   5.70000e-01        4.30000e-01        2.36367e-01        7.63633e-01       5.05355e+02        0.00000         1.64898e+00         1.58317         59.793     55.4469     0.597838     5.77430e-01     7.77426e-01
   5.62965e-01        4.37035e-01        2.31235e-01        7.68765e-01       4.97743e+02        0.00000         1.57299e+00         1.57058         56.142     55.9778     0.579581     5.78780e-01     9.90041e-01
   5.62720e-01        4.37280e-01        2.31058e-01        7.68942e-01       4.97486e+02        0.50000         1.57015e+00         1.57015         55.996     55.9963     0.578828     5.78828e-01     1.00000e+00
END

$Env_BP << END
#                                                                              Sat Pres                                                                                     Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
   5.62720e-01          0.43728          2.31058e-01          0.76894          497.486          0.5000            1.57015           1.57015        55.9963     55.9963     0.578828     0.578828     1.00000e+00
   5.62474e-01          0.43753          2.30881e-01          0.76912          497.230          1.0000            1.56974           1.56733        56.0149     55.8518     0.578877     0.578077     9.90045e-01
   5.60000e-01          0.44000          2.29101e-01          0.77090          494.689          1.0000            1.56559           1.53991        56.2016     54.4429     0.579367     0.570598     8.95557e-01
   5.50000e-01          0.45000          2.22029e-01          0.77797          485.098          1.0000            1.55035           1.43859        56.9564     49.0010     0.581427     0.539076     5.79039e-01
   5.40000e-01          0.46000          2.15141e-01          0.78486          476.469          1.0000            1.53721           1.36519        57.7111     45.0107     0.583596     0.512518     3.91163e-01
   5.30000e-01          0.47000          2.08431e-01          0.79157          468.552          1.0000            1.52558           1.31294        58.4659     42.2387     0.585836     0.491786     2.81853e-01
   5.20000e-01          0.48000          2.01892e-01          0.79811          461.166          1.0000            1.51502           1.27307        59.2206     40.1867     0.588115     0.474938     2.12364e-01
   5.10000e-01          0.49000          1.95518e-01          0.80448          454.196          1.0000            1.50526           1.24090        59.9754     38.5757     0.590416     0.460652     1.64825e-01
   5.00000e-01          0.50000          1.89302e-01          0.81070          447.566          1.0000            1.49610           1.21390        60.7301     37.2563     0.592726     0.448151     1.30598e-01
   4.90000e-01          0.51000          1.83238e-01          0.81676          441.223          1.0000            1.48742           1.19064        61.4849     36.1424     0.595038     0.436966     1.05052e-01
   4.80000e-01          0.52000          1.77322e-01          0.82268          435.127          1.0000            1.47914           1.17019        62.2396     35.1807     0.597346     0.426792     8.54781e-02
   4.70000e-01          0.53000          1.71548e-01          0.82845          429.248          1.0000            1.47118           1.15195        62.9944     34.3360     0.599646     0.417421     7.01796e-02
   4.60000e-01          0.54000          1.65910e-01          0.83409          423.561          1.0000            1.46350           1.13551        63.7491     33.5841     0.601934     0.408706     5.80373e-02
   4.50000e-01          0.55000          1.60404e-01          0.83960          418.048          1.0000            1.45605           1.12054        64.5039     32.9075     0.604209     0.400539     4.82812e-02
   4.40000e-01          0.56000          1.55026e-01          0.84497          412.692          1.0000            1.44880           1.10682        65.2586     32.2933     0.606467     0.392835     4.03640e-02
   4.30000e-01          0.57000          1.49770e-01          0.85023          407.480          1.0000            1.44172           1.09418        66.0134     31.7315     0.608709     0.385531     3.38863e-02
   4.20000e-01          0.58000          1.44633e-01          0.85537          402.400          1.0000            1.43478           1.08246        66.7681     31.2144     0.610932     0.378577     2.85499e-02
   4.10000e-01          0.59000          1.39612e-01          0.86039          397.444          1.0000            1.42798           1.07155        67.5229     30.7361     0.613136     0.371931     2.41281e-02
   4.00000e-01          0.60000          1.34701e-01          0.86530          392.602          1.0000            1.42129           1.06137        68.2776     30.2914     0.615321     0.365559     2.04460e-02
   3.90000e-01          0.61000          1.29897e-01          0.87010          387.868          1.0000            1.41469           1.05183        69.0324     29.8763     0.617485     0.359433     1.73668e-02
   3.80000e-01          0.62000          1.25198e-01          0.87480          383.234          1.0000            1.40818           1.04287        69.7871     29.4875     0.619629     0.353529     1.47820e-02
   3.70000e-01          0.63000          1.20599e-01          0.87940          378.695          1.0000            1.40175           1.03443        70.5419     29.1222     0.621751     0.347828     1.26053e-02
   3.60000e-01          0.64000          1.16097e-01          0.88390          374.246          1.0000            1.39539           1.02647        71.2966     28.7780     0.623853     0.342312     1.07671e-02
   3.50000e-01          0.65000          1.11690e-01          0.88831          369.882          1.0000            1.38908           1.01895        72.0514     28.4528     0.625934     0.336967     9.21062e-03
   3.40000e-01          0.66000          1.07374e-01          0.89263          365.599          1.0000            1.38283           1.01183        72.8061     28.1449     0.627994     0.331779     7.88985e-03
   3.30000e-01          0.67000          1.03147e-01          0.89685          361.394          1.0000            1.37663           1.00508        73.5609     27.8528     0.630032     0.326738     6.76680e-03
   3.20000e-01          0.68000          9.90053e-02          0.90099          357.262          1.0000            1.37046           0.99868        74.3156     27.5751     0.632050     0.321833     5.81014e-03
   3.10000e-01          0.69000          9.49471e-02          0.90505          353.201          1.0000            1.36433           0.99259        75.0704     27.3107     0.634046     0.317055     4.99388e-03
   3.00000e-01          0.70000          9.09697e-02          0.90903          349.207          1.0000            1.35824           0.98681        75.8251     27.0585     0.636022     0.312397     4.29640e-03
   2.90000e-01          0.71000          8.70707e-02          0.91293          345.279          1.0000            1.35217           0.98130        76.5799     26.8177     0.637977     0.307852     3.69960e-03
   2.80000e-01          0.72000          8.32478e-02          0.91675          341.413          1.0000            1.34613           0.97605        77.3346     26.5874     0.639911     0.303414     3.18833e-03
   2.70000e-01          0.73000          7.94988e-02          0.92050          337.607          1.0000            1.34010           0.97105        78.0894     26.3668     0.641825     0.299076     2.74982e-03
   2.60000e-01          0.74000          7.58215e-02          0.92418          333.859          1.0000            1.33410           0.96627        78.8441     26.1554     0.643719     0.294833     2.37334e-03
   2.50000e-01          0.75000          7.22141e-02          0.92779          330.168          1.0000            1.32811           0.96172        79.5989     25.9526     0.645593     0.290682     2.04980e-03
   2.40000e-01          0.76000          6.86743e-02          0.93133          326.531          1.0000            1.32214           0.95737        80.3536     25.7577     0.647447     0.286617     1.77150e-03
   2.30000e-01          0.77000          6.52005e-02          0.93480          322.946          1.0000            1.31618           0.95322        81.1084     25.5704     0.649281     0.282635     1.53193e-03
   2.20000e-01          0.78000          6.17907e-02          0.93821          319.412          1.0000            1.31022           0.94925        81.8631     25.3901     0.651097     0.278731     1.32553e-03
   2.10000e-01          0.79000          5.84432e-02          0.94156          315.927          1.0000            1.30428           0.94546        82.6179     25.2166     0.652892     0.274904     1.14757e-03
   2.00000e-01          0.80000          5.51563e-02          0.94484          312.490          1.0000            1.29834           0.94184        83.3726     25.0493     0.654670     0.271149     9.94044e-04
   1.90000e-01          0.81000          5.19284e-02          0.94807          309.099          1.0000            1.29241           0.93837        84.1274     24.8880     0.656428     0.267464     8.61499e-04
   1.80000e-01          0.82000          4.87579e-02          0.95124          305.753          1.0000            1.28648           0.93506        84.8821     24.7324     0.658168     0.263846     7.47001e-04
   1.70000e-01          0.83000          4.56433e-02          0.95436          302.452          1.0000            1.28055           0.93189        85.6369     24.5821     0.659890     0.260293     6.48033e-04
   1.60000e-01          0.84000          4.25831e-02          0.95742          299.193          1.0000            1.27463           0.92886        86.3916     24.4369     0.661593     0.256802     5.62442e-04
   1.50000e-01          0.85000          3.95759e-02          0.96042          295.975          1.0000            1.26870           0.92596        87.1464     24.2965     0.663280     0.253372     4.88379e-04
   1.40000e-01          0.86000          3.66203e-02          0.96338          292.798          1.0000            1.26278           0.92319        87.9011     24.1608     0.664948     0.250000     4.24259e-04
   1.30000e-01          0.87000          3.37151e-02          0.96628          289.660          1.0000            1.25685           0.92054        88.6559     24.0295     0.666599     0.246684     3.68719e-04
   1.20000e-01          0.88000          3.08589e-02          0.96914          286.561          1.0000            1.25092           0.91801        89.4106     23.9023     0.668234     0.243424     3.20588e-04
   1.10000e-01          0.89000          2.80506e-02          0.97195          283.499          1.0000            1.24499           0.91559        90.1654     23.7792     0.669851     0.240216     2.78857e-04
   1.00000e-01          0.90000          2.52888e-02          0.97471          280.474          1.0000            1.23905           0.91327        90.9201     23.6599     0.671452     0.237059     2.42659e-04
   9.00000e-02          0.91000          2.25726e-02          0.97743          277.484          1.0000            1.23311           0.91106        91.6749     23.5443     0.673036     0.233952     2.11248e-04
   8.00000e-02          0.92000          1.99007e-02          0.98010          274.530          1.0000            1.22716           0.90895        92.4296     23.4322     0.674605     0.230894     1.83977e-04
   7.00000e-02          0.93000          1.72720e-02          0.98273          271.609          1.0000            1.22121           0.90694        93.1844     23.3235     0.676157     0.227883     1.60291e-04
   6.00000e-02          0.94000          1.46857e-02          0.98531          268.722          1.0000            1.21526           0.90502        93.9391     23.2180     0.677694     0.224918     1.39710e-04
   5.00000e-02          0.95000          1.21405e-02          0.98786          265.868          1.0000            1.20929           0.90318        94.6939     23.1156     0.679215     0.221997     1.21819e-04
   4.00000e-02          0.96000          9.63560e-03          0.99036          263.045          1.0000            1.20332           0.90143        95.4486     23.0163     0.680721     0.219120     1.06262e-04
   3.00000e-02          0.97000          7.17001e-03          0.99283          260.254          1.0000            1.19735           0.89977        96.2034     22.9198     0.682212     0.216286     9.27274e-05
   2.00000e-02          0.98000          4.74280e-03          0.99526          257.493          1.0000            1.19136           0.89818        96.9581     22.8260     0.683688     0.213492     8.09482e-05
   1.00000e-02          0.99000          2.35308e-03          0.99765          254.762          1.0000            1.18537           0.89668        97.7129     22.7350     0.685150     0.210739     7.06928e-05
   5.00000e-03          0.99500          1.17201e-03          0.99883          253.408          1.0000            1.18237           0.89595        98.0903     22.6904     0.685875     0.209378     6.60726e-05
   2.00000e-03          0.99800          4.67726e-04          0.99953          252.599          1.0000            1.18057           0.89552        98.3167     22.6640     0.686309     0.208565     6.34497e-05
   1.00000e-03          0.99900          2.33684e-04          0.99977          252.330          1.0000            1.17997           0.89538        98.3922     22.6552     0.686453     0.208295     6.25992e-05
   5.00000e-04          0.99950          1.16797e-04          0.99988          252.195          1.0000            1.17967           0.89531        98.4299     22.6508     0.686525     0.208161     6.21784e-05
   2.00000e-04          0.99980          4.67081e-05          0.99995          252.115          1.0000            1.17949           0.89527        98.4525     22.6482     0.686568     0.208080     6.19272e-05
   1.00000e-04          0.99990          2.33522e-05          0.99998          252.088          1.0000            1.17943           0.89526        98.4601     22.6474     0.686583     0.208053     6.18438e-05
   5.00000e-05          0.99995          1.16757e-05          0.99999          252.074          1.0000            1.17940           0.89525        98.4639     22.6469     0.686590     0.208039     6.18021e-05
   2.00000e-05          0.99998          4.67016e-06          1.00000          252.066          1.0000            1.17938           0.89524        98.4661     22.6467     0.686594     0.208031     6.17771e-05
   1.00000e-05          0.99999          2.33506e-06          1.00000          252.064          1.0000            1.17937           0.89524        98.4669     22.6466     0.686596     0.208029     6.17687e-05
   5.00000e-06          0.99999          1.16753e-06          1.00000          252.062          1.0000            1.17937           0.89524        98.4673     22.6465     0.686596     0.208027     6.17646e-05
   2.00000e-06          1.00000          4.67010e-07          1.00000          252.062          1.0000            1.17937           0.89524        98.4675     22.6465     0.686597     0.208026     6.17621e-05
   1.00000e-06          1.00000          2.33505e-07          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17612e-05
   5.00000e-07          1.00000          1.16752e-07          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17608e-05
   2.00000e-07          1.00000          4.67009e-08          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17606e-05
   1.00000e-07          1.00000          2.33504e-08          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17605e-05
   5.00000e-08          1.00000          1.16752e-08          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   2.00000e-08          1.00000          4.67009e-09          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   1.00000e-08          1.00000          2.33504e-09          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   5.00000e-09          1.00000          1.16752e-09          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   2.00000e-09          1.00000          4.67009e-10          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   1.00000e-09          1.00000          2.33504e-10          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   5.00000e-10          1.00000          1.16752e-10          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   2.00000e-10          1.00000          4.67009e-11          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   1.00000e-10          1.00000          2.33504e-11          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   5.00000e-11          1.00000          1.16752e-11          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   2.00000e-11          1.00000          4.67009e-12          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   1.00000e-11          1.00000          2.33504e-12          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   5.00000e-12          1.00000          1.16752e-12          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   2.00000e-12          1.00000          4.67009e-13          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   1.00000e-12          1.00000          2.33504e-13          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          252.061          1.0000            1.17937           0.89524        98.4676     22.6465     0.686597     0.208026     6.17604e-05
END

set output "Figures/Env_006_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_006_P_vs_Wi_1.pdf"
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 3:5 with lines title "Dew Points", \
     $Env_BP using 3:5 with lines title "Bubble Points"

set output "Figures/Env_006_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_006_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (bar)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "P-T Diagram for Predicted_3350_m_Oil"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   31.961     1.00000e-13        0.00000         2.54835e-15          1.00000       602.891     99.2901     0.932586     3.91394e-16     1.59148e-17
   32.500     1.11894e-13        0.00000         2.84673e-15          1.00000       602.891     99.2901     0.932485     4.37176e-16     1.77609e-17
   35.000     1.87288e-13        0.00000         4.72854e-15          1.00000       602.891     99.2901     0.932019     7.25803e-16     2.93728e-17
   37.500     3.10474e-13        0.00000         7.77952e-15          1.00000       602.891     99.2901     0.931549     1.19351e-15     4.81261e-17
   40.000     5.09874e-13        0.00000         1.26803e-14          1.00000       602.891     99.2901     0.931075     1.94439e-15     7.81406e-17
   42.500     8.29709e-13        0.00000         2.04815e-14          1.00000       602.891     99.2901     0.930597     3.13900e-15     1.25757e-16
   45.000     1.33818e-12        0.00000         3.27906e-14          1.00000       602.891     99.2901     0.930115     5.02289e-15     2.00652e-16
   47.500     2.13955e-12        0.00000         5.20459e-14          1.00000       602.891     99.2901     0.929629     7.96826e-15     3.17472e-16
   50.000     3.39193e-12        0.00000         8.19156e-14          1.00000       602.891     99.2901     0.929139     1.25347e-14     4.98205e-16
   52.500     5.33307e-12        0.00000         1.27873e-13          1.00000       602.891     99.2901     0.928646     1.95568e-14     7.75600e-16
   55.000     8.31765e-12        0.00000         1.98023e-13          1.00000       602.891     99.2901     0.928148     3.02691e-14     1.19806e-15
   57.500     1.28707e-11        0.00000         3.04268e-13          1.00000       602.891     99.2901     0.927646     4.64842e-14     1.83661e-15
   60.000     1.97635e-11        0.00000         4.63963e-13          1.00000       602.891     99.2901     0.927139     7.08429e-14     2.79466e-15
   62.500     3.01208e-11        0.00000         7.02228e-13          1.00000       602.891     99.2901     0.926629     1.07165e-13     4.22175e-15
   65.000     4.55707e-11        0.00000         1.05515e-12          1.00000       602.890     99.2901     0.926115     1.60934e-13     6.33259e-15
   67.500     6.84539e-11        0.00000         1.57425e-12          1.00000       602.890     99.2901     0.925596     2.39973e-13     9.43342e-15
   70.000     1.02112e-10        0.00000         2.33249e-12          1.00000       602.890     99.2901     0.925073     3.55355e-13     1.39581e-14
   72.500     1.51282e-10        0.00000         3.43263e-12          1.00000       602.890     99.2901     0.924546     5.22664e-13     2.05173e-14
   75.000     2.22640e-10        0.00000         5.01837e-12          1.00000       602.890     99.2901     0.924014     7.63676e-13     2.99652e-14
   77.500     3.25529e-10        0.00000         7.28942e-12          1.00000       602.890     99.2901     0.923478     1.10863e-12     4.34892e-14
   80.000     4.72944e-10        0.00000         1.05216e-11          1.00000       602.890     99.2901     0.922938     1.59927e-12     6.27300e-14
   82.500     6.82853e-10        0.00000         1.50936e-11          1.00000       602.889     99.2901     0.922393     2.29285e-12     8.99413e-14
   85.000     9.79945e-10        0.00000         2.15220e-11          1.00000       602.889     99.2901     0.921844     3.26745e-12     1.28201e-13
   87.500     1.39795e-09        0.00000         3.05080e-11          1.00000       602.889     99.2901     0.921290     4.62891e-12     1.81690e-13
   90.000     1.98270e-09        0.00000         4.29973e-11          1.00000       602.889     99.2901     0.920732     6.51993e-12     2.56053e-13
   92.500     2.79609e-09        0.00000         6.02587e-11          1.00000       602.888     99.2901     0.920169     9.13181e-12     3.58875e-13
   95.000     3.92127e-09        0.00000         8.39856e-11          1.00000       602.888     99.2901     0.919601     1.27196e-11     5.00293e-13
   97.500     5.46939e-09        0.00000         1.16425e-10          1.00000       602.887     99.2901     0.919029     1.76217e-11     6.93782e-13
  100.000     7.58818e-09        0.00000         1.60546e-10          1.00000       602.887     99.2901     0.918452     2.42843e-11     9.57170e-13
  102.500     1.04730e-08        0.00000         2.20246e-10          1.00000       602.886     99.2901     0.917871     3.32936e-11     1.31392e-12
  105.000     1.43811e-08        0.00000         3.00624e-10          1.00000       602.885     99.2901     0.917284     4.54149e-11     1.79479e-12
  107.500     1.96490e-08        0.00000         4.08311e-10          1.00000       602.885     99.2901     0.916693     6.16434e-11     2.43985e-12
  110.000     2.67157e-08        0.00000         5.51895e-10          1.00000       602.884     99.2901     0.916097     8.32665e-11     3.30114e-12
  112.500     3.61506e-08        0.00000         7.42444e-10          1.00000       602.883     99.2901     0.915496     1.11942e-10     4.44590e-12
  115.000     4.86885e-08        0.00000         9.94160e-10          1.00000       602.882     99.2901     0.914890     1.49796e-10     5.96062e-12
  117.500     6.52747e-08        0.00000         1.32518e-09          1.00000       602.880     99.2901     0.914279     1.99540e-10     7.95610e-12
  120.000     8.71185e-08        0.00000         1.75858e-09          1.00000       602.879     99.2901     0.913663     2.64621e-10     1.05737e-11
  122.500     1.15761e-07        0.00000         2.32357e-09          1.00000       602.878     99.2901     0.913042     3.49400e-10     1.39928e-11
  125.000     1.53158e-07        0.00000         3.05700e-09          1.00000       602.876     99.2901     0.912415     4.59373e-10     1.84407e-11
  127.500     2.01782e-07        0.00000         4.00514e-09          1.00000       602.874     99.2901     0.911784     6.01435e-10     2.42036e-11
  130.000     2.64742e-07        0.00000         5.22588e-09          1.00000       602.872     99.2901     0.911147     7.84203e-10     3.16406e-11
  132.500     3.45940e-07        0.00000         6.79136e-09          1.00000       602.870     99.2901     0.910505     1.01841e-09     4.12013e-11
  135.000     4.50246e-07        0.00000         8.79111e-09          1.00000       602.867     99.2901     0.909858     1.31735e-09     5.34453e-11
  137.500     5.83718e-07        0.00000         1.13359e-08          1.00000       602.865     99.2901     0.909205     1.69747e-09     6.90677e-11
  140.000     7.53867e-07        0.00000         1.45621e-08          1.00000       602.862     99.2901     0.908547     2.17901e-09     8.89279e-11
  142.500     9.69966e-07        0.00000         1.86372e-08          1.00000       602.858     99.2901     0.907883     2.78677e-09     1.14086e-10
  145.000     1.24343e-06        0.00000         2.37660e-08          1.00000       602.855     99.2901     0.907214     3.55108e-09     1.45843e-10
  147.500     1.58824e-06        0.00000         3.01984e-08          1.00000       602.851     99.2901     0.906540     4.50887e-09     1.85792e-10
  150.000     2.02151e-06        0.00000         3.82378e-08          1.00000       602.846     99.2901     0.905859     5.70496e-09     2.35879e-10
  152.500     2.56404e-06        0.00000         4.82514e-08          1.00000       602.842     99.2901     0.905173     7.19357e-09     2.98469e-10
  155.000     3.24112e-06        0.00000         6.06828e-08          1.00000       602.837     99.2901     0.904481     9.04007e-09     3.76430e-10
  157.500     4.08333e-06        0.00000         7.60653e-08          1.00000       602.831     99.2901     0.903784     1.13230e-08     4.73228e-10
  160.000     5.12752e-06        0.00000         9.50385e-08          1.00000       602.825     99.2901     0.903080     1.41365e-08     5.93041e-10
  162.500     6.41803e-06        0.00000         1.18367e-07          1.00000       602.818     99.2901     0.902371     1.75928e-08     7.40890e-10
  165.000     8.00799e-06        0.00000         1.46963e-07          1.00000       602.811     99.2901     0.901655     2.18259e-08     9.22787e-10
  167.500     9.96089e-06        0.00000         1.81909e-07          1.00000       602.803     99.2901     0.900934     2.69946e-08     1.14592e-09
  170.000     1.23523e-05        0.00000         2.24488e-07          1.00000       602.795     99.2901     0.900206     3.32867e-08     1.41883e-09
  172.500     1.52722e-05        0.00000         2.76216e-07          1.00000       602.786     99.2901     0.899472     4.09242e-08     1.75170e-09
  175.000     1.88269e-05        0.00000         3.38881e-07          1.00000       602.776     99.2901     0.898732     5.01680e-08     2.15657e-09
  177.500     2.31421e-05        0.00000         4.14580e-07          1.00000       602.766     99.2901     0.897986     6.13247e-08     2.64766e-09
  180.000     2.83659e-05        0.00000         5.05773e-07          1.00000       602.754     99.2901     0.897233     7.47526e-08     3.24174e-09
  182.500     3.46722e-05        0.00000         6.15333e-07          1.00000       602.742     99.2901     0.896474     9.08704e-08     3.95853e-09
  185.000     4.22649e-05        0.00000         7.46610e-07          1.00000       602.729     99.2901     0.895708     1.10165e-07     4.82113e-09
  187.500     5.13821e-05        0.00000         9.03497e-07          1.00000       602.715     99.2901     0.894935     1.33203e-07     5.85657e-09
  190.000     6.23013e-05        0.00000         1.09051e-06          1.00000       602.700     99.2901     0.894156     1.60638e-07     7.09640e-09
  192.500     7.53455e-05        0.00000         1.31287e-06          1.00000       602.683     99.2901     0.893370     1.93228e-07     8.57732e-09
  195.000     9.08888e-05        0.00000         1.57660e-06          1.00000       602.666     99.2901     0.892578     2.31845e-07     1.03420e-08
  197.500     1.09364e-04        0.00000         1.88864e-06          1.00000       602.647     99.2901     0.891778     2.77492e-07     1.24398e-08
  200.000     1.31272e-04        0.00000         2.25696e-06          1.00000       602.627     99.2901     0.890972     3.31319e-07     1.49278e-08
  202.500     1.57188e-04        0.00000         2.69068e-06          1.00000       602.606     99.2901     0.890158     3.94642e-07     1.78720e-08
  205.000     1.87772e-04        0.00000         3.20024e-06          1.00000       602.583     99.2901     0.889337     4.68964e-07     2.13481e-08
  207.500     2.23783e-04        0.00000         3.79753e-06          1.00000       602.558     99.2901     0.888509     5.55996e-07     2.54433e-08
  210.000     2.66088e-04        0.00000         4.49611e-06          1.00000       602.532     99.2901     0.887674     6.57684e-07     3.02573e-08
  212.500     3.15676e-04        0.00000         5.31133e-06          1.00000       602.504     99.2901     0.886831     7.76233e-07     3.59044e-08
  215.000     3.73673e-04        0.00000         6.26065e-06          0.99999       602.475     99.2901     0.885980     9.14140e-07     4.25149e-08
  217.500     4.41359e-04        0.00000         7.36375e-06          0.99999       602.443     99.2901     0.885122     1.07422e-06     5.02372e-08
  220.000     5.20185e-04        0.00000         8.64288e-06          0.99999       602.410     99.2901     0.884256     1.25966e-06     5.92404e-08
  222.500     6.11794e-04        0.00000         1.01231e-05          0.99999       602.374     99.2901     0.883383     1.47403e-06     6.97158e-08
  225.000     7.18038e-04        0.00000         1.18325e-05          0.99999       602.336     99.2901     0.882501     1.72133e-06     8.18808e-08
  227.500     8.41009e-04        0.00000         1.38027e-05          0.99999       602.296     99.2901     0.881612     2.00606e-06     9.59806e-08
  230.000     9.83057e-04        0.00000         1.60691e-05          0.99999       602.253     99.2901     0.880714     2.33324e-06     1.12292e-07
  232.500     1.14682e-03        0.00000         1.86711e-05          0.99999       602.208     99.2901     0.879808     2.70847e-06     1.31128e-07
  235.000     1.33526e-03        0.00000         2.16528e-05          0.99998       602.160     99.2901     0.878894     3.13799e-06     1.52839e-07
  237.500     1.55167e-03        0.00000         2.50632e-05          0.99998       602.109     99.2901     0.877971     3.62875e-06     1.77818e-07
  240.000     1.79976e-03        0.00000         2.89569e-05          0.99998       602.056     99.2901     0.877039     4.18843e-06     2.06509e-07
  242.500     2.08363e-03        0.00000         3.33943e-05          0.99997       601.999     99.2901     0.876099     4.82556e-06     2.39405e-07
  245.000     2.40786e-03        0.00000         3.84424e-05          0.99997       601.939     99.2901     0.875150     5.54958e-06     2.77059e-07
  247.500     2.77753e-03        0.00000         4.41752e-05          0.99997       601.875     99.2901     0.874192     6.37088e-06     3.20087e-07
  250.000     3.19828e-03        0.00000         5.06743e-05          0.99996       601.808     99.2901     0.873225     7.30093e-06     3.69175e-07
  252.500     3.67633e-03        0.00000         5.80297e-05          0.99996       601.737     99.2901     0.872249     8.35234e-06     4.25086e-07
  255.000     4.21858e-03        0.00000         6.63405e-05          0.99995       601.663     99.2901     0.871263     9.53897e-06     4.88667e-07
  257.500     4.83262e-03        0.00000         7.57153e-05          0.99995       601.584     99.2901     0.870268     1.08760e-05     5.60860e-07
  260.000     5.52681e-03        0.00000         8.62732e-05          0.99994       601.501     99.2901     0.869263     1.23801e-05     6.42703e-07
  262.500     6.31034e-03        0.00000         9.81448e-05          0.99993       601.414     99.2901     0.868248     1.40693e-05     7.35347e-07
  265.000     7.19332e-03        0.00000         1.11473e-04          0.99992       601.322     99.2901     0.867223     1.59636e-05     8.40063e-07
  267.500     8.18680e-03        0.00000         1.26412e-04          0.99991       601.225     99.2901     0.866188     1.80845e-05     9.58252e-07
  270.000     9.30289e-03        0.00000         1.43133e-04          0.99990       601.123     99.2901     0.865142     2.04556e-05     1.09146e-06
  272.500     1.05548e-02        0.00000         1.61820e-04          0.99989       601.016     99.2901     0.864086     2.31023e-05     1.24137e-06
  275.000     1.19570e-02        0.00000         1.82673e-04          0.99988       600.903     99.2901     0.863020     2.60524e-05     1.40986e-06
  277.500     1.35253e-02        0.00000         2.05910e-04          0.99987       600.785     99.2901     0.861942     2.93359e-05     1.59897e-06
  280.000     1.52766e-02        0.00000         2.31766e-04          0.99985       600.661     99.2901     0.860854     3.29853e-05     1.81094e-06
  282.500     1.72297e-02        0.00000         2.60497e-04          0.99984       600.530     99.2901     0.859754     3.70356e-05     2.04823e-06
  285.000     1.94047e-02        0.00000         2.92378e-04          0.99982       600.394     99.2901     0.858643     4.15247e-05     2.31351e-06
  287.500     2.18234e-02        0.00000         3.27706e-04          0.99980       600.250     99.2901     0.857520     4.64934e-05     2.60971e-06
  290.000     2.45096e-02        0.00000         3.66803e-04          0.99978       600.099     99.2901     0.856385     5.19855e-05     2.94004e-06
  292.500     2.74889e-02        0.00000         4.10012e-04          0.99975       599.942     99.2901     0.855239     5.80482e-05     3.30796e-06
  295.000     3.07888e-02        0.00000         4.57706e-04          0.99973       599.776     99.2901     0.854079     6.47321e-05     3.71728e-06
  297.500     3.44391e-02        0.00000         5.10282e-04          0.99970       599.603     99.2901     0.852908     7.20916e-05     4.17212e-06
  300.000     3.84720e-02        0.00000         5.68167e-04          0.99967       599.421     99.2901     0.851723     8.01848e-05     4.67696e-06
  302.500     4.29219e-02        0.00000         6.31820e-04          0.99964       599.231     99.2901     0.850526     8.90738e-05     5.23666e-06
  305.000     4.78259e-02        0.00000         7.01730e-04          0.99960       599.033     99.2901     0.849315     9.88252e-05     5.85651e-06
  307.500     5.32238e-02        0.00000         7.78421e-04          0.99956       598.825     99.2901     0.848091     1.09510e-04     6.54222e-06
  310.000     5.91583e-02        0.00000         8.62452e-04          0.99952       598.607     99.2901     0.846853     1.21203e-04     7.30000e-06
  312.500     6.56750e-02        0.00000         9.54419e-04          0.99948       598.380     99.2901     0.845601     1.33986e-04     8.13655e-06
  315.000     7.28229e-02        0.00000         1.05496e-03          0.99943       598.142     99.2901     0.844335     1.47945e-04     9.05912e-06
  317.500     8.06542e-02        0.00000         1.16475e-03          0.99938       597.894     99.2901     0.843054     1.63170e-04     1.00756e-05
  320.000     8.92247e-02        0.00000         1.28450e-03          0.99932       597.634     99.2901     0.841758     1.79758e-04     1.11943e-05
  322.500     9.85941e-02        0.00000         1.41499e-03          0.99926       597.363     99.2901     0.840447     1.97812e-04     1.24245e-05
  325.000     1.08826e-01        0.00000         1.55702e-03          0.99920       597.080     99.2901     0.839120     2.17441e-04     1.37760e-05
  327.500     1.19987e-01        0.00000         1.71146e-03          0.99913       596.784     99.2901     0.837777     2.38761e-04     1.52595e-05
  330.000     1.32150e-01        0.00000         1.87922e-03          0.99905       596.475     99.2901     0.836418     2.61894e-04     1.68863e-05
  332.500     1.45392e-01        0.00000         2.06126e-03          0.99897       596.154     99.2901     0.835042     2.86970e-04     1.86688e-05
  335.000     1.59793e-01        0.00000         2.25862e-03          0.99889       595.818     99.2901     0.833649     3.14124e-04     2.06203e-05
  337.500     1.75440e-01        0.00000         2.47236e-03          0.99880       595.467     99.2901     0.832239     3.43502e-04     2.27550e-05
  340.000     1.92424e-01        0.00000         2.70363e-03          0.99870       595.102     99.2901     0.830811     3.75257e-04     2.50883e-05
  342.500     2.10843e-01        0.00000         2.95364e-03          0.99860       594.721     99.2901     0.829365     4.09549e-04     2.76367e-05
  345.000     2.30799e-01        0.00000         3.22366e-03          0.99849       594.323     99.2901     0.827901     4.46548e-04     3.04181e-05
  347.500     2.52401e-01        0.00000         3.51504e-03          0.99837       593.909     99.2901     0.826417     4.86433e-04     3.34513e-05
  350.000     2.75764e-01        0.00000         3.82919e-03          0.99825       593.478     99.2901     0.824913     5.29394e-04     3.67571e-05
  352.500     3.01011e-01        0.00000         4.16761e-03          0.99812       593.028     99.2901     0.823390     5.75628e-04     4.03573e-05
  355.000     3.28271e-01        0.00000         4.53186e-03          0.99798       592.560     99.2901     0.821846     6.25346e-04     4.42757e-05
  357.500     3.57679e-01        0.00000         4.92359e-03          0.99783       592.072     99.2901     0.820281     6.78768e-04     4.85377e-05
  360.000     3.89379e-01        0.00000         5.34456e-03          0.99767       591.563     99.2901     0.818694     7.36124e-04     5.31707e-05
  362.500     4.23525e-01        0.00000         5.79658e-03          0.99750       591.034     99.2901     0.817086     7.97661e-04     5.82039e-05
  365.000     4.60276e-01        0.00000         6.28158e-03          0.99733       590.482     99.2901     0.815454     8.63634e-04     6.36689e-05
  367.500     4.99802e-01        0.00000         6.80158e-03          0.99714       589.908     99.2901     0.813799     9.34312e-04     6.95996e-05
  370.000     5.42282e-01        0.00000         7.35871e-03          0.99694       589.310     99.2901     0.812121     1.00998e-03     7.60325e-05
  372.500     5.87904e-01        0.00000         7.95521e-03          0.99674       588.688     99.2901     0.810418     1.09094e-03     8.30066e-05
  375.000     6.36869e-01        0.00000         8.59341e-03          0.99652       588.040     99.2901     0.808689     1.17750e-03     9.05640e-05
  377.500     6.89385e-01        0.00000         9.27578e-03          0.99629       587.366     99.2901     0.806935     1.26999e-03     9.87501e-05
  380.000     7.45676e-01        0.00000         1.00049e-02          0.99604       586.664     99.2901     0.805154     1.36877e-03     1.07613e-04
  382.500     8.05975e-01        0.00000         1.07835e-02          0.99579       585.933     99.2901     0.803345     1.47419e-03     1.17207e-04
  385.000     8.70528e-01        0.00000         1.16145e-02          0.99552       585.172     99.2901     0.801508     1.58665e-03     1.27586e-04
  387.500     9.39598e-01        0.00000         1.25008e-02          0.99524       584.380     99.2901     0.799642     1.70654e-03     1.38812e-04
  390.000     1.01346e+00        0.00000         1.34455e-02          0.99494       583.556     99.2901     0.797746     1.83429e-03     1.50951e-04
  392.500     1.09240e+00        0.00000         1.44521e-02          0.99463       582.698     99.2901     0.795819     1.97036e-03     1.64073e-04
  395.000     1.17673e+00        0.00000         1.55239e-02          0.99430       581.805     99.2901     0.793860     2.11522e-03     1.78255e-04
  397.500     1.26677e+00        0.00000         1.66647e-02          0.99396       580.876     99.2901     0.791868     2.26937e-03     1.93579e-04
  400.000     1.36287e+00        0.00000         1.78783e-02          0.99360       579.908     99.2901     0.789842     2.43334e-03     2.10135e-04
  402.500     1.46538e+00        0.00000         1.91687e-02          0.99322       578.901     99.2901     0.787782     2.60768e-03     2.28018e-04
  405.000     1.57470e+00        0.00000         2.05402e-02          0.99283       577.852     99.2901     0.785684     2.79298e-03     2.47334e-04
  407.500     1.69122e+00        0.00000         2.19973e-02          0.99242       576.760     99.2901     0.783550     2.98988e-03     2.68195e-04
  410.000     1.81538e+00        0.00000         2.35448e-02          0.99198       575.622     99.2901     0.781376     3.19903e-03     2.90725e-04
  412.500     1.94763e+00        0.00000         2.51875e-02          0.99153       574.438     99.2901     0.779163     3.42113e-03     3.15058e-04
  415.000     2.08847e+00        0.00000         2.69309e-02          0.99106       573.204     99.2901     0.776907     3.65693e-03     3.41338e-04
  417.500     2.23840e+00        0.00000         2.87804e-02          0.99057       571.918     99.2901     0.774609     3.90721e-03     3.69724e-04
  420.000     2.39797e+00        0.00000         3.07420e-02          0.99005       570.579     99.2901     0.772265     4.17282e-03     4.00390e-04
  422.500     2.56777e+00        0.00000         3.28218e-02          0.98952       569.183     99.2901     0.769875     4.45466e-03     4.33522e-04
  425.000     2.74842e+00        0.00000         3.50265e-02          0.98895       567.728     99.2901     0.767436     4.75367e-03     4.69329e-04
  427.500     2.94058e+00        0.00000         3.73631e-02          0.98837       566.210     99.2901     0.764947     5.07089e-03     5.08036e-04
  430.000     3.14496e+00        0.00000         3.98390e-02          0.98776       564.627     99.2901     0.762406     5.40740e-03     5.49891e-04
  432.500     3.36233e+00        0.00000         4.24621e-02          0.98712       562.976     99.2901     0.759810     5.76437e-03     5.95168e-04
  435.000     3.59350e+00        0.00000         4.52409e-02          0.98646       561.253     99.2901     0.757156     6.14307e-03     6.44168e-04
  437.500     3.83935e+00        0.00000         4.81842e-02          0.98577       559.453     99.2901     0.754443     6.54485e-03     6.97224e-04
  440.000     4.10082e+00        0.00000         5.13018e-02          0.98504       557.574     99.2901     0.751667     6.97117e-03     7.54703e-04
  442.500     4.37893e+00        0.00000         5.46039e-02          0.98429       555.611     99.2901     0.748825     7.42362e-03     8.17013e-04
  445.000     4.67480e+00        0.00000         5.81015e-02          0.98351       553.558     99.2901     0.745915     7.90390e-03     8.84609e-04
  447.500     4.98960e+00        0.00000         6.18064e-02          0.98269       551.412     99.2901     0.742933     8.41388e-03     9.57998e-04
  450.000     5.32465e+00        0.00000         6.57316e-02          0.98184       549.166     99.2901     0.739874     8.95558e-03     1.03775e-03
  452.500     5.68136e+00        0.00000         6.98906e-02          0.98095       546.814     99.2901     0.736736     9.53122e-03     1.12449e-03
  455.000     6.06129e+00        0.00000         7.42986e-02          0.98003       544.350     99.2901     0.733512     1.01432e-02     1.21895e-03
  457.500     6.46613e+00        0.50000         9.79066e-01          0.97907        99.290     99.2901     0.010794     1.07943e-02     1.00000e+00
  460.000     6.89777e+00        0.00000         8.39279e-02          0.97806       539.056     99.2901     0.726791     1.14874e-02     1.43434e-03
  462.500     7.35827e+00        0.00000         8.91862e-02          0.97701       536.210     99.2901     0.723282     1.22258e-02     1.55724e-03
  465.000     7.84995e+00        0.00000         9.47682e-02          0.97592       533.219     99.2901     0.719665     1.30130e-02     1.69183e-03
  467.500     8.37536e+00        0.00000         1.00697e-01          0.97478       530.071     99.2901     0.715933     1.38534e-02     1.83947e-03
  470.000     8.93740e+00        0.00000         1.07000e-01          0.97359       526.756     99.2901     0.712077     1.47513e-02     2.00178e-03
  472.500     9.53931e+00        0.00000         1.13704e-01          0.97235       523.259     99.2901     0.708088     1.57121e-02     2.18059e-03
  475.000     1.01848e+01        0.00000         1.20844e-01          0.97104       519.567     99.2901     0.703956     1.67416e-02     2.37808e-03
  477.500     1.08781e+01        0.00000         1.28456e-01          0.96968       515.661     99.2901     0.699668     1.78467e-02     2.59683e-03
  480.000     1.16240e+01        0.00000         1.36581e-01          0.96826       511.523     99.2901     0.695210     1.90352e-02     2.83987e-03
  482.500     1.24283e+01        0.00000         1.45268e-01          0.96676       507.130     99.2901     0.690566     2.03163e-02     3.11087e-03
  485.000     1.32975e+01        0.00000         1.54573e-01          0.96519       502.456     99.2901     0.685717     2.17007e-02     3.41427e-03
  487.500     1.42395e+01        0.00000         1.64560e-01          0.96353       497.470     99.2901     0.680641     2.32014e-02     3.75553e-03
  490.000     1.52639e+01        0.00000         1.75308e-01          0.96179       492.135     99.2901     0.675309     2.48339e-02     4.14143e-03
  492.500     1.63821e+01        0.00000         1.86909e-01          0.95995       486.406     99.2901     0.669691     2.66173e-02     4.58055e-03
  495.000     1.76086e+01        0.00000         1.99477e-01          0.95799       480.230     99.2901     0.663743     2.85751e-02     5.08392e-03
  497.500     1.89616e+01        0.00000         2.13156e-01          0.95591       473.536     99.2901     0.657415     3.07377e-02     5.66606e-03
  500.000     2.04649e+01        0.00000         2.28128e-01          0.95369       466.237     99.2901     0.650639     3.31445e-02     6.34660e-03
  502.500     2.21506e+01        0.00000         2.44637e-01          0.95129       458.213     99.2901     0.643323     3.58490e-02     7.15290e-03
  505.000     2.40634e+01        0.00000         2.63020e-01          0.94869       449.300     99.2901     0.635342     3.89260e-02     8.12486e-03
  507.500     2.62699e+01        0.00000         2.83766e-01          0.94584       439.258     99.2901     0.626508     4.24870e-02     9.32386e-03
  510.000     2.88760e+01        0.00000         3.07649e-01          0.94265       427.705     99.2901     0.616521     4.67104e-02     1.08520e-02
  512.500     3.20718e+01        0.00000         3.36032e-01          0.93899       413.968     99.2901     0.604849     5.19168e-02     1.29001e-02
  515.000     3.62711e+01        0.00000         3.71850e-01          0.93454       396.592     99.2901     0.590329     5.88064e-02     1.59030e-02
  517.500     4.28880e+01        0.00000         4.24990e-01          0.92831       370.662     99.2901     0.569006     6.97802e-02     2.14255e-02
  518.431     4.76765e+01        0.00000         4.61023e-01          0.92431       352.936     99.2901     0.554560     7.78149e-02     2.60958e-02
  518.764     5.29998e+01        0.00000         4.98791e-01          0.92033       334.196     99.2901     0.539317     8.68406e-02     3.20365e-02
  518.764     5.30493e+01        0.00000         4.99132e-01          0.92030       334.026     99.2901     0.539179     8.69251e-02     3.20958e-02
  518.461     5.84179e+01        0.00000         5.34865e-01          0.91674       316.119     99.2901     0.524574     9.61298e-02     3.89916e-02
  517.500     6.43299e+01        0.00000         5.71631e-01          0.91332       297.486     99.2901     0.509266     1.06384e-01     4.77658e-02
  515.000     7.32306e+01        0.00000         6.22194e-01          0.90907       271.459     99.2901     0.487559     1.22055e-01     6.37047e-02
  512.500     7.97009e+01        0.00000         6.55589e-01          0.90662       253.974     99.2901     0.472670     1.33622e-01     7.77258e-02
  510.000     8.51550e+01        0.00000         6.81698e-01          0.90496       240.118     99.2901     0.460643     1.43486e-01     9.14243e-02
  507.500     9.00064e+01        0.00000         7.03447e-01          0.90377       228.436     99.2901     0.450316     1.52347e-01     1.05267e-01
  505.000     9.44451e+01        0.00000         7.22196e-01          0.90291       218.255     99.2901     0.441154     1.60525e-01     1.19479e-01
  502.500     9.85769e+01        0.00000         7.38713e-01          0.90232       209.193     99.2901     0.432860     1.68198e-01     1.34197e-01
  500.000     1.02468e+02        0.00000         7.53482e-01          0.90193       201.011     99.2901     0.425245     1.75478e-01     1.49521e-01
  497.500     1.06164e+02        0.00000         7.66835e-01          0.90172       193.545     99.2901     0.418182     1.82440e-01     1.65529e-01
  495.000     1.09696e+02        0.00000         7.79011e-01          0.90165       186.676     99.2901     0.411580     1.89137e-01     1.82290e-01
  492.500     1.13087e+02        0.00000         7.90188e-01          0.90171       180.316     99.2901     0.405371     1.95608e-01     1.99868e-01
  490.000     1.16357e+02        0.00000         8.00505e-01          0.90189       174.396     99.2901     0.399504     2.01884e-01     2.18324e-01
  487.500     1.19519e+02        0.00000         8.10071e-01          0.90216       168.863     99.2901     0.393937     2.07988e-01     2.37716e-01
  485.000     1.22584e+02        0.00000         8.18975e-01          0.90253       163.670     99.2901     0.388637     2.13938e-01     2.58105e-01
  482.500     1.25563e+02        0.00000         8.27291e-01          0.90299       158.783     99.2901     0.383576     2.19751e-01     2.79552e-01
  480.000     1.28462e+02        0.00000         8.35080e-01          0.90352       154.170     99.2901     0.378732     2.25439e-01     3.02118e-01
  477.500     1.31289e+02        0.00000         8.42394e-01          0.90412       149.806     99.2901     0.374085     2.31013e-01     3.25869e-01
  475.000     1.34049e+02        0.00000         8.49277e-01          0.90479       145.668     99.2901     0.369620     2.36482e-01     3.50872e-01
  472.500     1.36746e+02        0.00000         8.55768e-01          0.90552       141.737     99.2901     0.365321     2.41854e-01     3.77196e-01
  470.000     1.39386e+02        0.00000         8.61900e-01          0.90631       137.997     99.2901     0.361178     2.47135e-01     4.04915e-01
  467.500     1.41970e+02        0.00000         8.67702e-01          0.90716       134.432     99.2901     0.357178     2.52332e-01     4.34106e-01
  465.000     1.44504e+02        0.00000         8.73200e-01          0.90806       131.030     99.2901     0.353312     2.57449e-01     4.64849e-01
  462.500     1.46988e+02        0.00000         8.78417e-01          0.90901       127.779     99.2901     0.349572     2.62491e-01     4.97230e-01
  460.000     1.49427e+02        0.00000         8.83374e-01          0.91001       124.669     99.2901     0.345950     2.67462e-01     5.31338e-01
  457.500     1.51821e+02        0.00000         8.88088e-01          0.91105       121.689     99.2901     0.342439     2.72366e-01     5.67266e-01
  455.000     1.54173e+02        0.00000         8.92576e-01          0.91213       118.832     99.2901     0.339034     2.77206e-01     6.05115e-01
  452.500     1.56485e+02        0.00000         8.96854e-01          0.91325       116.091     99.2901     0.335728     2.81985e-01     6.44990e-01
  450.000     1.58759e+02        0.00000         9.00934e-01          0.91442       113.457     99.2901     0.332516     2.86705e-01     6.87001e-01
  447.500     1.60995e+02        0.00000         9.04830e-01          0.91562       110.925     99.2901     0.329394     2.91369e-01     7.31266e-01
  445.000     1.63195e+02        0.00000         9.08551e-01          0.91686       108.489     99.2901     0.326358     2.95979e-01     7.77908e-01
  442.500     1.65360e+02        0.00000         9.12109e-01          0.91813       106.144     99.2901     0.323403     3.00537e-01     8.27060e-01
  440.000     1.67492e+02        0.00000         9.15513e-01          0.91944       103.884     99.2901     0.320526     3.05045e-01     8.78858e-01
  437.500     1.69592e+02        0.00000         9.18771e-01          0.92077       101.705     99.2901     0.317723     3.09505e-01     9.33452e-01
  435.040     1.71627e+02        0.00000         9.21843e-01          0.92212        99.636     99.2901     0.315036     3.13848e-01     9.90049e-01
  434.620     1.71971e+02        0.50000         9.22354e-01          0.92235        99.290     99.2901     0.314584     3.14584e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   12.910     1.69793e+02        0.00000         1.33470e+00          0.96101       151.546     99.2901     0.810568     7.37572e-01     2.41182e-01
   13.517     2.52959e+02        0.00000         1.95931e+00          1.41346       150.489     99.2901     0.815157     7.45523e-01     2.40137e-01
   14.873     3.76860e+02        0.00000         2.85856e+00          2.06955       149.077     99.2901     0.820697     7.55003e-01     2.41163e-01
   17.203     5.61448e+02        0.00000         4.14461e+00          3.01504       147.432     99.2901     0.827291     7.65882e-01     2.44473e-01
   20.637     8.36450e+02        0.00000         5.97685e+00          4.37102       145.726     99.2901     0.834906     7.77850e-01     2.49932e-01
   25.153     1.24615e+03        0.00000         8.58625e+00          6.31148       144.112     99.2901     0.843287     7.90411e-01     2.57153e-01
   30.544     1.85652e+03        0.00000         1.23133e+01          9.09200       142.679     99.2901     0.851951     8.02926e-01     2.65634e-01
   36.438     2.76586e+03        0.00000         1.76661e+01         13.09503       141.444     99.2901     0.860308     8.14724e-01     2.74522e-01
   42.370     4.12059e+03        0.00000         2.54098e+01         18.89853       140.390     99.2901     0.867830     8.25233e-01     2.82005e-01
   47.893     6.13889e+03        0.00000         3.66994e+01         27.37680       139.498     99.2901     0.874182     8.34096e-01     2.89132e-01
   52.684     9.14576e+03        0.00000         5.32751e+01         39.84691       138.755     99.2901     0.879258     8.41204e-01     2.95533e-01
   56.591     1.36254e+04        0.00000         7.77477e+01         58.28265       138.156     99.2901     0.883132     8.46662e-01     3.00949e-01
   59.619     2.02992e+04        0.00000         1.14019e+02         85.63082       137.690     99.2901     0.885987     8.50706e-01     3.05289e-01
   61.873     3.02420e+04        0.00000         1.67906e+02        126.28252       137.339     99.2901     0.888033     8.53620e-01     3.08610e-01
   63.500     4.50547e+04        0.00000         2.48074e+02        186.77704       137.084     99.2901     0.889471     8.55676e-01     3.10797e-01
   64.650     6.71228e+04        0.00000         3.67424e+02        276.85248       136.902     99.2901     0.890467     8.57104e-01     3.12343e-01
   65.449     1.00000e+05        0.00000         5.45174e+02        411.01230       136.775     99.2901     0.891150     8.58087e-01     3.13430e-01
END

$Env_BP << END
#   Temp      Sat Pres                                                                                    Liq Den      Gas Den           
#   (C)         (bar)       Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   ----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
  457.500       6.4661         0.5000            0.97907          0.979066       99.2901     99.2901     0.010794     0.010794     1.00000e+00
      NaN          NaN            NaN                NaN               NaN           NaN         NaN          NaN          NaN             NaN
  434.620     171.9707         0.5000            0.92235          0.922354       99.2901     99.2901     0.314584     0.314584     1.00000e+00
  434.201     172.3140         1.0000            0.92259          0.922863       99.2901     98.9458     0.315319     0.314132     9.90045e-01
  432.500     173.6963         1.0000            0.92354          0.924883       99.2901     97.5736     0.318285     0.312329     9.50883e-01
  430.000     175.7031         1.0000            0.92497          0.927750       99.2901     95.6137     0.322608     0.309732     8.96377e-01
  427.500     177.6806         1.0000            0.92643          0.930500       99.2901     93.7197     0.326888     0.307198     8.45291e-01
  425.000     179.6295         1.0000            0.92791          0.933139       99.2901     91.8883     0.331127     0.304725     7.97372e-01
  422.500     181.5503         1.0000            0.92942          0.935672       99.2901     90.1168     0.335325     0.302311     7.52393e-01
  420.000     183.4436         1.0000            0.93095          0.938104       99.2901     88.4022     0.339484     0.299953     7.10142e-01
  417.500     185.3101         1.0000            0.93251          0.940441       99.2901     86.7420     0.343604     0.297649     6.70430e-01
  415.000     187.1501         1.0000            0.93409          0.942685       99.2901     85.1339     0.347687     0.295399     6.33081e-01
  412.500     188.9641         1.0000            0.93570          0.944843       99.2901     83.5754     0.351732     0.293199     5.97935e-01
  410.000     190.7526         1.0000            0.93733          0.946916       99.2901     82.0645     0.355742     0.291048     5.64844e-01
  407.500     192.5160         1.0000            0.93898          0.948909       99.2901     80.5991     0.359716     0.288944     5.33672e-01
  405.000     194.2545         1.0000            0.94065          0.950826       99.2901     79.1774     0.363656     0.286887     5.04295e-01
  402.500     195.9687         1.0000            0.94234          0.952669       99.2901     77.7975     0.367562     0.284875     4.76596e-01
  400.000     197.6587         1.0000            0.94405          0.954441       99.2901     76.4577     0.371435     0.282906     4.50469e-01
  397.500     199.3249         1.0000            0.94577          0.956145       99.2901     75.1564     0.375276     0.280979     4.25816e-01
  395.000     200.9676         1.0000            0.94752          0.957784       99.2901     73.8922     0.379084     0.279093     4.02545e-01
  392.500     202.5870         1.0000            0.94928          0.959360       99.2901     72.6634     0.382861     0.277246     3.80570e-01
  390.000     204.1834         1.0000            0.95107          0.960876       99.2901     71.4689     0.386607     0.275438     3.59814e-01
  387.500     205.7570         1.0000            0.95286          0.962333       99.2901     70.3072     0.390323     0.273667     3.40203e-01
  385.000     207.3080         1.0000            0.95468          0.963735       99.2901     69.1772     0.394009     0.271933     3.21669e-01
  382.500     208.8366         1.0000            0.95651          0.965081       99.2901     68.0776     0.397665     0.270234     3.04147e-01
  380.000     210.3430         1.0000            0.95835          0.966375       99.2901     67.0074     0.401293     0.268570     2.87580e-01
  377.500     211.8273         1.0000            0.96021          0.967619       99.2901     65.9655     0.404892     0.266939     2.71912e-01
  375.000     213.2898         1.0000            0.96209          0.968813       99.2901     64.9508     0.408463     0.265341     2.57091e-01
  372.500     214.7306         1.0000            0.96397          0.969959       99.2901     63.9624     0.412006     0.263775     2.43068e-01
  370.000     216.1497         1.0000            0.96587          0.971059       99.2901     62.9994     0.415522     0.262240     2.29800e-01
  367.500     217.5474         1.0000            0.96778          0.972114       99.2901     62.0609     0.419012     0.260735     2.17242e-01
  365.000     218.9237         1.0000            0.96971          0.973125       99.2901     61.1461     0.422475     0.259260     2.05357e-01
  362.500     220.2788         1.0000            0.97164          0.974094       99.2901     60.2541     0.425911     0.257814     1.94106e-01
  360.000     221.6128         1.0000            0.97359          0.975022       99.2901     59.3842     0.429322     0.256396     1.83454e-01
  357.500     222.9256         1.0000            0.97555          0.975909       99.2901     58.5356     0.432707     0.255005     1.73369e-01
  355.000     224.2175         1.0000            0.97752          0.976757       99.2901     57.7077     0.436068     0.253641     1.63820e-01
  352.500     225.4885         1.0000            0.97949          0.977567       99.2901     56.8998     0.439403     0.252303     1.54778e-01
  350.000     226.7387         1.0000            0.98148          0.978339       99.2901     56.1111     0.442714     0.250991     1.46216e-01
  347.500     227.9681         1.0000            0.98348          0.979075       99.2901     55.3412     0.446000     0.249704     1.38108e-01
  345.000     229.1767         1.0000            0.98548          0.979775       99.2901     54.5893     0.449263     0.248441     1.30430e-01
  342.500     230.3647         1.0000            0.98749          0.980440       99.2901     53.8550     0.452502     0.247203     1.23158e-01
  340.000     231.5320         1.0000            0.98951          0.981071       99.2901     53.1377     0.455718     0.245987     1.16272e-01
  337.500     232.6787         1.0000            0.99154          0.981668       99.2901     52.4369     0.458910     0.244795     1.09751e-01
  335.000     233.8049         1.0000            0.99357          0.982232       99.2901     51.7520     0.462080     0.243625     1.03577e-01
  332.500     234.9105         1.0000            0.99561          0.982764       99.2901     51.0826     0.465227     0.242477     9.77300e-02
  330.000     235.9955         1.0000            0.99765          0.983263       99.2901     50.4281     0.468352     0.241350     9.21941e-02
  327.500     237.0600         1.0000            0.99970          0.983731       99.2901     49.7883     0.471454     0.240244     8.69529e-02
  325.000     238.1041         1.0000            1.00175          0.984169       99.2901     49.1625     0.474535     0.239159     8.19910e-02
  322.500     239.1276         1.0000            1.00381          0.984575       99.2901     48.5505     0.477594     0.238094     7.72941e-02
  320.000     240.1305         1.0000            1.00587          0.984952       99.2901     47.9518     0.480631     0.237049     7.28484e-02
  317.500     241.1130         1.0000            1.00794          0.985299       99.2901     47.3660     0.483648     0.236023     6.86410e-02
  315.000     242.0749         1.0000            1.01000          0.985617       99.2901     46.7928     0.486643     0.235016     6.46596e-02
  312.500     243.0163         1.0000            1.01207          0.985905       99.2901     46.2317     0.489618     0.234028     6.08925e-02
  310.000     243.9371         1.0000            1.01414          0.986165       99.2901     45.6825     0.492572     0.233058     5.73288e-02
  307.500     244.8374         1.0000            1.01622          0.986396       99.2901     45.1448     0.495506     0.232106     5.39581e-02
  305.000     245.7169         1.0000            1.01829          0.986599       99.2901     44.6183     0.498420     0.231171     5.07703e-02
  302.500     246.5759         1.0000            1.02036          0.986774       99.2901     44.1027     0.501313     0.230253     4.77561e-02
  300.000     247.4141         1.0000            1.02244          0.986922       99.2901     43.5977     0.504187     0.229352     4.49066e-02
  297.500     248.2317         1.0000            1.02451          0.987041       99.2901     43.1030     0.507041     0.228468     4.22134e-02
  295.000     249.0284         1.0000            1.02658          0.987133       99.2901     42.6183     0.509876     0.227600     3.96683e-02
  292.500     249.8044         1.0000            1.02865          0.987198       99.2901     42.1434     0.512692     0.226748     3.72639e-02
  290.000     250.5594         1.0000            1.03072          0.987235       99.2901     41.6780     0.515489     0.225912     3.49927e-02
  287.500     251.2936         1.0000            1.03278          0.987245       99.2901     41.2218     0.518267     0.225091     3.28481e-02
  285.000     252.0068         1.0000            1.03484          0.987228       99.2901     40.7746     0.521026     0.224285     3.08234e-02
  282.500     252.6989         1.0000            1.03690          0.987184       99.2901     40.3362     0.523767     0.223493     2.89124e-02
  280.000     253.3699         1.0000            1.03895          0.987113       99.2901     39.9063     0.526489     0.222717     2.71093e-02
  277.500     254.0198         1.0000            1.04100          0.987015       99.2901     39.4847     0.529194     0.221954     2.54084e-02
  275.000     254.6484         1.0000            1.04304          0.986889       99.2901     39.0713     0.531880     0.221206     2.38045e-02
  272.500     255.2556         1.0000            1.04507          0.986737       99.2901     38.6658     0.534549     0.220471     2.22924e-02
  270.000     255.8415         1.0000            1.04710          0.986557       99.2901     38.2679     0.537199     0.219750     2.08674e-02
  267.500     256.4059         1.0000            1.04912          0.986351       99.2901     37.8776     0.539833     0.219043     1.95248e-02
  265.000     256.9488         1.0000            1.05113          0.986117       99.2901     37.4946     0.542449     0.218348     1.82604e-02
  262.500     257.4700         1.0000            1.05313          0.985855       99.2901     37.1188     0.545047     0.217667     1.70700e-02
  260.000     257.9695         1.0000            1.05513          0.985566       99.2901     36.7499     0.547629     0.216998     1.59497e-02
  257.500     258.4471         1.0000            1.05711          0.985250       99.2901     36.3879     0.550194     0.216341     1.48958e-02
  255.000     258.9028         1.0000            1.05908          0.984906       99.2901     36.0324     0.552742     0.215697     1.39046e-02
  252.500     259.3364         1.0000            1.06104          0.984533       99.2901     35.6835     0.555273     0.215065     1.29729e-02
  250.000     259.7480         1.0000            1.06299          0.984133       99.2901     35.3409     0.557788     0.214445     1.20974e-02
  247.500     260.1373         1.0000            1.06492          0.983704       99.2901     35.0045     0.560287     0.213836     1.12751e-02
  245.000     260.5042         1.0000            1.06684          0.983247       99.2901     34.6741     0.562769     0.213240     1.05031e-02
  242.500     260.8487         1.0000            1.06875          0.982761       99.2901     34.3496     0.565236     0.212654     9.77854e-03
  240.000     261.1706         1.0000            1.07064          0.982246       99.2901     34.0309     0.567686     0.212080     9.09893e-03
  237.500     261.4698         1.0000            1.07251          0.981702       99.2901     33.7178     0.570121     0.211516     8.46174e-03
  235.000     261.7462         1.0000            1.07437          0.981128       99.2901     33.4103     0.572540     0.210964     7.86460e-03
  232.500     261.9996         1.0000            1.07621          0.980525       99.2901     33.1081     0.574943     0.210422     7.30528e-03
  230.000     262.2299         1.0000            1.07803          0.979891       99.2901     32.8111     0.577331     0.209891     6.78164e-03
  227.500     262.4371         1.0000            1.07983          0.979227       99.2901     32.5193     0.579704     0.209370     6.29165e-03
  225.000     262.6209         1.0000            1.08161          0.978532       99.2901     32.2325     0.582062     0.208860     5.83341e-03
  222.500     262.7812         1.0000            1.08337          0.977805       99.2901     31.9507     0.584404     0.208359     5.40507e-03
  220.000     262.9179         1.0000            1.08511          0.977048       99.2901     31.6736     0.586732     0.207869     5.00492e-03
  217.500     263.0309         1.0000            1.08682          0.976258       99.2901     31.4013     0.589045     0.207388     4.63130e-03
  215.000     263.1199         1.0000            1.08851          0.975436       99.2901     31.1336     0.591343     0.206917     4.28266e-03
  212.500     263.1848         1.0000            1.09017          0.974581       99.2901     30.8704     0.593627     0.206456     3.95752e-03
  210.000     263.2256         1.0000            1.09181          0.973693       99.2901     30.6116     0.595896     0.206004     3.65449e-03
  207.500     263.2419         1.0000            1.09342          0.972771       99.2901     30.3571     0.598151     0.205561     3.37223e-03
  205.000     263.2337         1.0000            1.09500          0.971814       99.2901     30.1068     0.600392     0.205128     3.10949e-03
  202.500     263.2008         1.0000            1.09655          0.970824       99.2901     29.8607     0.602619     0.204704     2.86507e-03
  200.000     263.1430         1.0000            1.09807          0.969798       99.2901     29.6187     0.604832     0.204288     2.63785e-03
  197.500     263.0601         1.0000            1.09956          0.968736       99.2901     29.3806     0.607030     0.203882     2.42676e-03
  195.000     262.9521         1.0000            1.10101          0.967638       99.2901     29.1465     0.609216     0.203484     2.23080e-03
  192.500     262.8186         1.0000            1.10243          0.966502       99.2901     28.9161     0.611387     0.203095     2.04900e-03
  190.000     262.6595         1.0000            1.10382          0.965330       99.2901     28.6895     0.613545     0.202714     1.88046e-03
  187.500     262.4747         1.0000            1.10516          0.964119       99.2901     28.4666     0.615690     0.202342     1.72434e-03
  185.000     262.2638         1.0000            1.10647          0.962870       99.2901     28.2472     0.617821     0.201978     1.57982e-03
  182.500     262.0269         1.0000            1.10774          0.961581       99.2901     28.0314     0.619939     0.201623     1.44615e-03
  180.000     261.7635         1.0000            1.10897          0.960252       99.2901     27.8190     0.622044     0.201275     1.32261e-03
  177.500     261.4736         1.0000            1.11015          0.958882       99.2901     27.6101     0.624136     0.200935     1.20853e-03
  175.000     261.1569         1.0000            1.11129          0.957470       99.2901     27.4044     0.626215     0.200604     1.10326e-03
  172.500     260.8133         1.0000            1.11238          0.956017       99.2901     27.2020     0.628281     0.200280     1.00621e-03
  170.000     260.4424         1.0000            1.11343          0.954520       99.2901     27.0028     0.630334     0.199964     9.16810e-04
  167.500     260.0441         1.0000            1.11442          0.952979       99.2901     26.8068     0.632375     0.199655     8.34533e-04
  165.000     259.6182         1.0000            1.11537          0.951394       99.2901     26.6138     0.634403     0.199354     7.58878e-04
  162.500     259.1645         1.0000            1.11626          0.949763       99.2901     26.4239     0.636419     0.199060     6.89374e-04
  160.000     258.6826         1.0000            1.11710          0.948085       99.2901     26.2369     0.638423     0.198774     6.25582e-04
  157.500     258.1724         1.0000            1.11788          0.946361       99.2901     26.0528     0.640414     0.198495     5.67088e-04
  155.000     257.6336         1.0000            1.11861          0.944588       99.2901     25.8716     0.642393     0.198223     5.13504e-04
  152.500     257.0661         1.0000            1.11927          0.942765       99.2901     25.6932     0.644360     0.197958     4.64467e-04
  150.000     256.4694         1.0000            1.11987          0.940893       99.2901     25.5176     0.646315     0.197700     4.19636e-04
  147.500     255.8435         1.0000            1.12041          0.938969       99.2901     25.3446     0.648259     0.197448     3.78693e-04
  145.000     255.1880         1.0000            1.12088          0.936993       99.2901     25.1743     0.650190     0.197204     3.41341e-04
  142.500     254.5026         1.0000            1.12128          0.934963       99.2901     25.0067     0.652110     0.196966     3.07302e-04
  140.000     253.7872         1.0000            1.12162          0.932879       99.2901     24.8416     0.654018     0.196735     2.76316e-04
  137.500     253.0413         1.0000            1.12187          0.930740       99.2901     24.6790     0.655915     0.196510     2.48141e-04
  135.000     252.2649         1.0000            1.12206          0.928543       99.2901     24.5189     0.657800     0.196291     2.22552e-04
  132.500     251.4575         1.0000            1.12216          0.926288       99.2901     24.3612     0.659674     0.196079     1.99339e-04
  130.000     250.6188         1.0000            1.12219          0.923975       99.2901     24.2059     0.661537     0.195873     1.78308e-04
  127.500     249.7487         1.0000            1.12213          0.921600       99.2901     24.0529     0.663388     0.195672     1.59276e-04
  125.000     248.8468         1.0000            1.12198          0.919164       99.2901     23.9023     0.665229     0.195478     1.42075e-04
  122.500     247.9127         1.0000            1.12175          0.916664       99.2901     23.7539     0.667058     0.195289     1.26549e-04
  120.000     246.9463         1.0000            1.12142          0.914100       99.2901     23.6078     0.668877     0.195106     1.12554e-04
  117.500     245.9471         1.0000            1.12101          0.911469       99.2901     23.4638     0.670684     0.194929     9.99562e-05
  115.000     244.9148         1.0000            1.12049          0.908771       99.2901     23.3220     0.672481     0.194757     8.86314e-05
  112.500     243.8492         1.0000            1.11987          0.906003       99.2901     23.1823     0.674267     0.194590     7.84656e-05
  110.000     242.7499         1.0000            1.11915          0.903165       99.2901     23.0447     0.676043     0.194428     6.93536e-05
  107.500     241.6165         1.0000            1.11832          0.900255       99.2901     22.9091     0.677808     0.194272     6.11981e-05
  105.000     240.4488         1.0000            1.11738          0.897270       99.2901     22.7755     0.679562     0.194120     5.39101e-05
  102.500     239.2463         1.0000            1.11633          0.894210       99.2901     22.6440     0.681307     0.193973     4.74074e-05
  100.000     238.0088         1.0000            1.11515          0.891072       99.2901     22.5143     0.683041     0.193830     4.16147e-05
   97.500     236.7358         1.0000            1.11386          0.887854       99.2901     22.3866     0.684764     0.193692     3.64631e-05
   95.000     235.4270         1.0000            1.11244          0.884555       99.2901     22.2607     0.686478     0.193558     3.18892e-05
   92.500     234.0820         1.0000            1.11089          0.881174       99.2901     22.1367     0.688181     0.193428     2.78354e-05
   90.000     232.7004         1.0000            1.10921          0.877706       99.2901     22.0144     0.689875     0.193302     2.42489e-05
   87.500     231.2819         1.0000            1.10739          0.874152       99.2901     21.8940     0.691559     0.193179     2.10816e-05
   85.000     229.8261         1.0000            1.10542          0.870508       99.2901     21.7753     0.693232     0.193060     1.82898e-05
   82.500     228.3325         1.0000            1.10331          0.866773       99.2901     21.6584     0.694896     0.192944     1.58337e-05
   80.000     226.8008         1.0000            1.10104          0.862944       99.2901     21.5431     0.696551     0.192831     1.36773e-05
   77.500     225.2305         1.0000            1.09862          0.859019       99.2901     21.4295     0.698195     0.192720     1.17877e-05
   75.000     223.6212         1.0000            1.09604          0.854995       99.2901     21.3175     0.699830     0.192613     1.01355e-05
   72.500     221.9726         1.0000            1.09329          0.850871       99.2901     21.2071     0.701456     0.192507     8.69393e-06
   70.000     220.2840         1.0000            1.09036          0.846643       99.2901     21.0983     0.703072     0.192403     7.43895e-06
   67.500     218.5552         1.0000            1.08726          0.842310       99.2901     20.9911     0.704679     0.192301     6.34889e-06
   65.000     216.7857         1.0000            1.08397          0.837867       99.2901     20.8853     0.706277     0.192200     5.40431e-06
   62.500     214.9750         1.0000            1.08049          0.833314       99.2901     20.7811     0.707865     0.192100     4.58779e-06
   60.000     213.1226         1.0000            1.07682          0.828646       99.2901     20.6783     0.709444     0.192000     3.88372e-06
   57.500     211.2281         1.0000            1.07294          0.823862       99.2901     20.5770     0.711015     0.191901     3.27819e-06
   55.000     209.2909         1.0000            1.06886          0.818957       99.2901     20.4771     0.712576     0.191801     2.75879e-06
   52.500     207.3107         1.0000            1.06455          0.813930       99.2901     20.3786     0.714128     0.191701     2.31450e-06
   50.000     205.2869         1.0000            1.06002          0.808777       99.2901     20.2814     0.715671     0.191599     1.93555e-06
   47.500     203.2190         1.0000            1.05526          0.803494       99.2901     20.1856     0.717206     0.191495     1.61326e-06
   45.000     201.1065         1.0000            1.05027          0.798079       99.2901     20.0911     0.718732     0.191389     1.34002e-06
   42.500     198.9489         1.0000            1.04502          0.792529       99.2901     19.9979     0.720249     0.191280     1.10908e-06
   40.000     196.7456         1.0000            1.03952          0.786839       99.2901     19.9059     0.721758     0.191168     9.14535e-07
   37.500     194.4961         1.0000            1.03376          0.781006       99.2901     19.8152     0.723258     0.191051     7.51209e-07
   35.000     192.1999         1.0000            1.02772          0.775028       99.2901     19.7257     0.724749     0.190929     6.14574e-07
   32.500     189.8564         1.0000            1.02140          0.768900       99.2901     19.6373     0.726233     0.190801     5.00689e-07
   30.000     187.4651         1.0000            1.01479          0.762618       99.2901     19.5501     0.727708     0.190665     4.06128e-07
   27.500     185.0255         1.0000            1.00788          0.756179       99.2901     19.4641     0.729174     0.190522     3.27926e-07
   25.000     182.5368         1.0000            1.00066          0.749579       99.2901     19.3791     0.730633     0.190370     2.63520e-07
   22.500     179.9987         1.0000            0.99312          0.742815       99.2901     19.2953     0.732083     0.190207     2.10707e-07
   20.000     177.4105         1.0000            0.98525          0.735882       99.2901     19.2124     0.733525     0.190033     1.67596e-07
   17.500     174.7715         1.0000            0.97703          0.728777       99.2901     19.1306     0.734959     0.189846     1.32573e-07
   15.000     172.0813         1.0000            0.96846          0.721496       99.2901     19.0498     0.736386     0.189643     1.04261e-07
   12.910     169.7930         1.0000            0.96101          0.715273       99.2901     18.9830     0.737572     0.189461     8.48952e-08
END

set output "Figures/Env_007_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:4.5e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_007_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "P-X Diagram for Predicted_3350_m_Oil\n with Lab3_Swelling_Gas at 93.4 C "
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   1.00000e-12        1.00000e+00        2.31570e-13        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   2.00000e-12        1.00000e+00        4.63140e-13        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   5.00000e-12        1.00000e+00        1.15785e-12        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   1.00000e-11        1.00000e+00        2.31570e-12        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   2.00000e-11        1.00000e+00        4.63140e-12        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   5.00000e-11        1.00000e+00        1.15785e-11        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   1.00000e-10        1.00000e+00        2.31570e-11        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   2.00000e-10        1.00000e+00        4.63140e-11        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   5.00000e-10        1.00000e+00        1.15785e-10        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   1.00000e-09        1.00000e+00        2.31570e-10        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   2.00000e-09        1.00000e+00        4.63140e-10        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   5.00000e-09        1.00000e+00        1.15785e-09        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   1.00000e-08        1.00000e+00        2.31570e-09        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   2.00000e-08        1.00000e+00        4.63140e-09        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   5.00000e-08        1.00000e+00        1.15785e-08        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   1.00000e-07        1.00000e+00        2.31570e-08        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   2.00000e-07        1.00000e+00        4.63140e-08        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   5.00000e-07        1.00000e+00        1.15785e-07        1.00000e+00       3.16011e-09        0.00000         6.79516e-11         1.00000        602.888     99.2901     0.919965     1.02953e-11     4.04716e-13
   1.00000e-06        9.99999e-01        2.31570e-07        1.00000e+00       3.16011e-09        0.00000         6.79517e-11         1.00000        602.888     99.2900     0.919965     1.02953e-11     4.04716e-13
   2.00000e-06        9.99998e-01        4.63141e-07        1.00000e+00       3.16011e-09        0.00000         6.79517e-11         1.00000        602.888     99.2900     0.919965     1.02953e-11     4.04716e-13
   5.00000e-06        9.99995e-01        1.15786e-06        9.99999e-01       3.16012e-09        0.00000         6.79519e-11         1.00000        602.888     99.2897     0.919965     1.02953e-11     4.04716e-13
   1.00000e-05        9.99990e-01        2.31572e-06        9.99998e-01       3.16014e-09        0.00000         6.79523e-11         1.00000        602.888     99.2894     0.919965     1.02954e-11     4.04716e-13
   2.00000e-05        9.99980e-01        4.63147e-06        9.99995e-01       3.16017e-09        0.00000         6.79530e-11         1.00000        602.888     99.2886     0.919965     1.02954e-11     4.04716e-13
   5.00000e-05        9.99950e-01        1.15790e-05        9.99988e-01       3.16027e-09        0.00000         6.79550e-11         1.00000        602.888     99.2863     0.919965     1.02955e-11     4.04716e-13
   1.00000e-04        9.99900e-01        2.31588e-05        9.99977e-01       3.16042e-09        0.00000         6.79584e-11         1.00000        602.888     99.2825     0.919965     1.02956e-11     4.04716e-13
   2.00000e-04        9.99800e-01        4.63212e-05        9.99954e-01       3.16074e-09        0.00000         6.79652e-11         1.00000        602.888     99.2749     0.919965     1.02958e-11     4.04716e-13
   5.00000e-04        9.99500e-01        1.15830e-04        9.99884e-01       3.16169e-09        0.00000         6.79856e-11         1.00000        602.888     99.2520     0.919965     1.02965e-11     4.04716e-13
   1.00000e-03        9.99000e-01        2.31748e-04        9.99768e-01       3.16327e-09        0.00000         6.80196e-11         1.00000        602.888     99.2138     0.919965     1.02977e-11     4.04716e-13
   2.00000e-03        9.98000e-01        4.63853e-04        9.99536e-01       3.16644e-09        0.00000         6.80878e-11         1.00000        602.888     99.1375     0.919965     1.03001e-11     4.04716e-13
   5.00000e-03        9.95000e-01        1.16232e-03        9.98838e-01       3.17599e-09        0.00000         6.82931e-11         1.00000        602.888     98.9086     0.919965     1.03073e-11     4.04716e-13
   1.00000e-02        9.90000e-01        2.33363e-03        9.97666e-01       3.19203e-09        0.00000         6.86380e-11         1.00000        602.888     98.5271     0.919965     1.03194e-11     4.04716e-13
   2.00000e-02        9.80000e-01        4.70369e-03        9.95296e-01       3.22460e-09        0.00000         6.93384e-11         1.00000        602.888     97.7642     0.919965     1.03440e-11     4.04716e-13
   3.00000e-02        9.70000e-01        7.11104e-03        9.92889e-01       3.25784e-09        0.00000         7.00532e-11         1.00000        602.888     97.0012     0.919965     1.03691e-11     4.04716e-13
   4.00000e-02        9.60000e-01        9.55655e-03        9.90443e-01       3.29178e-09        0.00000         7.07829e-11         1.00000        602.888     96.2382     0.919965     1.03947e-11     4.04716e-13
   5.00000e-02        9.50000e-01        1.20411e-02        9.87959e-01       3.32643e-09        0.00000         7.15280e-11         1.00000        602.888     95.4752     0.919965     1.04208e-11     4.04716e-13
   6.00000e-02        9.40000e-01        1.45658e-02        9.85434e-01       3.36182e-09        0.00000         7.22889e-11         1.00000        602.888     94.7123     0.919965     1.04475e-11     4.04716e-13
   7.00000e-02        9.30000e-01        1.71314e-02        9.82869e-01       3.39797e-09        0.00000         7.30662e-11         1.00000        602.888     93.9493     0.919965     1.04748e-11     4.04716e-13
   8.00000e-02        9.20000e-01        1.97391e-02        9.80261e-01       3.43490e-09        0.00000         7.38604e-11         1.00000        602.888     93.1863     0.919965     1.05026e-11     4.04716e-13
   9.00000e-02        9.10000e-01        2.23898e-02        9.77610e-01       3.47265e-09        0.00000         7.46721e-11         1.00000        602.888     92.4233     0.919965     1.05311e-11     4.04716e-13
   1.00000e-01        9.00000e-01        2.50846e-02        9.74915e-01       3.51123e-09        0.00000         7.55018e-11         1.00000        602.888     91.6604     0.919965     1.05602e-11     4.04716e-13
   1.10000e-01        8.90000e-01        2.78247e-02        9.72175e-01       3.55068e-09        0.00000         7.63501e-11         1.00000        602.888     90.8974     0.919965     1.05900e-11     4.04716e-13
   1.20000e-01        8.80000e-01        3.06111e-02        9.69389e-01       3.59103e-09        0.00000         7.72177e-11         1.00000        602.888     90.1344     0.919965     1.06204e-11     4.04716e-13
   1.30000e-01        8.70000e-01        3.34452e-02        9.66555e-01       3.63231e-09        0.00000         7.81053e-11         1.00000        602.888     89.3714     0.919965     1.06516e-11     4.04716e-13
   1.40000e-01        8.60000e-01        3.63280e-02        9.63672e-01       3.67454e-09        0.00000         7.90135e-11         1.00000        602.888     88.6085     0.919965     1.06834e-11     4.04716e-13
   1.50000e-01        8.50000e-01        3.92609e-02        9.60739e-01       3.71777e-09        0.00000         7.99431e-11         1.00000        602.888     87.8455     0.919965     1.07161e-11     4.04716e-13
   1.60000e-01        8.40000e-01        4.22452e-02        9.57755e-01       3.76203e-09        0.00000         8.08948e-11         1.00000        602.888     87.0825     0.919965     1.07494e-11     4.04716e-13
   1.70000e-01        8.30000e-01        4.52823e-02        9.54718e-01       3.80736e-09        0.00000         8.18694e-11         1.00000        602.888     86.3195     0.919965     1.07836e-11     4.04716e-13
   1.80000e-01        8.20000e-01        4.83735e-02        9.51626e-01       3.85379e-09        0.00000         8.28678e-11         1.00000        602.888     85.5566     0.919965     1.08187e-11     4.04716e-13
   1.90000e-01        8.10000e-01        5.15204e-02        9.48480e-01       3.90137e-09        0.00000         8.38909e-11         1.00000        602.888     84.7936     0.919965     1.08546e-11     4.04716e-13
   2.00000e-01        8.00000e-01        5.47244e-02        9.45276e-01       3.95013e-09        0.00000         8.49395e-11         1.00000        602.888     84.0306     0.919965     1.08914e-11     4.04716e-13
   2.10000e-01        7.90000e-01        5.79871e-02        9.42013e-01       4.00014e-09        0.00000         8.60147e-11         1.00000        602.888     83.2676     0.919965     1.09291e-11     4.04716e-13
   2.20000e-01        7.80000e-01        6.13102e-02        9.38690e-01       4.05142e-09        0.00000         8.71174e-11         1.00000        602.888     82.5047     0.919965     1.09678e-11     4.04716e-13
   2.30000e-01        7.70000e-01        6.46953e-02        9.35305e-01       4.10404e-09        0.00000         8.82488e-11         1.00000        602.888     81.7417     0.919965     1.10075e-11     4.04716e-13
   2.40000e-01        7.60000e-01        6.81442e-02        9.31856e-01       4.15804e-09        0.00000         8.94100e-11         1.00000        602.888     80.9787     0.919965     1.10482e-11     4.04716e-13
   2.50000e-01        7.50000e-01        7.16587e-02        9.28341e-01       4.21348e-09        0.00000         9.06021e-11         1.00000        602.888     80.2157     0.919965     1.10900e-11     4.04716e-13
   2.60000e-01        7.40000e-01        7.52407e-02        9.24759e-01       4.27042e-09        0.00000         9.18265e-11         1.00000        602.888     79.4528     0.919965     1.11330e-11     4.04716e-13
   2.70000e-01        7.30000e-01        7.88922e-02        9.21108e-01       4.32891e-09        0.00000         9.30844e-11         1.00000        602.888     78.6898     0.919965     1.11771e-11     4.04716e-13
   2.80000e-01        7.20000e-01        8.26152e-02        9.17385e-01       4.38904e-09        0.00000         9.43772e-11         1.00000        602.888     77.9268     0.919965     1.12225e-11     4.04716e-13
   2.90000e-01        7.10000e-01        8.64118e-02        9.13588e-01       4.45086e-09        0.00000         9.57065e-11         1.00000        602.888     77.1638     0.919965     1.12691e-11     4.04716e-13
   3.00000e-01        7.00000e-01        9.02842e-02        9.09716e-01       4.51444e-09        0.00000         9.70737e-11         1.00000        602.888     76.4009     0.919965     1.13171e-11     4.04716e-13
   3.10000e-01        6.90000e-01        9.42347e-02        9.05765e-01       4.57987e-09        0.00000         9.84806e-11         1.00000        602.888     75.6379     0.919965     1.13664e-11     4.04716e-13
   3.20000e-01        6.80000e-01        9.82658e-02        9.01734e-01       4.64722e-09        0.00000         9.99288e-11         1.00000        602.888     74.8749     0.919965     1.14173e-11     4.04716e-13
   3.30000e-01        6.70000e-01        1.02380e-01        8.97620e-01       4.71658e-09        0.00000         1.01420e-10         1.00000        602.888     74.1119     0.919965     1.14696e-11     4.04716e-13
   3.40000e-01        6.60000e-01        1.06579e-01        8.93421e-01       4.78804e-09        0.00000         1.02957e-10         1.00000        602.888     73.3490     0.919965     1.15235e-11     4.04716e-13
   3.50000e-01        6.50000e-01        1.10867e-01        8.89133e-01       4.86170e-09        0.00000         1.04541e-10         1.00000        602.888     72.5860     0.919965     1.15791e-11     4.04716e-13
   3.60000e-01        6.40000e-01        1.15246e-01        8.84754e-01       4.93767e-09        0.00000         1.06174e-10         1.00000        602.888     71.8230     0.919965     1.16364e-11     4.04716e-13
   3.70000e-01        6.30000e-01        1.19720e-01        8.80280e-01       5.01604e-09        0.00000         1.07860e-10         1.00000        602.888     71.0600     0.919965     1.16955e-11     4.04716e-13
   3.80000e-01        6.20000e-01        1.24290e-01        8.75710e-01       5.09695e-09        0.00000         1.09599e-10         1.00000        602.888     70.2971     0.919965     1.17566e-11     4.04716e-13
   3.90000e-01        6.10000e-01        1.28960e-01        8.71040e-01       5.18050e-09        0.00000         1.11396e-10         1.00000        602.888     69.5341     0.919965     1.18196e-11     4.04716e-13
   4.00000e-01        6.00000e-01        1.33734e-01        8.66266e-01       5.26685e-09        0.00000         1.13253e-10         1.00000        602.888     68.7711     0.919965     1.18847e-11     4.04716e-13
   4.10000e-01        5.90000e-01        1.38615e-01        8.61385e-01       5.35611e-09        0.00000         1.15172e-10         1.00000        602.888     68.0081     0.919965     1.19521e-11     4.04716e-13
   4.20000e-01        5.80000e-01        1.43607e-01        8.56393e-01       5.44846e-09        0.00000         1.17158e-10         1.00000        602.888     67.2452     0.919965     1.20217e-11     4.04716e-13
   4.30000e-01        5.70000e-01        1.48714e-01        8.51286e-01       5.54405e-09        0.00000         1.19213e-10         1.00000        602.888     66.4822     0.919965     1.20939e-11     4.04716e-13
   4.40000e-01        5.60000e-01        1.53939e-01        8.46061e-01       5.64305e-09        0.00000         1.21342e-10         1.00000        602.888     65.7192     0.919965     1.21686e-11     4.04716e-13
   4.50000e-01        5.50000e-01        1.59287e-01        8.40713e-01       5.74565e-09        0.00000         1.23548e-10         1.00000        602.888     64.9562     0.919965     1.22460e-11     4.04716e-13
   4.60000e-01        5.40000e-01        1.64762e-01        8.35238e-01       5.85205e-09        0.00000         1.25836e-10         1.00000        602.888     64.1933     0.919965     1.23262e-11     4.04716e-13
   4.70000e-01        5.30000e-01        1.70369e-01        8.29631e-01       5.96247e-09        0.00000         1.28211e-10         1.00000        602.888     63.4303     0.919965     1.24095e-11     4.04716e-13
   4.80000e-01        5.20000e-01        1.76112e-01        8.23888e-01       6.07713e-09        0.00000         1.30676e-10         1.00000        602.888     62.6673     0.919965     1.24960e-11     4.04716e-13
   4.90000e-01        5.10000e-01        1.81997e-01        8.18003e-01       6.19629e-09        0.00000         1.33238e-10         1.00000        602.888     61.9043     0.919965     1.25859e-11     4.04716e-13
   5.00000e-01        5.00000e-01        1.88028e-01        8.11972e-01       6.32022e-09        0.00000         1.35903e-10         1.00000        602.888     61.1414     0.919965     1.26794e-11     4.04716e-13
   5.10000e-01        4.90000e-01        1.94213e-01        8.05787e-01       6.44920e-09        0.00000         1.38677e-10         1.00000        602.888     60.3784     0.919965     1.27767e-11     4.04716e-13
   5.20000e-01        4.80000e-01        2.00555e-01        7.99445e-01       6.58356e-09        0.00000         1.41566e-10         1.00000        602.888     59.6154     0.919965     1.28781e-11     4.04716e-13
   5.30000e-01        4.70000e-01        2.07062e-01        7.92938e-01       6.72363e-09        0.00000         1.44578e-10         1.00000        602.888     58.8524     0.919965     1.29838e-11     4.04716e-13
   5.40000e-01        4.60000e-01        2.13740e-01        7.86260e-01       6.86980e-09        0.00000         1.47721e-10         1.00000        602.888     58.0895     0.919965     1.30941e-11     4.04716e-13
   5.50000e-01        4.50000e-01        2.20595e-01        7.79405e-01       7.02246e-09        0.00000         1.51004e-10         1.00000        602.888     57.3265     0.919965     1.32092e-11     4.04716e-13
   5.60000e-01        4.40000e-01        2.27636e-01        7.72364e-01       7.18206e-09        0.00000         1.54435e-10         1.00000        602.888     56.5635     0.919965     1.33296e-11     4.04716e-13
   5.70000e-01        4.30000e-01        2.34869e-01        7.65131e-01       7.34909e-09        0.00000         1.58027e-10         1.00000        602.888     55.8005     0.919965     1.34556e-11     4.04716e-13
   5.80000e-01        4.20000e-01        2.42302e-01        7.57698e-01       7.52407e-09        0.00000         1.61790e-10         1.00000        602.888     55.0376     0.919965     1.35877e-11     4.04716e-13
   5.90000e-01        4.10000e-01        2.49945e-01        7.50055e-01       7.70758e-09        0.00000         1.65736e-10         1.00000        602.888     54.2746     0.919965     1.37261e-11     4.04716e-13
   6.00000e-01        4.00000e-01        2.57805e-01        7.42195e-01       7.90027e-09        0.00000         1.69879e-10         1.00000        602.888     53.5116     0.919965     1.38715e-11     4.04716e-13
   6.10000e-01        3.90000e-01        2.65893e-01        7.34107e-01       8.10284e-09        0.00000         1.74235e-10         1.00000        602.888     52.7486     0.919965     1.40243e-11     4.04716e-13
   6.20000e-01        3.80000e-01        2.74218e-01        7.25782e-01       8.31607e-09        0.00000         1.78820e-10         1.00000        602.888     51.9857     0.919965     1.41852e-11     4.04716e-13
   6.30000e-01        3.70000e-01        2.82792e-01        7.17208e-01       8.54083e-09        0.00000         1.83653e-10         1.00000        602.888     51.2227     0.919965     1.43547e-11     4.04716e-13
   6.40000e-01        3.60000e-01        2.91624e-01        7.08376e-01       8.77808e-09        0.00000         1.88754e-10         1.00000        602.888     50.4597     0.919965     1.45337e-11     4.04716e-13
   6.50000e-01        3.50000e-01        3.00728e-01        6.99272e-01       9.02888e-09        0.00000         1.94147e-10         1.00000        602.888     49.6968     0.919965     1.47229e-11     4.04716e-13
   6.60000e-01        3.40000e-01        3.10116e-01        6.89884e-01       9.29443e-09        0.00000         1.99858e-10         1.00000        602.888     48.9338     0.919965     1.49233e-11     4.04716e-13
   6.70000e-01        3.30000e-01        3.19801e-01        6.80199e-01       9.57608e-09        0.00000         2.05914e-10         1.00000        602.888     48.1708     0.919965     1.51358e-11     4.04716e-13
   6.80000e-01        3.20000e-01        3.29798e-01        6.70202e-01       9.87534e-09        0.00000         2.12349e-10         1.00000        602.888     47.4078     0.919965     1.53615e-11     4.04716e-13
   6.90000e-01        3.10000e-01        3.40121e-01        6.59879e-01       1.01939e-08        0.00000         2.19199e-10         1.00000        602.888     46.6449     0.919965     1.56019e-11     4.04716e-13
   7.00000e-01        3.00000e-01        3.50789e-01        6.49211e-01       1.05337e-08        0.00000         2.26505e-10         1.00000        602.888     45.8819     0.919965     1.58582e-11     4.04716e-13
   7.10000e-01        2.90000e-01        3.61817e-01        6.38183e-01       1.08969e-08        0.00000         2.34316e-10         1.00000        602.888     45.1189     0.919965     1.61323e-11     4.04716e-13
   7.20000e-01        2.80000e-01        3.73224e-01        6.26776e-01       1.12861e-08        0.00000         2.42684e-10         1.00000        602.888     44.3559     0.919965     1.64259e-11     4.04716e-13
   7.30000e-01        2.70000e-01        3.85031e-01        6.14969e-01       1.17041e-08        0.00000         2.51673e-10         1.00000        602.888     43.5930     0.919965     1.67412e-11     4.04716e-13
   7.40000e-01        2.60000e-01        3.97258e-01        6.02742e-01       1.21543e-08        0.00000         2.61352e-10         1.00000        602.888     42.8300     0.919965     1.70808e-11     4.04716e-13
   7.50000e-01        2.50000e-01        4.09929e-01        5.90071e-01       1.26404e-08        0.00000         2.71806e-10         1.00000        602.888     42.0670     0.919965     1.74476e-11     4.04716e-13
   7.60000e-01        2.40000e-01        4.23068e-01        5.76932e-01       1.31671e-08        0.00000         2.83132e-10         1.00000        602.888     41.3040     0.919965     1.78450e-11     4.04716e-13
   7.70000e-01        2.30000e-01        4.36701e-01        5.63299e-01       1.37396e-08        0.00000         2.95442e-10         1.00000        602.888     40.5411     0.919965     1.82769e-11     4.04716e-13
   7.80000e-01        2.20000e-01        4.50858e-01        5.49142e-01       1.43641e-08        0.00000         3.08871e-10         1.00000        602.888     39.7781     0.919965     1.87480e-11     4.04716e-13
   7.90000e-01        2.10000e-01        4.65568e-01        5.34432e-01       1.50481e-08        0.00000         3.23579e-10         1.00000        602.888     39.0151     0.919965     1.92641e-11     4.04716e-13
   8.00000e-01        2.00000e-01        4.80865e-01        5.19135e-01       1.58005e-08        0.00000         3.39758e-10         1.00000        602.888     38.2521     0.919965     1.98317e-11     4.04716e-13
   8.10000e-01        1.90000e-01        4.96785e-01        5.03215e-01       1.66321e-08        0.00000         3.57640e-10         1.00000        602.888     37.4892     0.919965     2.04591e-11     4.04716e-13
   8.20000e-01        1.80000e-01        5.13366e-01        4.86634e-01       1.75562e-08        0.00000         3.77509e-10         1.00000        602.888     36.7262     0.919965     2.11562e-11     4.04716e-13
   8.30000e-01        1.70000e-01        5.30650e-01        4.69350e-01       1.85889e-08        0.00000         3.99715e-10         1.00000        602.888     35.9632     0.919965     2.19353e-11     4.04716e-13
   8.40000e-01        1.60000e-01        5.48684e-01        4.51316e-01       1.97507e-08        0.00000         4.24698e-10         1.00000        602.888     35.2002     0.919965     2.28118e-11     4.04716e-13
   8.50000e-01        1.50000e-01        5.67517e-01        4.32483e-01       2.10674e-08        0.00000         4.53011e-10         1.00000        602.888     34.4373     0.919965     2.38052e-11     4.04716e-13
   8.60000e-01        1.40000e-01        5.87204e-01        4.12796e-01       2.25722e-08        0.00000         4.85369e-10         1.00000        602.888     33.6743     0.919965     2.49405e-11     4.04716e-13
   8.70000e-01        1.30000e-01        6.07803e-01        3.92197e-01       2.43085e-08        0.00000         5.22705e-10         1.00000        602.888     32.9113     0.919965     2.62504e-11     4.04716e-13
   8.80000e-01        1.20000e-01        6.29380e-01        3.70620e-01       2.63342e-08        0.00000         5.66263e-10         1.00000        602.888     32.1483     0.919965     2.77787e-11     4.04716e-13
   8.90000e-01        1.10000e-01        6.52006e-01        3.47994e-01       2.87283e-08        0.00000         6.17742e-10         1.00000        602.888     31.3854     0.919965     2.95848e-11     4.04716e-13
   9.00000e-01        1.00000e-01        6.75760e-01        3.24240e-01       3.16011e-08        0.00000         6.79516e-10         1.00000        602.888     30.6224     0.919965     3.17522e-11     4.04716e-13
   9.10000e-01        9.00000e-02        7.00727e-01        2.99273e-01       3.51123e-08        0.00000         7.55018e-10         1.00000        602.888     29.8594     0.919965     3.44012e-11     4.04716e-13
   9.20000e-01        8.00000e-02        7.27004e-01        2.72996e-01       3.95013e-08        0.00000         8.49395e-10         1.00000        602.888     29.0964     0.919965     3.77124e-11     4.04716e-13
   9.30000e-01        7.00000e-02        7.54696e-01        2.45304e-01       4.51444e-08        0.00000         9.70737e-10         1.00000        602.888     28.3335     0.919965     4.19697e-11     4.04716e-13
   9.40000e-01        6.00000e-02        7.83921e-01        2.16079e-01       5.26685e-08        0.00000         1.13253e-09         1.00000        602.888     27.5705     0.919965     4.76461e-11     4.04716e-13
   9.50000e-01        5.00000e-02        8.14809e-01        1.85191e-01       6.32022e-08        0.00000         1.35903e-09         1.00000        602.888     26.8075     0.919965     5.55931e-11     4.04716e-13
   9.60000e-01        4.00000e-02        8.47507e-01        1.52493e-01       7.90027e-08        0.00000         1.69879e-09         1.00000        602.888     26.0445     0.919965     6.75136e-11     4.04716e-13
   9.70000e-01        3.00000e-02        8.82179e-01        1.17821e-01       1.05337e-07        0.00000         2.26505e-09         1.00000        602.888     25.2816     0.919965     8.73810e-11     4.04716e-13
   9.80000e-01        2.00000e-02        9.19008e-01        8.09917e-02       1.58005e-07        0.00000         3.39758e-09         1.00000        602.888     24.5186     0.919965     1.27116e-10     4.04716e-13
   9.90000e-01        1.00000e-02        9.58204e-01        4.17965e-02       3.16011e-07        0.00000         6.79516e-09         1.00000        602.888     23.7556     0.919965     2.46321e-10     4.04716e-13
   9.95000e-01        5.00000e-03        9.78761e-01        2.12393e-02       6.32022e-07        0.00000         1.35903e-08         1.00000        602.888     23.3741     0.919965     4.84730e-10     4.04716e-13
   9.98000e-01        2.00000e-03        9.91420e-01        8.57975e-03       1.58005e-06        0.00000         3.39758e-08         1.00000        602.888     23.1452     0.919965     1.19996e-09     4.04716e-13
   9.99000e-01        1.00000e-03        9.95696e-01        4.30406e-03       3.16011e-06        0.00000         6.79516e-08         1.00000        602.888     23.0689     0.919965     2.39200e-09     4.04716e-13
   9.99500e-01        5.00000e-04        9.97844e-01        2.15560e-03       6.32022e-06        0.00000         1.35903e-07         1.00000        602.888     23.0308     0.919965     4.77610e-09     4.04716e-13
   9.99800e-01        2.00000e-04        9.99137e-01        8.63096e-04       1.58006e-05        0.00000         3.39758e-07         1.00000        602.888     23.0079     0.919965     1.19284e-08     4.04717e-13
   9.99900e-01        1.00000e-04        9.99568e-01        4.31691e-04       3.16012e-05        0.00000         6.79518e-07         1.00000        602.888     23.0003     0.919965     2.38489e-08     4.04717e-13
   9.99950e-01        5.00000e-05        9.99784e-01        2.15881e-04       6.32025e-05        0.00000         1.35904e-06         1.00000        602.888     22.9964     0.919965     4.76901e-08     4.04719e-13
   9.99980e-01        2.00000e-05        9.99914e-01        8.63612e-05       1.58008e-04        0.00000         3.39763e-06         1.00000        602.887     22.9942     0.919965     1.19214e-07     4.04723e-13
   9.99990e-01        1.00000e-05        9.99957e-01        4.31820e-05       3.16020e-04        0.00000         6.79534e-06         1.00000        602.886     22.9934     0.919965     2.38424e-07     4.04730e-13
   9.99995e-01        5.00000e-06        9.99978e-01        2.15914e-05       6.32059e-04        0.00000         1.35910e-05         1.00000        602.883     22.9930     0.919965     4.76856e-07     4.04743e-13
   9.99998e-01        2.00000e-06        9.99991e-01        8.63663e-06       1.58029e-03        0.00000         3.39803e-05         1.00000        602.876     22.9928     0.919964     1.19224e-06     4.04784e-13
   9.99999e-01        1.00000e-06        9.99996e-01        4.31833e-06       3.16106e-03        0.00000         6.79695e-05         0.99999        602.864     22.9927     0.919962     2.38483e-06     4.04853e-13
   1.00000e+00        5.00000e-07        9.99998e-01        2.15917e-06       6.32401e-03        0.00000         1.35975e-04         0.99999        602.841     22.9927     0.919960     4.77112e-06     4.04990e-13
   1.00000e+00        2.00000e-07        9.99999e-01        8.63668e-07       1.58243e-02        0.00000         3.40207e-04         0.99997        602.770     22.9926     0.919952     1.19388e-05     4.05401e-13
   1.00000e+00        1.00000e-07        1.00000e+00        4.31834e-07       3.16963e-02        0.00000         6.81316e-04         0.99993        602.652     22.9926     0.919939     2.39144e-05     4.06089e-13
   1.00000e+00        5.00000e-08        1.00000e+00        2.15917e-07       6.35847e-02        0.00000         1.36626e-03         0.99986        602.416     22.9926     0.919913     4.79770e-05     4.07475e-13
   1.00000e+00        2.00000e-08        1.00000e+00        8.63669e-08       1.60430e-01        0.00000         3.44339e-03         0.99966        601.697     22.9926     0.919834     1.21075e-04     4.11714e-13
   1.00000e+00        1.00000e-08        1.00000e+00        4.31835e-08       3.25940e-01        0.00000         6.98263e-03         0.99930        600.474     22.9926     0.919699     2.46072e-04     4.19060e-13
   1.00000e+00        5.00000e-09        1.00000e+00        2.15917e-08       6.73769e-01        0.00000         1.43771e-02         0.99856        597.916     22.9926     0.919415     5.09048e-04     4.34926e-13
   1.00000e+00        3.11642e-09        1.00000e+00        1.34578e-08       1.12873e+00        0.00000         2.39614e-02         0.99759        594.599     22.9926     0.919044     8.53616e-04     4.56587e-13
   1.00000e+00        2.00000e-09        1.00000e+00        8.63669e-09       1.89092e+00        0.00000         3.97981e-02         0.99596        589.115     22.9926     0.918422     1.43236e-03     4.95312e-13
   1.00000e+00        1.36092e-09        1.00000e+00        5.87690e-09       3.12492e+00        0.00000         6.48712e-02         0.99334        580.426     22.9926     0.917416     2.37335e-03     5.65066e-13
   1.00000e+00        1.00000e-09        1.00000e+00        4.31835e-09       5.16422e+00        0.00000         1.04836e-01         0.98903        566.566     22.9926     0.915754     3.93926e-03     7.02428e-13
   1.00000e+00        8.65549e-10        1.00000e+00        3.73774e-09       7.34772e+00        0.00000         1.45712e-01         0.98446        552.390     22.9926     0.913977     5.63089e-03     8.86535e-13
   1.00000e+00        8.18576e-10        1.00000e+00        3.53490e-09       1.04545e+01        0.00000         2.00726e-01         0.97801        533.344     22.9926     0.911461     8.06453e-03     1.23408e-12
   1.00000e+00        8.18576e-10        1.00000e+00        3.53490e-09       1.04564e+01        0.00000         2.00759e-01         0.97801        533.333     22.9926     0.911459     8.06604e-03     1.23433e-12
   1.00000e+00        8.56391e-10        1.00000e+00        3.69819e-09       1.39056e+01        0.00000         2.57911e-01         0.97094        513.645     22.9926     0.908687     1.08048e-02     1.78078e-12
   1.00000e+00        1.00000e-09        1.00000e+00        4.31835e-09       1.84926e+01        0.00000         3.28285e-01         0.96170        489.659     22.9926     0.905050     1.45070e-02     2.89533e-12
   1.00000e+00        1.17703e-09        1.00000e+00        5.08283e-09       2.19916e+01        0.00000         3.78192e-01         0.95479        472.918     22.9926     0.902325     1.73769e-02     4.18969e-12
   1.00000e+00        1.47707e-09        1.00000e+00        6.37848e-09       2.61527e+01        0.00000         4.33873e-01         0.94671        454.618     22.9926     0.899154     2.08411e-02     6.49111e-12
   1.00000e+00        2.00000e-09        1.00000e+00        8.63669e-09       3.11012e+01        0.00000         4.95649e-01         0.93733        434.939     22.9926     0.895497     2.50325e-02     1.08959e-11
   1.00000e+00        2.99198e-09        1.00000e+00        1.29204e-08       3.71277e+01        0.00000         5.65514e-01         0.92627        413.720     22.9926     0.891238     3.02401e-02     2.03797e-11
   1.00000e+00        5.00000e-09        1.00000e+00        2.15917e-08       4.43219e+01        0.00000         6.42862e-01         0.91360        391.862     22.9926     0.886475     3.66002e-02     4.26959e-11
   1.00000e+00        1.00000e-08        1.00000e+00        4.31835e-08       5.35745e+01        0.00000         7.35296e-01         0.89826        368.473     22.9926     0.880915     4.49966e-02     1.08858e-10
   1.00000e+00        2.00000e-08        1.00000e+00        8.63669e-08       6.25684e+01        0.00000         8.19998e-01         0.88445        349.950     22.9926     0.876154     5.33708e-02     2.65112e-10
   1.00000e+00        3.10001e-08        1.00000e+00        1.33869e-07       6.82004e+01        0.00000         8.71311e-01         0.87640        340.107     22.9926     0.873497     5.87092e-02     4.57675e-10
   1.00000e+00        5.00000e-08        1.00000e+00        2.15917e-07       7.43393e+01        0.00000         9.26197e-01         0.86818        330.680     22.9926     0.870874     6.45998e-02     8.20730e-10
   1.00000e+00        1.00000e-07        1.00000e+00        4.31834e-07       8.33008e+01        0.00000         1.00496e+00         0.85726        318.971     22.9926     0.867526     7.33093e-02     1.88165e-09
   1.00000e+00        2.00000e-07        9.99999e-01        8.63668e-07       9.24186e+01        0.00000         1.08401e+00         0.84752        309.085     22.9926     0.864644     8.22678e-02     4.24550e-09
   1.00000e+00        5.00000e-07        9.99998e-01        2.15917e-06       1.04873e+02        0.00000         1.19075e+00         0.83654        298.082     22.9927     0.861418     9.45799e-02     1.22192e-08
   9.99999e-01        1.00000e-06        9.99996e-01        4.31833e-06       1.14733e+02        0.00000         1.27433e+00         0.82978        290.883     22.9927     0.859323     1.04314e-01     2.69029e-08
   9.99998e-01        2.00000e-06        9.99991e-01        8.63663e-06       1.25102e+02        0.00000         1.36124e+00         0.82451        284.344     22.9928     0.857446     1.14470e-01     5.88448e-08
   9.99995e-01        5.00000e-06        9.99978e-01        2.15914e-05       1.39846e+02        0.00000         1.48259e+00         0.82014        276.308     22.9930     0.855177     1.28644e-01     1.64461e-07
   9.99990e-01        1.00000e-05        9.99957e-01        4.31820e-05       1.52027e+02        0.00000         1.58041e+00         0.81915        270.420     22.9934     0.853532     1.40020e-01     3.56788e-07
   9.99980e-01        2.00000e-05        9.99914e-01        8.63612e-05       1.65365e+02        0.00000         1.68459e+00         0.82056        264.478     22.9942     0.851868     1.52050e-01     7.73389e-07
   9.99968e-01        3.17675e-05        9.99863e-01        1.37169e-04       1.75074e+02        0.00000         1.75829e+00         0.82306        260.386     22.9951     0.850708     1.60492e-01     1.29668e-06
   9.99950e-01        5.00000e-05        9.99784e-01        2.15881e-04       1.85352e+02        0.00000         1.83428e+00         0.82695        256.213     22.9964     0.849505     1.69127e-01     2.15371e-06
   9.99900e-01        1.00000e-04        9.99568e-01        4.31691e-04       2.02855e+02        0.00000         1.95872e+00         0.83611        249.394     23.0003     0.847482     1.83100e-01     4.68918e-06
   9.99858e-01        1.42195e-04        9.99386e-01        6.13756e-04       2.12760e+02        0.00000         2.02639e+00         0.84253        245.667     23.0035     0.846340     1.90603e-01     6.97408e-06
   9.99800e-01        2.00000e-04        9.99137e-01        8.63096e-04       2.23148e+02        0.00000         2.09526e+00         0.85010        241.847     23.0079     0.845140     1.98168e-01     1.02610e-05
   9.99680e-01        3.20186e-04        9.98619e-01        1.38120e-03       2.38994e+02        0.00000         2.19628e+00         0.86306        236.185     23.0171     0.843301     2.09136e-01     1.75322e-05
   9.99500e-01        5.00000e-04        9.97844e-01        2.15560e-03       2.55965e+02        0.00000         2.29934e+00         0.87855        230.331     23.0308     0.841322     2.20168e-01     2.92340e-05
   9.99287e-01        7.13391e-04        9.96927e-01        3.07339e-03       2.71172e+02        0.00000         2.38744e+00         0.89360        225.268     23.0471     0.839544     2.29483e-01     4.40961e-05
   9.99000e-01        1.00000e-03        9.95696e-01        4.30406e-03       2.87282e+02        0.00000         2.47669e+00         0.91054        220.089     23.0689     0.837658     2.38818e-01     6.53774e-05
   9.98571e-01        1.42894e-03        9.93858e-01        6.14153e-03       3.06417e+02        0.00000         2.57763e+00         0.93179        214.181     23.1017     0.835423     2.49272e-01     9.95202e-05
   9.98000e-01        2.00000e-03        9.91420e-01        8.57975e-03       3.26827e+02        0.00000         2.67972e+00         0.95555        208.167     23.1452     0.833053     2.59752e-01     1.48486e-04
   9.97445e-01        2.55546e-03        9.89057e-01        1.09426e-02       3.43439e+02        0.00000         2.75893e+00         0.97560        203.485     23.1876     0.831140     2.67834e-01     1.99376e-04
   9.96771e-01        3.22925e-03        9.86203e-01        1.37972e-02       3.60896e+02        0.00000         2.83872e+00         0.99726        198.765     23.2390     0.829148     2.75945e-01     2.64873e-04
   9.95962e-01        4.03815e-03        9.82792e-01        1.72076e-02       3.79240e+02        0.00000         2.91905e+00         1.02059        194.018     23.3007     0.827080     2.84095e-01     3.48368e-04
   9.95000e-01        5.00000e-03        9.78761e-01        2.12393e-02       3.98516e+02        0.00000         2.99990e+00         1.04568        189.256     23.3741     0.824937     2.92292e-01     4.53874e-04
   9.93994e-01        6.00617e-03        9.74570e-01        2.54299e-02       4.16600e+02        0.00000         3.07269e+00         1.06968        184.988     23.4509     0.822957     2.99680e-01     5.70844e-04
   9.92835e-01        7.16450e-03        9.69780e-01        3.02203e-02       4.35504e+02        0.00000         3.14589e+00         1.09522        180.725     23.5393     0.820919     3.07126e-01     7.13211e-04
   9.91510e-01        8.49033e-03        9.64341e-01        3.56595e-02       4.55266e+02        0.00000         3.21948e+00         1.12238        176.474     23.6404     0.818827     3.14639e-01     8.85579e-04
   9.90000e-01        1.00000e-02        9.58204e-01        4.17965e-02       4.75924e+02        0.00000         3.29346e+00         1.15125        172.240     23.7556     0.816682     3.22230e-01     1.09329e-03
   9.87990e-01        1.20099e-02        9.50125e-01        4.98754e-02       5.01126e+02        0.00000         3.38000e+00         1.18711        167.350     23.9090     0.814122     3.31169e-01     1.38754e-03
   9.85677e-01        1.43228e-02        9.40956e-01        5.90445e-02       5.27663e+02        0.00000         3.46710e+00         1.22559        162.504     24.0854     0.811495     3.40250e-01     1.74959e-03
   9.83027e-01        1.69729e-02        9.30613e-01        6.93867e-02       5.55605e+02        0.00000         3.55477e+00         1.26691        157.709     24.2876     0.808804     3.49492e-01     2.19339e-03
   9.80000e-01        2.00000e-02        9.19008e-01        8.09917e-02       5.85026e+02        0.00000         3.64300e+00         1.31130        152.972     24.5186     0.806047     3.58922e-01     2.73598e-03
   9.77038e-01        2.29621e-02        9.07862e-01        9.21377e-02       6.11757e+02        0.00000         3.71984e+00         1.35244        148.922     24.7446     0.803609     3.67260e-01     3.30175e-03
   9.73720e-01        2.62799e-02        8.95617e-01        1.04383e-01       6.39709e+02        0.00000         3.79705e+00         1.39630        144.920     24.9977     0.801120     3.75783e-01     3.97434e-03
   9.70000e-01        3.00000e-02        8.82179e-01        1.17821e-01       6.68938e+02        0.00000         3.87455e+00         1.44313        140.968     25.2816     0.798576     3.84518e-01     4.77505e-03
   9.65340e-01        3.46601e-02        8.65765e-01        1.34235e-01       7.02850e+02        0.00000         3.96047e+00         1.49879        136.645     25.6371     0.795687     3.94479e-01     5.84405e-03
   9.60000e-01        4.00000e-02        8.47507e-01        1.52493e-01       7.38481e+02        0.00000         4.04619e+00         1.55896        132.368     26.0445     0.792702     4.04813e-01     7.15436e-03
   9.55309e-01        4.46906e-02        8.31935e-01        1.68065e-01       7.67221e+02        0.00000         4.11182e+00         1.60891        129.086     26.4024     0.790311     4.13110e-01     8.37653e-03
   9.50000e-01        5.00000e-02        8.14809e-01        1.85191e-01       7.97079e+02        0.00000         4.17640e+00         1.66235        125.804     26.8075     0.787816     4.21762e-01     9.83600e-03
   9.45309e-01        5.46908e-02        8.00104e-01        1.99896e-01       8.21213e+02        0.00000         4.22558e+00         1.70691        123.222     27.1654     0.785765     4.28839e-01     1.11893e-02
   9.40000e-01        6.00000e-02        7.83921e-01        2.16079e-01       8.46078e+02        0.00000         4.27287e+00         1.75436        120.605     27.5705     0.783587     4.36283e-01     1.27897e-02
   9.30000e-01        7.00000e-02        7.54696e-01        2.45304e-01       8.86062e+02        0.00000         4.33926e+00         1.83509        116.388     28.3335     0.779808     4.48890e-01     1.59900e-02
   9.20000e-01        8.00000e-02        7.27004e-01        2.72996e-01       9.17362e+02        0.00000         4.37775e+00         1.90432        112.908     29.0964     0.776333     4.59910e-01     1.94152e-02
   9.10000e-01        9.00000e-02        7.00727e-01        2.99273e-01       9.40309e+02        0.00000         4.39012e+00         1.96191        109.998     29.8594     0.773056     4.69575e-01     2.30476e-02
   9.00000e-01        1.00000e-01        6.75760e-01        3.24240e-01       9.55354e+02        0.00000         4.37837e+00         2.00792        107.535     30.6224     0.769899     4.78068e-01     2.68737e-02
   8.90000e-01        1.10000e-01        6.52006e-01        3.47994e-01       9.63121e+02        0.00000         4.34488e+00         2.04274        105.427     31.3854     0.766807     4.85543e-01     3.08846e-02
   8.80000e-01        1.20000e-01        6.29380e-01        3.70620e-01       9.64395e+02        0.00000         4.29248e+00         2.06710        103.601     32.1483     0.763739     4.92135e-01     3.50758e-02
   8.70000e-01        1.30000e-01        6.07803e-01        3.92197e-01       9.60065e+02        0.00000         4.22422e+00         2.08198        102.002     32.9113     0.760670     4.97968e-01     3.94474e-02
   8.60000e-01        1.40000e-01        5.87204e-01        4.12796e-01       9.51065e+02        0.00000         4.14320e+00         2.08853        100.582     33.6743     0.757582     5.03152e-01     4.40038e-02
   8.50000e-01        1.50000e-01        5.67517e-01        4.32483e-01       9.38302e+02        0.00000         4.05237e+00         2.08796         99.306     34.4373     0.754465     5.07788e-01     4.87536e-02
   8.40000e-01        1.60000e-01        5.48684e-01        4.51316e-01       9.22614e+02        0.00000         3.95441e+00         2.08142         98.141     35.2002     0.751313     5.11962e-01     5.37089e-02
   8.30000e-01        1.70000e-01        5.30650e-01        4.69350e-01       9.04737e+02        0.00000         3.85157e+00         2.07002         97.063     35.9632     0.748121     5.15748e-01     5.88856e-02
   8.20000e-01        1.80000e-01        5.13366e-01        4.86634e-01       8.85294e+02        0.00000         3.74575e+00         2.05472         96.052     36.7262     0.744885     5.19211e-01     6.43034e-02
   8.10000e-01        1.90000e-01        4.96785e-01        5.03215e-01       8.64797e+02        0.00000         3.63844e+00         2.03633         95.091     37.4892     0.741600     5.22402e-01     6.99859e-02
   8.00000e-01        2.00000e-01        4.80865e-01        5.19135e-01       8.43658e+02        0.00000         3.53082e+00         2.01554         94.164     38.2521     0.738262     5.25368e-01     7.59610e-02
   7.90000e-01        2.10000e-01        4.65568e-01        5.34432e-01       8.22202e+02        0.00000         3.42374e+00         1.99293         93.260     39.0151     0.734864     5.28143e-01     8.22616e-02
   7.80000e-01        2.20000e-01        4.50858e-01        5.49142e-01       8.00678e+02        0.00000         3.31784e+00         1.96896         92.367     39.7781     0.731397     5.30759e-01     8.89267e-02
   7.70000e-01        2.30000e-01        4.36701e-01        5.63299e-01       7.79277e+02        0.00000         3.21358e+00         1.94400         91.476     40.5411     0.727852     5.33240e-01     9.60023e-02
   7.60000e-01        2.40000e-01        4.23068e-01        5.76932e-01       7.58143e+02        0.00000         3.11125e+00         1.91836         90.577     41.3040     0.724217     5.35607e-01     1.03544e-01
   7.50000e-01        2.50000e-01        4.09929e-01        5.90071e-01       7.37381e+02        0.00000         3.01101e+00         1.89227         89.662     42.0670     0.720476     5.37877e-01     1.11617e-01
   7.40000e-01        2.60000e-01        3.97258e-01        6.02742e-01       7.17065e+02        0.00000         2.91297e+00         1.86592         88.722     42.8300     0.716613     5.40065e-01     1.20302e-01
   7.30000e-01        2.70000e-01        3.85031e-01        6.14969e-01       6.97251e+02        0.00000         2.81711e+00         1.83947         87.747     43.5930     0.712606     5.42184e-01     1.29700e-01
   7.20000e-01        2.80000e-01        3.73224e-01        6.26776e-01       6.77975e+02        0.00000         2.72341e+00         1.81303         86.729     44.3559     0.708430     5.44242e-01     1.39933e-01
   7.10000e-01        2.90000e-01        3.61817e-01        6.38183e-01       6.59259e+02        0.00000         2.63175e+00         1.78672         85.657     45.1189     0.704052     5.46250e-01     1.51160e-01
   7.00000e-01        3.00000e-01        3.50789e-01        6.49211e-01       6.41119e+02        0.00000         2.54200e+00         1.76061         84.518     45.8819     0.699434     5.48215e-01     1.63584e-01
   6.90000e-01        3.10000e-01        3.40121e-01        6.59879e-01       6.23563e+02        0.00000         2.45396e+00         1.73476         83.299     46.6449     0.694524     5.50144e-01     1.77476e-01
   6.80000e-01        3.20000e-01        3.29798e-01        6.70202e-01       6.06594e+02        0.00000         2.36739e+00         1.70926         81.982     47.4078     0.689257     5.52044e-01     1.93201e-01
   6.70000e-01        3.30000e-01        3.19801e-01        6.80199e-01       5.90214e+02        0.00000         2.28198e+00         1.68414         80.545     48.1708     0.683545     5.53921e-01     2.11274e-01
   6.60000e-01        3.40000e-01        3.10116e-01        6.89884e-01       5.74425e+02        0.00000         2.19732e+00         1.65947         78.956     48.9338     0.677267     5.55782e-01     2.32443e-01
   6.50000e-01        3.50000e-01        3.00728e-01        6.99272e-01       5.59229e+02        0.00000         2.11285e+00         1.63532         77.176     49.6968     0.670247     5.57633e-01     2.57853e-01
   6.40000e-01        3.60000e-01        2.91624e-01        7.08376e-01       5.44636e+02        0.00000         2.02777e+00         1.61175         75.142     50.4597     0.662220     5.59481e-01     2.89373e-01
   6.30000e-01        3.70000e-01        2.82792e-01        7.17208e-01       5.30662e+02        0.00000         1.94087e+00         1.58887         72.760     51.2227     0.652748     5.61337e-01     3.30309e-01
   6.20000e-01        3.80000e-01        2.74218e-01        7.25782e-01       5.17340e+02        0.00000         1.85003e+00         1.56683         69.866     51.9857     0.641055     5.63211e-01     3.87249e-01
   6.10000e-01        3.90000e-01        2.65893e-01        7.34107e-01       5.04737e+02        0.00000         1.75131e+00         1.54585         66.150     52.7486     0.625557     5.65122e-01     4.75726e-01
   6.00000e-01        4.00000e-01        2.57805e-01        7.42195e-01       4.92992e+02        0.00000         1.63683e+00         1.52637         60.978     53.5116     0.602619     5.67102e-01     6.42084e-01
   5.90709e-01        4.09291e-01        2.50495e-01        7.49505e-01       4.83093e+02        0.00000         1.51250e+00         1.51033         54.373     54.2205     0.569840     5.69056e-01     9.90038e-01
   5.90539e-01        4.09461e-01        2.50363e-01        7.49637e-01       4.82922e+02        0.50000         1.51006e+00         1.51006         54.233     54.2335     0.569093     5.69093e-01     1.00000e+00
END

$Env_BP << END
#                                                                              Sat Pres                                                                                     Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
   5.90539e-01          0.40946          2.50363e-01          0.74964          482.922          0.5000            1.51006           1.51006        54.2335     54.2335     0.569093     0.569093     1.00000e+00
   5.90369e-01          0.40963          2.50231e-01          0.74977          482.752          1.0000            1.50979           1.50763        54.2465     54.0944     0.569131     0.568348     9.90044e-01
   5.90000e-01          0.41000          2.49945e-01          0.75006          482.385          1.0000            1.50921           1.50299        54.2746     53.8360     0.569212     0.566948     9.71437e-01
   5.80000e-01          0.42000          2.42302e-01          0.75770          473.085          1.0000            1.49494           1.39530        55.0376     47.6993     0.571490     0.530661     5.83448e-01
   5.70000e-01          0.43000          2.34869e-01          0.76513          464.771          1.0000            1.48281           1.32745        55.8005     43.9161     0.573885     0.504518     3.91687e-01
   5.60000e-01          0.44000          2.27636e-01          0.77236          457.123          1.0000            1.47205           1.28002        56.5635     41.3698     0.576342     0.484765     2.83356e-01
   5.50000e-01          0.45000          2.20595e-01          0.77940          449.962          1.0000            1.46222           1.24351        57.3265     39.4747     0.578830     0.468684     2.14070e-01
   5.40000e-01          0.46000          2.13740e-01          0.78626          443.184          1.0000            1.45308           1.21371        58.0895     37.9715     0.581332     0.454946     1.66249e-01
   5.30000e-01          0.47000          2.07062e-01          0.79294          436.720          1.0000            1.44447           1.18849        58.8524     36.7285     0.583836     0.442838     1.31588e-01
   5.20000e-01          0.48000          2.00555e-01          0.79945          430.522          1.0000            1.43628           1.16659        59.6154     35.6706     0.586336     0.431936     1.05608e-01
   5.10000e-01          0.49000          1.94213e-01          0.80579          424.553          1.0000            1.42843           1.14725        60.3784     34.7511     0.588826     0.421964     8.56572e-02
   5.00000e-01          0.50000          1.88028e-01          0.81197          418.787          1.0000            1.42086           1.12992        61.1414     33.9390     0.591302     0.412739     7.00549e-02
   4.90000e-01          0.51000          1.81997e-01          0.81800          413.200          1.0000            1.41352           1.11425        61.9043     33.2127     0.593762     0.404125     5.76792e-02
   4.80000e-01          0.52000          1.76112e-01          0.82389          407.777          1.0000            1.40638           1.09994        62.6673     32.5565     0.596203     0.396025     4.77517e-02
   4.70000e-01          0.53000          1.70369e-01          0.82963          402.501          1.0000            1.39940           1.08681        63.4303     31.9589     0.598624     0.388364     3.97148e-02
   4.60000e-01          0.54000          1.64762e-01          0.83524          397.361          1.0000            1.39257           1.07467        64.1933     31.4107     0.601023     0.381082     3.31592e-02
   4.50000e-01          0.55000          1.59287e-01          0.84071          392.347          1.0000            1.38586           1.06342        64.9562     30.9049     0.603400     0.374133     2.77780e-02
   4.40000e-01          0.56000          1.53939e-01          0.84606          387.449          1.0000            1.37925           1.05293        65.7192     30.4359     0.605754     0.367479     2.33370e-02
   4.30000e-01          0.57000          1.48714e-01          0.85129          382.660          1.0000            1.37274           1.04314        66.4822     29.9991     0.608084     0.361088     1.96553e-02
   4.20000e-01          0.58000          1.43607e-01          0.85639          377.973          1.0000            1.36630           1.03395        67.2452     29.5907     0.610390     0.354934     1.65908e-02
   4.10000e-01          0.59000          1.38615e-01          0.86138          373.382          1.0000            1.35994           1.02533        68.0081     29.2076     0.612672     0.348996     1.40315e-02
   4.00000e-01          0.60000          1.33734e-01          0.86627          368.882          1.0000            1.35363           1.01721        68.7711     28.8473     0.614930     0.343254     1.18876e-02
   3.90000e-01          0.61000          1.28960e-01          0.87104          364.468          1.0000            1.34738           1.00955        69.5341     28.5073     0.617164     0.337692     1.00869e-02
   3.80000e-01          0.62000          1.24290e-01          0.87571          360.135          1.0000            1.34117           1.00231        70.2971     28.1858     0.619374     0.332297     8.57093e-03
   3.70000e-01          0.63000          1.19720e-01          0.88028          355.881          1.0000            1.33500           0.99546        71.0600     27.8811     0.621559     0.327057     7.29206e-03
   3.60000e-01          0.64000          1.15246e-01          0.88475          351.701          1.0000            1.32886           0.98897        71.8230     27.5919     0.623720     0.321960     6.21119e-03
   3.50000e-01          0.65000          1.10867e-01          0.88913          347.592          1.0000            1.32275           0.98282        72.5860     27.3167     0.625857     0.316998     5.29614e-03
   3.40000e-01          0.66000          1.06579e-01          0.89342          343.551          1.0000            1.31667           0.97698        73.3490     27.0546     0.627971     0.312161     4.52029e-03
   3.30000e-01          0.67000          1.02380e-01          0.89762          339.575          1.0000            1.31061           0.97143        74.1119     26.8045     0.630061     0.307443     3.86158e-03
   3.20000e-01          0.68000          9.82658e-02          0.90173          335.663          1.0000            1.30457           0.96615        74.8749     26.5655     0.632128     0.302837     3.30161e-03
   3.10000e-01          0.69000          9.42347e-02          0.90577          331.812          1.0000            1.29854           0.96113        75.6379     26.3369     0.634171     0.298337     2.82506e-03
   3.00000e-01          0.70000          9.02842e-02          0.90972          328.019          1.0000            1.29253           0.95635        76.4009     26.1180     0.636192     0.293937     2.41906e-03
   2.90000e-01          0.71000          8.64118e-02          0.91359          324.282          1.0000            1.28653           0.95179        77.1638     25.9080     0.638190     0.289633     2.07284e-03
   2.80000e-01          0.72000          8.26152e-02          0.91738          320.600          1.0000            1.28053           0.94745        77.9268     25.7066     0.640166     0.285419     1.77734e-03
   2.70000e-01          0.73000          7.88922e-02          0.92111          316.972          1.0000            1.27455           0.94331        78.6898     25.5130     0.642120     0.281293     1.52491e-03
   2.60000e-01          0.74000          7.52407e-02          0.92476          313.394          1.0000            1.26856           0.93937        79.4528     25.3270     0.644052     0.277249     1.30910e-03
   2.50000e-01          0.75000          7.16587e-02          0.92834          309.866          1.0000            1.26258           0.93561        80.2157     25.1479     0.645963     0.273285     1.12448e-03
   2.40000e-01          0.76000          6.81442e-02          0.93186          306.387          1.0000            1.25660           0.93202        80.9787     24.9755     0.647853     0.269398     9.66422e-04
   2.30000e-01          0.77000          6.46953e-02          0.93530          302.954          1.0000            1.25062           0.92859        81.7417     24.8094     0.649721     0.265583     8.31019e-04
   2.20000e-01          0.78000          6.13102e-02          0.93869          299.568          1.0000            1.24464           0.92533        82.5047     24.6492     0.651569     0.261840     7.14952e-04
   2.10000e-01          0.79000          5.79871e-02          0.94201          296.225          1.0000            1.23866           0.92221        83.2676     24.4946     0.653397     0.258164     6.15401e-04
   2.00000e-01          0.80000          5.47244e-02          0.94528          292.925          1.0000            1.23268           0.91923        84.0306     24.3454     0.655205     0.254555     5.29968e-04
   1.90000e-01          0.81000          5.15204e-02          0.94848          289.668          1.0000            1.22669           0.91640        84.7936     24.2013     0.656993     0.251008     4.56611e-04
   1.80000e-01          0.82000          4.83735e-02          0.95163          286.452          1.0000            1.22070           0.91369        85.5566     24.0620     0.658761     0.247523     3.93590e-04
   1.70000e-01          0.83000          4.52823e-02          0.95472          283.275          1.0000            1.21470           0.91111        86.3195     23.9274     0.660511     0.244098     3.39421e-04
   1.60000e-01          0.84000          4.22452e-02          0.95775          280.137          1.0000            1.20870           0.90865        87.0825     23.7971     0.662241     0.240730     2.92839e-04
   1.50000e-01          0.85000          3.92609e-02          0.96074          277.038          1.0000            1.20269           0.90631        87.8455     23.6710     0.663953     0.237417     2.52760e-04
   1.40000e-01          0.86000          3.63280e-02          0.96367          273.975          1.0000            1.19667           0.90408        88.6085     23.5490     0.665646     0.234159     2.18263e-04
   1.30000e-01          0.87000          3.34452e-02          0.96655          270.949          1.0000            1.19065           0.90195        89.3714     23.4308     0.667322     0.230953     1.88554e-04
   1.20000e-01          0.88000          3.06111e-02          0.96939          267.958          1.0000            1.18462           0.89993        90.1344     23.3162     0.668979     0.227799     1.62959e-04
   1.10000e-01          0.89000          2.78247e-02          0.97218          265.002          1.0000            1.17858           0.89800        90.8974     23.2052     0.670619     0.224694     1.40899e-04
   1.00000e-01          0.90000          2.50846e-02          0.97492          262.080          1.0000            1.17253           0.89617        91.6604     23.0976     0.672242     0.221637     1.21876e-04
   9.00000e-02          0.91000          2.23898e-02          0.97761          259.191          1.0000            1.16647           0.89443        92.4233     22.9932     0.673847     0.218627     1.05465e-04
   8.00000e-02          0.92000          1.97391e-02          0.98026          256.334          1.0000            1.16040           0.89278        93.1863     22.8920     0.675436     0.215664     9.13024e-05
   7.00000e-02          0.93000          1.71314e-02          0.98287          253.509          1.0000            1.15432           0.89122        93.9493     22.7937     0.677008     0.212745     7.90745e-05
   6.00000e-02          0.94000          1.45658e-02          0.98543          250.715          1.0000            1.14823           0.88973        94.7123     22.6984     0.678564     0.209869     6.85126e-05
   5.00000e-02          0.95000          1.20411e-02          0.98796          247.952          1.0000            1.14213           0.88833        95.4752     22.6058     0.680104     0.207036     5.93861e-05
   4.00000e-02          0.96000          9.55655e-03          0.99044          245.218          1.0000            1.13602           0.88700        96.2382     22.5159     0.681628     0.204244     5.14966e-05
   3.00000e-02          0.97000          7.11104e-03          0.99289          242.514          1.0000            1.12990           0.88574        97.0012     22.4285     0.683136     0.201493     4.46738e-05
   2.00000e-02          0.98000          4.70369e-03          0.99530          239.838          1.0000            1.12376           0.88456        97.7642     22.3437     0.684629     0.198782     3.87709e-05
   1.00000e-02          0.99000          2.33363e-03          0.99767          237.190          1.0000            1.11762           0.88345        98.5271     22.2612     0.686107     0.196109     3.36619e-05
   5.00000e-03          0.99500          1.16232e-03          0.99884          235.877          1.0000            1.11454           0.88292        98.9086     22.2209     0.686840     0.194787     3.13706e-05
   2.00000e-03          0.99800          4.63853e-04          0.99954          235.092          1.0000            1.11270           0.88260        99.1375     22.1969     0.687278     0.193998     3.00729e-05
   1.00000e-03          0.99900          2.31748e-04          0.99977          234.831          1.0000            1.11208           0.88250        99.2138     22.1890     0.687424     0.193736     2.96526e-05
   5.00000e-04          0.99950          1.15830e-04          0.99988          234.701          1.0000            1.11177           0.88245        99.2520     22.1851     0.687497     0.193605     2.94447e-05
   2.00000e-04          0.99980          4.63212e-05          0.99995          234.623          1.0000            1.11159           0.88242        99.2749     22.1827     0.687540     0.193527     2.93207e-05
   1.00000e-04          0.99990          2.31588e-05          0.99998          234.596          1.0000            1.11153           0.88241        99.2825     22.1819     0.687555     0.193500     2.92795e-05
   5.00000e-05          0.99995          1.15790e-05          0.99999          234.583          1.0000            1.11149           0.88241        99.2863     22.1815     0.687562     0.193487     2.92589e-05
   2.00000e-05          0.99998          4.63147e-06          1.00000          234.576          1.0000            1.11148           0.88240        99.2886     22.1813     0.687566     0.193479     2.92465e-05
   1.00000e-05          0.99999          2.31572e-06          1.00000          234.573          1.0000            1.11147           0.88240        99.2894     22.1812     0.687568     0.193477     2.92424e-05
   5.00000e-06          0.99999          1.15786e-06          1.00000          234.572          1.0000            1.11147           0.88240        99.2897     22.1811     0.687569     0.193475     2.92404e-05
   2.00000e-06          1.00000          4.63141e-07          1.00000          234.571          1.0000            1.11146           0.88240        99.2900     22.1811     0.687569     0.193475     2.92391e-05
   1.00000e-06          1.00000          2.31570e-07          1.00000          234.571          1.0000            1.11146           0.88240        99.2900     22.1811     0.687569     0.193474     2.92387e-05
   5.00000e-07          1.00000          1.15785e-07          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92385e-05
   2.00000e-07          1.00000          4.63140e-08          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92384e-05
   1.00000e-07          1.00000          2.31570e-08          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   5.00000e-08          1.00000          1.15785e-08          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   2.00000e-08          1.00000          4.63140e-09          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   1.00000e-08          1.00000          2.31570e-09          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   5.00000e-09          1.00000          1.15785e-09          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   2.00000e-09          1.00000          4.63140e-10          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   1.00000e-09          1.00000          2.31570e-10          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   5.00000e-10          1.00000          1.15785e-10          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   2.00000e-10          1.00000          4.63140e-11          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   1.00000e-10          1.00000          2.31570e-11          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   5.00000e-11          1.00000          1.15785e-11          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   2.00000e-11          1.00000          4.63140e-12          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   1.00000e-11          1.00000          2.31570e-12          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   5.00000e-12          1.00000          1.15785e-12          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   2.00000e-12          1.00000          4.63140e-13          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   1.00000e-12          1.00000          2.31570e-13          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          234.570          1.0000            1.11146           0.88240        99.2901     22.1811     0.687569     0.193474     2.92383e-05
END

set output "Figures/Env_008_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_008_P_vs_Wi_1.pdf"
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 3:5 with lines title "Dew Points", \
     $Env_BP using 3:5 with lines title "Bubble Points"

set output "Figures/Env_008_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_008_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (bar)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "Black Oil Tables from Predicted_3350_m_Oil at 93.5 C\nUsing Three-Stage Separation Process"
show title

$BOT_BP << END
#   Psat        EOS Deno     BO Deno          Rs              Bo            1/Bo          Viso
#   (bar)       (kg/m3)      (kg/m3)      (sm3/stm3)      (rm3/stm3)     (stm3/rm3)       (cp)
#----------   -----------   ---------   -------------   -------------   ------------   ---------
    1.0132      820.342      817.920          0.000        1.04243        0.959297      1.97186
    2.0000      814.891      816.678          0.000        1.04402        0.957840      1.84819
    5.0000      807.331      813.236         26.211        1.04953        0.952811      1.69739
   10.0000      801.426      806.071        114.387        1.06256        0.941128      1.59414
   20.0000      793.419      794.263        279.132        1.08537        0.921344      1.46672
   40.0000      780.778      780.163        525.418        1.11567        0.896323      1.28577
   60.0000      769.813      768.284        763.237        1.14339        0.874589      1.14622
   80.0000      759.479      757.541       1000.577        1.17021        0.854547      1.02800
  100.0000      749.515      747.335       1243.896        1.19721        0.835277      0.92544
  120.0000      739.821      737.511       1494.841        1.22467        0.816547      0.83568
  140.0000      730.345      727.985       1754.532        1.25277        0.798234      0.75676
  160.0000      721.055      718.704       2023.955        1.28163        0.780258      0.68711
  180.0000      711.920      709.625       2304.140        1.31139        0.762552      0.62541
  200.0000      702.910      700.710       2596.270        1.34218        0.745058      0.57050
  220.0000      693.990      691.921       2901.758        1.37417        0.727714      0.52140
  234.6243      687.501      685.551       3134.612        1.39843        0.715088      0.48867
  250.0000      680.718      678.902       3388.606        1.42478        0.701862      0.45694
  275.0000      669.779      668.197       3823.108        1.46961        0.680451      0.41068
  300.0000      658.882      657.562       4288.030        1.51731        0.659063      0.36995
  325.0000      647.973      646.945       4788.192        1.56837        0.637606      0.33385
  350.0000      636.981      636.280       5329.907        1.62346        0.615967      0.30162
  375.0000      625.813      625.478       5921.800        1.68352        0.593993      0.27259
  400.0000      614.332      614.411       6576.385        1.74990        0.571462      0.24617
  425.0000      602.316      602.871       7313.436        1.82476        0.548016      0.22173
  450.0000      589.354      590.472       8168.527        1.91208        0.522990      0.19854
  475.0000      574.488      576.311       9221.529        2.02089        0.494831      0.17541
  500.0000      554.053      556.921      10768.912        2.18527        0.457610      0.14862
  506.7132      543.059      546.512      11614.806        2.27926        0.438738      0.13621
END

$BOT_DP << END
#   Psat       EOS Deng      BO Deng          Rv             Bg            1/Bg           Visg
#   (bar)       (kg/m3)      (kg/m3)      (stm3/sm3)      (rm3/sm3)      (sm3/rm3)        (cp)
#----------   ----------   ----------   -------------   ------------   ------------   -----------
    1.0132       2.1798       1.8214     1.51053e-04     0.08928911        11.200      0.0093655
    2.0000       3.4710       2.4149     5.41279e-05     0.03312281        30.191      0.0100643
    5.0000       6.4151       4.3529     1.86349e-05     0.01142372        87.537      0.0110888
   10.0000      10.3400       7.7208     9.71191e-06     0.00545523       183.310      0.0118346
   20.0000      17.6020      14.4101     4.80735e-06     0.00263266       379.844      0.0124691
   40.0000      31.9944      28.1559     2.25566e-06     0.00127011       787.332      0.0131155
   60.0000      46.7283      42.6771     1.73988e-06     0.00082764      1208.250      0.0136614
   80.0000      62.0051      57.8831     1.73027e-06     0.00061008      1639.135      0.0142672
  100.0000      77.8304      73.6809     1.94702e-06     0.00048178      2075.635      0.0149856
  120.0000      94.1519      89.9914     2.32022e-06     0.00039800      2512.591      0.0158444
  140.0000     110.8928     106.7410     2.83106e-06     0.00033962      2944.436      0.0168592
  160.0000     127.9689     123.8610     3.47652e-06     0.00029712      3365.597      0.0180367
  180.0000     145.3002     141.2917     4.25920e-06     0.00026519      3770.852      0.0193756
  200.0000     162.8205     158.9860     5.18431e-06     0.00024064      4155.608      0.0208693
  220.0000     180.4846     176.9137     6.25901e-06     0.00022143      4516.042      0.0225078
  234.6243     193.4794     190.1642     7.14519e-06     0.00020998      4762.429      0.0237921
  250.0000     207.2082     204.2195     8.17220e-06     0.00019981      5004.675      0.0252175
  275.0000     229.6801     227.3485     1.00638e-05     0.00018658      5359.644      0.0276961
  300.0000     252.4030     250.8813     1.22629e-05     0.00017655      5664.054      0.0303869
  325.0000     275.5090     274.9340     1.48212e-05     0.00016904      5915.761      0.0333324
  350.0000     299.2131     299.6974     1.78174e-05     0.00016360      6112.595      0.0366196
  375.0000     323.8454     325.4707     2.13750e-05     0.00015996      6251.504      0.0404036
  400.0000     349.9192     352.7274     2.56963e-05     0.00015805      6327.267      0.0449587
  425.0000     378.2836     382.2594     3.11382e-05     0.00015797      6330.147      0.0508000
  450.0000     410.5150     415.5432     3.84131e-05     0.00016025      6240.338      0.0590309
  475.0000     450.2311     455.9537     4.92916e-05     0.00016639      6010.051      0.0726816
  500.0000     510.9868     515.9543     7.11833e-05     0.00018321      5458.069      0.1067788
  506.7132     542.2539     545.7536     8.56746e-05     0.00019585      5105.931      0.1353319
END

set output "Figures/BOT_001_Rs_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Rs (sm3/stm3)"
plot [*:*] [*:*] $BOT_BP using 1:4 with lines linetype 2 notitle

set output "Figures/BOT_001_Bo_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Bo (rm3/stm3)"
plot [*:*] [*:*] $BOT_BP using 1:5 with lines linetype 2 notitle

set output "Figures/BOT_001_Rv_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Rv (stm3/sm3)"
set logscale y
plot [*:*] [*:*] $BOT_DP using 1:4 with lines linetype 2 notitle
unset logscale y

set output "Figures/BOT_001_Bgi_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "1/Bg (sm3/rm3)"
plot [*:*] [*:*] $BOT_DP using 1:6 with lines linetype 2 notitle

set output "Figures/BOT_001_Vis_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Viscosity (cp)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:7 with lines title "Gas", \
     $BOT_BP using 1:7 with lines title "Oil"
unset logscale y

set output "Figures/BOT_001_Den_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Density (kg/m3)"
plot [*:*] [*:*]  \
     $BOT_BP using 1:2 with points title "Oil, EOS", \
     $BOT_BP using 1:3 with lines title "Oil, BO", \
     $BOT_DP using 1:2 with points title "Gas, EOS", \
     $BOT_DP using 1:3 with lines title "Gas, BO"

set output "Figures/BOT_001_R_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Rs and 1/Rv (sm3/stm3)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:(1/$4) with lines title "1/Rv", \
     $BOT_BP using 1:4 with lines title "Rs"
unset logscale y

set output
